/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intocps.maestro.framework.core.EnvironmentException;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironmentConfiguration;
import org.intocps.maestro.framework.fmi2.KeyInstance;

public class LegacyMMSupport {
    public static Map<String, String> adjustFmi2SimulationEnvironmentConfiguration(Fmi2SimulationEnvironmentConfiguration config) throws EnvironmentException {
        Map<String, String> instanceRemapping = LegacyMMSupport.calculateInstanceRemapping(config.getConnections());
        LegacyMMSupport.fixVariableToVariablesMap(instanceRemapping, config.getConnections());
        LegacyMMSupport.fixKeyInstanceToVariablesMap(instanceRemapping, config.variablesToLog);
        LegacyMMSupport.fixKeyInstanceToVariablesMap(instanceRemapping, config.logVariables);
        LegacyMMSupport.fixKeyInstanceToVariablesMap(instanceRemapping, config.livestream);
        return instanceRemapping;
    }

    public static <T> void fixKeyInstanceToVariablesMap(Map<String, String> remappings, Map<String, T> variables) throws EnvironmentException {
        ArrayList objectsToRemove = new ArrayList();
        HashMap<String, T> newMap = new HashMap<String, T>();
        if (variables != null) {
            for (Map.Entry<String, T> entry : variables.entrySet()) {
                KeyInstance entry_ = KeyInstance.ofKeyInstance(entry.getKey());
                if (!remappings.containsKey(entry_.instance)) continue;
                objectsToRemove.remove(entry.getKey());
                entry_.instance = remappings.get(entry_.instance);
                newMap.put(entry_.toKeyInstance(), entry.getValue());
            }
            objectsToRemove.forEach(x -> variables.remove(x));
            variables.putAll(newMap);
        }
    }

    public static <T> void fixVariableToXMap(Map<String, String> remappings, Map<String, T> variables) throws EnvironmentException {
        ArrayList<String> objectsToRemove = new ArrayList<String>();
        HashMap<String, T> newMap = new HashMap<String, T>();
        if (variables != null) {
            for (Map.Entry<String, T> entry : variables.entrySet()) {
                KeyInstance entry_ = KeyInstance.ofVariable(entry.getKey());
                if (!remappings.containsKey(entry_.instance)) continue;
                objectsToRemove.add(entry.getKey());
                entry_.instance = remappings.get(entry_.instance);
                newMap.put(entry_.toVariable(), entry.getValue());
            }
            objectsToRemove.forEach(x -> variables.remove(x));
            variables.putAll(newMap);
        }
    }

    public static void fixVariableToVariablesMap(Map<String, String> remappings, Map<String, List<String>> map) throws EnvironmentException {
        HashMap newMap = new HashMap();
        ArrayList<String> objectsToRemove = new ArrayList<String>();
        if (map != null && map.size() > 0 && remappings != null && remappings.size() > 0) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                ArrayList<String> newValues = new ArrayList<String>();
                boolean replaceValues = false;
                for (String value : entry.getValue()) {
                    KeyInstance value_ = KeyInstance.ofVariable(value);
                    if (remappings.containsKey(value_.instance)) {
                        value_.instance = remappings.get(value_.instance);
                        newValues.add(value_.toVariable());
                        replaceValues = true;
                        continue;
                    }
                    newValues.add(value);
                }
                KeyInstance entry_ = KeyInstance.ofVariable(entry.getKey());
                if (remappings.containsKey(entry_.instance)) {
                    entry_.instance = remappings.get(entry_.instance);
                    newMap.put(entry_.toVariable(), newValues);
                    objectsToRemove.add(entry.getKey());
                    continue;
                }
                if (!replaceValues) continue;
                newMap.put(entry.getKey(), newValues);
            }
        }
        objectsToRemove.forEach(x -> map.remove(x));
        map.putAll(newMap);
    }

    public static Map<String, String> calculateInstanceRemapping(Map<String, List<String>> connections) throws EnvironmentException {
        HashMap<String, String> instanceRemapping = new HashMap<String, String>();
        HashSet<KeyInstance> uniqueStrings = new HashSet<KeyInstance>();
        for (Map.Entry<String, List<String>> entry : connections.entrySet()) {
            uniqueStrings.add(KeyInstance.ofVariable(entry.getKey()));
            for (String entry_ : entry.getValue()) {
                uniqueStrings.add(KeyInstance.ofVariable(entry_));
            }
        }
        BiFunction<String, Stream, Boolean> instanceNameIsInvalid = (instanceName, keyInstances) -> keyInstances.anyMatch(x -> x.key.equals(instanceName) || x.instance.equals(instanceName));
        List sameKeyInstance = uniqueStrings.stream().filter(x -> x.instance.equals(x.key)).collect(Collectors.toList());
        for (KeyInstance keyInstanceEntry : sameKeyInstance) {
            int adder = 1;
            String newInstanceName = null;
            do {
                newInstanceName = keyInstanceEntry.instance + "_" + adder;
                ++adder;
            } while (instanceNameIsInvalid.apply(newInstanceName, uniqueStrings.stream().filter(x -> x != keyInstanceEntry)).booleanValue());
            instanceRemapping.put(keyInstanceEntry.instance, newInstanceName);
        }
        return instanceRemapping;
    }

    public static class LegacyEnvConfigResult {
        public final Map<String, String> remapping;
        public final Fmi2SimulationEnvironmentConfiguration adjustedConfiguration;

        public LegacyEnvConfigResult(Map<String, String> remapping, Fmi2SimulationEnvironmentConfiguration adjustedConfiguration) {
            this.remapping = remapping;
            this.adjustedConfiguration = adjustedConfiguration;
        }
    }
}

