/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.framework.core.EnvironmentException;

public class ModelDescriptionValidator {
    private static Predicate<Fmi2ModelDescription.ScalarVariable> notAllowedConfigurations() {
        return ModelDescriptionValidator.exactInitialA().or(ModelDescriptionValidator.calculatedInitialB()).or(ModelDescriptionValidator.calculatedInitialC()).or(ModelDescriptionValidator.initialD()).or(ModelDescriptionValidator.initialE()).negate();
    }

    private static Predicate<Fmi2ModelDescription.ScalarVariable> exactInitialA() {
        return o -> o.causality == Fmi2ModelDescription.Causality.Parameter && (o.variability == ModelDescription.Variability.Fixed || o.variability == ModelDescription.Variability.Tunable) || o.causality == Fmi2ModelDescription.Causality.Output && o.variability == ModelDescription.Variability.Constant || o.causality == Fmi2ModelDescription.Causality.Local && o.variability == ModelDescription.Variability.Constant;
    }

    private static Predicate<Fmi2ModelDescription.ScalarVariable> calculatedInitialB() {
        return o -> o.causality == Fmi2ModelDescription.Causality.CalculatedParameter && (o.variability == ModelDescription.Variability.Fixed || o.variability == ModelDescription.Variability.Tunable) || o.causality == Fmi2ModelDescription.Causality.Local && (o.variability == ModelDescription.Variability.Fixed || o.variability == ModelDescription.Variability.Tunable);
    }

    private static Predicate<Fmi2ModelDescription.ScalarVariable> calculatedInitialC() {
        return o -> o.causality == Fmi2ModelDescription.Causality.Output && (o.variability == ModelDescription.Variability.Discrete || o.variability == ModelDescription.Variability.Continuous) || o.causality == Fmi2ModelDescription.Causality.Local && (o.variability == ModelDescription.Variability.Discrete || o.variability == ModelDescription.Variability.Continuous);
    }

    private static Predicate<Fmi2ModelDescription.ScalarVariable> initialD() {
        return o -> o.causality == Fmi2ModelDescription.Causality.Input && (o.variability == ModelDescription.Variability.Discrete || o.variability == ModelDescription.Variability.Continuous);
    }

    private static Predicate<Fmi2ModelDescription.ScalarVariable> initialE() {
        return o -> o.causality == Fmi2ModelDescription.Causality.Independent && o.variability == ModelDescription.Variability.Continuous;
    }

    private static Predicate<Fmi2ModelDescription.ScalarVariable> initialNotAllowedToBeSpecified() {
        return o -> o.causality == Fmi2ModelDescription.Causality.Input || o.causality == Fmi2ModelDescription.Causality.Independent;
    }

    public Fmi2ModelDescription verify(Fmi2ModelDescription md) throws IllegalAccessException, XPathExpressionException, InvocationTargetException, EnvironmentException {
        List variables = md.getScalarVariables();
        this.verifyVariabilityCausality(variables);
        this.addInitialToModelDescription(variables);
        return md;
    }

    public void verifyVariabilityCausality(List<Fmi2ModelDescription.ScalarVariable> variables) throws IllegalAccessException, XPathExpressionException, InvocationTargetException, EnvironmentException {
        if (variables.stream().anyMatch(ModelDescriptionValidator.notAllowedConfigurations())) {
            List scalarVariablesWithWrongSettings = variables.stream().filter(ModelDescriptionValidator.notAllowedConfigurations()).collect(Collectors.toList());
            throw new EnvironmentException("The following components are being initialized with the wrong settings for causality and variability");
        }
        if (variables.stream().anyMatch(ModelDescriptionValidator.initialNotAllowedToBeSpecified().and(o -> o.initial != null))) {
            throw new EnvironmentException("Some components with causality = \"independent\" or causality = \"input\" has also a specified initial value");
        }
    }

    public List<Fmi2ModelDescription.ScalarVariable> addInitialToModelDescription(List<Fmi2ModelDescription.ScalarVariable> variables) throws IllegalAccessException, XPathExpressionException, InvocationTargetException {
        List<Fmi2ModelDescription.ScalarVariable> decoratedExact = variables.parallelStream().filter(ModelDescriptionValidator.exactInitialA().and(o -> o.initial == null)).collect(Collectors.toList());
        decoratedExact.forEach(o -> {
            o.initial = ModelDescription.Initial.Exact;
        });
        List<Fmi2ModelDescription.ScalarVariable> decoratedCalculated = variables.parallelStream().filter(ModelDescriptionValidator.calculatedInitialB().or(ModelDescriptionValidator.calculatedInitialC()).and(o -> o.initial == null)).collect(Collectors.toList());
        decoratedCalculated.forEach(o -> {
            o.initial = ModelDescription.Initial.Calculated;
        });
        return variables;
    }
}

