/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.IFmuValidator;
import org.intocps.maestro.modeldefinitionchecker.VdmSvChecker;

public class MaestroV1FmuValidation
implements IFmuValidator {
    @Override
    public boolean validate(String id, URI path, IErrorReporter reporter) {
        try {
            Fmi2SimulationEnvironment.FileModelDescriptionResolver resolver = new Fmi2SimulationEnvironment.FileModelDescriptionResolver();
            ModelDescription md = resolver.apply(null, path);
            if (md instanceof Fmi2ModelDescription) {
                this.validateModelDescription((Fmi2ModelDescription)md);
                VdmSvChecker.validateModelVariables((List)((Fmi2ModelDescription)md).getScalarVariables());
            }
            return true;
        }
        catch (Exception e) {
            reporter.report(0, e.getMessage(), null);
            return false;
        }
    }

    void validateModelDescription(Fmi2ModelDescription description) throws IllegalAccessException, XPathExpressionException, InvocationTargetException, VdmSvChecker.ScalarVariableConfigException {
        List outputs = description.getScalarVariables().stream().filter(sv -> sv.causality == Fmi2ModelDescription.Causality.Output).collect(Collectors.toList());
        List declaredOutputs = description.getOutputs();
        List invalidDeclaredOutputs = declaredOutputs.stream().filter(sv -> sv.causality != Fmi2ModelDescription.Causality.Output).collect(Collectors.toList());
        if (!invalidDeclaredOutputs.isEmpty()) {
            throw new VdmSvChecker.ScalarVariableConfigException("Declared outputs in model description model structure contains scalar variables that has Causality != Output: " + invalidDeclaredOutputs);
        }
        if (!(outputs.isEmpty() || declaredOutputs != null && declaredOutputs.size() == outputs.size() && declaredOutputs.containsAll(outputs))) {
            throw new VdmSvChecker.ScalarVariableConfigException("The model description does not declare the following outputs in the model structure: " + outputs.stream().filter(x -> !declaredOutputs.contains(x)).map(Objects::toString));
        }
    }
}

