/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.apache.commons.io.IOUtils;
import org.intocps.fmi.IFmu;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.core.dto.MultiModel;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.fmi.fmi3.Fmi3Causality;
import org.intocps.maestro.fmi.fmi3.Fmi3ModelDescription;
import org.intocps.maestro.framework.core.EnvironmentException;
import org.intocps.maestro.framework.core.FrameworkUnitInfo;
import org.intocps.maestro.framework.core.FrameworkVariableInfo;
import org.intocps.maestro.framework.core.IRelation;
import org.intocps.maestro.framework.core.ISimulationEnvironment;
import org.intocps.maestro.framework.core.ISimulationEnvironmentTransfer;
import org.intocps.maestro.framework.fmi2.ComponentInfo;
import org.intocps.maestro.framework.fmi2.ExplicitModelDescription;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironmentConfiguration;
import org.intocps.maestro.framework.fmi2.FmuFactory;
import org.intocps.maestro.framework.fmi2.IFmuValidator;
import org.intocps.maestro.framework.fmi2.InstanceInfo;
import org.intocps.maestro.framework.fmi2.MaestroV1FmuValidation;
import org.intocps.maestro.framework.fmi2.ModelConnection;
import org.intocps.maestro.framework.fmi2.ModelSwapInfo;
import org.intocps.maestro.framework.fmi2.RelationVariable;
import org.intocps.maestro.parser.template.MablSwapConditionParserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Fmi2SimulationEnvironment
implements ISimulationEnvironment,
ISimulationEnvironmentTransfer {
    static final Logger logger = LoggerFactory.getLogger(Fmi2SimulationEnvironment.class);
    private final Map<String, String> instanceLexToInstanceName = new HashMap<String, String>();
    private final Map<String, List<String>> instanceNameToLogLevels = new HashMap<String, List<String>>();
    Map<LexIdentifier, Set<Relation>> variableToRelations = new HashMap<LexIdentifier, Set<Relation>>();
    Map<String, FrameworkUnitInfo> instanceNameToInstanceComponentInfo = new HashMap<String, FrameworkUnitInfo>();
    HashMap<String, ModelDescription> fmuKeyToModelDescription = new HashMap();
    Map<String, URI> fmuToUri = null;
    Map<String, RelationVariable> variables = new HashMap<String, RelationVariable>();
    Map<String, List<RelationVariable>> globalVariablesToLogForInstance = new HashMap<String, List<RelationVariable>>();
    Map<String, String> instanceToModelTransfer = new HashMap<String, String>();
    Map<String, ModelSwapInfo> instanceToModelSwap = new HashMap<String, ModelSwapInfo>();
    private String faultInjectionConfigurationPath;

    protected Fmi2SimulationEnvironment(Fmi2SimulationEnvironmentConfiguration msg, ModelDescriptionResolver resolver) throws Exception {
        this.initialize(msg, resolver);
    }

    public static Fmi2SimulationEnvironment of(File file, IErrorReporter reporter) throws Exception {
        try (FileInputStream is = new FileInputStream(file);){
            Fmi2SimulationEnvironment fmi2SimulationEnvironment = Fmi2SimulationEnvironment.of(is, reporter);
            return fmi2SimulationEnvironment;
        }
    }

    public static Fmi2SimulationEnvironment of(Fmi2SimulationEnvironmentConfiguration msg, IErrorReporter reporter, ModelDescriptionResolver resolver) throws Exception {
        return new Fmi2SimulationEnvironment(msg, resolver);
    }

    public static Fmi2SimulationEnvironment of(Fmi2SimulationEnvironmentConfiguration msg, IErrorReporter reporter) throws Exception {
        return Fmi2SimulationEnvironment.of(msg, reporter, new FileModelDescriptionResolver());
    }

    public static Fmi2SimulationEnvironment of(InputStream inputStream, IErrorReporter reporter) throws Exception {
        return Fmi2SimulationEnvironment.of(Fmi2SimulationEnvironmentConfiguration.createFromJsonString(new String(inputStream.readAllBytes())), reporter);
    }

    public static List<ModelConnection> buildConnections(Map<String, List<String>> connections) throws Exception {
        Vector<ModelConnection> list = new Vector<ModelConnection>();
        if (connections == null) {
            return new ArrayList<ModelConnection>();
        }
        for (Map.Entry<String, List<String>> entry : connections.entrySet()) {
            for (String input : entry.getValue()) {
                list.add(new ModelConnection(ModelConnection.Variable.parse(entry.getKey()), ModelConnection.Variable.parse(input)));
            }
        }
        return list;
    }

    private static Map<String, List<RelationVariable>> getEnvironmentVariablesToLog(Map<String, List<String>> variablesToLogMap, Map<String, List<RelationVariable>> globalVariablesToLogForInstance) {
        Function<String, String> extractInstance = x -> x.split("}.")[1];
        Map<String, List<RelationVariable>> t = variablesToLogMap.entrySet().stream().collect(Collectors.toMap(entry -> (String)extractInstance.apply((String)entry.getKey()), entry -> ((List)globalVariablesToLogForInstance.get(extractInstance.apply((String)entry.getKey()))).stream().filter(x -> ((List)entry.getValue()).contains(x.getName())).collect(Collectors.toList())));
        return t;
    }

    public List<RelationVariable> getConnectedOutputs() {
        return this.getInstances().stream().flatMap(instance -> this.getRelations(new LexIdentifier((String)instance.getKey(), null)).stream().filter(relation -> relation.getOrigin() == IRelation.InternalOrExternal.External && relation.getDirection() == IRelation.Direction.OutputToInput).map(x -> x.getSource())).collect(Collectors.toList());
    }

    public Set<Map.Entry<String, String>> getModelTransfers() {
        return this.instanceToModelTransfer.entrySet();
    }

    public ModelSwapInfo getModelSwapInfoByInstanceName(String name) {
        return this.instanceToModelSwap.get(name);
    }

    public Set<Map.Entry<String, ModelSwapInfo>> getModelSwaps() {
        return this.instanceToModelSwap.entrySet();
    }

    public Set<Relation> getModelSwapRelations() {
        HashSet<Relation> relations = new HashSet<Relation>();
        for (Map.Entry<String, ModelSwapInfo> entry : this.instanceToModelSwap.entrySet()) {
            for (Set<Relation> relation : entry.getValue().swapRelations.values()) {
                relations.addAll(relation);
            }
        }
        return relations;
    }

    public void setLexNameToInstanceNameMapping(String lexName, String instanceName) {
        this.instanceLexToInstanceName.put(lexName, instanceName);
    }

    public FrameworkUnitInfo getInstanceByLexName(String lexName) {
        if (!this.instanceNameToInstanceComponentInfo.containsKey(lexName)) {
            throw new RuntimeException("Unable to locate instance named " + lexName + " in the simulation environment.");
        }
        return this.instanceNameToInstanceComponentInfo.get(lexName);
    }

    public List<RelationVariable> getVariablesToLog(String instanceName) {
        List<RelationVariable> vars = this.globalVariablesToLogForInstance.get(instanceName);
        if (vars == null) {
            return new ArrayList<RelationVariable>();
        }
        return vars;
    }

    public Set<Map.Entry<String, ModelDescription>> getFmusWithModelDescriptions() {
        return this.fmuKeyToModelDescription.entrySet();
    }

    public Set<? extends Map.Entry<String, ? extends FrameworkUnitInfo>> getInstances() {
        return this.instanceNameToInstanceComponentInfo.entrySet();
    }

    public Set<Map.Entry<String, URI>> getFmuToUri() {
        return this.fmuToUri.entrySet();
    }

    public URI getUriFromFMUName(String fmuName) {
        return this.fmuToUri.get(fmuName);
    }

    ModelSwapInfo convert(MultiModel.ModelSwap swap) throws Exception {
        MultiModel.ModelSwap modelSwap = swap;
        modelSwap.swapConnections = swap.swapConnections;
        return new ModelSwapInfo(modelSwap.swapInstance, modelSwap.swapCondition == null ? null : MablSwapConditionParserUtil.parse((CharStream)CharStreams.fromString((String)modelSwap.swapCondition)), modelSwap.stepCondition == null ? null : MablSwapConditionParserUtil.parse((CharStream)CharStreams.fromString((String)modelSwap.stepCondition)), modelSwap.swapConnections);
    }

    private void addInstance(ModelConnection.Variable var, Fmi2SimulationEnvironmentConfiguration msg) throws Exception {
        if (!this.instanceNameToInstanceComponentInfo.containsKey(var.instance.instanceName)) {
            ModelDescription md = this.fmuKeyToModelDescription.get(var.instance.key);
            if (md instanceof Fmi2ModelDescription) {
                ComponentInfo instanceComponentInfo = new ComponentInfo((Fmi2ModelDescription)md, var.instance.key);
                if (msg.faultInjectInstances != null && msg.faultInjectInstances.containsKey(var.instance.instanceName)) {
                    instanceComponentInfo.setFaultInject(msg.faultInjectInstances.get(var.instance.instanceName));
                }
                if (msg.modelSwaps != null && msg.modelSwaps.containsKey(var.instance.instanceName)) {
                    this.instanceToModelSwap.put(var.instance.instanceName, this.convert(msg.modelSwaps.get(var.instance.instanceName)));
                }
                if (msg.modelTransfers != null && msg.modelTransfers.containsKey(var.instance.instanceName)) {
                    this.instanceToModelTransfer.put(var.instance.instanceName, msg.modelTransfers.get(var.instance.instanceName));
                }
                this.instanceNameToInstanceComponentInfo.put(var.instance.instanceName, instanceComponentInfo);
            } else if (md instanceof Fmi3ModelDescription) {
                this.instanceNameToInstanceComponentInfo.put(var.instance.instanceName, new InstanceInfo((Fmi3ModelDescription)md, var.instance.key));
            } else {
                logger.warn("Cannot add instance as model description type is unknown: {}", (Object)var.instance.key);
            }
        }
    }

    private void initialize(Fmi2SimulationEnvironmentConfiguration msg, ModelDescriptionResolver resolver) throws Exception {
        Map<String, URI> fmuToURI = msg.getFmuFiles();
        this.fmuToUri = fmuToURI;
        List<ModelConnection> connections = Fmi2SimulationEnvironment.buildConnections(msg.getConnections());
        List<ModelConnection> swapConnections = Fmi2SimulationEnvironment.buildConnections(msg.getModelSwapConnections());
        HashMap<String, ModelDescription> fmuKeyToModelDescription = this.buildFmuKeyToFmuMD(fmuToURI, resolver);
        this.fmuKeyToModelDescription = fmuKeyToModelDescription;
        if (msg.faultInjectConfigurationPath != null && !msg.faultInjectConfigurationPath.isEmpty()) {
            if (new File(msg.faultInjectConfigurationPath).exists()) {
                this.faultInjectionConfigurationPath = msg.faultInjectConfigurationPath;
            } else {
                throw new EnvironmentException("Failed to find the fault injection configuration file: " + msg.faultInjectConfigurationPath);
            }
        }
        HashSet<ModelConnection.ModelInstance> instancesFromConnections = new HashSet<ModelConnection.ModelInstance>();
        for (ModelConnection instance : Stream.concat(connections.stream(), swapConnections.stream()).collect(Collectors.toList())) {
            instancesFromConnections.add(instance.from.instance);
            instancesFromConnections.add(instance.to.instance);
            this.addInstance(instance.from, msg);
            this.addInstance(instance.to, msg);
        }
        this.variableToRelations = this.buildRelations(msg, connections, instancesFromConnections);
        this.instanceToModelSwap.forEach((key, value) -> {
            try {
                value.swapRelations = this.buildRelations(msg, Fmi2SimulationEnvironment.buildConnections(value.swapConnections), instancesFromConnections);
                value.swapRelations.entrySet().forEach(e -> ((Set)e.getValue()).removeIf(r -> r.origin.name().equals("Internal")));
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        });
    }

    private Map<LexIdentifier, Set<Relation>> buildRelations(Fmi2SimulationEnvironmentConfiguration msg, List<ModelConnection> connections, Set<ModelConnection.ModelInstance> instancesFromConnections) throws XPathExpressionException, InvocationTargetException, IllegalAccessException, EnvironmentException {
        HashMap<LexIdentifier, Set<Relation>> idToRelations = new HashMap<LexIdentifier, Set<Relation>>();
        for (ModelConnection.ModelInstance instance : instancesFromConnections) {
            LexIdentifier instanceLexIdentifier = new LexIdentifier(instance.instanceName, null);
            List<Object> globalVariablesToLogForGivenInstance = this.globalVariablesToLogForInstance.containsKey(instance.instanceName) ? this.globalVariablesToLogForInstance.get(instance.instanceName) : new ArrayList();
            this.globalVariablesToLogForInstance.putIfAbsent(instance.instanceName, globalVariablesToLogForGivenInstance);
            ModelDescription md = this.fmuKeyToModelDescription.get(instance.key);
            if (md instanceof Fmi2ModelDescription) {
                this.buildFmi2Relation((Fmi2ModelDescription)md, instance, instanceLexIdentifier, idToRelations, connections, globalVariablesToLogForGivenInstance);
            } else if (md instanceof Fmi3ModelDescription) {
                this.buildFmi3Relation((Fmi3ModelDescription)md, instance, instanceLexIdentifier, idToRelations, connections, globalVariablesToLogForGivenInstance);
            }
            HashMap<String, List<String>> globalLogVariablesMaps = new HashMap<String, List<String>>();
            if (msg != null && msg.logVariables != null) {
                globalLogVariablesMaps.putAll(msg.logVariables);
            }
            if (msg != null && msg.livestream != null) {
                msg.livestream.forEach((k, v) -> globalLogVariablesMaps.merge((String)k, (List<String>)v, (v1, v2) -> {
                    TreeSet set = new TreeSet(v1);
                    set.addAll(v2);
                    return new ArrayList(set);
                }));
            }
            ArrayList<RelationVariable<Fmi2ModelDescription.ScalarVariable>> variablesToLogForInstance = new ArrayList<RelationVariable<Fmi2ModelDescription.ScalarVariable>>();
            String logVariablesKey = instance.key + "." + instance.instanceName;
            if (!globalLogVariablesMaps.containsKey(logVariablesKey)) continue;
            for (String s : (List)globalLogVariablesMaps.get(logVariablesKey)) {
                Fmi2ModelDescription.ScalarVariable sv;
                ModelDescription modelDescription = this.fmuKeyToModelDescription.get(instance.key);
                RelationVariable<Fmi2ModelDescription.ScalarVariable> rvar = null;
                if (modelDescription instanceof Fmi2ModelDescription) {
                    sv = ((Fmi2ModelDescription)modelDescription).getScalarVariables().stream().filter(x -> x.name.equals(s)).findFirst().get();
                    rvar = new RelationVariable<Fmi2ModelDescription.ScalarVariable>(sv, sv.getName(), instanceLexIdentifier, sv.getValueReference(), new RelationVariable.RelationFmi2Type(sv.getType()));
                } else if (modelDescription instanceof Fmi3ModelDescription) {
                    sv = ((Fmi3ModelDescription)modelDescription).getScalarVariables().stream().filter(x -> x.getVariable().getName().equals(s)).findFirst().get();
                    rvar = new RelationVariable<Fmi2ModelDescription.ScalarVariable>(sv, sv.getVariable().getName(), instanceLexIdentifier, sv.getVariable().getValueReferenceAsLong(), new RelationVariable.RelationFmi3Type(sv.getVariable().getTypeIdentifier()));
                }
                variablesToLogForInstance.add(rvar);
            }
            if (this.globalVariablesToLogForInstance.containsKey(instance.instanceName)) {
                List<RelationVariable> existingRVs = this.globalVariablesToLogForInstance.get(instance.instanceName);
                for (RelationVariable relationVariable : variablesToLogForInstance) {
                    if (existingRVs.contains(relationVariable)) continue;
                    existingRVs.add(relationVariable);
                }
                continue;
            }
            this.globalVariablesToLogForInstance.put(instance.instanceName, variablesToLogForInstance);
        }
        return idToRelations;
    }

    private void buildFmi2Relation(Fmi2ModelDescription md2, ModelConnection.ModelInstance instance, final LexIdentifier instanceLexIdentifier, Map<LexIdentifier, Set<Relation>> idToRelations, List<ModelConnection> connections, List<RelationVariable> globalVariablesToLogForGivenInstance) throws XPathExpressionException, InvocationTargetException, IllegalAccessException, EnvironmentException {
        List instanceOutputScalarVariablesPorts = md2.getScalarVariables().stream().filter(x -> x.causality == Fmi2ModelDescription.Causality.Output).collect(Collectors.toList());
        Set instanceRelations = idToRelations.computeIfAbsent(instanceLexIdentifier, key -> new HashSet());
        for (Fmi2ModelDescription.ScalarVariable outputScalarVariable : instanceOutputScalarVariablesPorts) {
            List externalInputTargets;
            final RelationVariable outputVariable = this.getOrCreateVariable(new RelationVariable(outputScalarVariable, outputScalarVariable.getName(), instanceLexIdentifier), instanceLexIdentifier);
            HashMap<LexIdentifier, RelationVariable> dependantInputs = new HashMap<LexIdentifier, RelationVariable>();
            for (Fmi2ModelDescription.ScalarVariable inputScalarVariable : outputScalarVariable.outputDependencies.keySet()) {
                if (inputScalarVariable.causality != Fmi2ModelDescription.Causality.Input) continue;
                RelationVariable inputVariable = this.getOrCreateVariable(new RelationVariable(outputScalarVariable, outputScalarVariable.getName(), instanceLexIdentifier), instanceLexIdentifier);
                dependantInputs.put(instanceLexIdentifier, inputVariable);
            }
            if (!dependantInputs.isEmpty()) {
                Relation r = new Relation();
                r.source = outputVariable;
                r.targets = dependantInputs;
                r.direction = IRelation.Direction.OutputToInput;
                r.origin = IRelation.InternalOrExternal.Internal;
                instanceRelations.add(r);
            }
            if ((externalInputTargets = connections.stream().filter(conn -> conn.from.instance.equals(instance) && conn.from.variable.equals(outputScalarVariable.name)).map(conn -> conn.to).collect(Collectors.toList())).isEmpty()) continue;
            globalVariablesToLogForGivenInstance.add(outputVariable);
            HashMap<LexIdentifier, RelationVariable> externalInputs = new HashMap<LexIdentifier, RelationVariable>();
            for (ModelConnection.Variable modelConnToVar : externalInputTargets) {
                FrameworkUnitInfo frameworkUnitInfo = this.instanceNameToInstanceComponentInfo.get(modelConnToVar.instance.instanceName);
                if (frameworkUnitInfo instanceof ComponentInfo) {
                    Optional<Fmi2ModelDescription.ScalarVariable> toScalarVariable = ((ComponentInfo)frameworkUnitInfo).getModelDescription().getScalarVariables().stream().filter(sv -> sv.name.equals(modelConnToVar.variable)).findFirst();
                    if (toScalarVariable.isPresent()) {
                        LexIdentifier inputInstanceLexIdentifier = new LexIdentifier(modelConnToVar.instance.instanceName, null);
                        RelationVariable inputVariable = this.getOrCreateVariable(new RelationVariable(toScalarVariable.get(), toScalarVariable.get().getName(), inputInstanceLexIdentifier), inputInstanceLexIdentifier);
                        externalInputs.put(inputInstanceLexIdentifier, inputVariable);
                        Set inputInstanceRelations = idToRelations.computeIfAbsent(inputInstanceLexIdentifier, key -> new HashSet());
                        Relation r = new Relation();
                        r.source = inputVariable;
                        r.targets = new HashMap<LexIdentifier, RelationVariable>(){
                            {
                                this.put(instanceLexIdentifier, outputVariable);
                            }
                        };
                        r.origin = IRelation.InternalOrExternal.External;
                        r.direction = IRelation.Direction.InputToOutput;
                        inputInstanceRelations.add(r);
                        continue;
                    }
                    throw new EnvironmentException("Failed to find the scalar variable " + modelConnToVar.variable + " at " + modelConnToVar.instance + " when building the dependencies tree");
                }
                logger.warn("Framework unit is not a component: {}", (Object)frameworkUnitInfo.getClass().getName());
            }
            Relation r = new Relation();
            r.source = outputVariable;
            r.targets = externalInputs;
            r.direction = IRelation.Direction.OutputToInput;
            r.origin = IRelation.InternalOrExternal.External;
            instanceRelations.add(r);
        }
    }

    private void buildFmi3Relation(Fmi3ModelDescription md2, ModelConnection.ModelInstance instance, final LexIdentifier instanceLexIdentifier, Map<LexIdentifier, Set<Relation>> idToRelations, List<ModelConnection> connections, List<RelationVariable> globalVariablesToLogForGivenInstance) throws EnvironmentException {
        List instanceOutputScalarVariablesPorts = md2.getScalarVariables().stream().filter(x -> x.getVariable().getCausality() == Fmi3Causality.Output).collect(Collectors.toList());
        Set instanceRelations = idToRelations.computeIfAbsent(instanceLexIdentifier, key -> new HashSet());
        for (Fmi3ModelDescription.Fmi3ScalarVariable outputScalarVariable : instanceOutputScalarVariablesPorts) {
            List externalInputTargets;
            final RelationVariable outputVariable = this.getOrCreateVariable(new RelationVariable(outputScalarVariable, outputScalarVariable.getVariable().getName(), instanceLexIdentifier), instanceLexIdentifier);
            HashMap<LexIdentifier, RelationVariable> dependantInputs = new HashMap<LexIdentifier, RelationVariable>();
            for (Fmi3ModelDescription.Fmi3ScalarVariable inputScalarVariable : outputScalarVariable.getOutputDependencies().keySet()) {
                if (inputScalarVariable.getVariable().getCausality() != Fmi3Causality.Input) continue;
                RelationVariable inputVariable = this.getOrCreateVariable(new RelationVariable(inputScalarVariable, inputScalarVariable.getVariable().getName(), instanceLexIdentifier), instanceLexIdentifier);
                dependantInputs.put(instanceLexIdentifier, inputVariable);
            }
            if (!dependantInputs.isEmpty()) {
                Relation r = new Relation();
                r.source = outputVariable;
                r.targets = dependantInputs;
                r.direction = IRelation.Direction.OutputToInput;
                r.origin = IRelation.InternalOrExternal.Internal;
                instanceRelations.add(r);
            }
            if ((externalInputTargets = connections.stream().filter(conn -> conn.from.instance.equals(instance) && conn.from.variable.equals(outputScalarVariable.getVariable().getName())).map(conn -> conn.to).collect(Collectors.toList())).isEmpty()) continue;
            globalVariablesToLogForGivenInstance.add(outputVariable);
            HashMap<LexIdentifier, RelationVariable> externalInputs = new HashMap<LexIdentifier, RelationVariable>();
            for (ModelConnection.Variable modelConnToVar : externalInputTargets) {
                FrameworkUnitInfo frameworkUnitInfo = this.instanceNameToInstanceComponentInfo.get(modelConnToVar.instance.instanceName);
                if (frameworkUnitInfo instanceof InstanceInfo) {
                    Optional<Fmi3ModelDescription.Fmi3ScalarVariable> toScalarVariable = ((InstanceInfo)frameworkUnitInfo).getModelDescription().getScalarVariables().stream().filter(sv -> sv.getVariable().getName().equals(modelConnToVar.variable)).findFirst();
                    if (toScalarVariable.isPresent()) {
                        LexIdentifier inputInstanceLexIdentifier = new LexIdentifier(modelConnToVar.instance.instanceName, null);
                        RelationVariable inputVariable = this.getOrCreateVariable(new RelationVariable(toScalarVariable.get(), toScalarVariable.get().getVariable().getName(), inputInstanceLexIdentifier), inputInstanceLexIdentifier);
                        externalInputs.put(inputInstanceLexIdentifier, inputVariable);
                        Set inputInstanceRelations = idToRelations.computeIfAbsent(inputInstanceLexIdentifier, key -> new HashSet());
                        Relation r = new Relation();
                        r.source = inputVariable;
                        r.targets = new HashMap<LexIdentifier, RelationVariable>(){
                            {
                                this.put(instanceLexIdentifier, outputVariable);
                            }
                        };
                        r.origin = IRelation.InternalOrExternal.External;
                        r.direction = IRelation.Direction.InputToOutput;
                        inputInstanceRelations.add(r);
                        continue;
                    }
                    throw new EnvironmentException("Failed to find the scalar variable " + modelConnToVar.variable + " at " + modelConnToVar.instance + " when building the dependencies tree");
                }
                logger.warn("Framework unit is not a component: {}", (Object)frameworkUnitInfo.getClass().getName());
            }
            Relation r = new Relation();
            r.source = outputVariable;
            r.targets = externalInputs;
            r.direction = IRelation.Direction.OutputToInput;
            r.origin = IRelation.InternalOrExternal.External;
            instanceRelations.add(r);
        }
    }

    public Map<String, List<String>> getLogLevels() {
        return Collections.unmodifiableMap(this.instanceNameToLogLevels);
    }

    private HashMap<String, ModelDescription> buildFmuKeyToFmuMD(Map<String, URI> fmus, ModelDescriptionResolver resolver) throws Exception {
        HashMap<String, ModelDescription> fmuKeyToFmuWithMD = new HashMap<String, ModelDescription>();
        for (Map.Entry<String, URI> entry : fmus.entrySet()) {
            String key = entry.getKey();
            URI value = entry.getValue();
            fmuKeyToFmuWithMD.put(key, (ModelDescription)resolver.apply(key, value));
        }
        return fmuKeyToFmuWithMD;
    }

    RelationVariable getOrCreateVariable(RelationVariable relationVariable, LexIdentifier instanceLexIdentifier) {
        if (this.variables.containsKey(relationVariable.getName() + instanceLexIdentifier)) {
            return this.variables.get(relationVariable.getName() + instanceLexIdentifier);
        }
        this.variables.put(relationVariable.getName() + instanceLexIdentifier, relationVariable);
        return relationVariable;
    }

    public Set<Relation> getRelations(List<LexIdentifier> identifiers) {
        return identifiers.stream().filter(id -> this.variableToRelations.containsKey(id)).map(lexId -> this.variableToRelations.get(lexId)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<Relation> getRelations(LexIdentifier ... identifiers) {
        if (identifiers == null) {
            return Collections.emptySet();
        }
        return this.getRelations(Arrays.asList(identifiers));
    }

    public Set<Relation> getRelations(String ... identifiers) {
        if (identifiers == null) {
            return Collections.emptySet();
        }
        return this.getRelations(Arrays.stream(identifiers).map(MableAstFactory::newLexIdentifier).collect(Collectors.toList()));
    }

    public <T extends FrameworkUnitInfo> T getUnitInfo(LexIdentifier identifier, Framework framework) {
        return (T)this.instanceNameToInstanceComponentInfo.get(identifier.getText());
    }

    public void check(IErrorReporter reporter) throws Exception {
        List<IFmuValidator> validators = Arrays.asList(new MaestroV1FmuValidation());
        Map<String, Boolean> validated = this.getFmuToUri().stream().collect(Collectors.toMap(Map.Entry::getKey, map -> validators.stream().allMatch(v -> v.validate((String)map.getKey(), (URI)map.getValue(), reporter))));
        if (validated.values().stream().anyMatch(v -> v == false)) {
            throw new Exception("The following FMUs does not respected the standard: " + validated.entrySet().stream().filter(map -> (Boolean)map.getValue() == false).map(Map.Entry::getKey).collect(Collectors.joining(",", "[", "]")));
        }
    }

    public ModelDescription getModelDescription(String name) {
        return this.fmuKeyToModelDescription.get(name);
    }

    public String getFaultInjectionConfigurationPath() {
        return this.faultInjectionConfigurationPath;
    }

    public static class FileModelDescriptionResolver
    implements ModelDescriptionResolver {
        static XPath xPath = XPathFactory.newInstance().newXPath();

        double getFmiVersion(InputStream is) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            doc.getDocumentElement().normalize();
            return Double.parseDouble((String)xPath.compile("fmiModelDescription/@fmiVersion").evaluate(doc, XPathConstants.STRING));
        }

        @Override
        public ModelDescription apply(String s, URI uri) {
            try {
                IFmu fmu = FmuFactory.create(null, uri);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)fmu.getModelDescription(), (OutputStream)buffer);
                double fmiVersion = this.getFmiVersion(new ByteArrayInputStream(buffer.toByteArray()));
                if (fmiVersion < 3.0) {
                    return new ExplicitModelDescription(new ByteArrayInputStream(buffer.toByteArray()));
                }
                return new Fmi3ModelDescription((InputStream)new ByteArrayInputStream(buffer.toByteArray()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Relation
    implements FrameworkVariableInfo,
    IRelation {
        RelationVariable source;
        IRelation.InternalOrExternal origin;
        IRelation.Direction direction;
        Map<LexIdentifier, RelationVariable> targets;

        public IRelation.InternalOrExternal getOrigin() {
            return this.origin;
        }

        public RelationVariable getSource() {
            return this.source;
        }

        public IRelation.Direction getDirection() {
            return this.direction;
        }

        public Map<LexIdentifier, RelationVariable> getTargets() {
            return this.targets;
        }

        public String toString() {
            return (this.origin == IRelation.InternalOrExternal.Internal ? "I" : "E") + " " + this.source + " " + (this.direction == IRelation.Direction.OutputToInput ? "->" : "<-") + " " + this.targets.entrySet().stream().map(map -> ((RelationVariable)map.getValue()).toString()).collect(Collectors.joining(",", "[", "]"));
        }

        public static class RelationBuilder {
            private final RelationVariable source;
            private final Map<LexIdentifier, RelationVariable> targets;
            private IRelation.InternalOrExternal origin = IRelation.InternalOrExternal.External;
            private IRelation.Direction direction = IRelation.Direction.OutputToInput;

            public RelationBuilder(RelationVariable source, Map<LexIdentifier, RelationVariable> targets) {
                this.source = source;
                this.targets = targets;
            }

            public RelationBuilder setInternalOrExternal(IRelation.InternalOrExternal origin) {
                this.origin = origin;
                return this;
            }

            public RelationBuilder setDirection(IRelation.Direction direction) {
                this.direction = direction;
                return this;
            }

            public Relation build() {
                Relation rel = new Relation();
                rel.source = this.source;
                rel.targets = this.targets;
                rel.origin = this.origin;
                rel.direction = this.direction;
                return rel;
            }
        }
    }

    public static interface ModelDescriptionResolver
    extends BiFunction<String, URI, ModelDescription> {
    }
}

