/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2;

import java.util.Optional;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.fmi.fmi3.Fmi3Causality;
import org.intocps.maestro.fmi.fmi3.Fmi3ModelDescription;
import org.intocps.maestro.fmi.fmi3.Fmi3TypeEnum;
import org.intocps.maestro.framework.core.RelationVariable;

public class RelationVariable<SCALAR_TYPE>
implements org.intocps.maestro.framework.core.RelationVariable {
    private final SCALAR_TYPE scalarVariable;
    final String name;
    public final LexIdentifier instance;
    private final long valueReference;
    private final Object type;

    public RelationVariable(SCALAR_TYPE scalarVariable, String name, LexIdentifier instance, long valueReference, RelationVariable.Type type) {
        this.scalarVariable = scalarVariable;
        this.name = name;
        this.instance = instance;
        this.valueReference = valueReference;
        this.type = type;
    }

    public RelationVariable(Fmi2ModelDescription.ScalarVariable scalarVariable, String name, LexIdentifier instance) {
        this(scalarVariable, name, instance, scalarVariable.getValueReference(), new RelationFmi2Type(scalarVariable.getType()));
    }

    public RelationVariable(Fmi3ModelDescription.Fmi3ScalarVariable scalarVariable, String name, LexIdentifier instance) {
        this(scalarVariable, name, instance, scalarVariable.getVariable().getValueReferenceAsLong(), new RelationFmi3Type(scalarVariable.getVariable().getTypeIdentifier()));
    }

    public LexIdentifier getInstance() {
        return this.instance;
    }

    public String getName() {
        return this.name;
    }

    public <T> T getScalarVariable(Class<T> clz) {
        if (clz.isAssignableFrom(this.scalarVariable.getClass())) {
            return clz.cast(this.scalarVariable);
        }
        return null;
    }

    public boolean has(Object scalarAttributeType) {
        if (scalarAttributeType instanceof Fmi2ModelDescription.Causality) {
            return this.has((Fmi2ModelDescription.Causality)scalarAttributeType);
        }
        if (scalarAttributeType instanceof Fmi3Causality) {
            return this.has((Fmi3Causality)scalarAttributeType);
        }
        return false;
    }

    public RelationVariable.Type<Object, Object> getType() {
        return (RelationVariable.Type)this.type;
    }

    public RelationFmi2Type getType2() {
        if (this.type instanceof RelationFmi2Type) {
            return (RelationFmi2Type)this.type;
        }
        if (this.type instanceof RelationFmi3Type) {
            // empty if block
        }
        return null;
    }

    public RelationFmi3Type getType3() {
        if (!(this.type instanceof RelationFmi2Type) && this.type instanceof RelationFmi3Type) {
            return (RelationFmi3Type)this.type;
        }
        return null;
    }

    public long getValueReference() {
        return this.valueReference;
    }

    public boolean has(Fmi2ModelDescription.Causality scalarAttributeType) {
        return this.getFmi2ScalarVariable().map(s -> s.causality == scalarAttributeType).orElse(false);
    }

    public boolean has(Fmi3Causality scalarAttributeType) {
        return this.getFmi3ScalarVariable().map(s -> s.getVariable().getCausality() == scalarAttributeType).orElse(false);
    }

    public Optional<Fmi2ModelDescription.ScalarVariable> getFmi2ScalarVariable() {
        Fmi2ModelDescription.ScalarVariable sv = this.getScalarVariable(Fmi2ModelDescription.ScalarVariable.class);
        return sv == null ? Optional.empty() : Optional.of(sv);
    }

    public Optional<Fmi3ModelDescription.Fmi3ScalarVariable> getFmi3ScalarVariable() {
        Fmi3ModelDescription.Fmi3ScalarVariable sv = this.getScalarVariable(Fmi3ModelDescription.Fmi3ScalarVariable.class);
        return sv == null ? Optional.empty() : Optional.of(sv);
    }

    public SCALAR_TYPE getScalarVariable() {
        return this.scalarVariable;
    }

    public String toString() {
        return this.instance + "." + this.scalarVariable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelationVariable)) {
            return false;
        }
        RelationVariable rv = (RelationVariable)o;
        return rv.toString().equals(this.toString());
    }

    public static class RelationFmi3Type
    implements RelationVariable.Type<Fmi3TypeEnum, Fmi3TypeEnum> {
        final Fmi3TypeEnum type;

        public RelationFmi3Type(Fmi3TypeEnum type) {
            this.type = type;
        }

        public boolean hasType(Fmi3TypeEnum type) {
            return this.type == type;
        }

        public Fmi3TypeEnum get() {
            return this.type;
        }

        public PType getLexType() {
            switch (this.type) {
                case Float32Type: {
                    break;
                }
                case Float64Type: {
                    break;
                }
                case Int8Type: {
                    break;
                }
                case UInt8Type: {
                    break;
                }
                case Int16Type: {
                    break;
                }
                case UInt16Type: {
                    break;
                }
                case Int32Type: {
                    return MableAstFactory.newAIntNumericPrimitiveType();
                }
                case UInt32Type: {
                    break;
                }
                case Int64Type: {
                    break;
                }
                case UInt64Type: {
                    return MableAstFactory.newARealNumericPrimitiveType();
                }
                case BooleanType: {
                    return MableAstFactory.newABoleanPrimitiveType();
                }
                case StringType: {
                    return MableAstFactory.newAStringPrimitiveType();
                }
                case BinaryType: {
                    break;
                }
                case EnumerationType: {
                    break;
                }
                case ClockType: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Converting fmi type: " + this.type + " to mabl type is not supported.");
                }
            }
            return null;
        }

        public PExp getLexDefaultValue() {
            switch (this.type) {
                case Float32Type: {
                    break;
                }
                case Float64Type: {
                    break;
                }
                case Int8Type: {
                    break;
                }
                case UInt8Type: {
                    break;
                }
                case Int16Type: {
                    break;
                }
                case UInt16Type: {
                    break;
                }
                case Int32Type: {
                    return MableAstFactory.newAIntLiteralExp((Integer)0);
                }
                case UInt32Type: {
                    break;
                }
                case Int64Type: {
                    break;
                }
                case UInt64Type: {
                    break;
                }
                case BooleanType: {
                    return MableAstFactory.newABoolLiteralExp((Boolean)false);
                }
                case StringType: {
                    return MableAstFactory.newAStringLiteralExp((String)"");
                }
                case BinaryType: {
                    break;
                }
                case EnumerationType: {
                    break;
                }
            }
            throw new RuntimeException("Unknown type");
        }

        public boolean isAssignableFrom(Fmi3TypeEnum other, boolean autoConvert) {
            return this.type.equals((Object)other);
        }
    }

    public static class RelationFmi2Type
    implements RelationVariable.Type<Fmi2ModelDescription.Type, Fmi2ModelDescription.Types> {
        final Fmi2ModelDescription.Type type;

        public RelationFmi2Type(Fmi2ModelDescription.Type type) {
            this.type = type;
        }

        public boolean hasType(Fmi2ModelDescription.Types type) {
            return this.type.type == type;
        }

        public Fmi2ModelDescription.Type get() {
            return this.type;
        }

        public PType getLexType() {
            switch (this.type.type) {
                case Boolean: {
                    return MableAstFactory.newABoleanPrimitiveType();
                }
                case Real: {
                    return MableAstFactory.newARealNumericPrimitiveType();
                }
                case Integer: {
                    return MableAstFactory.newAIntNumericPrimitiveType();
                }
                case String: {
                    return MableAstFactory.newAStringPrimitiveType();
                }
            }
            throw new UnsupportedOperationException("Converting fmi type: " + this.type + " to mabl type is not supported.");
        }

        public PExp getLexDefaultValue() {
            switch (this.type.type) {
                case Boolean: {
                    return MableAstFactory.newABoolLiteralExp((Boolean)false);
                }
                case Real: {
                    return MableAstFactory.newARealLiteralExp((Double)0.0);
                }
                case Integer: 
                case Enumeration: {
                    return MableAstFactory.newAIntLiteralExp((Integer)0);
                }
                case String: {
                    return MableAstFactory.newAStringLiteralExp((String)"");
                }
            }
            throw new RuntimeException("Unknown type");
        }

        public boolean isAssignableFrom(Fmi2ModelDescription.Type other, boolean autoConvert) {
            return this.type.isAssignableFrom(other, autoConvert);
        }
    }
}

