/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2;

import java.io.File;
import java.net.URI;
import java.util.List;
import maestro.MaestroCheckFMI2;
import org.intocps.fmi.IFmu;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.fmi2.FmuFactory;
import org.intocps.maestro.framework.fmi2.IFmuValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fmi2FmuValidator
implements IFmuValidator {
    static final Logger logger = LoggerFactory.getLogger(Fmi2FmuValidator.class);

    @Override
    public boolean validate(String id, URI path, IErrorReporter reporter) {
        try {
            logger.trace("Validating: {} at {}", (Object)id, (Object)path);
            IFmu fmu = FmuFactory.create(null, path);
            MaestroCheckFMI2 checker = new MaestroCheckFMI2();
            List onFailErrors = checker.check(fmu.getModelDescription());
            onFailErrors.forEach(onFailError -> reporter.warning(onFailError.errno, onFailError.message, new LexToken(String.valueOf(path) + File.separator + "modelDescription.xml", 0, 0)));
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred during validate in Fmi2FmUValidator", e);
        }
    }

    static {
        System.setProperty("vdmj.mapping.search_path", "/annotations");
    }
}

