/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.intocps.fmi.FmuInvocationException;
import org.intocps.fmi.IFmu;
import org.intocps.fmi.jnifmuapi.Factory;
import org.intocps.maestro.framework.fmi2.IFmuFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FmuFactory {
    static final Logger logger = LoggerFactory.getLogger(FmuFactory.class);
    static final IFmuFactory localFactory = new LocalFmuFactory();
    public static IFmuFactory customFactory = null;
    public static final String customFmuFactoryProperty = "coe.fmu.custom.factory";

    public static IFmu create(String path) throws IOException, FmuInvocationException {
        return Factory.create((File)new File(path));
    }

    public static IFmu create(File sessionRoot, URI uri) throws Exception {
        if (customFactory != null && customFactory.accept(uri)) {
            return customFactory.instantiate(sessionRoot, uri);
        }
        return localFactory.instantiate(sessionRoot, uri);
    }

    static {
        String customFmuFactoryQualifiedName = System.getProperty(customFmuFactoryProperty);
        if (customFmuFactoryQualifiedName != null) {
            logger.trace("Obtained custom fmu factory with qualified class name '{}'", (Object)customFmuFactoryQualifiedName);
            try {
                logger.trace("Instantiating custom fmu factory with qualified class name '{}'", (Object)customFmuFactoryQualifiedName);
                Class<?> cls = Class.forName(customFmuFactoryQualifiedName);
                if (IFmuFactory.class.isAssignableFrom(cls)) {
                    customFactory = (IFmuFactory)cls.newInstance();
                } else {
                    logger.trace("Custom fmu factory with qualified class name '{}' dows not implement interface {}", (Object)customFmuFactoryQualifiedName, (Object)IFmuFactory.class.getName());
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error("Failed to instantiate custom fmu factory", (Throwable)e);
            }
        }
    }

    private static class LocalFmuFactory
    implements IFmuFactory {
        private LocalFmuFactory() {
        }

        @Override
        public boolean accept(URI uri) {
            return true;
        }

        @Override
        public IFmu instantiate(File sessionRoot, URI uri) throws Exception {
            if (uri.getScheme() != null && uri.getScheme().equals("session")) {
                uri = new URI("file://" + String.valueOf(sessionRoot.toURI()) + "/" + uri.getPath());
            }
            if (uri.getScheme() == null || uri.getScheme().equals("file")) {
                File file;
                if (!uri.isAbsolute()) {
                    uri = new File(".").toURI().resolve(uri);
                }
                if (!(file = new File(uri)).exists()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
                if (file.isFile()) {
                    return Factory.create((File)file);
                }
                return Factory.createFromDirectory((File)file);
            }
            if ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
                File temp = new File(new File(uri.getPath()).getName());
                FileUtils.copyURLToFile((URL)uri.toURL(), (File)temp);
                return this.instantiate(sessionRoot, temp.toURI());
            }
            logger.error("Cannot create FMU from: {}", (Object)uri);
            return null;
        }
    }
}

