/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2;

import java.util.Objects;
import org.intocps.maestro.framework.fmi2.InvalidVariableStringException;

public class ModelConnection {
    public final Variable from;
    public final Variable to;

    public ModelConnection(Variable from, Variable to) {
        this.from = from;
        this.to = to;
    }

    public static ModelConnection parse(String connection) throws Exception {
        String[] parts = connection.split("=");
        return new ModelConnection(Variable.parse(parts[0]), Variable.parse(parts[1]));
    }

    public String toString() {
        return String.valueOf(this.from) + " -> " + String.valueOf(this.to);
    }

    public static class Variable {
        public final ModelInstance instance;
        public final String variable;

        public Variable(ModelInstance instance, String variable) {
            this.instance = instance;
            this.variable = variable;
        }

        public static Variable parse(String data) throws InvalidVariableStringException {
            String string = new String(data);
            String key = null;
            String instance = null;
            int splitter = 46;
            int index = string.indexOf(46);
            if (index > 0) {
                key = string.substring(0, index);
                if ((index = (string = string.substring(index + 1)).indexOf(46)) != -1) {
                    instance = string.substring(0, index);
                    string = string.substring(index + 1);
                }
                if (key != null && instance != null && string.length() > 0) {
                    return new Variable(new ModelInstance(key, instance), string);
                }
            }
            throw new InvalidVariableStringException("Invalid connection: " + data + " must be of the form key.instance.variableName");
        }

        public String toString() {
            return String.valueOf(this.instance) + "." + this.variable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable1 = (Variable)o;
            return Objects.equals(this.instance, variable1.instance) && Objects.equals(this.variable, variable1.variable);
        }

        public int hashCode() {
            return Objects.hash(this.instance, this.variable);
        }
    }

    public static class ModelInstance {
        public final String key;
        public final String instanceName;

        public ModelInstance(String key, String instanceName) {
            this.key = key;
            this.instanceName = instanceName;
        }

        public static ModelInstance parse(String data) throws InvalidConnectionException {
            String string = new String(data);
            String guid = null;
            String instance = null;
            int splitter = 46;
            int index = string.indexOf(46);
            if (index > 0) {
                guid = string.substring(0, index);
                instance = string.substring(index + 1);
                if (guid != null && instance != null) {
                    return new ModelInstance(guid, instance);
                }
            }
            throw new InvalidConnectionException("Invalid connection: " + data + " must be of the form key.instance");
        }

        public String toString() {
            return this.key + "." + this.instanceName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ModelInstance) {
                return this.key.equals(((ModelInstance)obj).key) && this.instanceName.equals(((ModelInstance)obj).instanceName);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return (this.key + this.instanceName).hashCode();
        }
    }

    public static class InvalidConnectionException
    extends Exception {
        public InvalidConnectionException(String message) {
            super(message);
        }
    }
}

