/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import com.spencerwi.either.Either;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.intocps.maestro.ast.NodeCollector;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.display.PrettyPrinter;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.core.messages.ErrorReporter;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.interpreter.DefaultExternalValueFactory;
import org.intocps.maestro.interpreter.MableInterpreter;
import org.intocps.maestro.interpreter.api.IValueLifecycleHandler;
import org.intocps.maestro.interpreter.values.ExternalModuleValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.intocps.maestro.parser.MablParserUtil;
import org.intocps.maestro.typechecker.TypeChecker;

public abstract class BaseApiTest {
    static BiConsumer<Boolean, String> assertTrueFunc = null;
    static BiConsumer<Boolean, String> assertFalseFunc = null;

    protected BaseApiTest(BiConsumer<Boolean, String> assertTrueFunc, BiConsumer<Boolean, String> assertFalseFunc) {
        BaseApiTest.assertTrueFunc = assertTrueFunc;
        BaseApiTest.assertFalseFunc = assertFalseFunc;
        if (assertTrueFunc == null || assertFalseFunc == null) {
            throw new IllegalStateException("Assertions must be set");
        }
    }

    public static void assertTrue(boolean condition, String message) {
        assertTrueFunc.accept(condition, message);
    }

    public static void assertFalse(boolean condition, String message) {
        assertFalseFunc.accept(condition, message);
    }

    public static List<ARootDocument> getModuleDocuments(List<String> modules) throws IOException {
        List allModules = TypeChecker.getRuntimeModules();
        ArrayList<ARootDocument> documents = new ArrayList<ARootDocument>();
        if (modules != null) {
            for (String module : modules) {
                if (!allModules.contains(module)) continue;
                documents.add(BaseApiTest.getRuntimeModule(module));
            }
        }
        return documents;
    }

    public static ARootDocument getRuntimeModule(String module) throws IOException {
        InputStream resourceAsStream = TypeChecker.getRuntimeModule((String)module);
        if (resourceAsStream == null) {
            return null;
        }
        ARootDocument parse = MablParserUtil.parse((CharStream)CharStreams.fromStream((InputStream)resourceAsStream));
        return parse;
    }

    public void check(String spec, String runtimedata) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, IOException, AnalysisException {
        ErrorReporter reporter = new ErrorReporter();
        ARootDocument doc = MablParserUtil.parse((CharStream)CharStreams.fromStream((InputStream)new ByteArrayInputStream(spec.getBytes())));
        TypeChecker typeChecker = new TypeChecker((IErrorReporter)reporter);
        List maestro2EmbeddedModules = BaseApiTest.getModuleDocuments(TypeChecker.getRuntimeModules()).stream().map(x -> NodeCollector.collect((INode)x, AImportedModuleCompilationUnit.class)).filter(Optional::isPresent).flatMap(x -> ((List)x.get()).stream()).collect(Collectors.toList());
        ARootDocument defaultModules = new ARootDocument();
        defaultModules.setContent(maestro2EmbeddedModules);
        boolean res = typeChecker.typeCheck(Arrays.asList(doc, defaultModules, MablParserUtil.parse((CharStream)CharStreams.fromStream((InputStream)new MDebugAssert.MDebugAssertRuntime().getMablModule()))), new Vector());
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        if (!res) {
            System.out.println(PrettyPrinter.printLineNumbers((INode)doc));
            reporter.printWarnings(writer);
            reporter.printErrors(writer);
        }
        BaseApiTest.assertTrue(res, "Type check errors:" + String.valueOf(out));
        new MableInterpreter(new DefaultExternalValueFactory(new File("target"), arg_0 -> ((TypeChecker)typeChecker).findModule(arg_0), (InputStream)new ByteArrayInputStream(runtimedata.getBytes(StandardCharsets.UTF_8)))).execute(doc);
    }

    public static class MDebugAssert {
        private final FmiBuilder builder;
        private final FmiBuilder.RuntimeModule<PStm> mdebugAssert;

        public MDebugAssert(FmiBuilder builder, FmiBuilder.RuntimeModule<PStm> mdebugAssert) {
            this.builder = builder;
            this.mdebugAssert = mdebugAssert;
        }

        public static MDebugAssert create(FmiBuilder builder) {
            FmiBuilder.RuntimeModule mdebugAssert = builder.loadRuntimeModule(MDebugAssert.class.getSimpleName(), new Object[0]);
            return new MDebugAssert(builder, (FmiBuilder.RuntimeModule<PStm>)mdebugAssert);
        }

        public void assertEquals(FmiBuilder.Variable a, FmiBuilder.Variable b) {
            this.mdebugAssert.callVoid(this.builder.getFunctionBuilder().addArgument("a", FmiBuilder.RuntimeFunction.FunctionType.Type.Any).addArgument("b", FmiBuilder.RuntimeFunction.FunctionType.Type.Any).setName("assertEquals").build(), new Object[]{a, b});
        }

        public void assertEquals(Object a, FmiBuilder.Variable b) {
            this.mdebugAssert.callVoid(this.builder.getFunctionBuilder().addArgument("a", FmiBuilder.RuntimeFunction.FunctionType.Type.Any).addArgument("b", FmiBuilder.RuntimeFunction.FunctionType.Type.Any).setName("assertEquals").build(), new Object[]{a, b});
        }

        public void assertNotEquals(FmiBuilder.Variable a, FmiBuilder.Variable b) {
            this.mdebugAssert.callVoid(this.builder.getFunctionBuilder().addArgument("a", FmiBuilder.RuntimeFunction.FunctionType.Type.Any).addArgument("b", FmiBuilder.RuntimeFunction.FunctionType.Type.Any).setName("assertNotEquals").build(), new Object[]{a, b});
        }

        public void assertNotEquals(Object a, FmiBuilder.Variable b) {
            this.mdebugAssert.callVoid(this.builder.getFunctionBuilder().addArgument("a", FmiBuilder.RuntimeFunction.FunctionType.Type.Any).addArgument("b", FmiBuilder.RuntimeFunction.FunctionType.Type.Any).setName("assertNotEquals").build(), new Object[]{a, b});
        }

        @IValueLifecycleHandler.ValueLifecycle(name="MDebugAssert")
        public static class MDebugAssertRuntime
        implements IValueLifecycleHandler {
            public Either<Exception, Value> instantiate(List<Value> args) {
                Map<String, Value> members = this.getMembers();
                ExternalModuleValue<Map<String, Object>> val = new ExternalModuleValue<Map<String, Object>>(this, members, null){};
                return Either.right((Object)val);
            }

            private Map<String, Value> getMembers() {
                HashMap<String, Value> members = new HashMap<String, Value>();
                members.put("assertEquals", (Value)new FunctionValue.ExternalFunctionValue(a -> {
                    BaseApiTest.assertTrue(0 == ((Value)a.get(0)).deref().compareTo(((Value)a.get(1)).deref()), "values does not match");
                    return new VoidValue();
                }));
                members.put("assertNotEquals", (Value)new FunctionValue.ExternalFunctionValue(a -> {
                    BaseApiTest.assertFalse(0 == ((Value)a.get(0)).deref().compareTo(((Value)a.get(1)).deref()), "values does not match");
                    return new VoidValue();
                }));
                return members;
            }

            public void destroy(Value value) {
            }

            public InputStream getMablModule() {
                return new ByteArrayInputStream(("module " + MDebugAssert.class.getSimpleName() + "{" + this.getMembers().keySet().stream().map(n -> "void " + n + "(?a,?b)").collect(Collectors.joining(";", "", ";")) + "}").getBytes(StandardCharsets.UTF_8));
            }
        }
    }
}

