/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.MableBuilder;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.DepthFirstAnalysisAdaptor;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.ABlockStm;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.AConfigFramework;
import org.intocps.maestro.ast.node.AExpressionStm;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.AUnloadExp;
import org.intocps.maestro.ast.node.AWhileStm;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.BooleanBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.BuilderUtil;
import org.intocps.maestro.framework.fmi2.api.mabl.DataWriter;
import org.intocps.maestro.framework.fmi2.api.mabl.FunctionBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.LoggerFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.MablToMablAPI;
import org.intocps.maestro.framework.fmi2.api.mabl.MathBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.TagNameGenerator;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.ScopeFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.IntVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.RuntimeModuleVariable;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.StringVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableCreatorFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;

public class MablApiBuilder
implements Fmi2Builder<PStm, ASimulationSpecificationCompilationUnit, PExp> {
    static ScopeFmi2Api rootScope;
    final DynamicActiveBuilderScope dynamicScope;
    final TagNameGenerator nameGenerator = new TagNameGenerator();
    private final VariableCreatorFmi2Api currentVariableCreator;
    private final BooleanVariableFmi2Api globalExecutionContinue;
    private final IntVariableFmi2Api globalFmiStatus;
    private final MablToMablAPI mablToMablAPI;
    private final MablSettings settings;
    private final Map<FmiStatus, IntVariableFmi2Api> fmiStatusVariables;
    private final ScopeFmi2Api mainErrorHandlingScope;
    private final Set<String> externalLoadedModuleIdentifier = new HashSet<String>();
    List<String> importedModules = new Vector<String>();
    private MathBuilderFmi2Api mathBuilderApi;
    private BooleanBuilderFmi2Api booleanBuilderApi;
    private DataWriter dataWriter;
    private LoggerFmi2Api runtimeLogger;

    @Deprecated
    public MablApiBuilder(boolean limited) {
        this(new MablSettings(), limited);
    }

    public MablApiBuilder() {
        this(new MablSettings(), false);
    }

    public MablApiBuilder(MablSettings settings, boolean limited) {
        this.settings = settings;
        rootScope = new ScopeFmi2Api(this);
        this.fmiStatusVariables = new HashMap<FmiStatus, IntVariableFmi2Api>();
        if (settings.fmiErrorHandlingEnabled) {
            if (limited) {
                this.fmiStatusVariables.putAll(MablToMablAPI.getFmiStatusVariables(this.nameGenerator));
            } else {
                this.fmiStatusVariables.put(FmiStatus.FMI_OK, rootScope.store("FMI_STATUS_OK", FmiStatus.FMI_OK.getValue()));
                this.fmiStatusVariables.put(FmiStatus.FMI_WARNING, rootScope.store("FMI_STATUS_WARNING", FmiStatus.FMI_WARNING.getValue()));
                this.fmiStatusVariables.put(FmiStatus.FMI_DISCARD, rootScope.store("FMI_STATUS_DISCARD", FmiStatus.FMI_DISCARD.getValue()));
                this.fmiStatusVariables.put(FmiStatus.FMI_ERROR, rootScope.store("FMI_STATUS_ERROR", FmiStatus.FMI_ERROR.getValue()));
                this.fmiStatusVariables.put(FmiStatus.FMI_FATAL, rootScope.store("FMI_STATUS_FATAL", FmiStatus.FMI_FATAL.getValue()));
                this.fmiStatusVariables.put(FmiStatus.FMI_PENDING, rootScope.store("FMI_STATUS_PENDING", FmiStatus.FMI_PENDING.getValue()));
            }
        }
        if (limited) {
            this.globalExecutionContinue = (BooleanVariableFmi2Api)this.createVariable(rootScope, (PType)MableAstFactory.newBoleanType(), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)true), "global", "execution", "continue");
            this.globalFmiStatus = (IntVariableFmi2Api)this.createVariable(rootScope, (PType)MableAstFactory.newIntType(), null, "status");
        } else {
            this.globalExecutionContinue = rootScope.store("global_execution_continue", true);
            this.globalFmiStatus = rootScope.store("status", FmiStatus.FMI_OK.getValue());
        }
        this.mainErrorHandlingScope = rootScope.enterWhile(this.globalExecutionContinue.toPredicate());
        this.dynamicScope = new DynamicActiveBuilderScope(this.mainErrorHandlingScope);
        this.currentVariableCreator = new VariableCreatorFmi2Api(this.dynamicScope, this);
        this.mablToMablAPI = new MablToMablAPI(this);
        if (this.settings.externalRuntimeLogger) {
            this.getMablToMablAPI().createExternalRuntimeLogger();
        }
    }

    public void setRuntimeLogger(LoggerFmi2Api runtimeLogger) {
        this.runtimeLogger = runtimeLogger;
    }

    public MablSettings getSettings() {
        return this.settings;
    }

    public IntVariableFmi2Api getFmiStatusConstant(FmiStatus status) {
        if (!this.settings.fmiErrorHandlingEnabled) {
            throw new IllegalStateException("Fmi error handling feature not enabled");
        }
        return this.fmiStatusVariables.get((Object)status);
    }

    public MablToMablAPI getMablToMablAPI() {
        return this.mablToMablAPI;
    }

    public DataWriter getDataWriter() {
        if (this.dataWriter == null) {
            Fmi2Builder.RuntimeModule<PStm> runtimeModule = this.loadRuntimeModule((Fmi2Builder.Scope<PStm>)this.mainErrorHandlingScope, "DataWriter", new Object[0]);
            this.dataWriter = new DataWriter(this.dynamicScope, this, runtimeModule);
        }
        return this.dataWriter;
    }

    public BooleanVariableFmi2Api getGlobalExecutionContinue() {
        return this.globalExecutionContinue;
    }

    public IntVariableFmi2Api getGlobalFmiStatus() {
        return this.globalFmiStatus;
    }

    private Fmi2Builder.Variable createVariable(IMablScope scope, PType type, PExp initialValue, String ... prefixes) {
        String name = this.nameGenerator.getName(prefixes);
        PStm var = MableBuilder.newVariable((String)name, (PType)type, (PExp)initialValue);
        scope.add(var);
        if (type instanceof ARealNumericPrimitiveType) {
            return new DoubleVariableFmi2Api(var, scope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        }
        if (type instanceof ABooleanPrimitiveType) {
            return new BooleanVariableFmi2Api(var, scope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        }
        if (type instanceof AIntNumericPrimitiveType) {
            return new IntVariableFmi2Api(var, scope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        }
        if (type instanceof AStringPrimitiveType) {
            return new StringVariableFmi2Api(var, scope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        }
        return new VariableFmi2Api(var, type, scope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
    }

    public TagNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    public MathBuilderFmi2Api getMathBuilder() {
        if (this.mathBuilderApi == null) {
            Fmi2Builder.RuntimeModule<PStm> runtimeModule = this.loadRuntimeModule("Math", new Object[0]);
            this.mathBuilderApi = new MathBuilderFmi2Api(this.dynamicScope, this, runtimeModule);
        }
        return this.mathBuilderApi;
    }

    public IMablScope getRootScope() {
        return rootScope;
    }

    public DynamicActiveBuilderScope getDynamicScope() {
        return this.dynamicScope;
    }

    @Override
    public <V, T> Fmi2Builder.Variable<T, V> getCurrentLinkedValue(Fmi2Builder.Port port) {
        PortFmi2Api mp = (PortFmi2Api)port;
        if (mp.getSharedAsVariable() == null) {
            return null;
        }
        return mp.getSharedAsVariable();
    }

    Pair<PStateDesignator, PExp> getDesignatorAndReferenceExp(PExp exp) {
        if (exp instanceof AArrayIndexExp) {
            AArrayIndexExp aArrayIndexExp = (AArrayIndexExp)exp;
        } else if (exp instanceof AIdentifierExp) {
            AIdentifierExp exp_ = (AIdentifierExp)exp;
            return Pair.of((Object)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)exp_.getName()), (Object)exp_);
        }
        throw new RuntimeException("Invalid expression of class: " + exp.getClass());
    }

    @Override
    public DoubleVariableFmi2Api getDoubleVariableFrom(PExp exp) {
        Pair<PStateDesignator, PExp> t = this.getDesignatorAndReferenceExp(exp);
        return new DoubleVariableFmi2Api(null, rootScope, this.dynamicScope, (PStateDesignator)t.getLeft(), (PExp)t.getRight());
    }

    @Override
    public IntVariableFmi2Api getIntVariableFrom(PExp exp) {
        Pair<PStateDesignator, PExp> t = this.getDesignatorAndReferenceExp(exp);
        return new IntVariableFmi2Api(null, rootScope, this.dynamicScope, (PStateDesignator)t.getLeft(), (PExp)t.getRight());
    }

    @Override
    public StringVariableFmi2Api getStringVariableFrom(PExp exp) {
        Pair<PStateDesignator, PExp> t = this.getDesignatorAndReferenceExp(exp);
        return new StringVariableFmi2Api(null, rootScope, this.dynamicScope, (PStateDesignator)t.getLeft(), (PExp)t.getRight());
    }

    @Override
    public BooleanVariableFmi2Api getBooleanVariableFrom(PExp exp) {
        Pair<PStateDesignator, PExp> t = this.getDesignatorAndReferenceExp(exp);
        return new BooleanVariableFmi2Api(null, rootScope, this.dynamicScope, (PStateDesignator)t.getLeft(), (PExp)t.getRight());
    }

    @Override
    public FmuVariableFmi2Api getFmuVariableFrom(PExp exp) {
        return null;
    }

    @Override
    public PStm buildRaw() throws AnalysisException {
        ABlockStm block = rootScope.getBlock().clone();
        if (block == null) {
            return null;
        }
        ABlockStm errorHandlingBlock = this.getErrorHandlingBlock(block);
        if (errorHandlingBlock == null) {
            return null;
        }
        errorHandlingBlock.getBody().add(MableAstFactory.newBreak());
        this.postClean(block);
        return block;
    }

    @Override
    public Fmi2Builder.RuntimeModule<PStm> loadRuntimeModule(String name, Object ... args) {
        return this.loadRuntimeModule((Fmi2Builder.Scope<PStm>)this.dynamicScope.getActiveScope(), name, args);
    }

    @Override
    public Fmi2Builder.RuntimeModule<PStm> loadRuntimeModule(Fmi2Builder.Scope<PStm> scope, String name, Object ... args) {
        return this.loadRuntimeModule(scope, (Fmi2Builder.Scope<PStm> s, PStm var) -> s.add(var), name, args);
    }

    public Fmi2Builder.RuntimeModule<PStm> loadRuntimeModule(Fmi2Builder.Scope<PStm> scope, BiConsumer<Fmi2Builder.Scope<PStm>, PStm> variableStoreFunc, String name, Object ... args) {
        String varName = this.getNameGenerator().getName(name);
        List<PExp> argList = BuilderUtil.toExp(args);
        argList.add(0, (PExp)MableAstFactory.newAStringLiteralExp((String)name));
        PStm var = MableBuilder.newVariable((String)varName, (PType)MableAstFactory.newANameType((String)name), (PExp)MableAstFactory.newALoadExp(argList));
        variableStoreFunc.accept(scope, var);
        RuntimeModuleVariable module = new RuntimeModuleVariable(var, (PType)MableAstFactory.newANameType((String)name), (IMablScope)scope, this.dynamicScope, this, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)varName), (PExp)MableAstFactory.newAIdentifierExp((String)varName));
        this.importedModules.add(name);
        return module;
    }

    private ABlockStm getErrorHandlingBlock(ABlockStm block) throws AnalysisException {
        final AtomicReference errorHandingBlock = new AtomicReference();
        block.apply((IAnalysis)new DepthFirstAnalysisAdaptor(){

            public void caseAWhileStm(AWhileStm node) throws AnalysisException {
                if (node.getBody().equals((Object)MablApiBuilder.this.mainErrorHandlingScope.getBlock())) {
                    errorHandingBlock.set((ABlockStm)node.getBody());
                }
                super.caseAWhileStm(node);
            }
        });
        return (ABlockStm)errorHandingBlock.get();
    }

    @Override
    public ASimulationSpecificationCompilationUnit build() throws AnalysisException {
        ABlockStm block = rootScope.getBlock().clone();
        ABlockStm errorHandingBlock = this.getErrorHandlingBlock(block);
        if (this.runtimeLogger != null && !this.getSettings().externalRuntimeLogger) {
            final VariableFmi2Api loggerVar = (VariableFmi2Api)((Object)this.runtimeLogger.module);
            block.apply((IAnalysis)new DepthFirstAnalysisAdaptor(){

                public void defaultInPStm(PStm node) throws AnalysisException {
                    if (node.equals((Object)loggerVar.getDeclaringStm()) && node.parent() instanceof ABlockStm) {
                        LinkedList body = ((ABlockStm)node.parent()).getBody();
                        boolean unloadFound = false;
                        for (int i = body.indexOf(node); i < body.size(); ++i) {
                            AUnloadExp unload;
                            PStm stm = (PStm)body.get(i);
                            if (!(stm instanceof AExpressionStm) || !(((AExpressionStm)stm).getExp() instanceof AUnloadExp) || (unload = (AUnloadExp)((AExpressionStm)stm).getExp()).getArgs().isEmpty() || !((PExp)unload.getArgs().get(0)).equals((Object)loggerVar.getReferenceExp())) continue;
                            unloadFound = true;
                        }
                        if (!unloadFound) {
                            body.add(MableAstFactory.newExpressionStm((PExp)MableAstFactory.newUnloadExp(Collections.singletonList(loggerVar.getReferenceExp().clone()))));
                        }
                    }
                }
            });
        }
        errorHandingBlock.getBody().add(MableAstFactory.newBreak());
        this.postClean(block);
        ASimulationSpecificationCompilationUnit unit = new ASimulationSpecificationCompilationUnit();
        unit.setBody((PStm)block);
        unit.setFramework(Collections.singletonList(MableAstFactory.newAIdentifier((String)"FMI2")));
        AConfigFramework config = new AConfigFramework();
        config.setName(MableAstFactory.newAIdentifier((String)"FMI2"));
        unit.setImports(Stream.concat(Stream.of(MableAstFactory.newAIdentifier((String)"FMI2")), this.importedModules.stream().map(MableAstFactory::newAIdentifier)).collect(Collectors.toList()));
        return unit;
    }

    private void postClean(ABlockStm block) throws AnalysisException {
        block.apply((IAnalysis)new DepthFirstAnalysisAdaptor(){

            public void caseABlockStm(ABlockStm node) throws AnalysisException {
                if (node.getBody().isEmpty()) {
                    AIfStm ifStm;
                    if (node.parent() instanceof ABlockStm) {
                        ABlockStm pb = (ABlockStm)node.parent();
                        pb.getBody().remove(node);
                    } else if (node.parent() instanceof AIfStm && (ifStm = (AIfStm)node.parent()).getElse() == node) {
                        ifStm.setElse(null);
                    }
                } else {
                    super.caseABlockStm(node);
                }
            }
        });
    }

    public FunctionBuilder getFunctionBuilder() {
        return new FunctionBuilder();
    }

    public BooleanBuilderFmi2Api getBooleanBuilder() {
        if (this.booleanBuilderApi == null) {
            Fmi2Builder.RuntimeModule<PStm> runtimeModule = this.loadRuntimeModule("BooleanLogic", new Object[0]);
            this.booleanBuilderApi = new BooleanBuilderFmi2Api(this.dynamicScope, this, runtimeModule);
        }
        return this.booleanBuilderApi;
    }

    public LoggerFmi2Api getLogger() {
        if (this.runtimeLogger == null) {
            Fmi2Builder.RuntimeModule<PStm> runtimeModule = this.loadRuntimeModule((Fmi2Builder.Scope<PStm>)this.mainErrorHandlingScope, (Fmi2Builder.Scope<PStm> s, PStm var) -> ((ScopeFmi2Api)s).getBlock().getBody().add(0, var), "Logger", new Object[0]);
            this.runtimeLogger = new LoggerFmi2Api(this, runtimeModule);
        }
        return this.runtimeLogger;
    }

    public void addExternalLoadedModuleIdentifier(String name) {
        this.externalLoadedModuleIdentifier.add(name);
    }

    public Set<String> getExternalLoadedModuleIdentifiers() {
        return this.externalLoadedModuleIdentifier;
    }

    public static class MablSettings {
        public boolean fmiErrorHandlingEnabled = true;
        public boolean externalRuntimeLogger = false;
    }

    public static enum FmiStatus {
        FMI_OK(0),
        FMI_WARNING(1),
        FMI_DISCARD(2),
        FMI_ERROR(3),
        FMI_FATAL(4),
        FMI_PENDING(5);

        private final int value;

        private FmiStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

