/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.util.Arrays;
import java.util.stream.Stream;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;

public class MathBuilderFmi2Api {
    private static final String DEFAULT_MODULE_IDENTIFIER = "math";
    private static final String FUNCTION_IS_CLOSE = "isClose";
    private final DynamicActiveBuilderScope dynamicScope;
    private final MablApiBuilder builder;
    private boolean runtimeModuleMode = false;
    private Fmi2Builder.RuntimeModule<PStm> runtimeModule;
    private String moduleIdentifier;

    public MathBuilderFmi2Api(DynamicActiveBuilderScope dynamicScope, MablApiBuilder mablApiBuilder, Fmi2Builder.RuntimeModule<PStm> runtimeModule) {
        this(dynamicScope, mablApiBuilder);
        this.runtimeModuleMode = true;
        this.runtimeModule = runtimeModule;
        this.moduleIdentifier = this.runtimeModule.getName();
    }

    public MathBuilderFmi2Api(DynamicActiveBuilderScope dynamicScope, MablApiBuilder mablApiBuilder) {
        this.dynamicScope = dynamicScope;
        this.builder = mablApiBuilder;
        this.moduleIdentifier = DEFAULT_MODULE_IDENTIFIER;
    }

    private BooleanVariableFmi2Api checkConvergence_(Fmi2Builder.ProvidesTypedReferenceExp a, Fmi2Builder.ProvidesTypedReferenceExp b, Fmi2Builder.ProvidesTypedReferenceExp absoluteTolerance, Fmi2Builder.ProvidesTypedReferenceExp relativeTolerance) {
        String variableName = this.dynamicScope.getName("convergence");
        ALocalVariableStm stm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName), (PType)MableAstFactory.newABoleanPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.moduleIdentifier), (LexIdentifier)MableAstFactory.newAIdentifier((String)FUNCTION_IS_CLOSE), Arrays.asList(a.getExp(), b.getExp(), absoluteTolerance.getExp(), relativeTolerance.getExp())))));
        this.dynamicScope.add(new PStm[]{stm});
        return new BooleanVariableFmi2Api((PStm)stm, this.dynamicScope.getActiveScope(), this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName)), (PExp)MableAstFactory.newAIdentifierExp((String)variableName));
    }

    public BooleanVariableFmi2Api checkConvergence(Fmi2Builder.ProvidesTypedReferenceExp a, Fmi2Builder.ProvidesTypedReferenceExp b, Fmi2Builder.DoubleVariable<PStm> absoluteTolerance, Fmi2Builder.DoubleVariable<PStm> relativeTolerance) {
        if (Stream.of(a, b, absoluteTolerance, relativeTolerance).allMatch(x -> x.getType() instanceof ARealNumericPrimitiveType)) {
            return this.checkConvergence_(a, b, absoluteTolerance, relativeTolerance);
        }
        throw new RuntimeException("Invalid arguments to checkConvergence");
    }
}

