/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl.scoping;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.MableBuilder;
import org.intocps.maestro.ast.node.ABlockStm;
import org.intocps.maestro.ast.node.ABoolLiteralExp;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.ARealLiteralExp;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.AStringLiteralExp;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.AWhileStm;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IfMaBlScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.WhileMaBLScope;
import org.intocps.maestro.framework.fmi2.api.mabl.values.ValueFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.IntVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.StringVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableCreatorFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.intocps.orchestration.coe.modeldefinition.ModelDescription;

public class ScopeFmi2Api
implements IMablScope,
Fmi2Builder.WhileScope<PStm> {
    final ScopeFmi2Api parent;
    private final MablApiBuilder builder;
    private final ABlockStm block;

    public ScopeFmi2Api(MablApiBuilder builder) {
        this.builder = builder;
        this.parent = null;
        this.block = new ABlockStm();
    }

    public ScopeFmi2Api(MablApiBuilder builder, ScopeFmi2Api parent, ABlockStm block) {
        this.builder = builder;
        this.parent = parent;
        this.block = block;
    }

    public ABlockStm getBlock() {
        return this.block;
    }

    @Override
    public WhileMaBLScope enterWhile(Fmi2Builder.LogicBuilder.Predicate predicate) {
        if (predicate instanceof PredicateFmi2Api) {
            PredicateFmi2Api predicate_ = (PredicateFmi2Api)predicate;
            ABlockStm whileBlock = new ABlockStm();
            AWhileStm whileStm = MableAstFactory.newWhile((PExp)predicate_.getExp(), (PStm)whileBlock);
            this.add(new PStm[]{whileStm});
            WhileMaBLScope scope = new WhileMaBLScope(this.builder, (PStm)whileStm, this, whileBlock);
            scope.activate();
            return scope;
        }
        throw new RuntimeException("Predicate has to be of type PredicateFmi2Api. Unknown predicate: " + predicate.getClass());
    }

    @Override
    public IfMaBlScope enterIf(Fmi2Builder.LogicBuilder.Predicate predicate) {
        if (predicate instanceof PredicateFmi2Api) {
            PredicateFmi2Api predicate_ = (PredicateFmi2Api)predicate;
            ABlockStm thenStm = MableAstFactory.newABlockStm((PStm[])new PStm[0]);
            ABlockStm elseStm = MableAstFactory.newABlockStm((PStm[])new PStm[0]);
            AIfStm ifStm = MableAstFactory.newIf((PExp)predicate_.getExp(), (PStm)thenStm, (PStm)elseStm);
            this.add(new PStm[]{ifStm});
            ScopeFmi2Api thenScope = new ScopeFmi2Api(this.builder, this, thenStm);
            ScopeFmi2Api elseScope = new ScopeFmi2Api(this.builder, this, elseStm);
            return new IfMaBlScope(this.builder, (PStm)ifStm, this, thenScope, elseScope);
        }
        throw new RuntimeException("Predicate has to be of type PredicateFmi2Api. Unknown predicate: " + predicate.getClass());
    }

    @Override
    public ScopeFmi2Api leave() {
        return this.parent.activate();
    }

    @Override
    public void add(PStm ... commands) {
        this.addAll((Collection<PStm>)Arrays.asList(commands));
    }

    @Override
    public void addAll(Collection<PStm> commands) {
        commands.forEach(x -> this.block.getBody().add(x));
    }

    @Override
    public void addBefore(PStm item, PStm ... commands) {
        int index = this.block.getBody().indexOf(item);
        if (index == -1) {
            this.add(commands);
        } else {
            int insertAt = index - 1;
            if (insertAt < 0) {
                this.addAll(0, commands);
            } else {
                this.addAll(insertAt, commands);
            }
        }
    }

    private void addAll(int index, PStm ... commands) {
        int index_ = index;
        int i = 0;
        while (i < commands.length) {
            this.block.getBody().add(index_, commands[i]);
            ++i;
            ++index_;
        }
    }

    @Override
    public void addAfter(PStm item, PStm ... commands) {
        int index = this.block.getBody().indexOf(item);
        int insertAt = index + 1;
        if (index == -1 || insertAt > this.block.getBody().size()) {
            this.add(commands);
        } else {
            this.addAll(insertAt, commands);
        }
    }

    @Override
    public ScopeFmi2Api activate() {
        if (this.builder.getDynamicScope() != null) {
            return (ScopeFmi2Api)this.builder.getDynamicScope().activate(this);
        }
        return this;
    }

    @Override
    public DoubleVariableFmi2Api store(double value) {
        return this.store(() -> this.builder.getNameGenerator().getName(), value);
    }

    @Override
    public StringVariableFmi2Api store(String value) {
        return this.store(() -> this.builder.getNameGenerator().getName(), value);
    }

    @Override
    public BooleanVariableFmi2Api store(boolean value) {
        return this.store(() -> this.builder.getNameGenerator().getName(), value);
    }

    @Override
    public IntVariableFmi2Api store(int value) {
        return this.store(() -> this.builder.getNameGenerator().getName(), value);
    }

    @Override
    public DoubleVariableFmi2Api store(String prefix, double value) {
        return this.store(() -> this.builder.getNameGenerator().getName(prefix), value);
    }

    @Override
    public StringVariableFmi2Api store(String prefix, String value) {
        return this.store(() -> this.builder.getNameGenerator().getName(prefix), value);
    }

    @Override
    public BooleanVariableFmi2Api store(String name, boolean value) {
        return this.store(() -> this.builder.getNameGenerator().getName(name), value);
    }

    @Override
    public IntVariableFmi2Api store(String name, int value) {
        return this.store(() -> this.builder.getNameGenerator().getName(name), value);
    }

    @Override
    public <ValType, Val extends Fmi2Builder.Value<ValType>, Var extends Fmi2Builder.Variable<PStm, Val>> Var store(String name, Var value) {
        return this.copy(name, value);
    }

    @Override
    public <ValType, Val extends Fmi2Builder.Value<ValType>, Var extends Fmi2Builder.Variable<PStm, Val>> Var copy(String name, Var value) {
        String varName = this.builder.getNameGenerator().getName(name);
        PStm var = MableBuilder.newVariable((String)varName, (PType)((VariableFmi2Api)value).getType(), (PExp)((VariableFmi2Api)value).getReferenceExp().clone());
        this.add(var);
        return (Var)((VariableFmi2Api)value).clone(var, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)varName), (PExp)MableAstFactory.newAIdentifierExp((String)varName));
    }

    protected DoubleVariableFmi2Api store(Supplier<String> nameProvider, double value) {
        String name = nameProvider.get();
        ARealLiteralExp initial = MableAstFactory.newARealLiteralExp((Double)value);
        PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newARealNumericPrimitiveType(), (PExp)initial);
        this.add(var);
        return new DoubleVariableFmi2Api(var, this, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIdentifierExp((String)name));
    }

    protected BooleanVariableFmi2Api store(Supplier<String> nameProvider, boolean value) {
        String name = nameProvider.get();
        ABoolLiteralExp initial = MableAstFactory.newABoolLiteralExp((Boolean)value);
        PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newABoleanPrimitiveType(), (PExp)initial);
        this.add(var);
        return new BooleanVariableFmi2Api(var, this, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIdentifierExp((String)name));
    }

    protected IntVariableFmi2Api store(Supplier<String> nameProvider, int value) {
        String name = nameProvider.get();
        AIntLiteralExp initial = MableAstFactory.newAIntLiteralExp((Integer)value);
        PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newAIntNumericPrimitiveType(), (PExp)initial);
        this.add(var);
        return new IntVariableFmi2Api(var, this, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIdentifierExp((String)name));
    }

    protected StringVariableFmi2Api store(Supplier<String> nameProvider, String value) {
        String name = nameProvider.get();
        AStringLiteralExp initial = MableAstFactory.newAStringLiteralExp((String)value);
        PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newAStringPrimitiveType(), (PExp)initial);
        this.add(var);
        return new StringVariableFmi2Api(var, this, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIdentifierExp((String)name));
    }

    @Override
    public String getName(String prefix) {
        return this.builder.getNameGenerator().getName(prefix);
    }

    @Override
    public <V> Fmi2Builder.Variable<PStm, V> store(Fmi2Builder.Value<V> tag) {
        return this.storePrivate(this.builder.getNameGenerator().getName(), tag);
    }

    @Override
    public IntVariableFmi2Api store(String namePrefix, IntVariableFmi2Api variable) {
        String name = this.getName(namePrefix);
        PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newAIntNumericPrimitiveType(), (PExp)variable.getReferenceExp());
        this.add(var);
        return new IntVariableFmi2Api(var, this, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIdentifierExp((String)name));
    }

    private <V> Fmi2Builder.Variable<PStm, V> storePrivate(String name, Fmi2Builder.Value<V> tag) {
        if (!(tag instanceof ValueFmi2Api)) {
            throw new IllegalArgumentException();
        }
        ValueFmi2Api v = (ValueFmi2Api)tag;
        ARealLiteralExp initial = null;
        if (v.getType() instanceof ARealNumericPrimitiveType) {
            if (v.get() != null) {
                initial = MableAstFactory.newARealLiteralExp((Double)((Double)v.get()));
            }
        } else if (v.getType() instanceof AIntNumericPrimitiveType) {
            if (v.get() != null) {
                initial = MableAstFactory.newAIntLiteralExp((Integer)((Integer)v.get()));
            }
        } else if (v.getType() instanceof ABooleanPrimitiveType) {
            if (v.get() != null) {
                initial = MableAstFactory.newABoolLiteralExp((Boolean)((Boolean)v.get()));
            }
        } else if (v.getType() instanceof AStringPrimitiveType && v.get() != null) {
            initial = MableAstFactory.newAStringLiteralExp((String)((String)v.get()));
        }
        PStm var = MableBuilder.newVariable((String)name, (PType)v.getType(), (PExp)initial);
        this.add(var);
        VariableFmi2Api variable = new VariableFmi2Api(var, v.getType(), this, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        return variable;
    }

    @Override
    public FmuVariableFmi2Api createFMU(String name, String loaderName, String ... args) throws Exception {
        return VariableCreatorFmi2Api.createFMU(this.builder, this.builder.getNameGenerator(), this.builder.getDynamicScope(), name, loaderName, args, (IMablScope)this);
    }

    @Override
    public FmuVariableFmi2Api createFMU(String name, ModelDescription modelDescription, URI path) throws Exception {
        return VariableCreatorFmi2Api.createFMU(this.builder, this.builder.getNameGenerator(), this.builder.getDynamicScope(), name, modelDescription, path, (IMablScope)this);
    }
}

