/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl.values;

import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.NumericExpressionValueFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.values.DoubleExpressionValue;

public class IntExpressionValue
extends NumericExpressionValueFmi2Api {
    final PType type = new AIntNumericPrimitiveType();
    final PExp exp;

    public IntExpressionValue(PExp exp) {
        this.exp = exp;
    }

    public static IntExpressionValue of(int i) {
        return new IntExpressionValue((PExp)MableAstFactory.newAIntLiteralExp((Integer)i));
    }

    @Override
    public PExp getExp() {
        return this.exp.clone();
    }

    @Override
    public PType getType() {
        return this.type;
    }

    @Override
    public IntExpressionValue subtraction(int v) {
        return new IntExpressionValue((PExp)MableAstFactory.newMinusExp((PExp)this.getExp(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)v)));
    }

    @Override
    public IntExpressionValue addition(int v) {
        return new IntExpressionValue((PExp)MableAstFactory.newPlusExp((PExp)this.getExp(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)v)));
    }

    @Override
    public DoubleExpressionValue divide(int v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newDivideExp((PExp)this.getExp(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)v)));
    }

    @Override
    public IntExpressionValue multiply(int v) {
        return new IntExpressionValue((PExp)MableAstFactory.newMultiplyExp((PExp)this.getExp(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)v)));
    }

    @Override
    public DoubleExpressionValue subtraction(double v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newMinusExp((PExp)this.getExp(), (PExp)MableAstFactory.newARealLiteralExp((Double)v)));
    }

    @Override
    public DoubleExpressionValue addition(double v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newPlusExp((PExp)this.getExp(), (PExp)MableAstFactory.newARealLiteralExp((Double)v)));
    }

    @Override
    public DoubleExpressionValue divide(double v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newDivideExp((PExp)this.getExp(), (PExp)MableAstFactory.newARealLiteralExp((Double)v)));
    }

    @Override
    public DoubleExpressionValue multiply(double v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newMultiplyExp((PExp)this.getExp(), (PExp)MableAstFactory.newARealLiteralExp((Double)v)));
    }

    @Override
    public NumericExpressionValueFmi2Api addition(Fmi2Builder.NumericTypedReferenceExp v) {
        if (v instanceof DoubleExpressionValue) {
            return new DoubleExpressionValue((PExp)MableAstFactory.newPlusExp((PExp)this.getExp(), (PExp)v.getExp()));
        }
        if (v instanceof IntExpressionValue) {
            return new IntExpressionValue((PExp)MableAstFactory.newPlusExp((PExp)this.getExp(), (PExp)v.getExp()));
        }
        throw new RuntimeException("v is not of type NumericExpressionValue.");
    }

    @Override
    public NumericExpressionValueFmi2Api divide(Fmi2Builder.NumericTypedReferenceExp v) {
        if (v instanceof DoubleExpressionValue || v instanceof IntExpressionValue) {
            return new DoubleExpressionValue((PExp)MableAstFactory.newDivideExp((PExp)this.getExp(), (PExp)v.getExp()));
        }
        throw new RuntimeException("v is not of type IntExpressionValue nor DoubleExpressionValue.");
    }

    @Override
    public NumericExpressionValueFmi2Api subtraction(Fmi2Builder.NumericTypedReferenceExp v) {
        if (v instanceof DoubleExpressionValue) {
            return new DoubleExpressionValue((PExp)MableAstFactory.newMinusExp((PExp)this.getExp(), (PExp)v.getExp()));
        }
        if (v instanceof IntExpressionValue) {
            return new IntExpressionValue((PExp)MableAstFactory.newMinusExp((PExp)this.getExp(), (PExp)v.getExp()));
        }
        throw new RuntimeException("v is not of type IntExpressionValue nor DoubleExpressionValue.");
    }

    @Override
    public NumericExpressionValueFmi2Api multiply(Fmi2Builder.NumericTypedReferenceExp v) {
        if (v instanceof DoubleExpressionValue) {
            return new DoubleExpressionValue((PExp)MableAstFactory.newMultiplyExp((PExp)this.getExp(), (PExp)v.getExp()));
        }
        if (v instanceof IntExpressionValue) {
            return new IntExpressionValue((PExp)MableAstFactory.newMultiplyExp((PExp)this.getExp(), (PExp)v.getExp()));
        }
        throw new RuntimeException("v is not of type IntExpressionValue nor DoubleExpressionValue.");
    }
}

