/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl.variables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.MableBuilder;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.DepthFirstAnalysisAdaptor;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.ABlockStm;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.AUIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.RelationVariable;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.BuilderUtil;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.ModelDescriptionContext;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.ScopeFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.values.PortValueExpresssionMapImpl;
import org.intocps.maestro.framework.fmi2.api.mabl.values.PortValueMapImpl;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ArrayVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.PortVariableMapImpl;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.StateMablVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.intocps.orchestration.coe.modeldefinition.ModelDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentVariableFmi2Api
extends VariableFmi2Api<Fmi2Builder.NamedVariable<PStm>>
implements Fmi2Builder.Fmi2ComponentVariable<PStm> {
    static final Logger logger = LoggerFactory.getLogger(ComponentVariableFmi2Api.class);
    private static final int FMI_OK = 0;
    private static final int FMI_WARNING = 1;
    private static final int FMI_DISCARD = 2;
    private static final int FMI_ERROR = 3;
    private static final int FMI_FATAL = 4;
    private static final int FMI_PENDING = 5;
    private static final int FMI_STATUS_LAST_SUCCESSFUL = 2;
    final List<PortFmi2Api> outputPorts;
    final List<PortFmi2Api> inputPorts;
    final List<PortFmi2Api> ports;
    private final FmuVariableFmi2Api owner;
    private final String name;
    private final MablApiBuilder builder;
    private final Map<PType, ArrayVariableFmi2Api<Object>> ioBuffer = new HashMap<PType, ArrayVariableFmi2Api<Object>>();
    private final Map<PType, ArrayVariableFmi2Api<Object>> sharedBuffer = new HashMap<PType, ArrayVariableFmi2Api<Object>>();
    Predicate<Fmi2Builder.Port> isLinked = p -> ((PortFmi2Api)p).getSourcePort() != null;
    ModelDescriptionContext modelDescriptionContext;
    private DoubleVariableFmi2Api currentTimeVar = null;
    private BooleanVariableFmi2Api currentTimeStepFullStepVar = null;
    private ArrayVariableFmi2Api<Object> valueRefBuffer;
    private List<String> variabesToLog;

    public ComponentVariableFmi2Api(PStm declaration, FmuVariableFmi2Api parent, String name, ModelDescriptionContext modelDescriptionContext, MablApiBuilder builder, IMablScope declaringScope, PStateDesignator designator, PExp referenceExp) {
        super(declaration, (PType)MableAstFactory.newANameType((String)"FMI2Component"), declaringScope, builder.getDynamicScope(), designator, referenceExp);
        this.owner = parent;
        this.name = name;
        this.modelDescriptionContext = modelDescriptionContext;
        this.builder = builder;
        this.ports = modelDescriptionContext.nameToSv.values().stream().map(sv -> new PortFmi2Api(this, (ModelDescription.ScalarVariable)sv)).sorted(Comparator.comparing(PortFmi2Api::getPortReferenceValue)).collect(Collectors.toUnmodifiableList());
        this.outputPorts = this.ports.stream().filter(p -> p.scalarVariable.causality == ModelDescription.Causality.Output).sorted(Comparator.comparing(PortFmi2Api::getPortReferenceValue)).collect(Collectors.toUnmodifiableList());
        this.inputPorts = this.ports.stream().filter(p -> p.scalarVariable.causality == ModelDescription.Causality.Input).sorted(Comparator.comparing(PortFmi2Api::getPortReferenceValue)).collect(Collectors.toUnmodifiableList());
    }

    public ModelDescription getModelDescription() {
        return this.modelDescriptionContext.getModelDescription();
    }

    public List<PortFmi2Api> getVariablesToLog() {
        return this.getPorts(this.variabesToLog.toArray(new String[0]));
    }

    public void setVariablesToLog(List<RelationVariable> variablesToLog) {
        this.variabesToLog = variablesToLog.stream().map(x -> x.scalarVariable.getName()).collect(Collectors.toList());
    }

    @Override
    public <V> void share(Fmi2Builder.Port port, Fmi2Builder.Variable<PStm, V> value) {
        HashMap<Fmi2Builder.Port, Fmi2Builder.Variable<PStm, V>> map = new HashMap<Fmi2Builder.Port, Fmi2Builder.Variable<PStm, V>>();
        map.put(port, value);
        this.share((Map<? extends Fmi2Builder.Port, ? extends Fmi2Builder.Variable<PStm, V>>)map);
    }

    private DoubleVariableFmi2Api getCurrentTimeVar() {
        if (this.currentTimeVar == null) {
            String name = this.builder.getNameGenerator().getName(this.name, "current", "time");
            PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newRealType(), (PExp)MableAstFactory.newARealLiteralExp((Double)0.0));
            this.getDeclaredScope().addAfter(this.getDeclaringStm(), var);
            this.currentTimeVar = new DoubleVariableFmi2Api(var, this.getDeclaredScope(), this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        }
        return this.currentTimeVar;
    }

    private BooleanVariableFmi2Api getCurrentTimeFullStepVar() {
        if (this.currentTimeStepFullStepVar == null) {
            String name = this.builder.getNameGenerator().getName(this.name, "current", "time", "full", "step");
            PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newBoleanType(), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)true));
            this.getDeclaredScope().addAfter(this.getDeclaringStm(), var);
            this.currentTimeStepFullStepVar = new BooleanVariableFmi2Api(var, this.getDeclaredScope(), this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        }
        return this.currentTimeStepFullStepVar;
    }

    private ArrayVariableFmi2Api<Object> getValueReferenceBuffer() {
        if (this.valueRefBuffer == null) {
            this.valueRefBuffer = this.createBuffer((PType)MableAstFactory.newUIntType(), "VRef", this.modelDescriptionContext.valRefToSv.size());
        }
        return this.valueRefBuffer;
    }

    private ArrayVariableFmi2Api<Object> getBuffer(Map<PType, ArrayVariableFmi2Api<Object>> buffer, PType type, String prefix, int size) {
        Optional<PType> first = buffer.keySet().stream().filter(x -> x.toString().equals(type.toString())).findFirst();
        if (first.isEmpty()) {
            ArrayVariableFmi2Api<Object> value = this.createBuffer(type, prefix, size);
            buffer.put(type, value);
            return value;
        }
        return buffer.get(first.get());
    }

    private ArrayVariableFmi2Api<Object> getIOBuffer(PType type) {
        return this.getBuffer(this.ioBuffer, type, "IO", this.modelDescriptionContext.valRefToSv.size());
    }

    private ArrayVariableFmi2Api<Object> getSharedBuffer(PType type) {
        return this.getBuffer(this.sharedBuffer, type, "Share", 0);
    }

    private ArrayVariableFmi2Api<Object> createBuffer(PType type, String prefix, int length) {
        String ioBufName = this.builder.getNameGenerator().getName(this.name, "" + type, prefix);
        AArrayInitializer initializer = null;
        if (length > 0) {
            if (type instanceof ARealNumericPrimitiveType) {
                initializer = MableAstFactory.newAArrayInitializer(IntStream.range(0, length).mapToObj(i -> MableAstFactory.newARealLiteralExp((Double)0.0)).collect(Collectors.toList()));
            } else if (type instanceof AIntNumericPrimitiveType || type instanceof AUIntNumericPrimitiveType) {
                initializer = MableAstFactory.newAArrayInitializer(IntStream.range(0, length).mapToObj(i -> MableAstFactory.newAIntLiteralExp((Integer)0)).collect(Collectors.toList()));
            } else if (type instanceof ABooleanPrimitiveType) {
                initializer = MableAstFactory.newAArrayInitializer(IntStream.range(0, length).mapToObj(i -> MableAstFactory.newABoolLiteralExp((Boolean)false)).collect(Collectors.toList()));
            } else if (type instanceof AStringPrimitiveType) {
                initializer = MableAstFactory.newAArrayInitializer(IntStream.range(0, length).mapToObj(i -> MableAstFactory.newAStringLiteralExp((String)"")).collect(Collectors.toList()));
            }
        }
        ALocalVariableStm var = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName), (PType)type, (int)length, initializer));
        this.getDeclaredScope().addAfter(this.getDeclaringStm(), new PStm[]{var});
        List items = IntStream.range(0, length).mapToObj(arg_0 -> this.lambda$createBuffer$10((PStm)var, type, ioBufName, arg_0)).collect(Collectors.toList());
        return new ArrayVariableFmi2Api<Object>((PStm)var, type, this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIdentifierExp((String)ioBufName), items);
    }

    @Override
    public void setupExperiment(Fmi2Builder.DoubleVariable<PStm> startTime, Fmi2Builder.DoubleVariable<PStm> endTime, Double tolerance) {
        this.setupExperiment(((DoubleVariableFmi2Api)startTime).getReferenceExp().clone(), ((DoubleVariableFmi2Api)endTime).getReferenceExp().clone(), tolerance);
    }

    @Override
    public void setupExperiment(double startTime, Double endTime, Double tolerance) {
        this.setupExperiment((PExp)MableAstFactory.newARealLiteralExp((Double)startTime), (PExp)MableAstFactory.newARealLiteralExp((Double)endTime), tolerance);
    }

    private void setupExperiment(PExp startTime, PExp endTime, Double tolerance) {
        IMablScope scope = this.builder.getDynamicScope().getActiveScope();
        this.setupExperiment((Fmi2Builder.Scope<PStm>)scope, startTime, endTime, tolerance);
    }

    private void setupExperiment(Fmi2Builder.Scope<PStm> scope, PExp startTime, PExp endTime, Double tolerance) {
        AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)this.builder.getGlobalFmiStatus().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)this.createFunctionName(FmiFunctionType.SETUPEXPERIMENT), new ArrayList<PExp>(Arrays.asList(MableAstFactory.newABoolLiteralExp((Boolean)(tolerance != null ? 1 : 0)), MableAstFactory.newARealLiteralExp((Double)(tolerance != null ? tolerance : 0.0)), startTime.clone(), MableAstFactory.newABoolLiteralExp((Boolean)(endTime != null ? 1 : 0)), endTime != null ? endTime.clone() : MableAstFactory.newARealLiteralExp((Double)0.0)))));
        scope.add((PStm[])new PStm[]{stm});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, "setupExperiment", this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
        }
    }

    @Override
    public void enterInitializationMode() {
        this.enterInitializationMode(this.builder.getDynamicScope());
    }

    @Override
    public void exitInitializationMode() {
        this.exitInitializationMode(this.builder.getDynamicScope());
    }

    @Override
    public void setupExperiment(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.DoubleVariable<PStm> startTime, Fmi2Builder.DoubleVariable<PStm> endTime, Double tolerance) {
        this.setupExperiment(scope, ((DoubleVariableFmi2Api)startTime).getReferenceExp().clone(), ((DoubleVariableFmi2Api)endTime).getReferenceExp().clone(), tolerance);
    }

    @Override
    public void setupExperiment(Fmi2Builder.Scope<PStm> scope, double startTime, Double endTime, Double tolerance) {
        this.setupExperiment(scope, (PExp)MableAstFactory.newARealLiteralExp((Double)startTime), (PExp)MableAstFactory.newARealLiteralExp((Double)endTime), tolerance);
    }

    @Override
    public void enterInitializationMode(Fmi2Builder.Scope<PStm> scope) {
        PStm stm = this.stateTransitionFunction(FmiFunctionType.ENTERINITIALIZATIONMODE);
        scope.add((PStm[])new PStm[]{stm});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, "enterInitializationMode", this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
        }
    }

    @Override
    public void exitInitializationMode(Fmi2Builder.Scope<PStm> scope) {
        PStm stm = this.stateTransitionFunction(FmiFunctionType.EXITINITIALIZATIONMODE);
        scope.add((PStm[])new PStm[]{stm});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, "exitInitializationMode", this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
        }
    }

    @Override
    public Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>> step(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.DoubleVariable<PStm> currentCommunicationPoint, Fmi2Builder.DoubleVariable<PStm> communicationStepSize, Fmi2Builder.BoolVariable<PStm> noSetFMUStatePriorToCurrentPoint) {
        return this.step(scope, currentCommunicationPoint, communicationStepSize, ((VariableFmi2Api)((Object)noSetFMUStatePriorToCurrentPoint)).getReferenceExp());
    }

    @Override
    public Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>> step(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.DoubleVariable<PStm> currentCommunicationPoint, Fmi2Builder.DoubleVariable<PStm> communicationStepSize) {
        return this.step(scope, currentCommunicationPoint, communicationStepSize, (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false));
    }

    @Override
    public Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>> step(Fmi2Builder.DoubleVariable<PStm> currentCommunicationPoint, Fmi2Builder.DoubleVariable<PStm> communicationStepSize, Fmi2Builder.BoolVariable<PStm> noSetFMUStatePriorToCurrentPoint) {
        return this.step((Fmi2Builder.Scope<PStm>)this.dynamicScope, currentCommunicationPoint, communicationStepSize, noSetFMUStatePriorToCurrentPoint);
    }

    @Override
    public Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>> step(Fmi2Builder.DoubleVariable<PStm> currentCommunicationPoint, Fmi2Builder.DoubleVariable<PStm> communicationStepSize) {
        return this.step((Fmi2Builder.Scope<PStm>)this.dynamicScope, currentCommunicationPoint, communicationStepSize, (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false));
    }

    private Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>> step(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.DoubleVariable<PStm> currentCommunicationPoint, Fmi2Builder.DoubleVariable<PStm> communicationStepSize, PExp noSetFMUStatePriorToCurrentPoint) {
        scope.add((PStm[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)this.builder.getGlobalFmiStatus().getDesignator().clone(), (PExp)MableAstFactory.newACallExp((PExp)this.getReferenceExp().clone(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"doStep"), Arrays.asList(((VariableFmi2Api)((Object)currentCommunicationPoint)).getReferenceExp().clone(), ((VariableFmi2Api)((Object)communicationStepSize)).getReferenceExp().clone(), noSetFMUStatePriorToCurrentPoint.clone())))});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, "doStep", this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
        }
        scope.add((PStm[])new PStm[]{MableAstFactory.newIf((PExp)MableAstFactory.newNotEqual((PExp)this.builder.getGlobalFmiStatus().getReferenceExp().clone(), (PExp)this.builder.getFmiStatusConstant(MablApiBuilder.FmiStatus.FMI_OK).getReferenceExp().clone()), (PStm)MableAstFactory.newABlockStm((PStm[])new PStm[]{MableAstFactory.newIf((PExp)MableAstFactory.newEqual((PExp)this.builder.getGlobalFmiStatus().getReferenceExp().clone(), (PExp)this.builder.getFmiStatusConstant(MablApiBuilder.FmiStatus.FMI_DISCARD).getReferenceExp().clone()), (PStm)MableAstFactory.newABlockStm((PStm[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)this.builder.getGlobalFmiStatus().getDesignator().clone(), (PExp)MableAstFactory.newACallExp((PExp)this.getReferenceExp().clone(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"getRealStatus"), Arrays.asList(MableAstFactory.newAIntLiteralExp((Integer)2), MableAstFactory.newARefExp((PExp)this.getCurrentTimeVar().getReferenceExp().clone())))), MableAstFactory.newAAssignmentStm((PStateDesignator)this.getCurrentTimeFullStepVar().getDesignator().clone(), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false))}), null)}), (PStm)MableAstFactory.newABlockStm((PStm[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)this.getCurrentTimeVar().getDesignator().clone(), (PExp)MableAstFactory.newPlusExp((PExp)((VariableFmi2Api)((Object)currentCommunicationPoint)).getReferenceExp().clone(), (PExp)((VariableFmi2Api)((Object)communicationStepSize)).getReferenceExp().clone())), MableAstFactory.newAAssignmentStm((PStateDesignator)this.getCurrentTimeFullStepVar().getDesignator().clone(), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)true))}))});
        return Map.entry(this.getCurrentTimeFullStepVar(), this.getCurrentTimeVar());
    }

    private PStm stateTransitionFunction(FmiFunctionType type) {
        switch (type) {
            case ENTERINITIALIZATIONMODE: {
                break;
            }
            case EXITINITIALIZATIONMODE: {
                break;
            }
            default: {
                throw new RuntimeException("Attempting to call state transition function with non-state transition function type: " + type);
            }
        }
        AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)this.builder.getGlobalFmiStatus().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)this.createFunctionName(type), (PExp[])new PExp[0]));
        return stm;
    }

    @Override
    public List<PortFmi2Api> getPorts() {
        return this.ports;
    }

    @Override
    public List<PortFmi2Api> getPorts(String ... names) {
        List<String> accept = Arrays.asList(names);
        return this.ports.stream().filter(p -> accept.contains(p.getName())).collect(Collectors.toList());
    }

    @Override
    public List<PortFmi2Api> getPorts(int ... valueReferences) {
        List accept = Arrays.stream(valueReferences).boxed().collect(Collectors.toList());
        return this.ports.stream().filter(p -> accept.contains(p.getPortReferenceValue().intValue())).collect(Collectors.toList());
    }

    @Override
    public PortFmi2Api getPort(String name) {
        return this.getPorts(name).get(0);
    }

    @Override
    public PortFmi2Api getPort(int valueReference) {
        return this.getPorts(valueReference).get(0);
    }

    @Override
    public <V> Map<PortFmi2Api, VariableFmi2Api<V>> get(Fmi2Builder.Port ... ports) {
        return this.get(this.builder.getDynamicScope().getActiveScope(), ports);
    }

    @Override
    public <V> Map<PortFmi2Api, VariableFmi2Api<V>> get(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Port ... ports) {
        if (ports == null || ports.length == 0) {
            return Map.of();
        }
        List selectedPorts = Arrays.stream(ports).map(PortFmi2Api.class::cast).collect(Collectors.toList());
        List sortedPorts = selectedPorts.stream().sorted(Comparator.comparing(Fmi2Builder.Port::getPortReferenceValue)).collect(Collectors.toList());
        ArrayVariableFmi2Api<Object> vrefBuf = this.getValueReferenceBuffer();
        for (int i = 0; i < sortedPorts.size(); ++i) {
            PortFmi2Api p = (PortFmi2Api)sortedPorts.get(i);
            PStateDesignator designator = vrefBuf.items().get(i).getDesignator().clone();
            scope.add((PStm[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)designator, (PExp)MableAstFactory.newAIntLiteralExp((Integer)p.getPortReferenceValue().intValue()))});
        }
        PType type = ((PortFmi2Api)sortedPorts.get(0)).getType();
        ArrayVariableFmi2Api<Object> valBuf = this.getIOBuffer(type);
        AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)this.builder.getGlobalFmiStatus().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)this.createFunctionName(FmiFunctionType.GET, (PortFmi2Api)sortedPorts.get(0)), (PExp[])new PExp[]{vrefBuf.getReferenceExp().clone(), MableAstFactory.newAUIntLiteralExp((Long)Long.valueOf(sortedPorts.size())), valBuf.getReferenceExp().clone()}));
        scope.add((PStm[])new PStm[]{stm});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, this.createFunctionName(FmiFunctionType.GET, (PortFmi2Api)sortedPorts.get(0)), this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
        }
        HashMap<PortFmi2Api, VariableFmi2Api<VariableFmi2Api<Object>>> results = new HashMap<PortFmi2Api, VariableFmi2Api<VariableFmi2Api<Object>>>();
        for (int i = 0; i < sortedPorts.size(); ++i) {
            results.put((PortFmi2Api)sortedPorts.get(i), valBuf.items().get(i));
        }
        return results;
    }

    @Override
    public <V> Map<PortFmi2Api, VariableFmi2Api<V>> get() {
        return this.get(this.builder.getDynamicScope(), (Fmi2Builder.Port[])this.outputPorts.toArray(Fmi2Builder.Port[]::new));
    }

    @Override
    public <V> Map<PortFmi2Api, VariableFmi2Api<V>> get(int ... valueReferences) {
        List accept = Arrays.stream(valueReferences).boxed().collect(Collectors.toList());
        return this.get(this.builder.getDynamicScope(), (Fmi2Builder.Port[])this.outputPorts.stream().filter(p -> accept.contains(p.getPortReferenceValue().intValue())).toArray(Fmi2Builder.Port[]::new));
    }

    @Override
    public <V> Map<PortFmi2Api, VariableFmi2Api<V>> get(String ... names) {
        List<String> accept = Arrays.asList(names);
        return this.get(this.builder.getDynamicScope(), (Fmi2Builder.Port[])this.outputPorts.stream().filter(p -> accept.contains(p.getName())).toArray(Fmi2Builder.Port[]::new));
    }

    @Override
    public <V> Map<PortFmi2Api, VariableFmi2Api<V>> getAndShare(String ... names) {
        Map<PortFmi2Api, VariableFmi2Api<V>> values = this.get(names);
        this.share((Map<? extends Fmi2Builder.Port, ? extends Fmi2Builder.Variable<PStm, V>>)values);
        return values;
    }

    @Override
    public <V> Map<? extends Fmi2Builder.Port, ? extends Fmi2Builder.Variable<PStm, V>> getAndShare(Fmi2Builder.Port ... ports) {
        Map<PortFmi2Api, VariableFmi2Api<V>> values = this.get(ports);
        this.share((Map<? extends Fmi2Builder.Port, ? extends Fmi2Builder.Variable<PStm, V>>)values);
        return values;
    }

    @Override
    public <V> Map<? extends Fmi2Builder.Port, ? extends Fmi2Builder.Variable<PStm, V>> getAndShare() {
        Map<PortFmi2Api, VariableFmi2Api<V>> values = this.get();
        this.share((Map<? extends Fmi2Builder.Port, ? extends Fmi2Builder.Variable<PStm, V>>)values);
        return values;
    }

    public VariableFmi2Api getShared(String name) {
        return this.getPort(name).getSharedAsVariable();
    }

    public VariableFmi2Api getShared(Fmi2Builder.Port port) {
        return ((PortFmi2Api)port).getSharedAsVariable();
    }

    public <V> VariableFmi2Api<V> getSingle(Fmi2Builder.Port port) {
        return this.get(port).entrySet().iterator().next().getValue();
    }

    private String createFunctionName(FmiFunctionType fun) {
        switch (fun) {
            case ENTERINITIALIZATIONMODE: {
                return "enterInitializationMode";
            }
            case EXITINITIALIZATIONMODE: {
                return "exitInitializationMode";
            }
            case SETUPEXPERIMENT: {
                return "setupExperiment";
            }
        }
        throw new RuntimeException("Attempting to call function that is type dependant without specifying type: " + fun);
    }

    private String createFunctionName(FmiFunctionType fun, PortFmi2Api p) {
        return this.createFunctionName(fun, p.scalarVariable.getType().type);
    }

    private String createFunctionName(FmiFunctionType f, ModelDescription.Types type) {
        Object functionName = "";
        switch (f) {
            case GET: {
                functionName = (String)functionName + "get";
                break;
            }
            case SET: {
                functionName = (String)functionName + "set";
                break;
            }
            default: {
                throw new RuntimeException("Attempting to call non type-dependant function with type: " + type);
            }
        }
        functionName = (String)functionName + type.name();
        return functionName;
    }

    public VariableFmi2Api getSingle(String name) {
        return this.get(name).entrySet().iterator().next().getValue();
    }

    public void set(Fmi2Builder.Port p, Fmi2Builder.ExpressionValue v) {
        this.set(new PortValueExpresssionMapImpl((Map<? extends Fmi2Builder.Port, ? extends Fmi2Builder.ExpressionValue>)Map.of(p, v)));
    }

    public void set(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Port p, Fmi2Builder.ExpressionValue v) {
        this.set(scope, (Fmi2Builder.Fmi2ComponentVariable.PortValueMap<V>)new PortValueMapImpl(Map.of(p, v)));
    }

    public void set(Fmi2Builder.Fmi2ComponentVariable.PortExpressionValueMap value) {
        this.set((Fmi2Builder.Scope<PStm>)this.builder.getDynamicScope().getActiveScope(), value);
    }

    public void set(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Fmi2ComponentVariable.PortExpressionValueMap value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        List<PortFmi2Api> selectedPorts = value.keySet().stream().map(PortFmi2Api.class::cast).collect(Collectors.toList());
        this.set(scope, selectedPorts, (PortFmi2Api port) -> {
            Fmi2Builder.ExpressionValue value_ = (Fmi2Builder.ExpressionValue)value.get(port);
            return Map.entry(value_.getExp(), value_.getType());
        });
    }

    @Override
    public <V> void set(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Fmi2ComponentVariable.PortValueMap<V> value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        List<PortFmi2Api> selectedPorts = value.keySet().stream().map(PortFmi2Api.class::cast).collect(Collectors.toList());
        this.set(scope, selectedPorts, (PortFmi2Api port) -> {
            Object val = ((Fmi2Builder.Value)value.get(port)).get();
            if (val instanceof Double) {
                return Map.entry(MableAstFactory.newARealLiteralExp((Double)((Double)val)), MableAstFactory.newRealType());
            }
            if (val instanceof Long) {
                return Map.entry(MableAstFactory.newAUIntLiteralExp((Long)((Long)val)), MableAstFactory.newUIntType());
            }
            if (val instanceof Integer) {
                return Map.entry(MableAstFactory.newAIntLiteralExp((Integer)((Integer)val)), MableAstFactory.newIntType());
            }
            if (val instanceof Boolean) {
                return Map.entry(MableAstFactory.newABoolLiteralExp((Boolean)((Boolean)val)), MableAstFactory.newBoleanType());
            }
            if (val instanceof String) {
                return Map.entry(MableAstFactory.newAStringLiteralExp((String)((String)val)), MableAstFactory.newStringType());
            }
            return null;
        });
    }

    @Override
    public <V> void set(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Fmi2ComponentVariable.PortVariableMap<PStm, V> value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        List<PortFmi2Api> selectedPorts = value.keySet().stream().map(PortFmi2Api.class::cast).collect(Collectors.toList());
        Fmi2Builder.Fmi2ComponentVariable.PortVariableMap valueFinal = value;
        this.set(scope, selectedPorts, (PortFmi2Api port) -> Map.entry(((VariableFmi2Api)valueFinal.get(port)).getReferenceExp().clone(), ((VariableFmi2Api)valueFinal.get((Object)port)).type));
    }

    public void set(Fmi2Builder.Scope<PStm> scope, List<PortFmi2Api> selectedPorts, Function<PortFmi2Api, Map.Entry<PExp, PType>> portToValue) {
        List sortedPorts = selectedPorts.stream().sorted(Comparator.comparing(Fmi2Builder.Port::getPortReferenceValue)).collect(Collectors.toList());
        ArrayVariableFmi2Api<Object> vrefBuf = this.getValueReferenceBuffer();
        for (int i = 0; i < sortedPorts.size(); ++i) {
            Fmi2Builder.Port p = (Fmi2Builder.Port)sortedPorts.get(i);
            PStateDesignator designator = vrefBuf.items().get(i).getDesignator().clone();
            scope.add((PStm[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)designator, (PExp)MableAstFactory.newAIntLiteralExp((Integer)p.getPortReferenceValue().intValue()))});
        }
        PType type = ((PortFmi2Api)sortedPorts.get(0)).getType();
        ArrayVariableFmi2Api<Object> valBuf = this.getIOBuffer(type);
        for (int i = 0; i < sortedPorts.size(); ++i) {
            PortFmi2Api p = (PortFmi2Api)sortedPorts.get(i);
            PStateDesignator designator = valBuf.items().get(i).getDesignator();
            scope.addAll(BuilderUtil.createTypeConvertingAssignment(this.builder, scope, designator.clone(), portToValue.apply(p).getKey().clone(), portToValue.apply(p).getValue(), valBuf.type));
        }
        AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)this.builder.getGlobalFmiStatus().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)this.createFunctionName(FmiFunctionType.SET, (PortFmi2Api)sortedPorts.get(0)), (PExp[])new PExp[]{vrefBuf.getReferenceExp().clone(), MableAstFactory.newAUIntLiteralExp((Long)Long.valueOf(sortedPorts.size())), valBuf.getReferenceExp().clone()}));
        scope.add((PStm[])new PStm[]{stm});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, this.createFunctionName(FmiFunctionType.SET, (PortFmi2Api)sortedPorts.get(0)), this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
        }
    }

    @Override
    public <V> void set(Fmi2Builder.Fmi2ComponentVariable.PortValueMap<V> value) {
        this.set((Fmi2Builder.Scope<PStm>)this.builder.getDynamicScope(), value);
    }

    @Override
    public <V> void set(Fmi2Builder.Port port, VariableFmi2Api<V> value) {
        this.set(new PortVariableMapImpl(Map.of(port, value)));
    }

    @Override
    public <V> void set(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Port port, VariableFmi2Api<V> value) {
        this.set(scope, new PortVariableMapImpl(Map.of(port, value)));
    }

    @Override
    public void set(Fmi2Builder.Port port, Fmi2Builder.Value value) {
        PortValueMapImpl<Fmi2Builder.Value> map = new PortValueMapImpl<Fmi2Builder.Value>();
        map.put(port, value);
        this.set(map);
    }

    @Override
    public <V> void set(Fmi2Builder.Fmi2ComponentVariable.PortVariableMap<PStm, V> value) {
        this.set((Fmi2Builder.Scope<PStm>)this.builder.getDynamicScope(), value);
    }

    @Override
    public void setLinked(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Port ... filterPorts) {
        List<PortFmi2Api> selectedPorts = this.ports.stream().filter(this.isLinked).collect(Collectors.toList());
        if (filterPorts != null && filterPorts.length != 0) {
            List<Fmi2Builder.Port> filterList = Arrays.asList(filterPorts);
            for (Fmi2Builder.Port p : filterList) {
                if (this.isLinked.test(p)) continue;
                logger.warn("Filter for setLinked contains unlined port. Its ignored. {}", (Object)p);
            }
            selectedPorts = selectedPorts.stream().filter(filterList::contains).collect(Collectors.toList());
        }
        for (PortFmi2Api port : selectedPorts) {
            if (port.getSourcePort() == null) {
                throw new RuntimeException("Attempting to obtain shared value from a port that is not linked. This port is missing a required link: " + port);
            }
            if (port.getSourcePort().getSharedAsVariable() != null) continue;
            throw new RuntimeException("Attempting to obtain shared values from a port that is linked but has no value shared. Share a value first. " + port);
        }
        this.set(scope, selectedPorts, (PortFmi2Api k) -> Map.entry(k.getSourcePort().getSharedAsVariable().getReferenceExp().clone(), k.getSourcePort().getSharedAsVariable().type));
    }

    @Override
    public void setLinked() {
        this.setLinked(this.dynamicScope, (Fmi2Builder.Port[])null);
    }

    @Override
    public void setLinked(Fmi2Builder.Port ... filterPorts) {
        this.setLinked(this.dynamicScope, filterPorts);
    }

    @Override
    public void setLinked(String ... filterNames) {
        List<String> accept = Arrays.asList(filterNames);
        this.setLinked(this.dynamicScope, (Fmi2Builder.Port[])this.getPorts().stream().filter(p -> accept.contains(p.getName())).toArray(Fmi2Builder.Port[]::new));
    }

    @Override
    public void setLinked(long ... filterValueReferences) {
        List accept = Arrays.stream(filterValueReferences).boxed().collect(Collectors.toList());
        this.setLinked(this.dynamicScope, (Fmi2Builder.Port[])this.getPorts().stream().filter(p -> accept.contains(p.getPortReferenceValue())).toArray(Fmi2Builder.Port[]::new));
    }

    @Override
    public void setInt(Map<? extends Integer, ? extends Fmi2Builder.Value<Integer>> values) {
    }

    @Override
    public void setString(Map<? extends String, ? extends Fmi2Builder.Value<String>> value) {
    }

    @Override
    public <V> void share(Map<? extends Fmi2Builder.Port, ? extends Fmi2Builder.Variable<PStm, V>> values) {
        values.entrySet().stream().collect(Collectors.groupingBy(map -> ((PortFmi2Api)map.getKey()).getType())).entrySet().stream().forEach(map -> {
            PType type = (PType)map.getKey();
            Map<Fmi2Builder.Port, Fmi2Builder.Variable> data = ((List)map.getValue()).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            data.keySet().stream().map(PortFmi2Api.class::cast).sorted(Comparator.comparing(PortFmi2Api::getPortReferenceValue)).forEach(port -> {
                ArrayVariableFmi2Api<Object> buffer = this.getSharedBuffer(type);
                if (port.getSharedAsVariable() == null) {
                    ArrayVariableFmi2Api<Object> newBuf = this.growBuffer(buffer, 1);
                    this.setSharedBuffer(newBuf, type);
                    VariableFmi2Api<Object> newShared = newBuf.items().get(newBuf.items().size() - 1);
                    port.setSharedAsVariable(newShared);
                }
                PStateDesignator designator = port.getSharedAsVariable().getDesignator();
                this.builder.getDynamicScope().addAll((Collection<PStm>)BuilderUtil.createTypeConvertingAssignment(this.builder, this.dynamicScope, designator.clone(), ((VariableFmi2Api)data.get(port)).getReferenceExp().clone(), port.getType(), ((VariableFmi2Api)data.get((Object)port)).type));
            });
        });
    }

    private void setSharedBuffer(ArrayVariableFmi2Api<Object> newBuf, PType type) {
        this.sharedBuffer.entrySet().removeIf(x -> ((PType)x.getKey()).toString().equals(type.toString()));
        this.sharedBuffer.put(type, newBuf);
    }

    private ArrayVariableFmi2Api<Object> growBuffer(ArrayVariableFmi2Api<Object> buffer, int increaseByCount) {
        String ioBufName = ((AIdentifierExp)buffer.getReferenceExp()).getName().getText();
        int length = buffer.size() + increaseByCount;
        ALocalVariableStm var = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName), (PType)buffer.type, (int)length, null));
        buffer.getDeclaringStm().parent().replaceChild((INode)buffer.getDeclaringStm(), (INode)var);
        List items = IntStream.range(buffer.size(), length).mapToObj(arg_0 -> this.lambda$growBuffer$30((PStm)var, buffer, ioBufName, arg_0)).collect(Collectors.toList());
        items.addAll(0, buffer.items());
        return new ArrayVariableFmi2Api<Object>((PStm)var, buffer.type, this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIdentifierExp((String)ioBufName), items);
    }

    @Override
    public Fmi2Builder.StateVariable<PStm> getState() {
        return this.getState(this.builder.getDynamicScope());
    }

    @Override
    public Fmi2Builder.StateVariable<PStm> getState(Fmi2Builder.Scope<PStm> scope) {
        String stateName = this.builder.getNameGenerator().getName(this.name, "state");
        PStm stateVar = MableBuilder.newVariable((String)stateName, (PType)MableAstFactory.newANameType((String)"FmiComponentState"), (int[])new int[0]);
        scope.add((PStm[])new PStm[]{stateVar});
        StateMablVariableFmi2Api state = new StateMablVariableFmi2Api(stateVar, (PType)MableAstFactory.newANameType((String)"FmiComponentState"), (IMablScope)scope, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)stateName), (PExp)MableAstFactory.newAIdentifierExp((String)stateName), this.builder, this);
        AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)this.builder.getGlobalFmiStatus().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)"getState", Collections.singletonList(MableAstFactory.newARefExp((PExp)state.getReferenceExp().clone()))));
        scope.add((PStm[])new PStm[]{stm});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, "getState", this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
        }
        return state;
    }

    public FmuVariableFmi2Api getOwner() {
        return this.owner;
    }

    public List<PortFmi2Api> getAllConnectedOutputs() {
        return this.ports.stream().filter(x -> x.scalarVariable.causality == ModelDescription.Causality.Output && x.getTargetPorts().size() > 0).collect(Collectors.toList());
    }

    @Override
    public String getName() {
        return this.name;
    }

    private /* synthetic */ VariableFmi2Api lambda$growBuffer$30(PStm var, ArrayVariableFmi2Api buffer, String ioBufName, int i) {
        return new VariableFmi2Api(var, buffer.type, this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((String)ioBufName), Collections.singletonList(MableAstFactory.newAIntLiteralExp((Integer)i))));
    }

    private /* synthetic */ VariableFmi2Api lambda$createBuffer$10(PStm var, PType type, String ioBufName, int i) {
        return new VariableFmi2Api(var, type, this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((String)ioBufName), Collections.singletonList(MableAstFactory.newAIntLiteralExp((Integer)i))));
    }

    static class FmiStatusErrorHandlingBuilder {
        FmiStatusErrorHandlingBuilder() {
        }

        static void generate(MablApiBuilder builder, String method, ComponentVariableFmi2Api instance, IMablScope scope, MablApiBuilder.FmiStatus ... statusesToFail) {
            if (statusesToFail == null || statusesToFail.length == 0) {
                return;
            }
            Function<MablApiBuilder.FmiStatus, PExp> checkStatusEq = s -> MableAstFactory.newEqual((PExp)builder.getGlobalFmiStatus().getReferenceExp().clone(), (PExp)builder.getFmiStatusConstant((MablApiBuilder.FmiStatus)((Object)s)).getReferenceExp().clone());
            PExp exp = checkStatusEq.apply(statusesToFail[0]);
            for (int i = 1; i < statusesToFail.length; ++i) {
                exp = MableAstFactory.newOr((PExp)exp, (PExp)checkStatusEq.apply(statusesToFail[i]));
            }
            ScopeFmi2Api thenScope = scope.enterIf(new PredicateFmi2Api(exp)).enterThen();
            thenScope.add(new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)builder.getGlobalExecutionContinue().getDesignator().clone(), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false))});
            for (MablApiBuilder.FmiStatus status : statusesToFail) {
                ScopeFmi2Api s2 = thenScope.enterIf(new PredicateFmi2Api(checkStatusEq.apply(status))).enterThen();
                builder.getLogger().error(s2, method.substring(0, 1).toUpperCase() + method.substring(1) + " failed on '%s' with status: " + status, instance);
            }
            FmiStatusErrorHandlingBuilder.collectedPreviousLoadedModules((INode)thenScope.getBlock().getBody().getLast()).forEach(p -> {
                thenScope.add(new PStm[]{MableAstFactory.newExpressionStm((PExp)MableAstFactory.newUnloadExp((PExp[])new PExp[]{MableAstFactory.newAIdentifierExp((String)p)}))});
                thenScope.add(new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)p), (PExp)MableAstFactory.newNullExp())});
            });
            thenScope.add(new PStm[]{MableAstFactory.newBreak()});
            thenScope.leave();
        }

        static Set<String> collectedPreviousLoadedModules(INode node) {
            if (node == null) {
                return new HashSet<String>();
            }
            Function<PStm, String> getLoadedIdentifier = s -> {
                final AtomicReference id = new AtomicReference();
                try {
                    s.apply((IAnalysis)new DepthFirstAnalysisAdaptor(){

                        public void caseALoadExp(ALoadExp node) {
                            AVariableDeclaration decl = (AVariableDeclaration)node.getAncestor(AVariableDeclaration.class);
                            if (decl != null) {
                                id.set(decl.getName().getText());
                            }
                            ALocalVariableStm ldecl = (ALocalVariableStm)node.getAncestor(ALocalVariableStm.class);
                            if (decl != null) {
                                id.set(ldecl.getDeclaration().getName().getText());
                            }
                        }
                    });
                }
                catch (AnalysisException e) {
                    e.addSuppressed((Throwable)e);
                }
                return (String)id.get();
            };
            HashSet<String> identifiers = new HashSet<String>();
            if (node instanceof ABlockStm) {
                for (PStm n : ((ABlockStm)node).getBody()) {
                    String id = getLoadedIdentifier.apply(n);
                    if (id == null) continue;
                    identifiers.add(id);
                }
            }
            if (node.parent() != null) {
                identifiers.addAll(FmiStatusErrorHandlingBuilder.collectedPreviousLoadedModules(node.parent()));
            }
            return identifiers;
        }
    }

    public static enum FmiFunctionType {
        GET,
        SET,
        ENTERINITIALIZATIONMODE,
        EXITINITIALIZATIONMODE,
        SETUPEXPERIMENT;

    }
}

