/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl.variables;

import java.util.List;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.MableBuilder;
import org.intocps.maestro.ast.node.AExpressionStm;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.BuilderUtil;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.IntVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.StringVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;

public class RuntimeModuleVariable
extends VariableFmi2Api<Fmi2Builder.NamedVariable<PStm>>
implements Fmi2Builder.RuntimeModule<PStm> {
    private final MablApiBuilder builder;
    private boolean external = false;

    public RuntimeModuleVariable(PStm declaration, PType type, IMablScope declaredScope, Fmi2Builder.DynamicActiveScope<PStm> dynamicScope, MablApiBuilder builder, PStateDesignator designator, PExp referenceExp) {
        this(declaration, type, declaredScope, dynamicScope, builder, designator, referenceExp, false);
    }

    public RuntimeModuleVariable(PStm declaration, PType type, IMablScope declaredScope, Fmi2Builder.DynamicActiveScope<PStm> dynamicScope, MablApiBuilder builder, PStateDesignator designator, PExp referenceExp, boolean external) {
        super(declaration, type, declaredScope, dynamicScope, designator, referenceExp);
        this.builder = builder;
        this.external = external;
    }

    @Override
    public void initialize(List<Fmi2Builder.RuntimeFunction> declaredFuncs) {
    }

    @Override
    public void initialize(Fmi2Builder.RuntimeFunction ... declaredFuncs) {
    }

    @Override
    public void callVoid(Fmi2Builder.RuntimeFunction functionId, Object ... args) {
        this.callVoid(this.dynamicScope, functionId, args);
    }

    @Override
    public void callVoid(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.RuntimeFunction functionId, Object ... args) {
        AExpressionStm stm = MableAstFactory.newExpressionStm((PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)functionId.getName(), BuilderUtil.toExp(args)));
        scope.add((PStm[])new PStm[]{stm});
    }

    @Override
    public <V> Fmi2Builder.Variable<PStm, V> call(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.RuntimeFunction functionId, Object ... args) {
        if (functionId.getReturnType().isNative() && functionId.getReturnType().getNativeType() == Fmi2Builder.RuntimeFunction.FunctionType.Type.Void) {
            this.callVoid(scope, functionId, args);
            return null;
        }
        PType varType = this.getMablType(functionId.getReturnType());
        String name = this.builder.getNameGenerator().getName();
        PStm stm = MableBuilder.newVariable((String)name, (PType)varType, (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)functionId.getName(), BuilderUtil.toExp(args)));
        scope.add((PStm[])new PStm[]{stm});
        if (functionId.getReturnType().isNative()) {
            switch (functionId.getReturnType().getNativeType()) {
                case Void: {
                    return null;
                }
                case Int: 
                case UInt: {
                    return new IntVariableFmi2Api(stm, (IMablScope)scope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
                }
                case Double: {
                    return new DoubleVariableFmi2Api(stm, (IMablScope)scope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
                }
                case String: {
                    return new StringVariableFmi2Api(stm, (IMablScope)scope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
                }
                case Boolean: {
                    return new BooleanVariableFmi2Api(stm, (IMablScope)scope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
                }
            }
        }
        return new VariableFmi2Api(stm, varType.clone(), (IMablScope)scope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
    }

    private PType getMablType(Fmi2Builder.RuntimeFunction.FunctionType type) {
        if (!type.isNative()) {
            return MableAstFactory.newANameType((String)type.getNamedType());
        }
        switch (type.getNativeType()) {
            case Void: {
                return MableAstFactory.newAVoidType();
            }
            case Int: {
                return MableAstFactory.newIntType();
            }
            case UInt: {
                return MableAstFactory.newUIntType();
            }
            case Double: {
                return MableAstFactory.newRealType();
            }
            case String: {
                return MableAstFactory.newStringType();
            }
            case Boolean: {
                return MableAstFactory.newBoleanType();
            }
        }
        return null;
    }

    @Override
    public <V> Fmi2Builder.Variable<PStm, V> call(Fmi2Builder.RuntimeFunction functionId, Object ... args) {
        return this.call(this.dynamicScope, functionId, args);
    }

    @Override
    public void destroy() {
        this.destroy(this.dynamicScope);
    }

    @Override
    public void destroy(Fmi2Builder.Scope<PStm> scope) {
        if (!this.external) {
            scope.add((PStm[])new PStm[]{MableAstFactory.newExpressionStm((PExp)MableAstFactory.newUnloadExp((PExp[])new PExp[]{this.getReferenceExp()}))});
        }
    }
}

