/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import com.spencerwi.either.Either;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.intocps.maestro.ast.NodeCollector;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.core.messages.ErrorReporter;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.RuntimeModuleVariable;
import org.intocps.maestro.interpreter.DefaultExternalValueFactory;
import org.intocps.maestro.interpreter.MableInterpreter;
import org.intocps.maestro.interpreter.api.IValueLifecycleHandler;
import org.intocps.maestro.interpreter.values.ExternalModuleValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.intocps.maestro.parser.MablParserUtil;
import org.intocps.maestro.typechecker.TypeChecker;
import org.junit.jupiter.api.Assertions;

public abstract class BaseApiTest {
    public static List<ARootDocument> getModuleDocuments(List<String> modules) throws IOException {
        List allModules = TypeChecker.getRuntimeModules();
        ArrayList<ARootDocument> documents = new ArrayList<ARootDocument>();
        if (modules != null) {
            for (String module : modules) {
                if (!allModules.contains(module)) continue;
                documents.add(BaseApiTest.getRuntimeModule(module));
            }
        }
        return documents;
    }

    public static ARootDocument getRuntimeModule(String module) throws IOException {
        InputStream resourceAsStream = TypeChecker.getRuntimeModule((String)module);
        if (resourceAsStream == null) {
            return null;
        }
        ARootDocument parse = MablParserUtil.parse((CharStream)CharStreams.fromStream((InputStream)resourceAsStream));
        return parse;
    }

    public void check(String spec, String runtimedata) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, IOException, AnalysisException {
        ErrorReporter reporter = new ErrorReporter();
        ARootDocument doc = MablParserUtil.parse((CharStream)CharStreams.fromStream((InputStream)new ByteArrayInputStream(spec.getBytes())));
        TypeChecker typeChecker = new TypeChecker((IErrorReporter)reporter);
        List maestro2EmbeddedModules = BaseApiTest.getModuleDocuments(TypeChecker.getRuntimeModules()).stream().map(x -> NodeCollector.collect((INode)x, AImportedModuleCompilationUnit.class)).filter(Optional::isPresent).flatMap(x -> ((List)x.get()).stream()).collect(Collectors.toList());
        ARootDocument defaultModules = new ARootDocument();
        defaultModules.setContent(maestro2EmbeddedModules);
        boolean res = typeChecker.typeCheck(Arrays.asList(doc, defaultModules, MablParserUtil.parse((CharStream)CharStreams.fromStream((InputStream)new MDebugAssert.MDebugAssertRuntime().getMablModule()))), new Vector());
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        if (!res) {
            reporter.printWarnings(writer);
            reporter.printErrors(writer);
        }
        Assertions.assertTrue((boolean)res, (String)("Type check errors:" + out.toString()));
        new MableInterpreter(new DefaultExternalValueFactory(new File("target"), (InputStream)new ByteArrayInputStream(runtimedata.getBytes(StandardCharsets.UTF_8)))).execute(doc);
    }

    public static class MDebugAssert {
        private final MablApiBuilder builder;
        private final Fmi2Builder.RuntimeModule<PStm> mdebugAssert;

        public MDebugAssert(MablApiBuilder builder, Fmi2Builder.RuntimeModule<PStm> mdebugAssert) {
            this.builder = builder;
            this.mdebugAssert = mdebugAssert;
        }

        public static MDebugAssert create(MablApiBuilder builder) {
            RuntimeModuleVariable mdebugAssert = builder.loadRuntimeModule(MDebugAssert.class.getSimpleName(), new Object[0]);
            return new MDebugAssert(builder, (Fmi2Builder.RuntimeModule<PStm>)mdebugAssert);
        }

        public void assertEquals(Fmi2Builder.Variable a, Fmi2Builder.Variable b) {
            this.mdebugAssert.callVoid(this.builder.getFunctionBuilder().addArgument("a", Fmi2Builder.RuntimeFunction.FunctionType.Type.Any).addArgument("b", Fmi2Builder.RuntimeFunction.FunctionType.Type.Any).setName("assertEquals").build(), new Object[]{a, b});
        }

        public void assertEquals(Object a, Fmi2Builder.Variable b) {
            this.mdebugAssert.callVoid(this.builder.getFunctionBuilder().addArgument("a", Fmi2Builder.RuntimeFunction.FunctionType.Type.Any).addArgument("b", Fmi2Builder.RuntimeFunction.FunctionType.Type.Any).setName("assertEquals").build(), new Object[]{a, b});
        }

        public void assertNotEquals(Fmi2Builder.Variable a, Fmi2Builder.Variable b) {
            this.mdebugAssert.callVoid(this.builder.getFunctionBuilder().addArgument("a", Fmi2Builder.RuntimeFunction.FunctionType.Type.Any).addArgument("b", Fmi2Builder.RuntimeFunction.FunctionType.Type.Any).setName("assertNotEquals").build(), new Object[]{a, b});
        }

        public void assertNotEquals(Object a, Fmi2Builder.Variable b) {
            this.mdebugAssert.callVoid(this.builder.getFunctionBuilder().addArgument("a", Fmi2Builder.RuntimeFunction.FunctionType.Type.Any).addArgument("b", Fmi2Builder.RuntimeFunction.FunctionType.Type.Any).setName("assertNotEquals").build(), new Object[]{a, b});
        }

        @IValueLifecycleHandler.ValueLifecycle(name="MDebugAssert")
        public static class MDebugAssertRuntime
        implements IValueLifecycleHandler {
            public Either<Exception, Value> instantiate(List<Value> args) {
                Map<String, Value> members = this.getMembers();
                ExternalModuleValue<Map<String, Object>> val = new ExternalModuleValue<Map<String, Object>>(members, null){};
                return Either.right((Object)val);
            }

            private Map<String, Value> getMembers() {
                HashMap<String, Value> members = new HashMap<String, Value>();
                members.put("assertEquals", (Value)new FunctionValue.ExternalFunctionValue(a -> {
                    Assertions.assertTrue((0 == ((Value)a.get(0)).deref().compareTo(((Value)a.get(1)).deref()) ? 1 : 0) != 0, (String)"values does not match");
                    return new VoidValue();
                }));
                members.put("assertNotEquals", (Value)new FunctionValue.ExternalFunctionValue(a -> {
                    Assertions.assertFalse((0 == ((Value)a.get(0)).deref().compareTo(((Value)a.get(1)).deref()) ? 1 : 0) != 0, (String)"values does not match");
                    return new VoidValue();
                }));
                return members;
            }

            public void destroy(Value value) {
            }

            public InputStream getMablModule() {
                return new ByteArrayInputStream(("module " + MDebugAssert.class.getSimpleName() + "{" + this.getMembers().keySet().stream().map(n -> "void " + n + "(?a,?b)").collect(Collectors.joining(";", "", ";")) + "}").getBytes(StandardCharsets.UTF_8));
            }
        }
    }
}

