/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.display.PrettyPrinter;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.BaseApiTest;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.junit.jupiter.api.Test;

public class EnvTest
extends BaseApiTest {
    @Test
    public void test() throws AnalysisException, IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        MablApiBuilder.MablSettings settings = new MablApiBuilder.MablSettings();
        settings.fmiErrorHandlingEnabled = false;
        MablApiBuilder builder = new MablApiBuilder(settings);
        BaseApiTest.MDebugAssert assertModule = BaseApiTest.MDebugAssert.create(builder);
        DynamicActiveBuilderScope dscope = builder.getDynamicScope();
        BooleanVariableFmi2Api trueVar = dscope.store(true);
        BooleanVariableFmi2Api falseVar = dscope.store(false);
        dscope.enterIf((Fmi2Builder.Predicate)dscope.store(true).toPredicate()).enterThen();
        assertModule.assertEquals((Fmi2Builder.Variable)trueVar, (Fmi2Builder.Variable)dscope.copy("var1", (VariableFmi2Api)builder.getExecutionEnvironment().getBool("my.true")));
        assertModule.assertEquals((Fmi2Builder.Variable)falseVar, (Fmi2Builder.Variable)builder.getExecutionEnvironment().getBool("my.false"));
        assertModule.assertEquals("string", (Fmi2Builder.Variable)builder.getExecutionEnvironment().getString("my.string"));
        assertModule.assertEquals(1, (Fmi2Builder.Variable)builder.getExecutionEnvironment().getInt("my.int"));
        assertModule.assertEquals(123.456, (Fmi2Builder.Variable)builder.getExecutionEnvironment().getReal("my.double"));
        String spec = PrettyPrinter.print((INode)builder.build());
        System.out.println(spec);
        HashMap<String, 1> data = new HashMap<String, 1>();
        data.put("environment_variables", new HashMap<String, Object>(){
            {
                this.put("my.false", false);
                this.put("my.true", true);
                this.put("my.string", "string");
                this.put("my.int", 1);
                this.put("my.double", 123.456);
            }
        });
        String runtimeData = new ObjectMapper().writeValueAsString(data);
        this.check(spec, runtimeData);
    }
}

