/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.util.List;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;

public class BooleanBuilderFmi2Api {
    private static final String BOOLEAN_LOGIC_MODULE_IDENTIFIER = "booleanLogic";
    private static final String ALL_TRUE_FUNCTION_NAME = "allTrue";
    private static final String ALL_FALSE_FUNCTION_NAME = "allFalse";
    private final DynamicActiveBuilderScope dynamicScope;
    private final MablApiBuilder builder;
    private String moduleIdentifier;
    private Fmi2Builder.RuntimeModule<PStm> runtimeModule;
    private boolean runtimeModuleMode = false;

    public BooleanBuilderFmi2Api(DynamicActiveBuilderScope dynamicScope, MablApiBuilder mablApiBuilder, Fmi2Builder.RuntimeModule<PStm> runtimeModule) {
        this(dynamicScope, mablApiBuilder);
        this.runtimeModuleMode = true;
        this.runtimeModule = runtimeModule;
        this.moduleIdentifier = runtimeModule.getName();
    }

    public BooleanBuilderFmi2Api(DynamicActiveBuilderScope dynamicScope, MablApiBuilder mablApiBuilder) {
        this.dynamicScope = dynamicScope;
        this.builder = mablApiBuilder;
        this.moduleIdentifier = BOOLEAN_LOGIC_MODULE_IDENTIFIER;
    }

    public BooleanVariableFmi2Api allTrue(String variablePrefix, List<? extends Fmi2Builder.ProvidesTypedReferenceExp> parameters) {
        return this.allTrueFalse(variablePrefix, parameters, ALL_TRUE_FUNCTION_NAME);
    }

    public BooleanVariableFmi2Api allFalse(String variablePrefix, List<? extends Fmi2Builder.ProvidesTypedReferenceExp> parameters) {
        return this.allTrueFalse(variablePrefix, parameters, ALL_FALSE_FUNCTION_NAME);
    }

    private BooleanVariableFmi2Api allTrueFalse(String variablePrefix, List<? extends Fmi2Builder.ProvidesTypedReferenceExp> parameters, String function) {
        String variableName = this.dynamicScope.getName(variablePrefix);
        ALocalVariableStm stm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName), (PType)MableAstFactory.newABoleanPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.moduleIdentifier), (LexIdentifier)MableAstFactory.newAIdentifier((String)function), parameters.stream().map(x -> x.getExp()).collect(Collectors.toList())))));
        this.dynamicScope.add(new PStm[]{stm});
        return new BooleanVariableFmi2Api((PStm)stm, this.dynamicScope.getActiveScope(), this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName)), (PExp)MableAstFactory.newAIdentifierExp((String)variableName));
    }
}

