/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.maestro.ast.ABasicBlockStm;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.SBlockStm;
import org.intocps.maestro.framework.core.IRelation;
import org.intocps.maestro.framework.core.ISimulationEnvironment;
import org.intocps.maestro.framework.core.IVariable;
import org.intocps.maestro.framework.fmi2.ComponentInfo;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.ModelDescriptionContext;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi2Api;

public class FromMaBLToMaBLAPI {
    public static Map.Entry<String, ComponentVariableFmi2Api> getComponentVariableFrom(MablApiBuilder builder, PExp exp, Fmi2SimulationEnvironment env) throws IllegalAccessException, XPathExpressionException, InvocationTargetException {
        if (exp instanceof AIdentifierExp) {
            String componentName = ((AIdentifierExp)exp).getName().getText();
            ComponentInfo instance = env.getInstanceByLexName(componentName);
            ModelDescriptionContext modelDescriptionContext = new ModelDescriptionContext(instance.modelDescription);
            ABasicBlockStm dummyStm = MableAstFactory.newABlockStm((PStm[])new PStm[0]);
            builder.getDynamicScope().add(new PStm[]{dummyStm});
            FmuVariableFmi2Api fmu = new FmuVariableFmi2Api(instance.fmuIdentifier, builder, modelDescriptionContext, (PStm)dummyStm, (PType)MableAstFactory.newANameType((String)"FMI2"), builder.getDynamicScope().getActiveScope(), builder.getDynamicScope(), null, (PExp)new AIdentifierExp(new LexIdentifier(instance.fmuIdentifier.replace("{", "").replace("}", ""), null)));
            ComponentVariableFmi2Api a = new ComponentVariableFmi2Api((PStm)dummyStm, fmu, componentName, modelDescriptionContext, builder, builder.getDynamicScope().getActiveScope(), null, (PExp)MableAstFactory.newAIdentifierExp((String)componentName));
            List variablesToLog = env.getVariablesToLog(componentName);
            a.setVariablesToLog(variablesToLog);
            return Map.entry(componentName, a);
        }
        throw new RuntimeException("exp is not of type AIdentifierExp, but of type: " + exp.getClass());
    }

    public static void createBindings(Map<String, ComponentVariableFmi2Api> instances, ISimulationEnvironment env) throws Fmi2Builder.Port.PortLinkException {
        for (Map.Entry<String, ComponentVariableFmi2Api> entry : instances.entrySet()) {
            for (IRelation relation : env.getRelations(new String[]{entry.getKey()}).stream().filter(x -> x.getDirection() == IRelation.Direction.OutputToInput && x.getOrigin() == IRelation.InternalOrExternal.External).collect(Collectors.toList())) {
                Fmi2Builder.Port[] targets = (PortFmi2Api[])relation.getTargets().entrySet().stream().map(x -> {
                    ComponentVariableFmi2Api instance = (ComponentVariableFmi2Api)instances.get(((IVariable)x.getValue()).getScalarVariable().getInstance().getText());
                    return instance.getPort(((IVariable)x.getValue()).getScalarVariable().getScalarVariable().getName());
                }).toArray(PortFmi2Api[]::new);
                entry.getValue().getPort(relation.getSource().getScalarVariable().getScalarVariable().getName()).linkTo(targets);
            }
        }
    }

    public static Map<String, ComponentVariableFmi2Api> getComponentVariablesFrom(MablApiBuilder builder, PExp exp, Fmi2SimulationEnvironment env) throws IllegalAccessException, XPathExpressionException, InvocationTargetException {
        LexIdentifier componentsArrayName = ((AIdentifierExp)exp).getName();
        SBlockStm containingBlock = (SBlockStm)exp.getAncestor(SBlockStm.class);
        Optional<AVariableDeclaration> componentDeclaration = containingBlock.getBody().stream().filter(ALocalVariableStm.class::isInstance).map(ALocalVariableStm.class::cast).map(ALocalVariableStm::getDeclaration).filter(decl -> decl.getName().equals((Object)componentsArrayName) && !decl.getSize().isEmpty() && decl.getInitializer() != null).findFirst();
        if (!componentDeclaration.isPresent()) {
            throw new RuntimeException("Could not find names for components");
        }
        AArrayInitializer initializer = (AArrayInitializer)componentDeclaration.get().getInitializer();
        List componentIdentifiers = initializer.getExp().stream().filter(AIdentifierExp.class::isInstance).map(AIdentifierExp.class::cast).collect(Collectors.toList());
        HashMap<String, ComponentVariableFmi2Api> fmuInstances = new HashMap<String, ComponentVariableFmi2Api>();
        for (PExp componentName : componentIdentifiers) {
            Map.Entry<String, ComponentVariableFmi2Api> component = FromMaBLToMaBLAPI.getComponentVariableFrom(builder, componentName, env);
            fmuInstances.put(component.getKey(), component.getValue());
        }
        return fmuInstances;
    }
}

