/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ArrayVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;

public class MathBuilderFmi2Api {
    private static final String FUNCTION_IS_CLOSE = "isClose";
    private static final String FUNCTION_MINREALFROMARRAY = "minRealFromArray";
    private final DynamicActiveBuilderScope dynamicScope;
    private final PExp referenceExp;

    public MathBuilderFmi2Api(DynamicActiveBuilderScope dynamicScope, MablApiBuilder mablApiBuilder, PExp referenceExp) {
        this.dynamicScope = dynamicScope;
        this.referenceExp = referenceExp;
    }

    private BooleanVariableFmi2Api checkConvergenceInternal(Fmi2Builder.ProvidesTypedReferenceExp a, Fmi2Builder.ProvidesTypedReferenceExp b, Fmi2Builder.ProvidesTypedReferenceExp absoluteTolerance, Fmi2Builder.ProvidesTypedReferenceExp relativeTolerance) {
        String variableName = this.dynamicScope.getName("convergence");
        ALocalVariableStm stm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName), (PType)MableAstFactory.newABoleanPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newACallExp((PExp)this.referenceExp.clone(), (LexIdentifier)MableAstFactory.newAIdentifier((String)FUNCTION_IS_CLOSE), Arrays.asList(a.getExp(), b.getExp(), absoluteTolerance.getExp(), relativeTolerance.getExp())))));
        this.dynamicScope.add(new PStm[]{stm});
        return new BooleanVariableFmi2Api((PStm)stm, this.dynamicScope.getActiveScope(), this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName)), (PExp)MableAstFactory.newAIdentifierExp((String)variableName));
    }

    public BooleanVariableFmi2Api checkConvergence(Fmi2Builder.ProvidesTypedReferenceExp a, Fmi2Builder.ProvidesTypedReferenceExp b, Fmi2Builder.DoubleVariable<PStm> absoluteTolerance, Fmi2Builder.DoubleVariable<PStm> relativeTolerance) {
        if (Stream.of(a, b, absoluteTolerance, relativeTolerance).allMatch(x -> x.getType() instanceof ARealNumericPrimitiveType)) {
            return this.checkConvergenceInternal(a, b, absoluteTolerance, relativeTolerance);
        }
        throw new RuntimeException("Invalid arguments to checkConvergence");
    }

    public DoubleVariableFmi2Api minRealFromArray(ArrayVariableFmi2Api<Double> array) {
        String variableName = this.dynamicScope.getName("minVal");
        ALocalVariableStm stm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName), (PType)MableAstFactory.newARealNumericPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newACallExp((PExp)this.referenceExp.clone(), (LexIdentifier)MableAstFactory.newAIdentifier((String)FUNCTION_MINREALFROMARRAY), Collections.singletonList(array.getExp())))));
        this.dynamicScope.add(new PStm[]{stm});
        return new DoubleVariableFmi2Api((PStm)stm, this.dynamicScope.getActiveScope(), this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName)), (PExp)MableAstFactory.newAIdentifierExp((String)variableName));
    }
}

