/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.AExpressionStm;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.StringVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;

public class VariableStep {
    private final DynamicActiveBuilderScope dynamicScope;
    private final MablApiBuilder mablApiBuilder;
    private String moduleIdentifier;
    private Fmi2Builder.RuntimeModule<PStm> runtimeModule;
    private boolean runtimeModuleMode = false;

    public VariableStep(DynamicActiveBuilderScope dynamicScope, MablApiBuilder mablApiBuilder) {
        this.dynamicScope = dynamicScope;
        this.mablApiBuilder = mablApiBuilder;
        this.moduleIdentifier = "variableStep";
    }

    public VariableStep(DynamicActiveBuilderScope dynamicScope, MablApiBuilder mablApiBuilder, Fmi2Builder.RuntimeModule<PStm> runtimeModule) {
        this(dynamicScope, mablApiBuilder);
        this.runtimeModuleMode = true;
        this.runtimeModule = runtimeModule;
        this.moduleIdentifier = runtimeModule.getName();
    }

    public VariableStepInstance createVariableStepInstanceInstance() {
        if (!this.runtimeModuleMode) {
            return new VariableStepInstance(this.dynamicScope, this.mablApiBuilder, this);
        }
        return new VariableStepInstance(this.dynamicScope, this.mablApiBuilder, this, this.runtimeModule);
    }

    public String getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public void unload() {
        this.mablApiBuilder.getDynamicScope().add(new PStm[]{MableAstFactory.newExpressionStm((PExp)MableAstFactory.newUnloadExp(Arrays.asList(this.getReferenceExp().clone())))});
    }

    private PExp getReferenceExp() {
        return MableAstFactory.newAIdentifierExp((String)this.moduleIdentifier);
    }

    public class VariableStepInstance {
        private final String FUNCTION_SETFMUS = "setFMUs";
        private final String FUNCTION_INITIALIZEPORTNAMES = "initializePortNames";
        private final String FUNCTION_ADDDATAPOINT = "addDataPoint";
        private final String FUNCTION_HASREDUCEDSTEPSIZE = "hasReducedStepsize";
        private final String FUNCTION_GETREDUCEDSTEPSIZE = "getReducedStepSize";
        private final String FUNCTION_GETSTEPSIZE = "getStepSize";
        private final String FUNCTION_SETENDTIME = "setEndTime";
        private final String FUNCTION_ISSTEPVALID = "isStepValid";
        private final String TYPE_VARIABLESTEPCONFIG = "VariableStepConfig";
        private final DynamicActiveBuilderScope dynamicScope;
        private final MablApiBuilder mablApiBuilder;
        private final VariableStep variableStep;
        private boolean runtimeModuleMode;
        private boolean initialized;
        private Collection<PortFmi2Api> ports;
        private Fmi2Builder.RuntimeModule<PStm> runtimeModule;
        private String variableStepConfigurationIdentifier;
        private String portsWithDataIdentifier;

        public VariableStepInstance(DynamicActiveBuilderScope dynamicScope, MablApiBuilder mablApiBuilder, VariableStep variableStep) {
            this.dynamicScope = dynamicScope;
            this.mablApiBuilder = mablApiBuilder;
            this.variableStep = variableStep;
        }

        public VariableStepInstance(DynamicActiveBuilderScope dynamicScope, MablApiBuilder mablApiBuilder, VariableStep variableStep, Fmi2Builder.RuntimeModule<PStm> runtimeModule) {
            this(dynamicScope, mablApiBuilder, variableStep);
            this.runtimeModuleMode = true;
            this.runtimeModule = runtimeModule;
        }

        private void checkForInitialized() {
            if (!this.initialized) {
                throw new RuntimeException("VariableStep has not been initialized!");
            }
        }

        public BooleanVariableFmi2Api validateStepSize(DoubleVariableFmi2Api nextTime, BooleanVariableFmi2Api supportsRollBack) {
            this.checkForInitialized();
            ArrayList<AAssigmentStm> assignmentStms = new ArrayList<AAssigmentStm>();
            List portsWithData = this.ports.stream().map(PortFmi2Api::getSharedAsVariable).collect(Collectors.toList());
            for (int i = 0; i < portsWithData.size(); ++i) {
                AArrayStateDesignator to = MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)this.portsWithDataIdentifier), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i));
                PExp from = ((VariableFmi2Api)portsWithData.get(i)).getReferenceExp().clone();
                assignmentStms.add(MableAstFactory.newAAssignmentStm((PStateDesignator)to, (PExp)from));
            }
            String variableName = this.dynamicScope.getName("valid_step");
            ALocalVariableStm targetVarStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName), (PType)MableAstFactory.newABoleanPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.variableStep.getModuleIdentifier()), (LexIdentifier)MableAstFactory.newAIdentifier((String)"isStepValid"), Arrays.asList(MableAstFactory.newAIdentifierExp((String)this.variableStepConfigurationIdentifier), nextTime.getExp(), supportsRollBack.getExp(), MableAstFactory.newAIdentifierExp((String)this.portsWithDataIdentifier))))));
            this.dynamicScope.add((PStm[])assignmentStms.toArray(AAssigmentStm[]::new));
            this.dynamicScope.add(new PStm[]{targetVarStm});
            return new BooleanVariableFmi2Api((PStm)targetVarStm, this.dynamicScope.getActiveScope(), this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName)), (PExp)MableAstFactory.newAIdentifierExp((String)variableName));
        }

        public DoubleVariableFmi2Api getStepSize(DoubleVariableFmi2Api simTime) {
            this.checkForInitialized();
            AExpressionStm addDataPointStm = MableAstFactory.newExpressionStm((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.variableStep.getModuleIdentifier()), (LexIdentifier)MableAstFactory.newAIdentifier((String)"addDataPoint"), Arrays.asList(MableAstFactory.newAIdentifierExp((String)this.variableStepConfigurationIdentifier), simTime.getExp(), MableAstFactory.newAIdentifierExp((String)this.portsWithDataIdentifier))));
            String variableName = this.dynamicScope.getName("var_step_size");
            ALocalVariableStm targetVarStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName), (PType)MableAstFactory.newARealNumericPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.variableStep.getModuleIdentifier()), (LexIdentifier)MableAstFactory.newAIdentifier((String)"getStepSize"), Arrays.asList(MableAstFactory.newAIdentifierExp((String)this.variableStepConfigurationIdentifier))))));
            this.dynamicScope.add(new PStm[]{addDataPointStm, targetVarStm});
            return new DoubleVariableFmi2Api((PStm)targetVarStm, this.dynamicScope.getActiveScope(), this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName)), (PExp)MableAstFactory.newAIdentifierExp((String)variableName));
        }

        public BooleanVariableFmi2Api hasReducedStepsize() {
            this.checkForInitialized();
            String variableName = this.dynamicScope.getName("has_reduced_step_size");
            ALocalVariableStm targetVarStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName), (PType)MableAstFactory.newABoleanPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.variableStep.getModuleIdentifier()), (LexIdentifier)MableAstFactory.newAIdentifier((String)"hasReducedStepsize"), Arrays.asList(MableAstFactory.newAIdentifierExp((String)this.variableStepConfigurationIdentifier))))));
            this.dynamicScope.add(new PStm[]{targetVarStm});
            return new BooleanVariableFmi2Api((PStm)targetVarStm, this.dynamicScope.getActiveScope(), this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName)), (PExp)MableAstFactory.newAIdentifierExp((String)variableName));
        }

        public DoubleVariableFmi2Api getReducedStepSize() {
            this.checkForInitialized();
            String variableName = this.dynamicScope.getName("reduced_step_size");
            ALocalVariableStm targetVarStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName), (PType)MableAstFactory.newARealNumericPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.variableStep.getModuleIdentifier()), (LexIdentifier)MableAstFactory.newAIdentifier((String)"getReducedStepSize"), Arrays.asList(MableAstFactory.newAIdentifierExp((String)this.variableStepConfigurationIdentifier))))));
            this.dynamicScope.add(new PStm[]{targetVarStm});
            return new DoubleVariableFmi2Api((PStm)targetVarStm, this.dynamicScope.getActiveScope(), this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)variableName)), (PExp)MableAstFactory.newAIdentifierExp((String)variableName));
        }

        public void initialize(Map<StringVariableFmi2Api, ComponentVariableFmi2Api> fmus, Collection<PortFmi2Api> ports, DoubleVariableFmi2Api endTime) {
            this.ports = ports;
            this.portsWithDataIdentifier = this.mablApiBuilder.getNameGenerator().getName("ports_with_data_for_varstep");
            this.variableStepConfigurationIdentifier = this.mablApiBuilder.getNameGenerator().getName("varstep_config");
            String fmuInstanceNamesIdentifier = this.mablApiBuilder.getNameGenerator().getName("FMU_instance_names");
            String fmuInstancesIdentifier = this.mablApiBuilder.getNameGenerator().getName("fmu_instances");
            String portNamesIdentifier = this.mablApiBuilder.getNameGenerator().getName("portnames_for_varstep");
            List portsWithData = ports.stream().map(p -> p.getSharedAsVariable().getReferenceExp().clone()).collect(Collectors.toList());
            ALocalVariableStm portsWithDataStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)this.portsWithDataIdentifier), (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newARealNumericPrimitiveType()), (int)portsWithData.size(), (PInitializer)(portsWithData.size() > 0 ? MableAstFactory.newAArrayInitializer(portsWithData) : null)));
            List fmuNames = fmus.entrySet().stream().map(v -> ((StringVariableFmi2Api)v.getKey()).getExp()).collect(Collectors.toList());
            ALocalVariableStm fmuNamesStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)fmuInstanceNamesIdentifier), (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newAStringPrimitiveType()), (int)fmuNames.size(), (PInitializer)MableAstFactory.newAArrayInitializer(fmuNames)));
            List fmuInstances = fmus.values().stream().map(x -> x.getReferenceExp().clone()).collect(Collectors.toList());
            ALocalVariableStm fmuInstancesStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)fmuInstancesIdentifier), (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newANameType((String)"FMI2Component")), (int)fmuInstances.size(), (PInitializer)MableAstFactory.newAArrayInitializer(fmuInstances)));
            ALocalVariableStm setFMUsStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)this.variableStepConfigurationIdentifier), (PType)MableAstFactory.newANameType((String)"VariableStepConfig"), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.variableStep.getModuleIdentifier()), (LexIdentifier)MableAstFactory.newAIdentifier((String)"setFMUs"), Arrays.asList(MableAstFactory.newAIdentifierExp((String)fmuInstanceNamesIdentifier), MableAstFactory.newAIdentifierExp((String)fmuInstancesIdentifier))))));
            List portNames = ports.stream().map(p -> MableAstFactory.newAStringLiteralExp((String)p.getMultiModelScalarVariableName())).collect(Collectors.toList());
            ALocalVariableStm portNamesStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)portNamesIdentifier), (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newAStringPrimitiveType()), (int)portNames.size(), (PInitializer)(portNames.size() > 0 ? MableAstFactory.newAArrayInitializer(portNames) : null)));
            AExpressionStm initializePortNamesStm = MableAstFactory.newExpressionStm((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.variableStep.getModuleIdentifier()), (LexIdentifier)MableAstFactory.newAIdentifier((String)"initializePortNames"), Arrays.asList(MableAstFactory.newAIdentifierExp((String)this.variableStepConfigurationIdentifier), MableAstFactory.newAIdentifierExp((String)portNamesIdentifier))));
            AExpressionStm setEndTimeStm = MableAstFactory.newExpressionStm((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.variableStep.getModuleIdentifier()), (LexIdentifier)MableAstFactory.newAIdentifier((String)"setEndTime"), Arrays.asList(MableAstFactory.newAIdentifierExp((String)this.variableStepConfigurationIdentifier), endTime.getExp())));
            if (this.runtimeModuleMode) {
                this.runtimeModule.getDeclaredScope().add(fmuNamesStm, fmuInstancesStm, setFMUsStm, portNamesStm, initializePortNamesStm, setEndTimeStm, portsWithDataStm);
            } else {
                this.mablApiBuilder.getDynamicScope().add(new PStm[]{fmuNamesStm, fmuInstancesStm, setFMUsStm, portNamesStm, initializePortNamesStm, setEndTimeStm, portsWithDataStm});
            }
            this.initialized = true;
        }
    }
}

