/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl.scoping;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.intocps.maestro.ast.ABasicBlockStm;
import org.intocps.maestro.ast.AParallelBlockStm;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.MableBuilder;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.node.ABoolLiteralExp;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.ANullType;
import org.intocps.maestro.ast.node.ARealLiteralExp;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.AStringLiteralExp;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.AWhileStm;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PExpBase;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStateDesignatorBase;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.SBlockStm;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IfMaBlScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.WhileMaBLScope;
import org.intocps.maestro.framework.fmi2.api.mabl.values.BooleanExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.values.DoubleExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.values.IntExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.values.StringExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.values.ValueFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ArrayVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.IntVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.StringVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableCreatorFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;

public class ScopeFmi2Api
implements IMablScope,
Fmi2Builder.WhileScope<PStm> {
    final ScopeFmi2Api parent;
    private final MablApiBuilder builder;
    private final SBlockStm block;
    IntVariableFmi2Api fmiStatusVariable = null;
    private final List<ComponentVariableFmi2Api> fmi2ComponentVariables = new ArrayList<ComponentVariableFmi2Api>();

    public ScopeFmi2Api(MablApiBuilder builder) {
        this.builder = builder;
        this.parent = null;
        this.block = new ABasicBlockStm();
    }

    public ScopeFmi2Api(MablApiBuilder builder, ScopeFmi2Api parent, SBlockStm block) {
        this.builder = builder;
        this.parent = parent;
        this.block = block;
    }

    public SBlockStm getBlock() {
        return this.block;
    }

    @Override
    public WhileMaBLScope enterWhile(Fmi2Builder.Predicate predicate) {
        if (predicate instanceof PredicateFmi2Api) {
            PredicateFmi2Api predicate_ = (PredicateFmi2Api)predicate;
            ABasicBlockStm whileBlock = new ABasicBlockStm();
            AWhileStm whileStm = MableAstFactory.newWhile((PExp)predicate_.getExp(), (PStm)whileBlock);
            this.add(new PStm[]{whileStm});
            WhileMaBLScope scope = new WhileMaBLScope(this.builder, (PStm)whileStm, this, (SBlockStm)whileBlock);
            scope.activate();
            return scope;
        }
        throw new RuntimeException("Predicate has to be of type PredicateFmi2Api. Unknown predicate: " + predicate.getClass());
    }

    @Override
    public IfMaBlScope enterIf(Fmi2Builder.Predicate predicate) {
        if (predicate instanceof PredicateFmi2Api) {
            PredicateFmi2Api predicate_ = (PredicateFmi2Api)predicate;
            ABasicBlockStm thenStm = MableAstFactory.newABlockStm((PStm[])new PStm[0]);
            ABasicBlockStm elseStm = MableAstFactory.newABlockStm((PStm[])new PStm[0]);
            AIfStm ifStm = MableAstFactory.newIf((PExp)predicate_.getExp(), (PStm)thenStm, (PStm)elseStm);
            this.add(new PStm[]{ifStm});
            ScopeFmi2Api thenScope = new ScopeFmi2Api(this.builder, this, (SBlockStm)thenStm);
            ScopeFmi2Api elseScope = new ScopeFmi2Api(this.builder, this, (SBlockStm)elseStm);
            return new IfMaBlScope(this.builder, (PStm)ifStm, this, thenScope, elseScope);
        }
        throw new RuntimeException("Predicate has to be of type PredicateFmi2Api. Unknown predicate: " + predicate.getClass());
    }

    @Override
    public IMablScope parallel() {
        AParallelBlockStm blockStm = new AParallelBlockStm();
        this.add(new PStm[]{blockStm});
        return new ScopeFmi2Api(this.builder, this, (SBlockStm)blockStm).activate();
    }

    @Override
    public ScopeFmi2Api leave() {
        return this.parent.activate();
    }

    @Override
    public void add(PStm ... commands) {
        this.addAll((Collection<PStm>)Arrays.asList(commands));
    }

    @Override
    public void addAll(Collection<PStm> commands) {
        commands.forEach(x -> this.block.getBody().add(x));
    }

    @Override
    public void addBefore(PStm item, PStm ... commands) {
        int index = this.block.getBody().indexOf(item);
        if (index == -1) {
            this.add(commands);
        } else {
            int insertAt = index - 1;
            if (insertAt < 0) {
                this.addAll(0, commands);
            } else {
                this.addAll(insertAt, commands);
            }
        }
    }

    private void addAll(int index, PStm ... commands) {
        int index_ = index;
        int i = 0;
        while (i < commands.length) {
            this.block.getBody().add(index_, commands[i]);
            ++i;
            ++index_;
        }
    }

    @Override
    public void addAfter(PStm item, PStm ... commands) {
        int index = this.block.getBody().indexOf(item);
        int insertAt = index + 1;
        if (index == -1 || insertAt > this.block.getBody().size()) {
            this.add(commands);
        } else {
            this.addAll(insertAt, commands);
        }
    }

    @Override
    public ScopeFmi2Api activate() {
        if (this.builder.getDynamicScope() != null) {
            return (ScopeFmi2Api)this.builder.getDynamicScope().activate(this);
        }
        return this;
    }

    @Override
    public DoubleVariableFmi2Api store(double value) {
        return this.store(() -> this.builder.getNameGenerator().getName(), value);
    }

    @Override
    public StringVariableFmi2Api store(String value) {
        return this.store(() -> this.builder.getNameGenerator().getName(), value);
    }

    @Override
    public BooleanVariableFmi2Api store(boolean value) {
        return this.store(() -> this.builder.getNameGenerator().getName(), value);
    }

    @Override
    public IntVariableFmi2Api store(int value) {
        return this.store(() -> this.builder.getNameGenerator().getName(), value);
    }

    @Override
    public DoubleVariableFmi2Api store(String prefix, double value) {
        return this.store(() -> this.builder.getNameGenerator().getName(prefix), value);
    }

    @Override
    public StringVariableFmi2Api store(String prefix, String value) {
        return this.store(() -> this.builder.getNameGenerator().getName(prefix), value);
    }

    @Override
    public BooleanVariableFmi2Api store(String name, boolean value) {
        return this.store(() -> this.builder.getNameGenerator().getName(name), value);
    }

    @Override
    public IntVariableFmi2Api store(String name, int value) {
        return this.store(() -> this.builder.getNameGenerator().getName(name), value);
    }

    @Override
    public <V> ArrayVariableFmi2Api<V> store(String name, V[] value) {
        return this.store(() -> this.builder.getNameGenerator().getName(name), value);
    }

    protected DoubleVariableFmi2Api store(Supplier<String> nameProvider, double value) {
        String name = nameProvider.get();
        ARealLiteralExp initial = MableAstFactory.newARealLiteralExp((Double)value);
        PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newARealNumericPrimitiveType(), (PExp)initial);
        this.add(var);
        return new DoubleVariableFmi2Api(var, this, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIdentifierExp((String)name));
    }

    protected BooleanVariableFmi2Api store(Supplier<String> nameProvider, boolean value) {
        String name = nameProvider.get();
        ABoolLiteralExp initial = MableAstFactory.newABoolLiteralExp((Boolean)value);
        PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newABoleanPrimitiveType(), (PExp)initial);
        this.add(var);
        return new BooleanVariableFmi2Api(var, this, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIdentifierExp((String)name));
    }

    protected IntVariableFmi2Api store(Supplier<String> nameProvider, int value) {
        String name = nameProvider.get();
        AIntLiteralExp initial = MableAstFactory.newAIntLiteralExp((Integer)value);
        PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newAIntNumericPrimitiveType(), (PExp)initial);
        this.add(var);
        return new IntVariableFmi2Api(var, this, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIdentifierExp((String)name));
    }

    protected StringVariableFmi2Api store(Supplier<String> nameProvider, String value) {
        String name = nameProvider.get();
        AStringLiteralExp initial = MableAstFactory.newAStringLiteralExp((String)value);
        PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newAStringPrimitiveType(), (PExp)initial);
        this.add(var);
        return new StringVariableFmi2Api(var, this, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIdentifierExp((String)name));
    }

    private <V> ArrayVariableFmi2Api<V> storeMDArray(String identifyingName, V[] mdArray) {
        ARealNumericPrimitiveType type;
        ArrayList<Integer> arrayShape = new ArrayList<Integer>();
        Object[] subArr = mdArray;
        while (subArr.getClass().getComponentType().isArray()) {
            arrayShape.add(subArr.length);
            subArr = (Object[])subArr[0];
        }
        arrayShape.add(subArr.length);
        if (subArr instanceof Double[]) {
            type = MableAstFactory.newARealNumericPrimitiveType();
        } else if (subArr instanceof Integer[]) {
            type = MableAstFactory.newAIntNumericPrimitiveType();
        } else if (subArr instanceof Boolean[]) {
            type = MableAstFactory.newABoleanPrimitiveType();
        } else if (subArr instanceof String[]) {
            type = MableAstFactory.newAStringPrimitiveType();
        } else if (subArr instanceof Long[]) {
            type = MableAstFactory.newAUIntNumericPrimitiveType();
        } else {
            throw new IllegalArgumentException();
        }
        ALocalVariableStm arrayVariableStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclarationMultiDimensionalArray((LexIdentifier)MableAstFactory.newAIdentifier((String)identifyingName), (PType)type, arrayShape));
        this.add(new PStm[]{arrayVariableStm});
        return this.instantiateMDArrayRecursively(mdArray, (PStm)arrayVariableStm, (PStateDesignatorBase)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)identifyingName)), (PExpBase)MableAstFactory.newAIdentifierExp((String)identifyingName));
    }

    private <V> ArrayVariableFmi2Api<V> instantiateMDArrayRecursively(V[] array, PStm declaringStm, PStateDesignatorBase stateDesignator, PExpBase indexExp) {
        if (array.getClass().getComponentType().isArray()) {
            ArrayList arrays = new ArrayList();
            for (int i = 0; i < array.length; ++i) {
                arrays.add(this.instantiateMDArrayRecursively((Object[])array[i], declaringStm, (PStateDesignatorBase)MableAstFactory.newAArayStateDesignator((PStateDesignator)stateDesignator, (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExpBase)MableAstFactory.newAArrayIndexExp((PExp)indexExp, List.of(MableAstFactory.newAIntLiteralExp((Integer)i)))));
            }
            return new ArrayVariableFmi2Api(declaringStm, ((VariableFmi2Api)arrays.get(0)).getType(), this, this.builder.getDynamicScope(), (PStateDesignator)stateDesignator, indexExp.clone(), arrays);
        }
        ArrayList variables = new ArrayList();
        for (int i = 0; i < array.length; ++i) {
            Fmi2Builder.ExpressionValue value;
            ARealNumericPrimitiveType type;
            if (array instanceof Double[]) {
                type = MableAstFactory.newARealNumericPrimitiveType();
                value = new DoubleExpressionValue((Double)array[i]);
            } else if (array instanceof Integer[]) {
                type = MableAstFactory.newAIntNumericPrimitiveType();
                value = new IntExpressionValue((Integer)array[i]);
            } else if (array instanceof Boolean[]) {
                type = MableAstFactory.newABoleanPrimitiveType();
                value = new BooleanExpressionValue((Boolean)array[i]);
            } else if (array instanceof String[]) {
                type = MableAstFactory.newAStringPrimitiveType();
                value = new StringExpressionValue((String)array[i]);
            } else if (array instanceof Long[]) {
                type = MableAstFactory.newAUIntNumericPrimitiveType();
                value = new IntExpressionValue(((Long)array[i]).intValue());
            } else {
                throw new IllegalArgumentException();
            }
            VariableFmi2Api variableToAdd = new VariableFmi2Api(declaringStm, (PType)type, this, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)stateDesignator.clone(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)indexExp.clone(), List.of(MableAstFactory.newAIntLiteralExp((Integer)i))));
            variableToAdd.setValue(value);
            variables.add(variableToAdd);
        }
        return new ArrayVariableFmi2Api(declaringStm, ((VariableFmi2Api)variables.get(0)).getType(), this, this.builder.getDynamicScope(), ((AArrayStateDesignator)((VariableFmi2Api)variables.get(0)).getDesignatorClone()).getTarget(), indexExp.clone(), variables);
    }

    protected <V> ArrayVariableFmi2Api<V> store(Supplier<String> nameProvider, V[] value) {
        String name = nameProvider.get();
        int length = value.length;
        ANullType type = new ANullType();
        AArrayInitializer initializer = null;
        if (value instanceof Double[]) {
            type = new ARealNumericPrimitiveType();
            if (length > 1 && value[0] != null) {
                initializer = MableAstFactory.newAArrayInitializer(Arrays.stream(value).map(v -> MableAstFactory.newARealLiteralExp((Double)((Double)v))).collect(Collectors.toList()));
            }
        } else if (value instanceof Integer[]) {
            type = new AIntNumericPrimitiveType();
            if (length > 1 && value[0] != null) {
                initializer = MableAstFactory.newAArrayInitializer(Arrays.stream(value).map(v -> MableAstFactory.newAIntLiteralExp((Integer)((Integer)v))).collect(Collectors.toList()));
            }
        } else if (value instanceof Boolean[]) {
            type = new ABooleanPrimitiveType();
            if (length > 1 && value[0] != null) {
                initializer = MableAstFactory.newAArrayInitializer(Arrays.stream(value).map(v -> MableAstFactory.newABoolLiteralExp((Boolean)((Boolean)v))).collect(Collectors.toList()));
            }
        } else if (value instanceof String[]) {
            type = new AStringPrimitiveType();
            if (length > 1 && value[0] != null) {
                initializer = MableAstFactory.newAArrayInitializer(Arrays.stream(value).map(v -> MableAstFactory.newAStringLiteralExp((String)((String)v))).collect(Collectors.toList()));
            }
        } else if (value.getClass().getComponentType().isArray()) {
            return this.storeMDArray(name, value);
        }
        ALocalVariableStm localVarStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)name), (PType)type, (int)length, initializer));
        ANullType finalType = type;
        List items = IntStream.range(0, length).mapToObj(arg_0 -> this.lambda$store$14((PStm)localVarStm, (PType)finalType, name, arg_0)).collect(Collectors.toList());
        this.add(new PStm[]{localVarStm});
        return new ArrayVariableFmi2Api((PStm)localVarStm, (PType)type, this, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIdentifierExp((String)name), items);
    }

    @Override
    public String getName(String prefix) {
        return this.builder.getNameGenerator().getName(prefix);
    }

    @Override
    public IMablScope enterScope() {
        ABasicBlockStm blockStm = new ABasicBlockStm();
        this.add(new PStm[]{blockStm});
        return new ScopeFmi2Api(this.builder, this, (SBlockStm)blockStm).activate();
    }

    @Override
    public <V> Fmi2Builder.Variable<PStm, V> store(Fmi2Builder.Value<V> tag) {
        return this.storePrivate(this.builder.getNameGenerator().getName(), tag);
    }

    @Override
    public IntVariableFmi2Api store(String namePrefix, IntVariableFmi2Api variable) {
        String name = this.getName(namePrefix);
        PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newAIntNumericPrimitiveType(), (PExp)variable.getReferenceExp());
        this.add(var);
        return new IntVariableFmi2Api(var, this, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIdentifierExp((String)name));
    }

    private <V> Fmi2Builder.Variable<PStm, V> storePrivate(String name, Fmi2Builder.Value<V> tag) {
        if (!(tag instanceof ValueFmi2Api)) {
            throw new IllegalArgumentException();
        }
        ValueFmi2Api v = (ValueFmi2Api)tag;
        ARealLiteralExp initial = null;
        if (v.getType() instanceof ARealNumericPrimitiveType) {
            if (v.get() != null) {
                initial = MableAstFactory.newARealLiteralExp((Double)((Double)v.get()));
            }
        } else if (v.getType() instanceof AIntNumericPrimitiveType) {
            if (v.get() != null) {
                initial = MableAstFactory.newAIntLiteralExp((Integer)((Integer)v.get()));
            }
        } else if (v.getType() instanceof ABooleanPrimitiveType) {
            if (v.get() != null) {
                initial = MableAstFactory.newABoolLiteralExp((Boolean)((Boolean)v.get()));
            }
        } else if (v.getType() instanceof AStringPrimitiveType && v.get() != null) {
            initial = MableAstFactory.newAStringLiteralExp((String)((String)v.get()));
        }
        PStm var = MableBuilder.newVariable((String)name, (PType)v.getType(), (PExp)initial);
        this.add(var);
        VariableFmi2Api variable = new VariableFmi2Api(var, v.getType(), this, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        return variable;
    }

    @Override
    public FmuVariableFmi2Api createFMU(String name, String loaderName, String ... args) throws Exception {
        return VariableCreatorFmi2Api.createFMU(this.builder, this.builder.getNameGenerator(), this.builder.getDynamicScope(), name, loaderName, args, (IMablScope)this);
    }

    @Override
    public <Var extends VariableFmi2Api> Var copy(String name, Var variable) {
        if (variable instanceof BooleanVariableFmi2Api || variable instanceof DoubleVariableFmi2Api || variable instanceof IntVariableFmi2Api || variable instanceof StringVariableFmi2Api) {
            String varName = this.builder.getNameGenerator().getName(name);
            PStm variableDeclaration = MableBuilder.newVariable((String)varName, (PType)variable.getType(), (PExp)variable.getReferenceExp().clone());
            this.add(variableDeclaration);
            return (Var)variable.clone(variableDeclaration, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)varName), (PExp)MableAstFactory.newAIdentifierExp((String)varName));
        }
        throw new RuntimeException("Copy is not implemented for the type: " + variable.getClass().getName());
    }

    @Override
    public FmuVariableFmi2Api createFMU(String name, ModelDescription modelDescription, URI path) throws Exception {
        return VariableCreatorFmi2Api.createFMU(this.builder, this.builder.getNameGenerator(), this.builder.getDynamicScope(), name, modelDescription, path, (IMablScope)this);
    }

    @Override
    public IntVariableFmi2Api getFmiStatusVariable() {
        if (this.parent == null) {
            return this.builder.getGlobalFmiStatus();
        }
        if (this.parent.block instanceof AParallelBlockStm) {
            if (this.fmiStatusVariable == null) {
                this.fmiStatusVariable = this.store("status", MablApiBuilder.FmiStatus.FMI_OK.getValue());
            }
            return this.fmiStatusVariable;
        }
        return this.parent.getFmiStatusVariable();
    }

    @Override
    public void registerComponentVariableFmi2Api(ComponentVariableFmi2Api componentVariableFmi2Api) {
        this.fmi2ComponentVariables.add(componentVariableFmi2Api);
    }

    @Override
    public Set<ComponentVariableFmi2Api> getAllComponentFmi2Variables() {
        HashSet<ComponentVariableFmi2Api> compFmi2Variables = new HashSet<ComponentVariableFmi2Api>();
        compFmi2Variables.addAll(this.fmi2ComponentVariables);
        ScopeFmi2Api parentScope = this.parent;
        while (parentScope != null) {
            compFmi2Variables.addAll(parentScope.getAllComponentFmi2Variables());
            parentScope = parentScope.parent;
        }
        return compFmi2Variables;
    }

    private /* synthetic */ VariableFmi2Api lambda$store$14(PStm localVarStm, PType finalType, String name, int i) {
        return new VariableFmi2Api(localVarStm, finalType, null, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((String)name), Collections.singletonList(MableAstFactory.newAIntLiteralExp((Integer)i))));
    }
}

