/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl.values;

import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.NumericExpressionValueFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;

public class DoubleExpressionValue
extends NumericExpressionValueFmi2Api {
    final PType type = new ARealNumericPrimitiveType();
    final PExp exp;

    public DoubleExpressionValue(double value) {
        this.exp = MableAstFactory.newARealLiteralExp((Double)value);
    }

    public DoubleExpressionValue(PExp exp) {
        this.exp = exp;
    }

    public static DoubleExpressionValue of(double value) {
        return new DoubleExpressionValue(value);
    }

    @Override
    public PExp getExp() {
        return this.exp.clone();
    }

    @Override
    public PType getType() {
        return this.type;
    }

    @Override
    public DoubleExpressionValue subtraction(int v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newMinusExp((PExp)this.getExp(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)v)));
    }

    @Override
    public DoubleExpressionValue addition(int v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newPlusExp((PExp)this.getExp(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)v)));
    }

    @Override
    public DoubleExpressionValue divide(int v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newDivideExp((PExp)this.getExp(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)v)));
    }

    @Override
    public DoubleExpressionValue multiply(int v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newMultiplyExp((PExp)this.getExp(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)v)));
    }

    @Override
    public DoubleExpressionValue subtraction(double v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newMinusExp((PExp)this.getExp(), (PExp)MableAstFactory.newARealLiteralExp((Double)v)));
    }

    @Override
    public DoubleExpressionValue addition(double v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newPlusExp((PExp)this.getExp(), (PExp)MableAstFactory.newARealLiteralExp((Double)v)));
    }

    @Override
    public DoubleExpressionValue divide(double v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newDivideExp((PExp)this.getExp(), (PExp)MableAstFactory.newARealLiteralExp((Double)v)));
    }

    @Override
    public DoubleExpressionValue multiply(double v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newMultiplyExp((PExp)this.getExp(), (PExp)MableAstFactory.newARealLiteralExp((Double)v)));
    }

    @Override
    public DoubleExpressionValue addition(Fmi2Builder.NumericTypedReferenceExp v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newPlusExp((PExp)this.getExp(), (PExp)v.getExp()));
    }

    @Override
    public DoubleExpressionValue divide(Fmi2Builder.NumericTypedReferenceExp v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newDivideExp((PExp)this.getExp(), (PExp)v.getExp()));
    }

    @Override
    public DoubleExpressionValue subtraction(Fmi2Builder.NumericTypedReferenceExp v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newMinusExp((PExp)this.getExp(), (PExp)v.getExp()));
    }

    @Override
    public DoubleExpressionValue multiply(Fmi2Builder.NumericTypedReferenceExp v) {
        return new DoubleExpressionValue((PExp)MableAstFactory.newMultiplyExp((PExp)this.getExp(), (PExp)v.getExp()));
    }

    @Override
    public PredicateFmi2Api lessThan(Fmi2Builder.NumericTypedReferenceExp endTimeVar) {
        return new PredicateFmi2Api((PExp)MableAstFactory.newALessBinaryExp((PExp)this.getExp(), (PExp)endTimeVar.getExp()));
    }
}

