/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl.variables;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.fmi.IFmu;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.MableBuilder;
import org.intocps.maestro.ast.node.AArrayType;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.framework.fmi2.FmuFactory;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.ModelDescriptionContext;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.TagNameGenerator;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.ScopeFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;

public class VariableCreatorFmi2Api {
    private final IMablScope scope;
    private final MablApiBuilder builder;

    public VariableCreatorFmi2Api(IMablScope scope, MablApiBuilder builder) {
        this.scope = scope;
        this.builder = builder;
    }

    public static PType fmitypetomabltype(ModelDescription.Types type) {
        switch (type) {
            case Boolean: {
                return MableAstFactory.newABoleanPrimitiveType();
            }
            case Real: {
                return MableAstFactory.newARealNumericPrimitiveType();
            }
            case Integer: {
                return MableAstFactory.newAIntNumericPrimitiveType();
            }
            case String: {
                return MableAstFactory.newAStringPrimitiveType();
            }
        }
        throw new UnsupportedOperationException("Converting fmi type: " + type + " to mabl type is not supported.");
    }

    public static VariableFmi2Api createVariableForPort(TagNameGenerator nameGenerator, PortFmi2Api port, IMablScope scope, Fmi2Builder.DynamicActiveScope<PStm> dynamicScope) {
        String name = nameGenerator.getName(port.toLexName());
        AArrayType type = MableAstFactory.newAArrayType((PType)VariableCreatorFmi2Api.fmitypetomabltype(port.scalarVariable.type.type));
        int size = 1;
        PStm stm = MableBuilder.newVariable((String)name, (PType)type, (int)size);
        scope.add(stm);
        VariableFmi2Api variable = new VariableFmi2Api(stm, (PType)type, scope, dynamicScope, (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)0)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((String)name), Arrays.asList(MableAstFactory.newAIntLiteralExp((Integer)0))));
        return variable;
    }

    public static FmuVariableFmi2Api createFMU(MablApiBuilder builder, TagNameGenerator nameGenerator, DynamicActiveBuilderScope dynamicScope, String name, URI uriPath, IMablScope scope) throws Exception {
        String path = uriPath.toString();
        if (uriPath.getScheme() != null && uriPath.getScheme().equals("file")) {
            path = uriPath.getPath();
        }
        IFmu fmu = FmuFactory.create(null, (URI)URI.create(path));
        ModelDescription modelDescription = new ModelDescription(fmu.getModelDescription());
        return VariableCreatorFmi2Api.createFMU(builder, nameGenerator, dynamicScope, name, modelDescription, uriPath, scope);
    }

    public static FmuVariableFmi2Api createFMU(MablApiBuilder builder, TagNameGenerator nameGenerator, DynamicActiveBuilderScope dynamicScope, String name, String loaderName, String[] args, IMablScope scope) throws Exception {
        if (loaderName.equals("FMI2")) {
            return VariableCreatorFmi2Api.createFMU(builder, nameGenerator, dynamicScope, name, URI.create(args[0]), scope);
        }
        if (loaderName.equals("JFMI2")) {
            return VariableCreatorFmi2Api.createFMU(builder, nameGenerator, dynamicScope, name, args[0], scope);
        }
        return null;
    }

    public static FmuVariableFmi2Api createFMU(MablApiBuilder builder, TagNameGenerator nameGenerator, DynamicActiveBuilderScope dynamicScope, String name, String className, IMablScope scope) throws Exception {
        String uniqueName = nameGenerator.getName(name);
        PStm var = MableBuilder.newVariable((String)uniqueName, (PType)MableAstFactory.newANameType((String)"FMI2"), (PExp)MableAstFactory.newALoadExp(Arrays.asList(MableAstFactory.newAStringLiteralExp((String)"JFMI2"), MableAstFactory.newAStringLiteralExp((String)className))));
        scope.add(var);
        IFmu fmu = (IFmu)VariableCreatorFmi2Api.class.getClassLoader().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        FmuVariableFmi2Api fmuVar = new FmuVariableFmi2Api(name, builder, new ModelDescriptionContext(new ModelDescription(fmu.getModelDescription())), var, (PType)MableAstFactory.newANameType((String)"FMI2"), scope, dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)uniqueName)), (PExp)MableAstFactory.newAIdentifierExp((String)uniqueName));
        if (builder.getSettings().fmiErrorHandlingEnabled) {
            ScopeFmi2Api thenScope = scope.enterIf(new PredicateFmi2Api((PExp)MableAstFactory.newEqual((PExp)fmuVar.getReferenceExp().clone(), (PExp)MableAstFactory.newNullExp()))).enterThen();
            thenScope.add(new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)builder.getGlobalExecutionContinue().getDesignator().clone(), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false))});
            builder.getLogger().error(thenScope, "FMU load failed on fmu: '%s' for classpath: '%s'", name, className);
            ComponentVariableFmi2Api.FmiStatusErrorHandlingBuilder.collectedPreviousLoadedModules((INode)thenScope.getBlock().getBody().getLast()).forEach(p -> {
                thenScope.add(new PStm[]{MableAstFactory.newExpressionStm((PExp)MableAstFactory.newUnloadExp((PExp[])new PExp[]{MableAstFactory.newAIdentifierExp((String)p)}))});
                thenScope.add(new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)p), (PExp)MableAstFactory.newNullExp())});
            });
            thenScope.add(new PStm[]{MableAstFactory.newBreak()});
            thenScope.leave();
        }
        return fmuVar;
    }

    public static FmuVariableFmi2Api createFMU(MablApiBuilder builder, TagNameGenerator nameGenerator, DynamicActiveBuilderScope dynamicScope, String name, ModelDescription modelDescription, URI uriPath, IMablScope scope) throws IllegalAccessException, XPathExpressionException, InvocationTargetException {
        String path = uriPath.toString();
        if (uriPath.getScheme() != null && uriPath.getScheme().equals("file")) {
            path = uriPath.getPath();
        }
        String uniqueName = nameGenerator.getName(name);
        PStm var = MableBuilder.newVariable((String)uniqueName, (PType)MableAstFactory.newANameType((String)"FMI2"), (PExp)MableAstFactory.newALoadExp(Arrays.asList(MableAstFactory.newAStringLiteralExp((String)"FMI2"), MableAstFactory.newAStringLiteralExp((String)modelDescription.getGuid()), MableAstFactory.newAStringLiteralExp((String)path))));
        scope.add(var);
        FmuVariableFmi2Api fmuVar = new FmuVariableFmi2Api(name, builder, new ModelDescriptionContext(modelDescription), var, (PType)MableAstFactory.newANameType((String)"FMI2"), scope, dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)uniqueName)), (PExp)MableAstFactory.newAIdentifierExp((String)uniqueName));
        if (builder.getSettings().fmiErrorHandlingEnabled) {
            ScopeFmi2Api thenScope = scope.enterIf(new PredicateFmi2Api((PExp)MableAstFactory.newEqual((PExp)fmuVar.getReferenceExp().clone(), (PExp)MableAstFactory.newNullExp()))).enterThen();
            thenScope.add(new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)builder.getGlobalExecutionContinue().getDesignator().clone(), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false))});
            builder.getLogger().error(thenScope, "FMU load failed on fmu: '%s' for uri: '%s'", name, "" + uriPath);
            ComponentVariableFmi2Api.FmiStatusErrorHandlingBuilder.collectedPreviousLoadedModules((INode)thenScope.getBlock().getBody().getLast()).forEach(p -> {
                thenScope.add(new PStm[]{MableAstFactory.newExpressionStm((PExp)MableAstFactory.newUnloadExp((PExp[])new PExp[]{MableAstFactory.newAIdentifierExp((String)p)}))});
                thenScope.add(new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)p), (PExp)MableAstFactory.newNullExp())});
            });
            thenScope.add(new PStm[]{MableAstFactory.newBreak()});
            thenScope.leave();
        }
        return fmuVar;
    }
}

