/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl.variables;

import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.BuilderUtil;
import org.intocps.maestro.framework.fmi2.api.mabl.NumericExpressionValueFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.values.DoubleExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.values.IntExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.IndexedVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.IntVariableFmi2Api;

public class VariableFmi2Api<V>
implements Fmi2Builder.Variable<PStm, V>,
IndexedVariableFmi2Api<V>,
Fmi2Builder.ProvidesTypedReferenceExp {
    private final PStateDesignator designator;
    private final PExp referenceExp;
    private final PStm declaration;
    protected PType type;
    protected Fmi2Builder.DynamicActiveScope<PStm> dynamicScope;
    IMablScope declaredScope;

    public VariableFmi2Api(PStm declaration, PType type, IMablScope declaredScope, Fmi2Builder.DynamicActiveScope<PStm> dynamicScope, PStateDesignator designator, PExp referenceExp) {
        this.declaration = declaration;
        this.declaredScope = declaredScope;
        this.dynamicScope = dynamicScope;
        this.designator = designator;
        this.referenceExp = referenceExp;
        this.type = type;
    }

    protected PStateDesignator getDesignator() {
        return this.designator;
    }

    public PStateDesignator getDesignatorClone() {
        return this.designator.clone();
    }

    public PExp getReferenceExp() {
        return this.referenceExp;
    }

    @Override
    public String getName() {
        return "" + this.referenceExp;
    }

    @Override
    public void setValue(V value) {
        this.setValue((Fmi2Builder.Scope<PStm>)this.dynamicScope, value);
    }

    @Override
    public void setValue(Fmi2Builder.Variable<PStm, V> variable) {
        this.setValue((Fmi2Builder.Scope<PStm>)this.dynamicScope, (V)variable);
    }

    @Override
    public void setValue(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Variable<PStm, V> variable) {
        scope.add((PStm[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)this.designator.clone(), (PExp)((VariableFmi2Api)variable).getReferenceExp().clone())});
    }

    @Override
    public void setValue(Fmi2Builder.Scope<PStm> scope, V value) {
        if (!(value instanceof DoubleExpressionValue)) {
            throw new IllegalArgumentException();
        }
        scope.add((PStm[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)this.designator.clone(), (PExp)((DoubleExpressionValue)value).getExp())});
    }

    public IMablScope getDeclaredScope() {
        return this.declaredScope;
    }

    @Override
    public PStm getDeclaringStm() {
        return this.declaration;
    }

    @Override
    public PType getType() {
        return this.type;
    }

    @Override
    public PExp getExp() {
        return this.referenceExp.clone();
    }

    @Override
    protected void setValue(Fmi2Builder.Scope<PStm> scope, PExp exp) {
        scope.add((PStm[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)this.designator.clone(), (PExp)exp)});
    }

    @Override
    protected void setValue(PExp exp) {
        this.setValue((Fmi2Builder.Scope<PStm>)this.dynamicScope, exp);
    }

    public VariableFmi2Api<V> clone(PStm declaration, IMablScope declaredScope, PStateDesignator designator, PExp referenceExp) {
        return new VariableFmi2Api<V>(declaration, this.type, declaredScope, this.dynamicScope, designator, referenceExp);
    }

    public NumericExpressionValueFmi2Api toMath() {
        if (this instanceof DoubleVariableFmi2Api) {
            return new DoubleExpressionValue(this.getExp());
        }
        if (this instanceof IntVariableFmi2Api) {
            return new IntExpressionValue(this.getExp());
        }
        throw new RuntimeException("Variable is not of Numeric Type but of type: " + this.getClass());
    }

    @Override
    public void setValue(Fmi2Builder.ExpressionValue value) {
        this.setValue(this.dynamicScope, value);
    }

    @Override
    private void setValue(Fmi2Builder.DynamicActiveScope<PStm> dynamicScope, Fmi2Builder.ExpressionValue value) {
        this.dynamicScope.addAll(BuilderUtil.createTypeConvertingAssignment(this.designator, value.getExp(), value.getType(), this.getType()));
    }
}

