/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.intocps.fmi.Fmi2Status;
import org.intocps.fmi.IFmiComponent;
import org.intocps.fmi.IFmu;
import org.intocps.fmi.IFmuCallback;
import org.intocps.maestro.ast.display.PrettyPrinter;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.framework.fmi2.FmuFactory;
import org.intocps.maestro.framework.fmi2.IFmuFactory;
import org.intocps.maestro.framework.fmi2.api.mabl.BaseApiTest;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi2Api;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ComponentVariableFmi2ApiTest
extends BaseApiTest {
    @Test
    public void setDebugLoggingTest() throws Exception {
        final Path dirPath = Paths.get("src", "test", "resources", "component_variable_fmi2_api_test");
        final String[] logCategories = new String[]{"logEvents", "logStatusError", "logStatusWarning", "logStatusPending"};
        boolean enableLogging = true;
        FmuFactory.customFactory = new IFmuFactory(){

            public boolean accept(URI uri) {
                return true;
            }

            public IFmu instantiate(File sessionRoot, URI uri) throws Exception {
                IFmu fmu = (IFmu)Mockito.mock(IFmu.class);
                Mockito.when((Object)fmu.isValid()).thenReturn((Object)true);
                IFmiComponent comp = (IFmiComponent)Mockito.mock(IFmiComponent.class);
                Mockito.when((Object)fmu.instantiate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (IFmuCallback)ArgumentMatchers.any())).thenReturn((Object)comp);
                Mockito.when((Object)comp.getFmu()).thenReturn((Object)fmu);
                Mockito.when((Object)comp.setDebugLogging(true, logCategories)).thenReturn((Object)Fmi2Status.OK);
                Mockito.when((Object)comp.setReals((long[])ArgumentMatchers.any(), (double[])ArgumentMatchers.any())).thenReturn((Object)Fmi2Status.OK);
                Mockito.when((Object)comp.terminate()).thenReturn((Object)Fmi2Status.OK);
                Mockito.when((Object)comp.isValid()).thenReturn((Object)true);
                String modelDescriptionPath = Paths.get(dirPath.toString(), "modelDescription.xml").toString();
                ByteArrayInputStream md = new ByteArrayInputStream(IOUtils.toByteArray((URI)new File(modelDescriptionPath.replace('/', File.separatorChar)).toURI()));
                Mockito.when((Object)fmu.getModelDescription()).thenReturn((Object)md);
                return fmu;
            }
        };
        MablApiBuilder.MablSettings settings = new MablApiBuilder.MablSettings();
        settings.fmiErrorHandlingEnabled = false;
        MablApiBuilder builder = new MablApiBuilder(settings, null);
        DynamicActiveBuilderScope dynamicScope = builder.getDynamicScope();
        FmuVariableFmi2Api tankFMU = dynamicScope.createFMU("tankFMU", new Fmi2ModelDescription(Paths.get(dirPath.toString(), "modelDescription.xml").toFile()), Paths.get(dirPath.toString(), "singlewatertank-20sim.fmu").toUri());
        ComponentVariableFmi2Api tank = tankFMU.instantiate("tank");
        tank.setDebugLogging(List.of(logCategories), true);
        tank.terminate();
        String spec = PrettyPrinter.print((INode)builder.build());
        Assertions.assertDoesNotThrow(() -> this.check(spec, ""), (String)"Exception can be caused by log categories not matching with mocked fmu");
        FmuFactory.customFactory = null;
    }
}

