/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.intocps.maestro.ast.ABasicBlockStm;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.MableBuilder;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.DepthFirstAnalysisAdaptor;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.AConfigFramework;
import org.intocps.maestro.ast.node.AErrorStm;
import org.intocps.maestro.ast.node.AExpressionStm;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.AUnloadExp;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.SBlockStm;
import org.intocps.maestro.framework.fmi2.api.DerivativeEstimator;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.BooleanBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.BuilderUtil;
import org.intocps.maestro.framework.fmi2.api.mabl.ConsolePrinter;
import org.intocps.maestro.framework.fmi2.api.mabl.DataWriter;
import org.intocps.maestro.framework.fmi2.api.mabl.ExecutionEnvironmentFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.FunctionBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.LoggerFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.MablToMablAPI;
import org.intocps.maestro.framework.fmi2.api.mabl.MathBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.RealTime;
import org.intocps.maestro.framework.fmi2.api.mabl.TagNameGenerator;
import org.intocps.maestro.framework.fmi2.api.mabl.VariableStep;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.ScopeFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.TryMaBlScope;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.IntVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.RuntimeModuleVariable;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.StringVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;

public class MablApiBuilder
implements Fmi2Builder<PStm, ASimulationSpecificationCompilationUnit, PExp, MablSettings> {
    static ScopeFmi2Api rootScope;
    final ScopeFmi2Api externalScope = new ScopeFmi2Api(this);
    final DynamicActiveBuilderScope dynamicScope;
    final TagNameGenerator nameGenerator = new TagNameGenerator();
    final TryMaBlScope mainErrorHandlingScope;
    private final IntVariableFmi2Api globalFmiStatus;
    private final MablToMablAPI mablToMablAPI;
    private final MablSettings settings;
    private final Map<FmiStatus, IntVariableFmi2Api> fmiStatusVariables;
    private final Set<String> externalLoadedModuleIdentifier = new HashSet<String>();
    int dynamicScopeInitialSize;
    List<String> importedModules = new Vector<String>();
    List<RuntimeModuleVariable> loadedModules = new Vector<RuntimeModuleVariable>();
    Map<String, Object> instanceCache = new HashMap<String, Object>();
    private MathBuilderFmi2Api mathBuilderApi;

    public MablApiBuilder() {
        this(new MablSettings(), null);
    }

    public MablApiBuilder(MablSettings settings) {
        this(settings, null);
    }

    public MablApiBuilder(MablSettings settings, INode lastNodePriorToBuilderTakeOver) {
        AVariableDeclaration decl;
        boolean createdFromExistingSpec = lastNodePriorToBuilderTakeOver != null;
        this.settings = settings;
        rootScope = new ScopeFmi2Api(this);
        this.fmiStatusVariables = new HashMap<FmiStatus, IntVariableFmi2Api>();
        if (settings.fmiErrorHandlingEnabled && createdFromExistingSpec) {
            Function<String, IntVariableFmi2Api> f = str -> new IntVariableFmi2Api(null, null, null, null, (PExp)MableAstFactory.newAIdentifierExp((String)str));
            for (FmiStatus s : FmiStatus.values()) {
                AVariableDeclaration decl2 = MablToMablAPI.findDeclaration(lastNodePriorToBuilderTakeOver, null, false, s.name());
                if (decl2 == null) {
                    this.fmiStatusVariables.put(s, rootScope.store(() -> this.getNameGenerator().getNameIgnoreCase(s.name()), s.getValue()));
                    continue;
                }
                this.fmiStatusVariables.put(s, f.apply(decl2.getName().getText()));
            }
        }
        String status_varname = "status";
        if (createdFromExistingSpec) {
            decl = MablToMablAPI.findDeclaration(lastNodePriorToBuilderTakeOver, null, false, "global_execution_continue");
            decl = MablToMablAPI.findDeclaration(lastNodePriorToBuilderTakeOver, null, false, status_varname);
            this.globalFmiStatus = decl == null ? rootScope.store(status_varname, FmiStatus.FMI_OK.getValue()) : (IntVariableFmi2Api)this.createVariableExact(rootScope, (PType)MableAstFactory.newIntType(), null, decl.getName().getText(), true);
        } else {
            this.globalFmiStatus = rootScope.store(status_varname, FmiStatus.FMI_OK.getValue());
        }
        this.mainErrorHandlingScope = rootScope.enterTry();
        this.dynamicScope = new DynamicActiveBuilderScope(this.mainErrorHandlingScope.getBody());
        this.mablToMablAPI = new MablToMablAPI(this);
        if (createdFromExistingSpec) {
            decl = MablToMablAPI.findDeclaration(lastNodePriorToBuilderTakeOver, null, false, "logger");
            if (decl != null) {
                this.getMablToMablAPI().createExternalRuntimeLogger();
            }
            MablToMablAPI.getPreviouslyUsedNamed(lastNodePriorToBuilderTakeOver).forEach(this.nameGenerator::addUsedIdentifier);
        }
        this.resetDirty();
    }

    public boolean isDirty() {
        return this.dynamicScopeInitialSize != ((ScopeFmi2Api)this.dynamicScope.activate()).getBlock().getBody().size();
    }

    public void resetDirty() {
        this.dynamicScopeInitialSize = ((ScopeFmi2Api)this.dynamicScope.activate()).getBlock().getBody().size();
    }

    public void setRuntimeLogger(LoggerFmi2Api runtimeLogger) {
        this.instanceCache.put("Logger", runtimeLogger);
    }

    public MablSettings getSettings() {
        return this.settings;
    }

    public IntVariableFmi2Api getFmiStatusConstant(FmiStatus status) {
        if (!this.fmiStatusVariables.containsKey((Object)status)) {
            switch (status) {
                case FMI_OK: {
                    IntVariableFmi2Api var = rootScope.store(status.name(), FmiStatus.FMI_OK.getValue());
                    rootScope.addAfterOrTop(null, var.getDeclaringStm());
                    this.fmiStatusVariables.put(FmiStatus.FMI_OK, var);
                    break;
                }
                case FMI_WARNING: {
                    IntVariableFmi2Api var = rootScope.store(status.name(), FmiStatus.FMI_WARNING.getValue());
                    rootScope.addAfterOrTop(null, var.getDeclaringStm());
                    this.fmiStatusVariables.put(FmiStatus.FMI_WARNING, var);
                    break;
                }
                case FMI_DISCARD: {
                    IntVariableFmi2Api var = rootScope.store(status.name(), FmiStatus.FMI_DISCARD.getValue());
                    rootScope.addAfterOrTop(null, var.getDeclaringStm());
                    this.fmiStatusVariables.put(FmiStatus.FMI_DISCARD, var);
                    break;
                }
                case FMI_ERROR: {
                    IntVariableFmi2Api var = this.storeStatusVariable(rootScope, status.name(), FmiStatus.FMI_ERROR.getValue());
                    rootScope.addAfterOrTop(null, var.getDeclaringStm());
                    this.fmiStatusVariables.put(FmiStatus.FMI_ERROR, var);
                    break;
                }
                case FMI_FATAL: {
                    IntVariableFmi2Api var = this.storeStatusVariable(rootScope, status.name(), FmiStatus.FMI_FATAL.getValue());
                    rootScope.addAfterOrTop(null, var.getDeclaringStm());
                    this.fmiStatusVariables.put(FmiStatus.FMI_FATAL, var);
                    break;
                }
                case FMI_PENDING: {
                    IntVariableFmi2Api var = rootScope.store(status.name(), FmiStatus.FMI_PENDING.getValue());
                    rootScope.addAfterOrTop(null, var.getDeclaringStm());
                    this.fmiStatusVariables.put(FmiStatus.FMI_PENDING, var);
                    break;
                }
            }
        }
        return this.fmiStatusVariables.get((Object)status);
    }

    public MablToMablAPI getMablToMablAPI() {
        return this.mablToMablAPI;
    }

    public IntVariableFmi2Api getGlobalFmiStatus() {
        return this.globalFmiStatus;
    }

    private IntVariableFmi2Api storeStatusVariable(ScopeFmi2Api rootScope, String name, int errorCode) {
        return rootScope.store(() -> this.getNameGenerator().getNameIgnoreCase(name), errorCode);
    }

    private Fmi2Builder.Variable createVariable(IMablScope scope, PType type, PExp initialValue, String ... prefixes) {
        String name = this.nameGenerator.getName(prefixes);
        return this.createVariableExact(scope, type, initialValue, name, false);
    }

    private Fmi2Builder.Variable createVariableExact(IMablScope scope, PType type, PExp initialValue, String name, boolean external) {
        PStm var = MableBuilder.newVariable((String)name, (PType)type, (PExp)initialValue);
        if (!external) {
            scope.add(var);
        }
        this.externalScope.add(var);
        if (type instanceof ARealNumericPrimitiveType) {
            return new DoubleVariableFmi2Api(var, this.externalScope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        }
        if (type instanceof ABooleanPrimitiveType) {
            return new BooleanVariableFmi2Api(var, this.externalScope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        }
        if (type instanceof AIntNumericPrimitiveType) {
            return new IntVariableFmi2Api(var, this.externalScope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        }
        if (type instanceof AStringPrimitiveType) {
            return new StringVariableFmi2Api(var, this.externalScope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        }
        return new VariableFmi2Api(var, type, this.externalScope, this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
    }

    public TagNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    public MathBuilderFmi2Api getMathBuilder() {
        if (this.mathBuilderApi == null) {
            RuntimeModuleVariable runtimeModule = this.loadRuntimeModule("Math", new Object[0]);
            this.mathBuilderApi = new MathBuilderFmi2Api(this.dynamicScope, this, runtimeModule.getReferenceExp());
        }
        return this.mathBuilderApi;
    }

    public IMablScope getRootScope() {
        return rootScope;
    }

    public DynamicActiveBuilderScope getDynamicScope() {
        return this.dynamicScope;
    }

    public <V, T> Fmi2Builder.Variable<T, V> getCurrentLinkedValue(Fmi2Builder.Port port) {
        PortFmi2Api mp = (PortFmi2Api)port;
        if (mp.getSharedAsVariable() == null) {
            return null;
        }
        return mp.getSharedAsVariable();
    }

    Pair<PStateDesignator, PExp> getDesignatorAndReferenceExp(PExp exp) {
        if (exp instanceof AArrayIndexExp) {
            AArrayIndexExp aArrayIndexExp = (AArrayIndexExp)exp;
        } else if (exp instanceof AIdentifierExp) {
            AIdentifierExp exp_ = (AIdentifierExp)exp;
            return Pair.of((Object)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)exp_.getName()), (Object)exp_);
        }
        throw new RuntimeException("Invalid expression of class: " + exp.getClass());
    }

    public DoubleVariableFmi2Api getDoubleVariableFrom(PExp exp) {
        Pair<PStateDesignator, PExp> t = this.getDesignatorAndReferenceExp(exp);
        return new DoubleVariableFmi2Api(null, rootScope, this.dynamicScope, (PStateDesignator)t.getLeft(), (PExp)t.getRight());
    }

    public IntVariableFmi2Api getIntVariableFrom(PExp exp) {
        Pair<PStateDesignator, PExp> t = this.getDesignatorAndReferenceExp(exp);
        return new IntVariableFmi2Api(null, rootScope, this.dynamicScope, (PStateDesignator)t.getLeft(), (PExp)t.getRight());
    }

    public StringVariableFmi2Api getStringVariableFrom(PExp exp) {
        Pair<PStateDesignator, PExp> t = this.getDesignatorAndReferenceExp(exp);
        return new StringVariableFmi2Api(null, rootScope, this.dynamicScope, (PStateDesignator)t.getLeft(), (PExp)t.getRight());
    }

    public BooleanVariableFmi2Api getBooleanVariableFrom(PExp exp) {
        Pair<PStateDesignator, PExp> t = this.getDesignatorAndReferenceExp(exp);
        return new BooleanVariableFmi2Api(null, rootScope, this.dynamicScope, (PStateDesignator)t.getLeft(), (PExp)t.getRight());
    }

    public FmuVariableFmi2Api getFmuVariableFrom(PExp exp) {
        return null;
    }

    public PStm buildRaw() throws AnalysisException {
        SBlockStm block = rootScope.getBlock().clone();
        if (block == null) {
            return null;
        }
        Iterator<RuntimeModuleVariable> iterator = this.loadedModules.iterator();
        while (iterator.hasNext()) {
            RuntimeModuleVariable module;
            RuntimeModuleVariable var = module = iterator.next();
            block.apply((IAnalysis)new DepthFirstAnalysisAdaptor(){

                public void defaultInPStm(PStm node) throws AnalysisException {
                    if (node.equals((Object)module.getDeclaringStm()) && node.parent() instanceof SBlockStm) {
                        LinkedList body = ((SBlockStm)node.parent()).getBody();
                        boolean unloadFound = false;
                        for (int i = body.indexOf(node); i < body.size(); ++i) {
                            AUnloadExp unload;
                            PStm stm = (PStm)body.get(i);
                            if (!(stm instanceof AExpressionStm) || !(((AExpressionStm)stm).getExp() instanceof AUnloadExp) || (unload = (AUnloadExp)((AExpressionStm)stm).getExp()).getArgs().isEmpty() || !((PExp)unload.getArgs().get(0)).equals((Object)module.getReferenceExp())) continue;
                            unloadFound = true;
                        }
                        if (!unloadFound) {
                            body.add(MableAstFactory.newIf((PExp)MableAstFactory.newNotEqual((PExp)module.getReferenceExp().clone(), (PExp)MableAstFactory.newNullExp()), (PStm)MableAstFactory.newExpressionStm((PExp)MableAstFactory.newUnloadExp(Collections.singletonList(module.getReferenceExp().clone()))), null));
                        }
                    }
                }
            });
        }
        this.postClean(block);
        return block;
    }

    public RuntimeModuleVariable loadRuntimeModule(String name, Object ... args) {
        IMablScope scope;
        block1: {
            scope = this.dynamicScope.getActiveScope();
            if (scope instanceof Fmi2Builder.TryScope) break block1;
            while ((scope = scope.parent()) != null && !(scope instanceof Fmi2Builder.TryScope)) {
            }
        }
        return this.loadRuntimeModule((Fmi2Builder.TryScope)scope, name, args);
    }

    public RuntimeModuleVariable loadRuntimeModule(Fmi2Builder.TryScope<PStm> scope, String name, Object ... args) {
        return this.loadRuntimeModule(scope, (Fmi2Builder.Scope<PStm> s, List<PStm> var) -> s.addAll((Collection)var), name, args);
    }

    public RuntimeModuleVariable loadRuntimeModule(Fmi2Builder.TryScope<PStm> scope, BiConsumer<Fmi2Builder.Scope<PStm>, List<PStm>> variableStoreFunc, String name, Object ... args) {
        String varName = this.getNameGenerator().getName(name);
        List<PExp> argList = BuilderUtil.toExp(args);
        argList.add(0, (PExp)MableAstFactory.newAStringLiteralExp((String)name));
        PStm var = MableBuilder.newVariable((String)varName, (PType)MableAstFactory.newANameType((String)name), (int[])new int[0]);
        ScopeFmi2Api thisScope = (ScopeFmi2Api)scope.findParent(ScopeFmi2Api.class);
        thisScope.addBefore((PStm)scope.getDeclaration(), var);
        RuntimeModuleVariable module = new RuntimeModuleVariable(var, (PType)MableAstFactory.newANameType((String)name), thisScope, this.dynamicScope, this, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)varName), (PExp)MableAstFactory.newAIdentifierExp((String)varName));
        variableStoreFunc.accept((Fmi2Builder.Scope<PStm>)scope.getBody(), Arrays.asList(MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)varName), (PExp)MableAstFactory.newALoadExp(argList)), MableAstFactory.newIf((PExp)MableAstFactory.newEqual((PExp)module.getReferenceExp().clone(), (PExp)MableAstFactory.newNullExp()), (PStm)new AErrorStm((PExp)MableAstFactory.newAStringLiteralExp((String)("Failed load of: " + varName))), null)));
        ((IMablScope)scope.getFinallyBody()).addAfterOrTop(null, new PStm[]{MableAstFactory.newIf((PExp)MableAstFactory.newNotEqual((PExp)module.getReferenceExp().clone(), (PExp)MableAstFactory.newNullExp()), (PStm)MableAstFactory.newABlockStm((PStm[])new PStm[]{MableAstFactory.newExpressionStm((PExp)MableAstFactory.newUnloadExp(List.of(module.getReferenceExp().clone()))), MableAstFactory.newAAssignmentStm((PStateDesignator)module.getDesignator().clone(), (PExp)MableAstFactory.newNullExp())}), null)});
        this.importedModules.add(name);
        return module;
    }

    public ASimulationSpecificationCompilationUnit build() throws AnalysisException {
        SBlockStm block = rootScope.getBlock().clone();
        Iterator<RuntimeModuleVariable> iterator = this.loadedModules.iterator();
        while (iterator.hasNext()) {
            RuntimeModuleVariable module;
            RuntimeModuleVariable var = module = iterator.next();
            block.apply((IAnalysis)new DepthFirstAnalysisAdaptor(){

                public void defaultInPStm(PStm node) throws AnalysisException {
                    if (node.equals((Object)module.getDeclaringStm()) && node.parent() instanceof SBlockStm) {
                        LinkedList body = ((SBlockStm)node.parent()).getBody();
                        boolean unloadFound = false;
                        for (int i = body.indexOf(node); i < body.size(); ++i) {
                            AUnloadExp unload;
                            PStm stm = (PStm)body.get(i);
                            if (!(stm instanceof AExpressionStm) || !(((AExpressionStm)stm).getExp() instanceof AUnloadExp) || (unload = (AUnloadExp)((AExpressionStm)stm).getExp()).getArgs().isEmpty() || !((PExp)unload.getArgs().get(0)).equals((Object)module.getReferenceExp())) continue;
                            unloadFound = true;
                        }
                        if (!unloadFound) {
                            body.add(MableAstFactory.newIf((PExp)MableAstFactory.newNotEqual((PExp)module.getReferenceExp().clone(), (PExp)MableAstFactory.newNullExp()), (PStm)MableAstFactory.newExpressionStm((PExp)MableAstFactory.newUnloadExp(Collections.singletonList(module.getReferenceExp().clone()))), null));
                        }
                    }
                }
            });
        }
        this.postClean(block);
        ASimulationSpecificationCompilationUnit unit = new ASimulationSpecificationCompilationUnit();
        unit.setBody((PStm)block);
        unit.setFramework(Collections.singletonList(MableAstFactory.newAIdentifier((String)"FMI2")));
        AConfigFramework config = new AConfigFramework();
        config.setName(MableAstFactory.newAIdentifier((String)"FMI2"));
        unit.setImports(Stream.concat(Stream.of(MableAstFactory.newAIdentifier((String)"FMI2")), this.importedModules.stream().map(MableAstFactory::newAIdentifier)).collect(Collectors.toList()));
        return unit;
    }

    private void postClean(SBlockStm block) throws AnalysisException {
        block.apply((IAnalysis)new DepthFirstAnalysisAdaptor(){

            public void caseABasicBlockStm(ABasicBlockStm node) throws AnalysisException {
                if (node.getBody().isEmpty()) {
                    AIfStm ifStm;
                    if (node.parent() instanceof SBlockStm) {
                        SBlockStm pb = (SBlockStm)node.parent();
                        pb.getBody().remove(node);
                    } else if (node.parent() instanceof AIfStm && (ifStm = (AIfStm)node.parent()).getElse() == node) {
                        ifStm.setElse(null);
                    }
                } else {
                    super.caseABasicBlockStm(node);
                }
            }
        });
    }

    public FunctionBuilder getFunctionBuilder() {
        return new FunctionBuilder();
    }

    public void addExternalLoadedModuleIdentifier(String name) {
        this.externalLoadedModuleIdentifier.add(name);
    }

    public Set<String> getExternalLoadedModuleIdentifiers() {
        return this.externalLoadedModuleIdentifier;
    }

    public BooleanBuilderFmi2Api getBooleanBuilder() {
        return this.load("BooleanLogic", runtime -> new BooleanBuilderFmi2Api(this, (Fmi2Builder.RuntimeModule<PStm>)runtime), new Object[0]);
    }

    public ExecutionEnvironmentFmi2Api getExecutionEnvironment() {
        return this.load("MEnv", runtime -> new ExecutionEnvironmentFmi2Api(this, (Fmi2Builder.RuntimeModule<PStm>)runtime), new Object[0]);
    }

    public LoggerFmi2Api getLogger() {
        return this.load("Logger", runtime -> new LoggerFmi2Api(this, (Fmi2Builder.RuntimeModule<PStm>)runtime), new Object[0]);
    }

    public VariableStep getVariableStep(StringVariableFmi2Api config) {
        return this.load("VariableStep", runtime -> new VariableStep(this, (Fmi2Builder.RuntimeModule<PStm>)runtime), config);
    }

    public DerivativeEstimator getDerivativeEstimator() {
        return this.load("DerivativeEstimator", runtime -> new DerivativeEstimator(this.getDynamicScope(), this, (Fmi2Builder.RuntimeModule<PStm>)runtime), new Object[0]);
    }

    public DataWriter getDataWriter() {
        return this.load("DataWriter", runtime -> new DataWriter(this, (Fmi2Builder.RuntimeModule<PStm>)runtime), new Object[0]);
    }

    public ConsolePrinter getConsolePrinter() {
        return this.load("ConsolePrinter", runtime -> new ConsolePrinter(this, (Fmi2Builder.RuntimeModule<PStm>)runtime), new Object[0]);
    }

    public RealTime getRealTimeModule() {
        return this.load("RealTime", runtime -> new RealTime(this, (Fmi2Builder.RuntimeModule<PStm>)runtime), new Object[0]);
    }

    <T> T load(String moduleType, Function<Fmi2Builder.RuntimeModule<PStm>, T> creator, Object ... args) {
        if (this.instanceCache.containsKey(moduleType)) {
            return (T)this.instanceCache.get(moduleType);
        }
        RuntimeModuleVariable runtimeModule = this.loadRuntimeModule((Fmi2Builder.TryScope<PStm>)this.mainErrorHandlingScope, (Fmi2Builder.Scope<PStm> s, List<PStm> var) -> {
            if (args == null || args.length == 0) {
                ((ScopeFmi2Api)s).getBlock().getBody().addAll(0, var);
            } else {
                int index = 0;
                SBlockStm b = ((ScopeFmi2Api)s).getBlock();
                for (Object arg : args) {
                    int argIndex;
                    if (!(arg instanceof VariableFmi2Api)) continue;
                    PStm argDecl = ((VariableFmi2Api)arg).getDeclaringStm();
                    while (!b.equals((Object)argDecl.parent()) && (argDecl = argDecl.parent()) != null) {
                    }
                    if (argDecl == null || !b.equals((Object)argDecl.parent()) || (argIndex = b.getBody().indexOf(argDecl) + 1) <= index) continue;
                    index = argIndex;
                }
                b.getBody().addAll(index, var);
            }
        }, moduleType, args);
        T m = creator.apply(runtimeModule);
        this.instanceCache.put(moduleType, m);
        return m;
    }

    public static class MablSettings {
        public boolean fmiErrorHandlingEnabled = true;
        public boolean setGetDerivatives = true;
    }

    public static enum FmiStatus {
        FMI_OK(0),
        FMI_WARNING(1),
        FMI_DISCARD(2),
        FMI_ERROR(3),
        FMI_FATAL(4),
        FMI_PENDING(5);

        private final int value;

        private FmiStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

