/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.util.ArrayList;
import java.util.List;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;

public class PortFmi2Api
implements Fmi2Builder.Port {
    public final ComponentVariableFmi2Api aMablFmi2ComponentAPI;
    public final Fmi2ModelDescription.ScalarVariable scalarVariable;
    private final List<PortFmi2Api> targetPorts = new ArrayList<PortFmi2Api>();
    private VariableFmi2Api sharedAsVariable;
    private PortFmi2Api sourcePort;

    public PortFmi2Api(ComponentVariableFmi2Api aMablFmi2ComponentAPI, Fmi2ModelDescription.ScalarVariable scalarVariable) {
        this.aMablFmi2ComponentAPI = aMablFmi2ComponentAPI;
        this.scalarVariable = scalarVariable;
    }

    public String toString() {
        return "Port( '" + this.aMablFmi2ComponentAPI.getName() + "." + this.scalarVariable.getName() + "' , '" + this.scalarVariable.getType().type + "')";
    }

    public VariableFmi2Api getSharedAsVariable() {
        return this.sharedAsVariable;
    }

    public void setSharedAsVariable(VariableFmi2Api sharedAsVariable) {
        this.sharedAsVariable = sharedAsVariable;
    }

    public PType getType() {
        switch (this.scalarVariable.getType().type) {
            case Boolean: {
                return MableAstFactory.newBoleanType();
            }
            case Real: {
                return MableAstFactory.newRealType();
            }
            case Integer: {
                return MableAstFactory.newIntType();
            }
            case String: {
                return MableAstFactory.newStringType();
            }
        }
        return null;
    }

    public String getName() {
        return this.scalarVariable.getName();
    }

    public Long getPortReferenceValue() {
        return this.scalarVariable.getValueReference();
    }

    public void linkTo(Fmi2Builder.Port ... receivers) throws Fmi2Builder.Port.PortLinkException {
        if (receivers == null || receivers.length == 0) {
            return;
        }
        if (this.scalarVariable.causality != Fmi2ModelDescription.Causality.Output) {
            throw new Fmi2Builder.Port.PortLinkException("Can only link output ports. This port is: " + this.scalarVariable.causality, (Fmi2Builder.Port)this);
        }
        for (Fmi2Builder.Port receiver : receivers) {
            PortFmi2Api receiverPort = (PortFmi2Api)receiver;
            if (receiverPort.scalarVariable.causality != Fmi2ModelDescription.Causality.Input) {
                throw new Fmi2Builder.Port.PortLinkException("Receivers must be input ports. This receiver is: " + receiverPort.scalarVariable.causality, (Fmi2Builder.Port)receiverPort);
            }
            if (receiverPort.getSourcePort() != null) {
                throw new Fmi2Builder.Port.PortLinkException("Cannot port already linked please break link first", receiver);
            }
            receiverPort.sourcePort = this;
            if (this.targetPorts.contains(receiverPort)) continue;
            this.targetPorts.add(receiverPort);
        }
    }

    public PortFmi2Api getSourcePort() {
        return this.sourcePort;
    }

    public void breakLink() {
        this.sourcePort = null;
    }

    public String toLexName() {
        return this.aMablFmi2ComponentAPI.getOwner().getName() + "_" + this.aMablFmi2ComponentAPI.getName() + "_" + this.getName();
    }

    public String getMultiModelScalarVariableName() {
        return this.aMablFmi2ComponentAPI.getOwner().getFmuIdentifier() + "." + this.aMablFmi2ComponentAPI.getName() + "." + this.getName();
    }

    public List<PortFmi2Api> getTargetPorts() {
        return this.targetPorts;
    }
}

