/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.NodeCollector;
import org.intocps.maestro.ast.display.PrettyPrinter;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.core.messages.ErrorReporter;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.fmi2.api.mabl.BaseApiTest;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ArrayVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.intocps.maestro.interpreter.DefaultExternalValueFactory;
import org.intocps.maestro.interpreter.MableInterpreter;
import org.intocps.maestro.parser.MablParserUtil;
import org.intocps.maestro.typechecker.TypeChecker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArrayTest
extends BaseApiTest {
    @Test
    public void mdArrayFaultyAssignmentTest() throws Exception {
        MablApiBuilder.MablSettings settings = new MablApiBuilder.MablSettings();
        settings.fmiErrorHandlingEnabled = false;
        MablApiBuilder builder = new MablApiBuilder(settings);
        DynamicActiveBuilderScope dynamicScope = builder.getDynamicScope();
        ErrorReporter reporter = new ErrorReporter();
        TypeChecker typeChecker = new TypeChecker((IErrorReporter)reporter);
        List maestro2EmbeddedModules = ArrayTest.getModuleDocuments(TypeChecker.getRuntimeModules()).stream().map(x -> NodeCollector.collect((INode)x, AImportedModuleCompilationUnit.class)).filter(Optional::isPresent).flatMap(x -> ((List)x.get()).stream()).collect(Collectors.toList());
        ARootDocument defaultModules = new ARootDocument();
        defaultModules.setContent(maestro2EmbeddedModules);
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        Double[][] mdArrayVals = new Double[][]{{0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}};
        ArrayVariableFmi2Api multiDimensionalArray = dynamicScope.store("multiDimensionalArray", (Object[])mdArrayVals);
        DoubleVariableFmi2Api realVar = dynamicScope.store("realVar", 1.1);
        PExp val = realVar.getReferenceExp().clone();
        builder.getDynamicScope().add(new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)((VariableFmi2Api)multiDimensionalArray.items().get(0)).getDesignatorClone(), (PExp)val)});
        String spec = PrettyPrinter.print((INode)builder.build());
        ARootDocument doc = MablParserUtil.parse((CharStream)CharStreams.fromStream((InputStream)new ByteArrayInputStream(spec.getBytes())));
        boolean res = typeChecker.typeCheck(List.of(doc, defaultModules), new Vector());
        if (!res) {
            reporter.printWarnings(writer);
            reporter.printErrors(writer);
        }
        Assertions.assertFalse((boolean)res, (String)"Expected error: Invalid assignment to cannot assign: 'real' to 'real[]' in: multidimensionalarray[0] = realvar; null");
        Assertions.assertThrows(RuntimeException.class, () -> new MableInterpreter(new DefaultExternalValueFactory(new File("target"), null)).execute(doc));
    }
}

