/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.values.PortValueMapImpl;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi2Api;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SetPortsTest {
    @Test
    public void undeclaredPortsTest() throws Exception {
        MablApiBuilder.MablSettings settings = new MablApiBuilder.MablSettings();
        settings.fmiErrorHandlingEnabled = false;
        MablApiBuilder builder = new MablApiBuilder(settings);
        Path tankFmuPath = Paths.get("src", "test", "resources", "set_wrong_port_test", "singlewatertank-20sim.fmu");
        Path controllerFmuPath = Paths.get("src", "test", "resources", "set_wrong_port_test", "watertankcontroller-c.fmu");
        DynamicActiveBuilderScope scope = builder.getDynamicScope();
        FmuVariableFmi2Api tankFMU = scope.createFMU("Tank", "FMI2", new String[]{tankFmuPath.toUri().toASCIIString()});
        FmuVariableFmi2Api controllerFMU = scope.createFMU("Controller", "FMI2", new String[]{controllerFmuPath.toUri().toASCIIString()});
        ComponentVariableFmi2Api tankInstance = tankFMU.instantiate("wtInstance");
        ComponentVariableFmi2Api controllerInstance = controllerFMU.instantiate("wtInstance");
        Map controllerPortMap = controllerInstance.get((String[])controllerInstance.getPorts().stream().map(PortFmi2Api::getName).toArray(String[]::new));
        controllerInstance.share(controllerPortMap);
        PortValueMapImpl portsToSet = new PortValueMapImpl(controllerPortMap);
        Assertions.assertThrows(RuntimeException.class, () -> SetPortsTest.lambda$undeclaredPortsTest$1(tankInstance, (Fmi2Builder.Fmi2ComponentVariable.PortValueMap)portsToSet));
    }

    private static /* synthetic */ void lambda$undeclaredPortsTest$1(ComponentVariableFmi2Api tankInstance, Fmi2Builder.Fmi2ComponentVariable.PortValueMap portsToSet) throws Throwable {
        tankInstance.set(portsToSet);
    }
}

