/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl.variables;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.MableBuilder;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.DepthFirstAnalysisAdaptor;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.AErrorStm;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PExpBase;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStateDesignatorBase;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.SBlockStm;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.framework.fmi2.RelationVariable;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.BuilderUtil;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.ModelDescriptionContext;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.ScopeFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.values.PortValueExpresssionMapImpl;
import org.intocps.maestro.framework.fmi2.api.mabl.values.PortValueMapImpl;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ArrayVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.PortVariableMapImpl;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.StateMablVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentVariableFmi2Api
extends VariableFmi2Api<Fmi2Builder.NamedVariable<PStm>>
implements Fmi2Builder.Fmi2ComponentVariable<PStm> {
    static final Logger logger = LoggerFactory.getLogger(ComponentVariableFmi2Api.class);
    private static final int FMI_OK = 0;
    private static final int FMI_WARNING = 1;
    private static final int FMI_DISCARD = 2;
    private static final int FMI_ERROR = 3;
    private static final int FMI_FATAL = 4;
    private static final int FMI_PENDING = 5;
    private static final int FMI_STATUS_LAST_SUCCESSFUL = 2;
    private static final String LOGLEVELS_POSTFIX = "_log_levels";
    private static final String CATEGORY_STATUS = "category_status";
    final List<PortFmi2Api> outputPorts;
    final List<PortFmi2Api> inputPorts;
    final List<PortFmi2Api> ports;
    private final FmuVariableFmi2Api owner;
    private final String name;
    private final MablApiBuilder builder;
    private final Map<PType, ArrayVariableFmi2Api<Object>> ioBuffer = new HashMap<PType, ArrayVariableFmi2Api<Object>>();
    private final Map<PType, ArrayVariableFmi2Api<Object>> sharedBuffer = new HashMap<PType, ArrayVariableFmi2Api<Object>>();
    private final Map<IMablScope, Map<PType, ArrayVariableFmi2Api<Object>>> tentativeBuffer = new HashMap<IMablScope, Map<PType, ArrayVariableFmi2Api<Object>>>();
    private final Map<IMablScope, Map<PortFmi2Api, Integer>> tentativeBufferIndexMap = new HashMap<IMablScope, Map<PortFmi2Api, Integer>>();
    private final String environmentName;
    Predicate<Fmi2Builder.Port> isLinked = p -> ((PortFmi2Api)p).getSourcePort() != null;
    ModelDescriptionContext modelDescriptionContext;
    private ArrayVariableFmi2Api<Object> derSharedBuffer;
    private DoubleVariableFmi2Api currentTimeVar = null;
    private BooleanVariableFmi2Api currentTimeStepFullStepVar = null;
    private ArrayVariableFmi2Api<Object> valueRefBuffer;
    private Map<PortFmi2Api, List<VariableFmi2Api<Object>>> derivativePortsToShare;
    private List<String> variabesToLog;

    public ComponentVariableFmi2Api(PStm declaration, FmuVariableFmi2Api parent, String name, ModelDescriptionContext modelDescriptionContext, MablApiBuilder builder, IMablScope declaringScope, PStateDesignator designator, PExp referenceExp) {
        this(declaration, parent, name, modelDescriptionContext, builder, declaringScope, designator, referenceExp, name);
    }

    public ComponentVariableFmi2Api(PStm declaration, FmuVariableFmi2Api parent, String name, ModelDescriptionContext modelDescriptionContext, MablApiBuilder builder, IMablScope declaringScope, PStateDesignator designator, PExp referenceExp, String environmentName) {
        super(declaration, (PType)MableAstFactory.newANameType((String)"FMI2Component"), declaringScope, builder.getDynamicScope(), designator, referenceExp);
        this.owner = parent;
        this.name = name;
        this.modelDescriptionContext = modelDescriptionContext;
        this.builder = builder;
        this.ports = modelDescriptionContext.nameToSv.values().stream().map(sv -> new PortFmi2Api(this, (Fmi2ModelDescription.ScalarVariable)sv)).sorted(Comparator.comparing(PortFmi2Api::getPortReferenceValue)).collect(Collectors.toUnmodifiableList());
        this.outputPorts = this.ports.stream().filter(p -> p.scalarVariable.causality == Fmi2ModelDescription.Causality.Output).sorted(Comparator.comparing(PortFmi2Api::getPortReferenceValue)).collect(Collectors.toUnmodifiableList());
        this.inputPorts = this.ports.stream().filter(p -> p.scalarVariable.causality == Fmi2ModelDescription.Causality.Input).sorted(Comparator.comparing(PortFmi2Api::getPortReferenceValue)).collect(Collectors.toUnmodifiableList());
        this.environmentName = environmentName;
    }

    public Fmi2ModelDescription getModelDescription() {
        return this.modelDescriptionContext.getModelDescription();
    }

    public List<PortFmi2Api> getVariablesToLog() {
        return this.getPorts(this.variabesToLog.toArray(new String[0]));
    }

    public void setVariablesToLog(List<RelationVariable> variablesToLog) {
        this.variabesToLog = variablesToLog.stream().map(x -> x.scalarVariable.getName()).collect(Collectors.toList());
    }

    public <V> void share(Fmi2Builder.Port port, Fmi2Builder.Variable<PStm, V> value) {
        HashMap<Fmi2Builder.Port, Fmi2Builder.Variable<PStm, V>> map = new HashMap<Fmi2Builder.Port, Fmi2Builder.Variable<PStm, V>>();
        map.put(port, value);
        this.share(map);
    }

    private DoubleVariableFmi2Api getCurrentTimeVar() {
        if (this.currentTimeVar == null) {
            String name = this.builder.getNameGenerator().getName(this.name, "current", "time");
            PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newRealType(), (PExp)MableAstFactory.newARealLiteralExp((Double)0.0));
            this.getDeclaredScope().addAfter(this.getDeclaringStm(), var);
            this.currentTimeVar = new DoubleVariableFmi2Api(var, this.getDeclaredScope(), (Fmi2Builder.DynamicActiveScope<PStm>)this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        }
        return this.currentTimeVar;
    }

    private BooleanVariableFmi2Api getCurrentTimeFullStepVar() {
        if (this.currentTimeStepFullStepVar == null) {
            String name = this.builder.getNameGenerator().getName(this.name, "current", "time", "full", "step");
            PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newBoleanType(), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)true));
            this.getDeclaredScope().addAfter(this.getDeclaringStm(), var);
            this.currentTimeStepFullStepVar = new BooleanVariableFmi2Api(var, this.getDeclaredScope(), (Fmi2Builder.DynamicActiveScope<PStm>)this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        }
        return this.currentTimeStepFullStepVar;
    }

    private ArrayVariableFmi2Api<Object> getValueReferenceBuffer() {
        if (this.valueRefBuffer == null) {
            this.valueRefBuffer = this.createBuffer((PType)MableAstFactory.newUIntType(), "VRef", this.modelDescriptionContext.valRefToSv.size(), this.getDeclaredScope());
        }
        return this.valueRefBuffer;
    }

    private ArrayVariableFmi2Api<Object> getBuffer(Map<PType, ArrayVariableFmi2Api<Object>> buffer, PType type, String prefix, int size, IMablScope scope) {
        Optional<PType> first = buffer.keySet().stream().filter(x -> x.toString().equals(type.toString())).findFirst();
        if (first.isEmpty()) {
            ArrayVariableFmi2Api<Object> value = this.createBuffer(type, prefix, size, scope);
            buffer.put(type, value);
            return value;
        }
        return buffer.get(first.get());
    }

    private ArrayVariableFmi2Api<Object> getIOBuffer(PType type) {
        return this.getBuffer(this.ioBuffer, type, "IO", this.modelDescriptionContext.valRefToSv.size(), this.getDeclaredScope());
    }

    private ArrayVariableFmi2Api<Object> getSharedDerBuffer() {
        if (this.derSharedBuffer == null) {
            try {
                this.derSharedBuffer = this.createDerValBuffer("DerShare", List.of(Integer.valueOf(1), Integer.valueOf(this.getModelDescription().getMaxOutputDerivativeOrder())));
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException("Exception occurred when accessing modeldescription: " + e);
            }
        }
        return this.derSharedBuffer;
    }

    private ArrayVariableFmi2Api<Object> getSharedBuffer(PType type) {
        return this.getBuffer(this.sharedBuffer, type, "Share", 0, this.getDeclaredScope());
    }

    private ArrayVariableFmi2Api createMDArrayRecursively(List<Integer> arraySizes, PStm declaringStm, PStateDesignatorBase stateDesignator, PExpBase indexExp) {
        if (arraySizes.size() > 1) {
            ArrayList arrays = new ArrayList();
            for (int i = 0; i < arraySizes.get(0); ++i) {
                arrays.add(this.createMDArrayRecursively(arraySizes.subList(1, arraySizes.size()), declaringStm, (PStateDesignatorBase)MableAstFactory.newAArayStateDesignator((PStateDesignator)stateDesignator, (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExpBase)MableAstFactory.newAArrayIndexExp((PExp)indexExp, List.of(MableAstFactory.newAIntLiteralExp((Integer)i)))));
            }
            return new ArrayVariableFmi2Api(declaringStm, ((VariableFmi2Api)arrays.get(0)).getType(), this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)stateDesignator, indexExp.clone(), arrays);
        }
        ArrayList variables = new ArrayList();
        for (int i = 0; i < arraySizes.get(0); ++i) {
            variables.add(new VariableFmi2Api(declaringStm, this.type, this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)stateDesignator.clone(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)indexExp.clone(), List.of(MableAstFactory.newAIntLiteralExp((Integer)i)))));
        }
        return new ArrayVariableFmi2Api(declaringStm, ((VariableFmi2Api)variables.get(0)).getType(), this.getDeclaredScope(), this.builder.getDynamicScope(), ((AArrayStateDesignator)((VariableFmi2Api)variables.get(0)).getDesignatorClone()).getTarget(), indexExp.clone(), variables);
    }

    private ArrayVariableFmi2Api createDerValBuffer(String identifyingName, List<Integer> lengths) {
        String bufferName = this.builder.getNameGenerator().getName(this.name, identifyingName);
        ALocalVariableStm arrayVariableStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclarationMultiDimensionalArray((LexIdentifier)MableAstFactory.newAIdentifier((String)bufferName), (PType)MableAstFactory.newARealNumericPrimitiveType(), lengths));
        this.getDeclaredScope().addAfter(this.getDeclaringStm(), new PStm[]{arrayVariableStm});
        return this.createMDArrayRecursively(lengths, (PStm)arrayVariableStm, (PStateDesignatorBase)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)bufferName)), (PExpBase)MableAstFactory.newAIdentifierExp((String)bufferName));
    }

    private ArrayVariableFmi2Api<Object> createBuffer(PType type, String prefix, int length, IMablScope scope) {
        String ioBufName = this.builder.getNameGenerator().getName(this.name, "" + type, prefix);
        ALocalVariableStm var = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName), (PType)type, (int)length, null));
        this.getDeclaredScope().addAfter(this.getDeclaringStm(), new PStm[]{var});
        List items = IntStream.range(0, length).mapToObj(arg_0 -> this.lambda$createBuffer$6((PStm)var, type, scope, ioBufName, arg_0)).collect(Collectors.toList());
        return new ArrayVariableFmi2Api<Object>((PStm)var, type, scope, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIdentifierExp((String)ioBufName), items);
    }

    public void setDebugLogging(List<String> categories, boolean enableLogging) {
        AArrayInitializer loglevelsArrayInitializer = null;
        String arrayName = this.name + LOGLEVELS_POSTFIX;
        IMablScope scope = this.builder.getDynamicScope().getActiveScope();
        if (!categories.isEmpty()) {
            loglevelsArrayInitializer = MableAstFactory.newAArrayInitializer(categories.stream().map(MableAstFactory::newAStringLiteralExp).collect(Collectors.toList()));
        }
        ALocalVariableStm arrayContent = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)arrayName), (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newAStringPrimitiveType()), (int)categories.size(), loglevelsArrayInitializer));
        LexIdentifier statusIdentifier = MableAstFactory.newAIdentifier((String)CATEGORY_STATUS);
        ALocalVariableStm callStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)statusIdentifier, (PType)MableAstFactory.newAIntNumericPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.name), (LexIdentifier)MableAstFactory.newAIdentifier((String)"setDebugLogging"), Arrays.asList(MableAstFactory.newABoolLiteralExp((Boolean)enableLogging), MableAstFactory.newAIntLiteralExp((Integer)categories.size()), MableAstFactory.newAIdentifierExp((String)arrayName))))));
        AIfStm ifStm = MableAstFactory.newIf((PExp)MableAstFactory.newOr((PExp)MableAstFactory.newPar((PExp)MableAstFactory.newEqual((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)((LexIdentifier)statusIdentifier.clone())), (PExp)MableAstFactory.newAIntLiteralExp((Integer)3))), (PExp)MableAstFactory.newPar((PExp)MableAstFactory.newEqual((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)((LexIdentifier)statusIdentifier.clone())), (PExp)MableAstFactory.newAIntLiteralExp((Integer)4)))), (PStm)new AErrorStm(), null);
        scope.add(new PStm[]{arrayContent, callStm, ifStm});
    }

    public void setupExperiment(Fmi2Builder.DoubleVariable<PStm> startTime, Fmi2Builder.DoubleVariable<PStm> endTime, Double tolerance) {
        this.setupExperiment(((DoubleVariableFmi2Api)startTime).getReferenceExp().clone(), ((DoubleVariableFmi2Api)endTime).getReferenceExp().clone(), tolerance);
    }

    public void setupExperiment(double startTime, Double endTime, Double tolerance) {
        this.setupExperiment((PExp)MableAstFactory.newARealLiteralExp((Double)startTime), (PExp)MableAstFactory.newARealLiteralExp((Double)endTime), tolerance);
    }

    private void setupExperiment(PExp startTime, PExp endTime, Double tolerance) {
        IMablScope scope = this.builder.getDynamicScope().getActiveScope();
        this.setupExperiment((Fmi2Builder.Scope<PStm>)scope, startTime, endTime, tolerance);
    }

    private void setupExperiment(Fmi2Builder.Scope<PStm> scope, PExp startTime, PExp endTime, Double tolerance) {
        AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)((IMablScope)scope).getFmiStatusVariable().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)this.createFunctionName(FmiFunctionType.SETUPEXPERIMENT), new ArrayList<PExp>(Arrays.asList(MableAstFactory.newABoolLiteralExp((Boolean)(tolerance != null ? 1 : 0)), MableAstFactory.newARealLiteralExp((Double)(tolerance != null ? tolerance : 0.0)), startTime.clone(), MableAstFactory.newABoolLiteralExp((Boolean)(endTime != null ? 1 : 0)), endTime != null ? endTime.clone() : MableAstFactory.newARealLiteralExp((Double)0.0)))));
        scope.add((Object[])new PStm[]{stm});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, "setupExperiment", this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
        }
    }

    public void enterInitializationMode() {
        this.enterInitializationMode(this.builder.getDynamicScope());
    }

    public void exitInitializationMode() {
        this.exitInitializationMode(this.builder.getDynamicScope());
    }

    public void setupExperiment(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.DoubleVariable<PStm> startTime, Fmi2Builder.DoubleVariable<PStm> endTime, Double tolerance) {
        this.setupExperiment(scope, ((DoubleVariableFmi2Api)startTime).getReferenceExp().clone(), ((DoubleVariableFmi2Api)endTime).getReferenceExp().clone(), tolerance);
    }

    public void setupExperiment(Fmi2Builder.Scope<PStm> scope, double startTime, Double endTime, Double tolerance) {
        this.setupExperiment(scope, (PExp)MableAstFactory.newARealLiteralExp((Double)startTime), (PExp)MableAstFactory.newARealLiteralExp((Double)endTime), tolerance);
    }

    public void enterInitializationMode(Fmi2Builder.Scope<PStm> scope) {
        PStm stm = this.stateTransitionFunction(FmiFunctionType.ENTERINITIALIZATIONMODE);
        scope.add((Object[])new PStm[]{stm});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, "enterInitializationMode", this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
        }
    }

    public void exitInitializationMode(Fmi2Builder.Scope<PStm> scope) {
        PStm stm = this.stateTransitionFunction(FmiFunctionType.EXITINITIALIZATIONMODE);
        scope.add((Object[])new PStm[]{stm});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, "exitInitializationMode", this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
        }
    }

    public Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>> step(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.DoubleVariable<PStm> currentCommunicationPoint, Fmi2Builder.DoubleVariable<PStm> communicationStepSize, Fmi2Builder.BoolVariable<PStm> noSetFMUStatePriorToCurrentPoint) {
        return this.step(scope, currentCommunicationPoint, communicationStepSize, ((VariableFmi2Api)noSetFMUStatePriorToCurrentPoint).getReferenceExp());
    }

    public Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>> step(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.DoubleVariable<PStm> currentCommunicationPoint, Fmi2Builder.DoubleVariable<PStm> communicationStepSize) {
        return this.step(scope, currentCommunicationPoint, communicationStepSize, (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false));
    }

    public Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>> step(Fmi2Builder.DoubleVariable<PStm> currentCommunicationPoint, Fmi2Builder.DoubleVariable<PStm> communicationStepSize, Fmi2Builder.BoolVariable<PStm> noSetFMUStatePriorToCurrentPoint) {
        return this.step((Fmi2Builder.Scope<PStm>)this.dynamicScope, currentCommunicationPoint, communicationStepSize, noSetFMUStatePriorToCurrentPoint);
    }

    public Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>> step(Fmi2Builder.DoubleVariable<PStm> currentCommunicationPoint, Fmi2Builder.DoubleVariable<PStm> communicationStepSize) {
        return this.step((Fmi2Builder.Scope<PStm>)this.dynamicScope, currentCommunicationPoint, communicationStepSize, (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false));
    }

    private Map.Entry<Fmi2Builder.BoolVariable<PStm>, Fmi2Builder.DoubleVariable<PStm>> step(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.DoubleVariable<PStm> currentCommunicationPoint, Fmi2Builder.DoubleVariable<PStm> communicationStepSize, PExp noSetFMUStatePriorToCurrentPoint) {
        scope.add((Object[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)((IMablScope)scope).getFmiStatusVariable().getDesignator().clone(), (PExp)MableAstFactory.newACallExp((PExp)this.getReferenceExp().clone(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"doStep"), Arrays.asList(((VariableFmi2Api)currentCommunicationPoint).getReferenceExp().clone(), ((VariableFmi2Api)communicationStepSize).getReferenceExp().clone(), noSetFMUStatePriorToCurrentPoint.clone())))});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, "doStep", this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
        }
        scope.add((Object[])new PStm[]{MableAstFactory.newIf((PExp)MableAstFactory.newNotEqual((PExp)((IMablScope)scope).getFmiStatusVariable().getReferenceExp().clone(), (PExp)this.builder.getFmiStatusConstant(MablApiBuilder.FmiStatus.FMI_OK).getReferenceExp().clone()), (PStm)MableAstFactory.newABlockStm((PStm[])new PStm[]{MableAstFactory.newIf((PExp)MableAstFactory.newEqual((PExp)((IMablScope)scope).getFmiStatusVariable().getReferenceExp().clone(), (PExp)this.builder.getFmiStatusConstant(MablApiBuilder.FmiStatus.FMI_DISCARD).getReferenceExp().clone()), (PStm)MableAstFactory.newABlockStm((PStm[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)((IMablScope)scope).getFmiStatusVariable().getDesignator().clone(), (PExp)MableAstFactory.newACallExp((PExp)this.getReferenceExp().clone(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"getRealStatus"), Arrays.asList(MableAstFactory.newAIntLiteralExp((Integer)2), MableAstFactory.newARefExp((PExp)this.getCurrentTimeVar().getReferenceExp().clone())))), MableAstFactory.newAAssignmentStm((PStateDesignator)this.getCurrentTimeFullStepVar().getDesignator().clone(), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false))}), null)}), (PStm)MableAstFactory.newABlockStm((PStm[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)this.getCurrentTimeVar().getDesignator().clone(), (PExp)MableAstFactory.newPlusExp((PExp)((VariableFmi2Api)currentCommunicationPoint).getReferenceExp().clone(), (PExp)((VariableFmi2Api)communicationStepSize).getReferenceExp().clone())), MableAstFactory.newAAssignmentStm((PStateDesignator)this.getCurrentTimeFullStepVar().getDesignator().clone(), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)true))}))});
        return Map.entry(this.getCurrentTimeFullStepVar(), this.getCurrentTimeVar());
    }

    private PStm stateTransitionFunction(FmiFunctionType type) {
        switch (type) {
            case ENTERINITIALIZATIONMODE: {
                break;
            }
            case EXITINITIALIZATIONMODE: {
                break;
            }
            case TERMINATE: {
                break;
            }
            default: {
                throw new RuntimeException("Attempting to call state transition function with non-state transition function type: " + type);
            }
        }
        AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)((IMablScope)this.dynamicScope).getFmiStatusVariable().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)this.createFunctionName(type), (PExp[])new PExp[0]));
        return stm;
    }

    public List<PortFmi2Api> getPorts() {
        return this.ports;
    }

    public List<PortFmi2Api> getPorts(String ... names) {
        List<String> accept = Arrays.asList(names);
        return this.ports.stream().filter(p -> accept.contains(p.getName())).collect(Collectors.toList());
    }

    public List<PortFmi2Api> getPorts(int ... valueReferences) {
        List accept = Arrays.stream(valueReferences).boxed().collect(Collectors.toList());
        return this.ports.stream().filter(p -> accept.contains(p.getPortReferenceValue().intValue())).collect(Collectors.toList());
    }

    public PortFmi2Api getPort(String name) {
        return this.getPorts(name).get(0);
    }

    public PortFmi2Api getPort(int valueReference) {
        return this.getPorts(valueReference).get(0);
    }

    public <V> Map<PortFmi2Api, VariableFmi2Api<V>> getTentative(IMablScope scope, String ... names) {
        Fmi2Builder.Port[] filteredPorts = (Fmi2Builder.Port[])this.ports.stream().filter(p -> Arrays.asList(names).contains(p.getName()) && p.scalarVariable.causality == Fmi2ModelDescription.Causality.Output).toArray(Fmi2Builder.Port[]::new);
        Map<PortFmi2Api, VariableFmi2Api<V>> portToValueMap = this.get(scope, filteredPorts);
        if (portToValueMap.isEmpty()) {
            return Map.of();
        }
        this.tentativeBufferIndexMap.computeIfAbsent(scope, s -> new HashMap());
        Map<PortFmi2Api, Integer> portToVariableIndexMap = this.tentativeBufferIndexMap.get(scope);
        return portToValueMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            VariableFmi2Api<Object> varToReturn;
            PType type = ((PortFmi2Api)entry.getKey()).getType();
            PortFmi2Api port = (PortFmi2Api)entry.getKey();
            VariableFmi2Api variable = (VariableFmi2Api)entry.getValue();
            this.tentativeBuffer.computeIfAbsent(scope, s -> new HashMap());
            ArrayVariableFmi2Api<Object> buffer = this.getBuffer(this.tentativeBuffer.getOrDefault(scope, new HashMap()), type, "TentativeBuffer", 0, scope);
            if (!portToVariableIndexMap.containsKey(port)) {
                portToVariableIndexMap.put(port, portToVariableIndexMap.entrySet().size());
                ArrayVariableFmi2Api<Object> newBuf = this.growBuffer(buffer, 1);
                this.tentativeBuffer.get(scope).entrySet().removeIf(x -> ((PType)x.getKey()).toString().equals(type.toString()));
                this.tentativeBuffer.get(scope).put(type, newBuf);
                varToReturn = newBuf.items().get(newBuf.items().size() - 1);
            } else {
                varToReturn = buffer.items().get((Integer)portToVariableIndexMap.get(port));
            }
            scope.add(new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)varToReturn.getDesignator(), (PExp)variable.getExp())});
            return varToReturn;
        }));
    }

    public <V> Map<PortFmi2Api, VariableFmi2Api<V>> get(Fmi2Builder.Port ... ports) {
        return this.get(this.builder.getDynamicScope().getActiveScope(), ports);
    }

    public <V> Map<PortFmi2Api, VariableFmi2Api<V>> get(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Port ... ports) {
        if (ports == null || ports.length == 0) {
            return Map.of();
        }
        List selectedPorts = Arrays.stream(ports).map(PortFmi2Api.class::cast).collect(Collectors.toList());
        HashMap<PortFmi2Api, VariableFmi2Api<VariableFmi2Api<Object>>> results = new HashMap<PortFmi2Api, VariableFmi2Api<VariableFmi2Api<Object>>>();
        HashMap typeToSortedPorts = new HashMap();
        ArrayVariableFmi2Api<Object> vrefBuf = this.getValueReferenceBuffer();
        selectedPorts.stream().map(p -> p.scalarVariable.getType().type).distinct().map(t -> selectedPorts.stream().filter(p -> p.scalarVariable.getType().type.equals(t)).sorted(Comparator.comparing(Fmi2Builder.Port::getPortReferenceValue)).collect(Collectors.toList())).forEach(l -> typeToSortedPorts.put(((PortFmi2Api)l.get((int)0)).scalarVariable.getType(), l));
        for (Map.Entry e : typeToSortedPorts.entrySet()) {
            ABooleanPrimitiveType type;
            for (int i = 0; i < ((List)e.getValue()).size(); ++i) {
                PortFmi2Api p2 = (PortFmi2Api)((List)e.getValue()).get(i);
                PStateDesignator designator = vrefBuf.items().get(i).getDesignator().clone();
                scope.add((Object[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)designator, (PExp)MableAstFactory.newAIntLiteralExp((Integer)p2.getPortReferenceValue().intValue()))});
            }
            switch (((Fmi2ModelDescription.Type)e.getKey()).type) {
                case Boolean: {
                    type = new ABooleanPrimitiveType();
                    break;
                }
                case Real: {
                    type = new ARealNumericPrimitiveType();
                    break;
                }
                case Integer: {
                    type = new AIntNumericPrimitiveType();
                    break;
                }
                case String: {
                    type = new AStringPrimitiveType();
                    break;
                }
                case Enumeration: {
                    throw new RuntimeException("Cannot assign enumeration port type.");
                }
                default: {
                    throw new RuntimeException("Cannot match port types.");
                }
            }
            ArrayVariableFmi2Api<Object> valBuf = this.getIOBuffer((PType)type);
            AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)((IMablScope)scope).getFmiStatusVariable().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)this.createFunctionName(FmiFunctionType.GET, (PortFmi2Api)((List)e.getValue()).get(0)), (PExp[])new PExp[]{vrefBuf.getReferenceExp().clone(), MableAstFactory.newAUIntLiteralExp((Long)Long.valueOf(((List)e.getValue()).size())), valBuf.getReferenceExp().clone()}));
            scope.add((Object[])new PStm[]{stm});
            if (this.builder.getSettings().fmiErrorHandlingEnabled) {
                FmiStatusErrorHandlingBuilder.generate(this.builder, this.createFunctionName(FmiFunctionType.GET, (PortFmi2Api)((List)e.getValue()).get(0)), this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
            }
            if (this.builder.getSettings().setGetDerivatives && type.equals((Object)new ARealNumericPrimitiveType())) {
                this.derivativePortsToShare = this.getDerivatives((List)e.getValue(), scope);
            }
            for (int i = 0; i < ((List)e.getValue()).size(); ++i) {
                results.put((PortFmi2Api)((List)e.getValue()).get(i), valBuf.items().get(i));
            }
        }
        return results;
    }

    public Map<PortFmi2Api, List<VariableFmi2Api<Object>>> getDerivatives(List<PortFmi2Api> ports, Fmi2Builder.Scope<PStm> scope) {
        HashMap<PortFmi2Api, List<VariableFmi2Api<Object>>> derivativePortsToReturn = new HashMap<PortFmi2Api, List<VariableFmi2Api<Object>>>();
        List portsLinkedToTargetsThatInterpolates = ports.stream().filter(p1 -> p1.getTargetPorts().stream().anyMatch(p2 -> {
            try {
                return p2.aMablFmi2ComponentAPI.getModelDescription().getCanInterpolateInputs();
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException("Exception occurred when accessing modeldescription: ", e);
            }
        })).collect(Collectors.toList());
        try {
            int maxOutputDerOrder = this.modelDescriptionContext.getModelDescription().getMaxOutputDerivativeOrder();
            if (portsLinkedToTargetsThatInterpolates.size() > 0 && maxOutputDerOrder > 0) {
                ArrayList derivativePorts = new ArrayList();
                this.modelDescriptionContext.getModelDescription().getDerivativesMap().entrySet().stream().filter(entry -> portsLinkedToTargetsThatInterpolates.stream().anyMatch(p -> p.getPortReferenceValue().equals(((Fmi2ModelDescription.ScalarVariable)entry.getKey()).getValueReference()))).forEach(e -> this.getPorts().stream().filter(p -> p.getPortReferenceValue().equals(((Fmi2ModelDescription.ScalarVariable)e.getValue()).getValueReference())).findAny().ifPresent(derivativePorts::add));
                if (derivativePorts.size() > 0) {
                    int arraySize = derivativePorts.size() * maxOutputDerOrder;
                    ArrayVariableFmi2Api<Object> derValOutBuf = this.createBuffer((PType)MableAstFactory.newRealType(), "DVal_OUT", arraySize, this.getDeclaredScope());
                    ArrayVariableFmi2Api<Object> derOrderOutBuf = this.createBuffer((PType)MableAstFactory.newIntType(), "DOrder_OUT", arraySize, this.getDeclaredScope());
                    ArrayVariableFmi2Api<Object> derRefOutBuf = this.createBuffer((PType)MableAstFactory.newUIntType(), "DRef_OUT", arraySize, this.getDeclaredScope());
                    PortFmi2Api derivativePort = null;
                    int portIndex = 0;
                    int order = 1;
                    for (int arrayIndex = 0; arrayIndex < arraySize; ++arrayIndex) {
                        if (arrayIndex % maxOutputDerOrder == 0) {
                            order = 1;
                            derivativePort = (PortFmi2Api)derivativePorts.get(portIndex);
                            derivativePortsToReturn.put(derivativePort, derValOutBuf.items().subList(arrayIndex, arrayIndex + maxOutputDerOrder));
                            ++portIndex;
                        }
                        PStateDesignator dRefDesignator = derRefOutBuf.items().get(arrayIndex).getDesignator().clone();
                        scope.add((Object[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)dRefDesignator, (PExp)MableAstFactory.newAIntLiteralExp((Integer)derivativePort.getPortReferenceValue().intValue()))});
                        PStateDesignator derOrderDesignator = derOrderOutBuf.items().get(arrayIndex).getDesignator().clone();
                        scope.add((Object[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)derOrderDesignator, (PExp)MableAstFactory.newAIntLiteralExp((Integer)order))});
                        ++order;
                    }
                    AAssigmentStm AStm = MableAstFactory.newAAssignmentStm((PStateDesignator)this.builder.getGlobalFmiStatus().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)this.createFunctionName(FmiFunctionType.GETREALOUTPUTDERIVATIVES), (PExp[])new PExp[]{derRefOutBuf.getReferenceExp().clone(), MableAstFactory.newAUIntLiteralExp((Long)Long.valueOf(arraySize)), derOrderOutBuf.getReferenceExp().clone(), derValOutBuf.getReferenceExp().clone()}));
                    scope.add((Object[])new PStm[]{AStm});
                    if (this.builder.getSettings().fmiErrorHandlingEnabled) {
                        FmiStatusErrorHandlingBuilder.generate(this.builder, this.createFunctionName(FmiFunctionType.GETREALOUTPUTDERIVATIVES), this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
                    }
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException | XPathExpressionException e2) {
            throw new RuntimeException("Exception occurred when retrieving derivatives: ", e2);
        }
        return derivativePortsToReturn;
    }

    public <V> Map<PortFmi2Api, VariableFmi2Api<V>> get() {
        return this.get(this.builder.getDynamicScope(), (Fmi2Builder.Port[])this.outputPorts.toArray(Fmi2Builder.Port[]::new));
    }

    public <V> Map<PortFmi2Api, VariableFmi2Api<V>> get(int ... valueReferences) {
        List accept = Arrays.stream(valueReferences).boxed().collect(Collectors.toList());
        return this.get(this.builder.getDynamicScope(), (Fmi2Builder.Port[])this.outputPorts.stream().filter(p -> accept.contains(p.getPortReferenceValue().intValue())).toArray(Fmi2Builder.Port[]::new));
    }

    public <V> Map<PortFmi2Api, VariableFmi2Api<V>> get(String ... names) {
        List<String> accept = Arrays.asList(names);
        Fmi2Builder.Port[] ports = (Fmi2Builder.Port[])this.ports.stream().filter(p -> accept.contains(p.getName())).toArray(Fmi2Builder.Port[]::new);
        return this.get(this.builder.getDynamicScope(), ports);
    }

    public <V> Map<PortFmi2Api, VariableFmi2Api<V>> getAndShare(String ... names) {
        Map<PortFmi2Api, VariableFmi2Api<V>> values = this.get(names);
        this.share(values);
        return values;
    }

    public <V> Map<? extends Fmi2Builder.Port, ? extends Fmi2Builder.Variable<PStm, V>> getAndShare(Fmi2Builder.Port ... ports) {
        Map<PortFmi2Api, VariableFmi2Api<V>> values = this.get(ports);
        this.share(values);
        return values;
    }

    public <V> Map<? extends Fmi2Builder.Port, ? extends Fmi2Builder.Variable<PStm, V>> getAndShare() {
        Map<PortFmi2Api, VariableFmi2Api<V>> values = this.get();
        this.share(values);
        return values;
    }

    public VariableFmi2Api getShared(String name) {
        return this.getPort(name).getSharedAsVariable();
    }

    public VariableFmi2Api getShared(Fmi2Builder.Port port) {
        return ((PortFmi2Api)port).getSharedAsVariable();
    }

    public <V> VariableFmi2Api<V> getSingle(Fmi2Builder.Port port) {
        return this.get(port).entrySet().iterator().next().getValue();
    }

    private String createFunctionName(FmiFunctionType fun) {
        switch (fun) {
            case ENTERINITIALIZATIONMODE: {
                return "enterInitializationMode";
            }
            case EXITINITIALIZATIONMODE: {
                return "exitInitializationMode";
            }
            case SETUPEXPERIMENT: {
                return "setupExperiment";
            }
            case GETREALOUTPUTDERIVATIVES: {
                return "getRealOutputDerivatives";
            }
            case SETREALINPUTDERIVATIVES: {
                return "setRealInputDerivatives";
            }
            case TERMINATE: {
                return "terminate";
            }
        }
        throw new RuntimeException("Attempting to call function that is type dependant without specifying type: " + fun);
    }

    private String createFunctionName(FmiFunctionType fun, PortFmi2Api p) {
        return this.createFunctionName(fun, p.scalarVariable.getType().type);
    }

    private String createFunctionName(FmiFunctionType f, Fmi2ModelDescription.Types type) {
        Object functionName = "";
        switch (f) {
            case GET: {
                functionName = (String)functionName + "get";
                break;
            }
            case SET: {
                functionName = (String)functionName + "set";
                break;
            }
            default: {
                throw new RuntimeException("Attempting to call non type-dependant function with type: " + type);
            }
        }
        functionName = (String)functionName + type.name();
        return functionName;
    }

    public VariableFmi2Api getSingle(String name) {
        return this.get(name).entrySet().iterator().next().getValue();
    }

    public void set(Fmi2Builder.Port p, Fmi2Builder.ExpressionValue v) {
        this.set(new PortValueExpresssionMapImpl((Map<? extends Fmi2Builder.Port, ? extends Fmi2Builder.ExpressionValue>)Map.of(p, v)));
    }

    public void set(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Port p, Fmi2Builder.ExpressionValue v) {
        this.set(scope, new PortValueMapImpl(Map.of(p, v)));
    }

    public void set(Fmi2Builder.Fmi2ComponentVariable.PortExpressionValueMap value) {
        this.set((Fmi2Builder.Scope<PStm>)this.builder.getDynamicScope().getActiveScope(), value);
    }

    public void set(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Fmi2ComponentVariable.PortExpressionValueMap value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        List<PortFmi2Api> selectedPorts = value.keySet().stream().map(PortFmi2Api.class::cast).collect(Collectors.toList());
        this.set(scope, selectedPorts, (PortFmi2Api port) -> {
            Fmi2Builder.ExpressionValue value_ = (Fmi2Builder.ExpressionValue)value.get(port);
            return Map.entry(value_.getExp(), value_.getType());
        });
    }

    public <V> void set(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Fmi2ComponentVariable.PortValueMap<V> value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        List<PortFmi2Api> selectedPorts = value.keySet().stream().map(PortFmi2Api.class::cast).collect(Collectors.toList());
        this.set(scope, selectedPorts, (PortFmi2Api port) -> {
            Object val = ((Fmi2Builder.Value)value.get(port)).get();
            if (val instanceof Double) {
                return Map.entry(MableAstFactory.newARealLiteralExp((Double)((Double)val)), MableAstFactory.newRealType());
            }
            if (val instanceof Long) {
                return Map.entry(MableAstFactory.newAUIntLiteralExp((Long)((Long)val)), MableAstFactory.newUIntType());
            }
            if (val instanceof Integer) {
                return Map.entry(MableAstFactory.newAIntLiteralExp((Integer)((Integer)val)), MableAstFactory.newIntType());
            }
            if (val instanceof Boolean) {
                return Map.entry(MableAstFactory.newABoolLiteralExp((Boolean)((Boolean)val)), MableAstFactory.newBoleanType());
            }
            if (val instanceof String) {
                return Map.entry(MableAstFactory.newAStringLiteralExp((String)((String)val)), MableAstFactory.newStringType());
            }
            return null;
        });
    }

    public <V> void set(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Fmi2ComponentVariable.PortVariableMap<PStm, V> value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        List<PortFmi2Api> selectedPorts = value.keySet().stream().map(PortFmi2Api.class::cast).collect(Collectors.toList());
        Fmi2Builder.Fmi2ComponentVariable.PortVariableMap valueFinal = value;
        this.set(scope, selectedPorts, (PortFmi2Api port) -> Map.entry(((VariableFmi2Api)valueFinal.get(port)).getReferenceExp().clone(), ((VariableFmi2Api)valueFinal.get((Object)port)).type));
    }

    public void set(Fmi2Builder.Scope<PStm> scope, List<PortFmi2Api> selectedPorts, Function<PortFmi2Api, Map.Entry<PExp, PType>> portToValue) {
        Set selectedPortsAsStrings = selectedPorts.stream().map(p -> p.getName() + "-" + p.aMablFmi2ComponentAPI.getName() + "-" + p.aMablFmi2ComponentAPI.getOwner().getName()).collect(Collectors.toSet());
        selectedPortsAsStrings.removeAll(this.ports.stream().map(p -> p.getName() + "-" + p.aMablFmi2ComponentAPI.getName() + "-" + p.aMablFmi2ComponentAPI.getOwner().getName()).collect(Collectors.toSet()));
        if (selectedPortsAsStrings.size() > 0) {
            throw new RuntimeException("Unable to set port(s) that is not declared in the FMU: " + selectedPortsAsStrings.stream().map(name -> name.split("-")[0]).collect(Collectors.joining(", ")));
        }
        List sortedPorts = selectedPorts.stream().sorted(Comparator.comparing(Fmi2Builder.Port::getPortReferenceValue)).collect(Collectors.toList());
        sortedPorts.stream().collect(Collectors.groupingBy(i -> i.getType().toString())).forEach((key, value) -> {
            ArrayVariableFmi2Api<Object> vrefBuf = this.getValueReferenceBuffer();
            PType type = ((PortFmi2Api)value.get(0)).getType();
            for (int i = 0; i < value.size(); ++i) {
                Fmi2Builder.Port p = (Fmi2Builder.Port)value.get(i);
                PStateDesignator designator = vrefBuf.items().get(i).getDesignator().clone();
                scope.add((Object[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)designator, (PExp)MableAstFactory.newAIntLiteralExp((Integer)p.getPortReferenceValue().intValue()))});
            }
            ArrayVariableFmi2Api<Object> valBuf = this.getIOBuffer(type);
            for (int i = 0; i < value.size(); ++i) {
                PortFmi2Api p = (PortFmi2Api)value.get(i);
                PStateDesignator designator = valBuf.items().get(i).getDesignator();
                scope.addAll(BuilderUtil.createTypeConvertingAssignment(this.builder, scope, designator.clone(), ((PExp)((Map.Entry)portToValue.apply(p)).getKey()).clone(), (PType)((Map.Entry)portToValue.apply(p)).getValue(), valBuf.type));
            }
            AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)((IMablScope)scope).getFmiStatusVariable().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)this.createFunctionName(FmiFunctionType.SET, (PortFmi2Api)value.get(0)), (PExp[])new PExp[]{vrefBuf.getReferenceExp().clone(), MableAstFactory.newAUIntLiteralExp((Long)Long.valueOf(value.size())), valBuf.getReferenceExp().clone()}));
            scope.add((Object[])new PStm[]{stm});
            if (this.builder.getSettings().fmiErrorHandlingEnabled) {
                FmiStatusErrorHandlingBuilder.generate(this.builder, this.createFunctionName(FmiFunctionType.SET, (PortFmi2Api)sortedPorts.get(0)), this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
            }
            try {
                if (this.builder.getSettings().setGetDerivatives && this.modelDescriptionContext.getModelDescription().getCanInterpolateInputs() && type.equals((Object)new ARealNumericPrimitiveType())) {
                    this.setDerivativesForSharedPorts((List<PortFmi2Api>)value, scope);
                }
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException("Exception occurred when when setting derivatives.", e);
            }
        });
    }

    private void setDerivativesForSharedPorts(List<PortFmi2Api> ports, Fmi2Builder.Scope<PStm> scope) {
        LinkedHashMap mapPortsToDerPortsWithOrder = ports.stream().filter(port -> port.getSourcePort() != null).map(port -> {
            try {
                Optional<Map.Entry> derivativePortEntry = port.getSourcePort().aMablFmi2ComponentAPI.getModelDescription().getDerivativesMap().entrySet().stream().filter(e -> ((Fmi2ModelDescription.ScalarVariable)e.getKey()).getValueReference().equals(port.getSourcePort().getPortReferenceValue())).findAny();
                if (derivativePortEntry.isPresent()) {
                    Map.Entry<PortFmi2Api, Integer> innerEntry = Map.entry(port.getSourcePort().aMablFmi2ComponentAPI.getPort(((Fmi2ModelDescription.ScalarVariable)derivativePortEntry.get().getValue()).getValueReference().intValue()), port.getSourcePort().aMablFmi2ComponentAPI.getModelDescription().getMaxOutputDerivativeOrder());
                    return Map.entry(port, innerEntry);
                }
                return null;
            }
            catch (IllegalAccessException | InvocationTargetException | XPathExpressionException e2) {
                throw new RuntimeException("Exception occurred when accessing modeldescription: ", e2);
            }
        }).filter(Objects::nonNull).collect(LinkedHashMap::new, (map, item) -> map.put((PortFmi2Api)item.getKey(), (Map.Entry)item.getValue()), Map::putAll);
        if (mapPortsToDerPortsWithOrder.size() > 0) {
            int arraySize = mapPortsToDerPortsWithOrder.values().stream().mapToInt(Map.Entry::getValue).sum();
            ArrayVariableFmi2Api<Object> derValInBuf = this.createBuffer((PType)MableAstFactory.newRealType(), "DVal_IN", arraySize, this.getDeclaredScope());
            ArrayVariableFmi2Api<Object> derOrderInBuf = this.createBuffer((PType)MableAstFactory.newIntType(), "DOrder_IN", arraySize, this.getDeclaredScope());
            ArrayVariableFmi2Api<Object> derRefInBuf = this.createBuffer((PType)MableAstFactory.newUIntType(), "DRef_IN", arraySize, this.getDeclaredScope());
            int arrayIndex = 0;
            for (Map.Entry entry : mapPortsToDerPortsWithOrder.entrySet()) {
                PortFmi2Api port2 = (PortFmi2Api)entry.getKey();
                int maxOrder = (Integer)((Map.Entry)entry.getValue()).getValue();
                int order = 1;
                while (order <= maxOrder) {
                    PStateDesignator derRefDesignator = derRefInBuf.items().get(arrayIndex).getDesignator().clone();
                    scope.add((Object[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)derRefDesignator, (PExp)MableAstFactory.newAIntLiteralExp((Integer)port2.getPortReferenceValue().intValue()))});
                    PStateDesignator derOrderDesignator = derOrderInBuf.items().get(arrayIndex).getDesignator().clone();
                    scope.add((Object[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)derOrderDesignator, (PExp)MableAstFactory.newAIntLiteralExp((Integer)order))});
                    PStateDesignator derValInDesignator = derValInBuf.items().get(arrayIndex).getDesignator().clone();
                    scope.add((Object[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)derValInDesignator, (PExp)((ArrayVariableFmi2Api)((PortFmi2Api)((Map.Entry)entry.getValue()).getKey()).getSharedAsVariable()).items().get(order - 1).getReferenceExp().clone())});
                    ++order;
                    ++arrayIndex;
                }
            }
            this.setDerivatives(derValInBuf, derOrderInBuf, derRefInBuf, scope);
        }
    }

    public void setDerivatives(ArrayVariableFmi2Api derValInBuf, ArrayVariableFmi2Api derOrderInBuf, ArrayVariableFmi2Api derRefInBuf, Fmi2Builder.Scope<PStm> scope) {
        int arraySize = derValInBuf.size();
        AAssigmentStm ifStm = MableAstFactory.newAAssignmentStm((PStateDesignator)this.builder.getGlobalFmiStatus().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)this.createFunctionName(FmiFunctionType.SETREALINPUTDERIVATIVES), (PExp[])new PExp[]{derRefInBuf.getReferenceExp().clone(), MableAstFactory.newAUIntLiteralExp((Long)Long.valueOf(arraySize)), derOrderInBuf.getReferenceExp().clone(), derValInBuf.getReferenceExp().clone()}));
        scope.add((Object[])new PStm[]{ifStm});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, this.createFunctionName(FmiFunctionType.SETREALINPUTDERIVATIVES), this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
        }
    }

    public <V> void set(Fmi2Builder.Fmi2ComponentVariable.PortValueMap<V> value) {
        this.set((Fmi2Builder.Scope<PStm>)this.builder.getDynamicScope(), value);
    }

    public <V> void set(Fmi2Builder.Port port, Fmi2Builder.Variable<PStm, V> value) {
        this.set(new PortVariableMapImpl<V>(Map.of(port, value)));
    }

    public <V> void set(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Port port, Fmi2Builder.Variable<PStm, V> value) {
        this.set(scope, new PortVariableMapImpl<V>(Map.of(port, value)));
    }

    public void set(Fmi2Builder.Port port, Fmi2Builder.Value value) {
        PortValueMapImpl map = new PortValueMapImpl();
        map.put(port, value);
        this.set(map);
    }

    public <V> void set(Fmi2Builder.Fmi2ComponentVariable.PortVariableMap<PStm, V> value) {
        this.set((Fmi2Builder.Scope<PStm>)this.builder.getDynamicScope(), value);
    }

    public void setLinked(Fmi2Builder.Scope<PStm> scope, Fmi2Builder.Port ... filterPorts) {
        List<PortFmi2Api> selectedPorts = this.ports.stream().filter(this.isLinked).collect(Collectors.toList());
        if (filterPorts != null && filterPorts.length != 0) {
            List<Fmi2Builder.Port> filterList = Arrays.asList(filterPorts);
            for (Fmi2Builder.Port p : filterList) {
                if (this.isLinked.test(p)) continue;
                logger.warn("Filter for setLinked contains unlined port. Its ignored. {}", (Object)p);
            }
            selectedPorts = selectedPorts.stream().filter(filterList::contains).collect(Collectors.toList());
        }
        if (selectedPorts.size() == 0) {
            logger.warn("No linked input variables for FMU instance: " + this.getName());
            return;
        }
        for (PortFmi2Api port : selectedPorts) {
            if (port.getSourcePort() == null) {
                throw new RuntimeException("Attempting to obtain shared value from a port that is not linked. This port is missing a required link: " + port);
            }
            if (port.getSourcePort().getSharedAsVariable() != null) continue;
            throw new RuntimeException("Attempting to obtain shared values from a port that is linked but has no value shared. Share a value first. " + port);
        }
        this.set(scope, selectedPorts, (PortFmi2Api k) -> Map.entry(k.getSourcePort().getSharedAsVariable().getReferenceExp().clone(), k.getSourcePort().getSharedAsVariable().type));
    }

    public void setLinked() {
        this.setLinked((Fmi2Builder.Scope<PStm>)this.dynamicScope, (Fmi2Builder.Port[])null);
    }

    public void setLinked(Fmi2Builder.Port ... filterPorts) {
        this.setLinked((Fmi2Builder.Scope<PStm>)this.dynamicScope, filterPorts);
    }

    public void setLinked(String ... filterNames) {
        List<String> accept = Arrays.asList(filterNames);
        this.setLinked((Fmi2Builder.Scope<PStm>)this.dynamicScope, (Fmi2Builder.Port[])this.getPorts().stream().filter(p -> accept.contains(p.getName())).toArray(Fmi2Builder.Port[]::new));
    }

    public void setLinked(long ... filterValueReferences) {
        List accept = Arrays.stream(filterValueReferences).boxed().collect(Collectors.toList());
        this.setLinked((Fmi2Builder.Scope<PStm>)this.dynamicScope, (Fmi2Builder.Port[])this.getPorts().stream().filter(p -> accept.contains(p.getPortReferenceValue())).toArray(Fmi2Builder.Port[]::new));
    }

    public void setInt(Map<? extends Integer, ? extends Fmi2Builder.Value<Integer>> values) {
    }

    public void setString(Map<? extends String, ? extends Fmi2Builder.Value<String>> value) {
    }

    public void terminate() {
        this.terminate(this.builder.getDynamicScope());
    }

    public void terminate(Fmi2Builder.Scope<PStm> scope) {
        PStm stm = this.stateTransitionFunction(FmiFunctionType.TERMINATE);
        scope.add((Object[])new PStm[]{stm});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, "terminate", this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
        }
    }

    public <V> void share(Map<? extends Fmi2Builder.Port, ? extends Fmi2Builder.Variable<PStm, V>> values) {
        values.entrySet().stream().collect(Collectors.groupingBy(map -> ((PortFmi2Api)map.getKey()).getType().toString())).entrySet().stream().forEach(map -> {
            PType type = ((PortFmi2Api)((Map.Entry)((List)map.getValue()).get(0)).getKey()).getType();
            Map<Fmi2Builder.Port, Fmi2Builder.Variable> data = ((List)map.getValue()).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            data.keySet().stream().map(PortFmi2Api.class::cast).sorted(Comparator.comparing(PortFmi2Api::getPortReferenceValue)).forEach(port -> {
                ArrayVariableFmi2Api<Object> buffer = this.getSharedBuffer(type);
                if (port.getSharedAsVariable() == null) {
                    ArrayVariableFmi2Api<Object> newBuf = this.growBuffer(buffer, 1);
                    this.setSharedBuffer(newBuf, type);
                    VariableFmi2Api<Object> newShared = newBuf.items().get(newBuf.items().size() - 1);
                    port.setSharedAsVariable(newShared);
                }
                PStateDesignator designator = port.getSharedAsVariable().getDesignator();
                this.builder.getDynamicScope().addAll(BuilderUtil.createTypeConvertingAssignment(this.builder, (Fmi2Builder.Scope<PStm>)this.dynamicScope, designator.clone(), ((VariableFmi2Api)data.get(port)).getReferenceExp().clone(), port.getType(), ((VariableFmi2Api)data.get((Object)port)).type));
                if (type.equals((Object)new ARealNumericPrimitiveType()) && this.derivativePortsToShare != null) {
                    this.derivativePortsToShare.keySet().stream().filter(derivativePort -> {
                        try {
                            return this.modelDescriptionContext.getModelDescription().getDerivativesMap().entrySet().stream().anyMatch(e -> ((Fmi2ModelDescription.ScalarVariable)e.getKey()).getValueReference().equals(port.getPortReferenceValue()) && ((Fmi2ModelDescription.ScalarVariable)e.getValue()).getValueReference().equals(derivativePort.getPortReferenceValue()));
                        }
                        catch (IllegalAccessException | InvocationTargetException | XPathExpressionException e2) {
                            throw new RuntimeException("Attempting to obtain shared values from a port that is linked but has no value shared. Share a value first. " + port);
                        }
                    }).findFirst().ifPresent(derivativePort -> {
                        if (derivativePort.getSharedAsVariable() == null) {
                            ArrayVariableFmi2Api<Object> sharedDerBuf = this.growSharedDerBuf(1);
                            ArrayVariableFmi2Api newSharedArray = (ArrayVariableFmi2Api)sharedDerBuf.items().get(sharedDerBuf.items().size() - 1);
                            derivativePort.setSharedAsVariable(newSharedArray);
                        }
                        List derivatives = ((ArrayVariableFmi2Api)derivativePort.getSharedAsVariable()).items();
                        for (int i = 0; i < derivatives.size(); ++i) {
                            PExp val = this.derivativePortsToShare.get(derivativePort).get(i).getReferenceExp().clone();
                            this.builder.getDynamicScope().add(new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)derivatives.get(i).getDesignator().clone(), (PExp)val)});
                        }
                    });
                }
            });
        });
    }

    private ArrayVariableFmi2Api<Object> growSharedDerBuf(int increaseByCount) {
        int innerArraySize;
        if (this.derSharedBuffer == null && increaseByCount == 1) {
            return this.getSharedDerBuffer();
        }
        ArrayVariableFmi2Api<Object> sharedBuffer = this.getSharedDerBuffer();
        try {
            innerArraySize = this.modelDescriptionContext.getModelDescription().getMaxOutputDerivativeOrder();
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Exception occurred when accessing model description: ", e);
        }
        String bufferName = ((AIdentifierExp)sharedBuffer.getReferenceExp()).getName().getText();
        int outerArraySize = sharedBuffer.size() + increaseByCount;
        ALocalVariableStm outerArrayVariableStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclarationMultiDimensionalArray((LexIdentifier)MableAstFactory.newAIdentifier((String)bufferName), (PType)MableAstFactory.newARealNumericPrimitiveType(), Arrays.asList(outerArraySize, innerArraySize)));
        sharedBuffer.getDeclaringStm().parent().replaceChild((INode)sharedBuffer.getDeclaringStm(), (INode)outerArrayVariableStm);
        ArrayList items = new ArrayList();
        for (int i = 0; i < increaseByCount; ++i) {
            int outerIndex = sharedBuffer.size() + i;
            ArrayList variables = new ArrayList();
            for (int l = 0; l < innerArraySize; ++l) {
                AArrayStateDesignator designator = MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)bufferName)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)outerIndex)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)l));
                AArrayIndexExp indexExp = MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((String)bufferName), Arrays.asList(MableAstFactory.newAIntLiteralExp((Integer)outerIndex), MableAstFactory.newAIntLiteralExp((Integer)l)));
                variables.add(new VariableFmi2Api((PStm)outerArrayVariableStm, this.type, this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)designator, (PExp)indexExp));
            }
            ArrayVariableFmi2Api innerArrayVariable = new ArrayVariableFmi2Api((PStm)outerArrayVariableStm, (PType)MableAstFactory.newARealNumericPrimitiveType(), this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)bufferName)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)outerIndex)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((String)bufferName), Collections.singletonList(MableAstFactory.newAIntLiteralExp((Integer)outerIndex))), variables);
            items.add(innerArrayVariable);
        }
        items.addAll(0, sharedBuffer.items());
        return new ArrayVariableFmi2Api<Object>((PStm)outerArrayVariableStm, (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newARealNumericPrimitiveType()), this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)bufferName)), (PExp)MableAstFactory.newAIdentifierExp((String)bufferName), items);
    }

    private void setSharedBuffer(ArrayVariableFmi2Api<Object> newBuf, PType type) {
        this.sharedBuffer.entrySet().removeIf(x -> ((PType)x.getKey()).toString().equals(type.toString()));
        this.sharedBuffer.put(type, newBuf);
    }

    private ArrayVariableFmi2Api<Object> growBuffer(ArrayVariableFmi2Api<Object> buffer, int increaseByCount) {
        String ioBufName = ((AIdentifierExp)buffer.getReferenceExp()).getName().getText();
        int length = buffer.size() + increaseByCount;
        ALocalVariableStm var = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName), (PType)buffer.type, (int)length, null));
        buffer.getDeclaringStm().parent().replaceChild((INode)buffer.getDeclaringStm(), (INode)var);
        List items = IntStream.range(buffer.size(), length).mapToObj(arg_0 -> this.lambda$growBuffer$54((PStm)var, buffer, ioBufName, arg_0)).collect(Collectors.toList());
        items.addAll(0, buffer.items());
        return new ArrayVariableFmi2Api<Object>((PStm)var, buffer.type, this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIdentifierExp((String)ioBufName), items);
    }

    public Fmi2Builder.StateVariable<PStm> getState() throws XPathExpressionException {
        return this.getState(this.builder.getDynamicScope());
    }

    public Fmi2Builder.StateVariable<PStm> getState(Fmi2Builder.Scope<PStm> scope) throws XPathExpressionException {
        if (!this.modelDescriptionContext.getModelDescription().getCanGetAndSetFmustate()) {
            throw new RuntimeException("Unable to get state on fmu: " + this.getOwner() + " with instance name: " + this.getName());
        }
        String stateName = this.builder.getNameGenerator().getName(this.name, "state");
        PStm stateVar = MableBuilder.newVariable((String)stateName, (PType)MableAstFactory.newANameType((String)"FmiComponentState"), (int[])new int[0]);
        scope.add((Object[])new PStm[]{stateVar});
        StateMablVariableFmi2Api state = new StateMablVariableFmi2Api(stateVar, (PType)MableAstFactory.newANameType((String)"FmiComponentState"), (IMablScope)scope, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)stateName), (PExp)MableAstFactory.newAIdentifierExp((String)stateName), this.builder, this);
        AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)((IMablScope)scope).getFmiStatusVariable().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)"getState", Collections.singletonList(MableAstFactory.newARefExp((PExp)state.getReferenceExp().clone()))));
        scope.add((Object[])new PStm[]{stm});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, "getState", this, (IMablScope)scope, MablApiBuilder.FmiStatus.FMI_ERROR, MablApiBuilder.FmiStatus.FMI_FATAL);
        }
        return state;
    }

    public FmuVariableFmi2Api getOwner() {
        return this.owner;
    }

    public List<PortFmi2Api> getAllConnectedOutputs() {
        return this.ports.stream().filter(x -> x.scalarVariable.causality == Fmi2ModelDescription.Causality.Output && x.getTargetPorts().size() > 0).collect(Collectors.toList());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    private /* synthetic */ VariableFmi2Api lambda$growBuffer$54(PStm var, ArrayVariableFmi2Api buffer, String ioBufName, int i) {
        return new VariableFmi2Api(var, buffer.type, this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((String)ioBufName), Collections.singletonList(MableAstFactory.newAIntLiteralExp((Integer)i))));
    }

    private /* synthetic */ VariableFmi2Api lambda$createBuffer$6(PStm var, PType type, IMablScope scope, String ioBufName, int i) {
        return new VariableFmi2Api(var, type, scope, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((String)ioBufName), Collections.singletonList(MableAstFactory.newAIntLiteralExp((Integer)i))));
    }

    static class FmiStatusErrorHandlingBuilder {
        FmiStatusErrorHandlingBuilder() {
        }

        static void generate(MablApiBuilder builder, String method, ComponentVariableFmi2Api instance, IMablScope scope, MablApiBuilder.FmiStatus ... statusesToFail) {
            if (statusesToFail == null || statusesToFail.length == 0) {
                return;
            }
            Function<MablApiBuilder.FmiStatus, PExp> checkStatusEq = s -> MableAstFactory.newEqual((PExp)scope.getFmiStatusVariable().getReferenceExp().clone(), (PExp)builder.getFmiStatusConstant((MablApiBuilder.FmiStatus)((Object)s)).getReferenceExp().clone());
            PExp exp = checkStatusEq.apply(statusesToFail[0]);
            for (int i = 1; i < statusesToFail.length; ++i) {
                exp = MableAstFactory.newOr((PExp)exp, (PExp)checkStatusEq.apply(statusesToFail[i]));
            }
            ScopeFmi2Api thenScope = scope.enterIf(new PredicateFmi2Api(exp)).enterThen();
            for (MablApiBuilder.FmiStatus status : statusesToFail) {
                ScopeFmi2Api s2 = thenScope.enterIf(new PredicateFmi2Api(checkStatusEq.apply(status))).enterThen();
                builder.getLogger().error(s2, method.substring(0, 1).toUpperCase() + method.substring(1) + " failed on '%s' with status: " + status, instance);
            }
            thenScope.add(new PStm[]{new AErrorStm((PExp)MableAstFactory.newAStringLiteralExp((String)("Failed to '" + method + "' on '" + instance.getName() + "'")))});
            thenScope.leave();
        }

        static Set<String> collectedPreviousLoadedModules(INode node) {
            if (node == null) {
                return new HashSet<String>();
            }
            Function<PStm, String> getLoadedIdentifier = s -> {
                final AtomicReference id = new AtomicReference();
                try {
                    s.apply((IAnalysis)new DepthFirstAnalysisAdaptor(){

                        public void caseALoadExp(ALoadExp node) {
                            AVariableDeclaration decl = (AVariableDeclaration)node.getAncestor(AVariableDeclaration.class);
                            if (decl != null) {
                                id.set(decl.getName().getText());
                            }
                            ALocalVariableStm ldecl = (ALocalVariableStm)node.getAncestor(ALocalVariableStm.class);
                            if (decl != null) {
                                id.set(ldecl.getDeclaration().getName().getText());
                            }
                        }
                    });
                }
                catch (AnalysisException e) {
                    e.addSuppressed((Throwable)e);
                }
                return (String)id.get();
            };
            HashSet<String> identifiers = new HashSet<String>();
            if (node instanceof SBlockStm) {
                for (PStm n : ((SBlockStm)node).getBody()) {
                    String id = getLoadedIdentifier.apply(n);
                    if (id == null) continue;
                    identifiers.add(id);
                }
            }
            if (node.parent() != null) {
                identifiers.addAll(FmiStatusErrorHandlingBuilder.collectedPreviousLoadedModules(node.parent()));
            }
            return identifiers;
        }
    }

    public static enum FmiFunctionType {
        GET,
        SET,
        ENTERINITIALIZATIONMODE,
        EXITINITIALIZATIONMODE,
        SETUPEXPERIMENT,
        GETREALOUTPUTDERIVATIVES,
        SETREALINPUTDERIVATIVES,
        TERMINATE;

    }
}

