/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl.variables;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.fmi.IFmu;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.MableBuilder;
import org.intocps.maestro.ast.node.AArrayType;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.AErrorStm;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.framework.fmi2.FmuFactory;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.ModelDescriptionContext;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.TagNameGenerator;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.ScopeFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.TryMaBlScope;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;

public class VariableCreatorFmi2Api {
    private final IMablScope scope;
    private final MablApiBuilder builder;

    public VariableCreatorFmi2Api(IMablScope scope, MablApiBuilder builder) {
        this.scope = scope;
        this.builder = builder;
    }

    public static PType fmitypetomabltype(Fmi2ModelDescription.Types type) {
        switch (type) {
            case Boolean: {
                return MableAstFactory.newABoleanPrimitiveType();
            }
            case Real: {
                return MableAstFactory.newARealNumericPrimitiveType();
            }
            case Integer: {
                return MableAstFactory.newAIntNumericPrimitiveType();
            }
            case String: {
                return MableAstFactory.newAStringPrimitiveType();
            }
        }
        throw new UnsupportedOperationException("Converting fmi type: " + type + " to mabl type is not supported.");
    }

    public static VariableFmi2Api createVariableForPort(TagNameGenerator nameGenerator, PortFmi2Api port, IMablScope scope, Fmi2Builder.DynamicActiveScope<PStm> dynamicScope) {
        String name = nameGenerator.getName(port.toLexName());
        AArrayType type = MableAstFactory.newAArrayType((PType)VariableCreatorFmi2Api.fmitypetomabltype(port.scalarVariable.type.type));
        int size = 1;
        PStm stm = MableBuilder.newVariable((String)name, (PType)type, (int)size);
        scope.add(stm);
        VariableFmi2Api variable = new VariableFmi2Api(stm, (PType)type, scope, dynamicScope, (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)name)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)0)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((String)name), Arrays.asList(MableAstFactory.newAIntLiteralExp((Integer)0))));
        return variable;
    }

    public static FmuVariableFmi2Api createFMU(MablApiBuilder builder, TagNameGenerator nameGenerator, DynamicActiveBuilderScope dynamicScope, String name, URI uriPath, IMablScope scope) throws Exception {
        String path = uriPath.toString();
        if (uriPath.getScheme() != null && uriPath.getScheme().equals("file")) {
            path = uriPath.getPath();
        }
        IFmu fmu = FmuFactory.create(null, (URI)URI.create(path));
        Fmi2ModelDescription modelDescription = new Fmi2ModelDescription(fmu.getModelDescription());
        return VariableCreatorFmi2Api.createFMU(builder, nameGenerator, dynamicScope, name, modelDescription, uriPath, scope);
    }

    public static FmuVariableFmi2Api createFMU(MablApiBuilder builder, TagNameGenerator nameGenerator, DynamicActiveBuilderScope dynamicScope, String name, String loaderName, String[] args, IMablScope scope) throws Exception {
        if (loaderName.equals("FMI2")) {
            return VariableCreatorFmi2Api.createFMU(builder, nameGenerator, dynamicScope, name, URI.create(args[0]), scope);
        }
        if (loaderName.equals("JFMI2")) {
            return VariableCreatorFmi2Api.createFMU(builder, nameGenerator, dynamicScope, name, args[0], scope);
        }
        return null;
    }

    public static FmuVariableFmi2Api createFMU(MablApiBuilder builder, TagNameGenerator nameGenerator, DynamicActiveBuilderScope dynamicScope, String name, String className, IMablScope scope) throws Exception {
        ALoadExp loadExp = MableAstFactory.newALoadExp(Arrays.asList(MableAstFactory.newAStringLiteralExp((String)"JFMI2"), MableAstFactory.newAStringLiteralExp((String)className)));
        IFmu fmu = (IFmu)VariableCreatorFmi2Api.class.getClassLoader().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        ModelDescriptionContext ctxt = new ModelDescriptionContext(new Fmi2ModelDescription(fmu.getModelDescription()));
        return VariableCreatorFmi2Api.createFmu(builder, nameGenerator, dynamicScope, name, scope, loadExp, () -> ctxt, "FMU load failed on fmu: '%s' for classpath: '" + className + "'");
    }

    public static FmuVariableFmi2Api createFMU(MablApiBuilder builder, TagNameGenerator nameGenerator, DynamicActiveBuilderScope dynamicScope, String name, Fmi2ModelDescription modelDescription, URI uriPath, IMablScope scope) throws IllegalAccessException, XPathExpressionException, InvocationTargetException {
        String path = uriPath.toString();
        if (uriPath.getScheme() != null && uriPath.getScheme().equals("file")) {
            path = uriPath.getPath();
        }
        ALoadExp loadExp = MableAstFactory.newALoadExp(Arrays.asList(MableAstFactory.newAStringLiteralExp((String)"FMI2"), MableAstFactory.newAStringLiteralExp((String)modelDescription.getGuid()), MableAstFactory.newAStringLiteralExp((String)path)));
        ModelDescriptionContext ctxt = new ModelDescriptionContext(modelDescription);
        return VariableCreatorFmi2Api.createFmu(builder, nameGenerator, dynamicScope, name, scope, loadExp, () -> ctxt, "FMU load failed on fmu: '%s' for uri: '" + uriPath + "'");
    }

    private static FmuVariableFmi2Api createFmu(MablApiBuilder builder, TagNameGenerator nameGenerator, DynamicActiveBuilderScope dynamicScope, String name, IMablScope scope, ALoadExp loadExp, Supplier<ModelDescriptionContext> modelDescriptionSupplier, String loadErrorMsgWithNameStringArgument) {
        String uniqueName = nameGenerator.getName(name);
        PStm var = MableBuilder.newVariable((String)uniqueName, (PType)MableAstFactory.newANameType((String)"FMI2"), (PExp)MableAstFactory.newNullExp());
        AAssigmentStm assign = MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)uniqueName), (PExp)loadExp);
        TryMaBlScope enclosingTryScope = scope.findParentScope(TryMaBlScope.class);
        if (enclosingTryScope == null) {
            throw new IllegalArgumentException("Call to load FMU is only allowed within a try scope");
        }
        enclosingTryScope.parent().addBefore(enclosingTryScope.getDeclaration(), var);
        scope.add(new PStm[]{assign});
        FmuVariableFmi2Api fmuVar = new FmuVariableFmi2Api(name, builder, modelDescriptionSupplier.get(), var, (PType)MableAstFactory.newANameType((String)"FMI2"), enclosingTryScope.parent(), dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)uniqueName)), (PExp)MableAstFactory.newAIdentifierExp((String)uniqueName));
        enclosingTryScope.getFinallyBody().addAfterOrTop(null, new PStm[]{MableAstFactory.newIf((PExp)MableAstFactory.newNotEqual((PExp)fmuVar.getReferenceExp().clone(), (PExp)MableAstFactory.newNullExp()), (PStm)MableAstFactory.newABlockStm((PStm[])new PStm[]{MableAstFactory.newExpressionStm((PExp)MableAstFactory.newUnloadExp(List.of(fmuVar.getReferenceExp().clone()))), MableAstFactory.newAAssignmentStm((PStateDesignator)fmuVar.getDesignator().clone(), (PExp)MableAstFactory.newNullExp())}), null)});
        if (builder.getSettings().fmiErrorHandlingEnabled) {
            ScopeFmi2Api thenScope = scope.enterIf(new PredicateFmi2Api((PExp)MableAstFactory.newEqual((PExp)fmuVar.getReferenceExp().clone(), (PExp)MableAstFactory.newNullExp()))).enterThen();
            builder.getLogger().error(thenScope, loadErrorMsgWithNameStringArgument, name);
            thenScope.add(new PStm[]{new AErrorStm((PExp)MableAstFactory.newAStringLiteralExp((String)String.format(loadErrorMsgWithNameStringArgument, name)))});
            thenScope.leave();
        }
        return fmuVar;
    }
}

