/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TagNameGenerator {
    final Set<String> identifiers = new HashSet<String>();
    final Set<String> reserved = new HashSet<String>(Arrays.asList("true", "false", "if", "while", "else", "out", "ref", "real", "uint", "bool", "int", "void", "string", "module", "expand", "import", "simulation", "observable", "break"));

    public void addUsedIdentifier(String name) {
        this.identifiers.add(name);
    }

    public String getName() {
        return this.getName("tmp");
    }

    public String getName(String ... prefixComponents) {
        if (prefixComponents == null || prefixComponents.length == 0) {
            return this.getName();
        }
        StringBuilder s = new StringBuilder(prefixComponents[0].toLowerCase());
        for (int i = 1; i < prefixComponents.length; ++i) {
            Object part = prefixComponents[i].toLowerCase();
            if (((String)part).length() > 1) {
                part = ((String)part).substring(0, 1).toUpperCase() + ((String)part).substring(1);
            }
            s.append((String)part);
        }
        return this.getName(s.toString());
    }

    public String getNameIgnoreCase(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return this.getName();
        }
        if (!this.identifiers.contains(prefix) && !this.reserved.contains(prefix)) {
            this.identifiers.add(prefix);
            return prefix;
        }
        int postFix = 1;
        while (this.identifiers.contains(prefix + postFix) || this.reserved.contains(prefix + postFix)) {
            ++postFix;
        }
        String name = prefix + postFix;
        this.identifiers.add(name);
        return name;
    }

    public String getName(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return this.getName();
        }
        return this.getNameIgnoreCase(StringUtils.uncapitalize((String)prefix));
    }
}

