/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl.variables;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.ScopeFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ArrayVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;

class Buffers<FMI_TYPE> {
    final MablApiBuilder builder;
    final String instance_name;
    final PStm instanceDeclStm;
    final ScopeFmi2Api instanceDeclaredScope;
    final Map<FMI_TYPE, Integer> variableMaxSize;
    final Map<BufferTypes, Map<FMI_TYPE, ArrayVariableFmi2Api<Object>>> buffers = new HashMap<BufferTypes, Map<FMI_TYPE, ArrayVariableFmi2Api<Object>>>();

    public Buffers(MablApiBuilder builder, String instance_name, PStm instanceDeclStm, ScopeFmi2Api instanceDeclaredScope, Map<FMI_TYPE, Integer> variableMaxSize) {
        this.builder = builder;
        this.instance_name = instance_name;
        this.instanceDeclStm = instanceDeclStm;
        this.instanceDeclaredScope = instanceDeclaredScope;
        this.variableMaxSize = variableMaxSize;
    }

    public ArrayVariableFmi2Api<Object> getBuffer(BufferTypes bufType, PType type, FMI_TYPE fmiType) {
        return this.getBuffer(this.buffers.computeIfAbsent(bufType, bufferType -> new HashMap()), fmiType, type, this.getPrefix(fmiType, bufType), bufType == BufferTypes.Share ? 0 : this.variableMaxSize.get(fmiType), this.instanceDeclaredScope);
    }

    private String getPrefix(FMI_TYPE fmiType, BufferTypes bufferType) {
        return fmiType.toString().replace("Type", "") + bufferType;
    }

    private ArrayVariableFmi2Api<Object> getBuffer(Map<FMI_TYPE, ArrayVariableFmi2Api<Object>> buffer, FMI_TYPE fmiType, PType type, String prefix, int size, IMablScope scope) {
        ArrayVariableFmi2Api<Object> buf = buffer.get(fmiType);
        if (buf != null) {
            return buf;
        }
        ArrayVariableFmi2Api<Object> value = this.createBuffer(type, prefix, size, scope);
        buffer.put(fmiType, value);
        return value;
    }

    private ArrayVariableFmi2Api<Object> createBuffer(PType type, String prefix, int length, IMablScope scope) {
        String ioBufName = this.builder.getNameGenerator().getName(this.instance_name, prefix);
        ALocalVariableStm var = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName), (PType)type, (int)length, null));
        this.instanceDeclaredScope.addAfter(this.instanceDeclStm, new PStm[]{var});
        List items = IntStream.range(0, length).mapToObj(arg_0 -> this.lambda$createBuffer$1((PStm)var, type, scope, ioBufName, arg_0)).collect(Collectors.toList());
        return new ArrayVariableFmi2Api<Object>((PStm)var, type, this.instanceDeclaredScope, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIdentifierExp((String)ioBufName), items);
    }

    public ArrayVariableFmi2Api<Object> growBuffer(BufferTypes bufType, ArrayVariableFmi2Api<Object> buffer, int increaseByCount, FMI_TYPE fmiType) {
        if (bufType != BufferTypes.Share) {
            throw new RuntimeException("can only grow shared buffers");
        }
        String ioBufName = ((AIdentifierExp)buffer.getReferenceExp()).getName().getText();
        int length = buffer.size() + increaseByCount;
        ALocalVariableStm var = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName), (PType)buffer.type.clone(), (int)length, null));
        buffer.getDeclaringStm().parent().replaceChild((INode)buffer.getDeclaringStm(), (INode)var);
        List items = IntStream.range(buffer.size(), length).mapToObj(arg_0 -> this.lambda$growBuffer$2((PStm)var, buffer, ioBufName, arg_0)).collect(Collectors.toList());
        items.addAll(0, buffer.items());
        ArrayVariableFmi2Api<Object> extendedVar = new ArrayVariableFmi2Api<Object>((PStm)var, buffer.type.clone(), this.instanceDeclaredScope, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIdentifierExp((String)ioBufName), items);
        this.buffers.get((Object)bufType).remove(fmiType);
        this.buffers.get((Object)bufType).put(fmiType, extendedVar);
        return extendedVar;
    }

    private /* synthetic */ VariableFmi2Api lambda$growBuffer$2(PStm var, ArrayVariableFmi2Api buffer, String ioBufName, int i) {
        return new VariableFmi2Api(var, buffer.type.clone(), this.instanceDeclaredScope, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((String)ioBufName), Collections.singletonList(MableAstFactory.newAIntLiteralExp((Integer)i))));
    }

    private /* synthetic */ VariableFmi2Api lambda$createBuffer$1(PStm var, PType type, IMablScope scope, String ioBufName, int i) {
        return new VariableFmi2Api(var, type, scope, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((String)ioBufName), Collections.singletonList(MableAstFactory.newAIntLiteralExp((Integer)i))));
    }

    public static enum BufferTypes {
        IO,
        Share,
        Tentative;

    }
}

