/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl.variables;

import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.BuilderUtil;
import org.intocps.maestro.framework.fmi2.api.mabl.NumericExpressionValueFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.values.DoubleExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.values.IntExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.IndexedVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.IntVariableFmi2Api;

public class VariableFmi2Api<V>
implements FmiBuilder.Variable<PStm, V>,
IndexedVariableFmi2Api<V>,
FmiBuilder.ProvidesTypedReferenceExp {
    private final PStateDesignator designator;
    private final PExp referenceExp;
    private final PStm declaration;
    protected PType type;
    protected FmiBuilder.DynamicActiveScope<PStm> dynamicScope;
    IMablScope declaredScope;

    public VariableFmi2Api(PStm declaration, PType type, IMablScope declaredScope, FmiBuilder.DynamicActiveScope<PStm> dynamicScope, PStateDesignator designator, PExp referenceExp) {
        if (declaration != null && (declaredScope == null || declaredScope.indexOf(declaration) == -1)) {
            throw new IllegalArgumentException("Declared scope is illegal it does not declare the declaration");
        }
        this.declaration = declaration;
        this.declaredScope = declaredScope;
        this.dynamicScope = dynamicScope;
        this.designator = designator;
        this.referenceExp = referenceExp;
        this.type = type;
    }

    public PStateDesignator getDesignator() {
        return this.designator;
    }

    public PStateDesignator getDesignatorClone() {
        return this.designator.clone();
    }

    public PExp getReferenceExp() {
        return this.referenceExp;
    }

    public String getName() {
        return String.valueOf(this.referenceExp);
    }

    public void setValue(V value) {
        this.setValue((FmiBuilder.Scope<PStm>)this.dynamicScope, value);
    }

    public void setValue(FmiBuilder.Variable<PStm, V> variable) {
        this.setValue((FmiBuilder.Scope<PStm>)this.dynamicScope, (V)variable);
    }

    public void setValue(FmiBuilder.Scope<PStm> scope, FmiBuilder.Variable<PStm, V> variable) {
        scope.add((Object[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)this.designator.clone(), (PExp)((VariableFmi2Api)variable).getReferenceExp().clone())});
    }

    public void setValue(FmiBuilder.Scope<PStm> scope, V value) {
        if (!(value instanceof FmiBuilder.ProvidesTypedReferenceExp)) {
            throw new IllegalArgumentException();
        }
        scope.add((Object[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)this.designator.clone(), (PExp)((FmiBuilder.ProvidesTypedReferenceExp)value).getExp())});
    }

    public IMablScope getDeclaredScope() {
        return this.declaredScope;
    }

    @Override
    public PStm getDeclaringStm() {
        return this.declaration;
    }

    public PType getType() {
        return this.type;
    }

    public PExp getExp() {
        return this.referenceExp.clone();
    }

    protected void setValue(FmiBuilder.Scope<PStm> scope, PExp exp) {
        scope.add((Object[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)this.designator.clone(), (PExp)exp)});
    }

    protected void setValue(PExp exp) {
        this.setValue((FmiBuilder.Scope<PStm>)this.dynamicScope, exp);
    }

    public VariableFmi2Api<V> clone(PStm declaration, IMablScope declaredScope, PStateDesignator designator, PExp referenceExp) {
        return new VariableFmi2Api<V>(declaration, this.type, declaredScope, this.dynamicScope, designator, referenceExp);
    }

    public NumericExpressionValueFmi2Api toMath() {
        if (this instanceof DoubleVariableFmi2Api) {
            return new DoubleExpressionValue(this.getExp());
        }
        if (this instanceof IntVariableFmi2Api) {
            return new IntExpressionValue(this.getExp());
        }
        throw new RuntimeException("Variable is not of Numeric Type but of type: " + String.valueOf(this.getClass()));
    }

    public void setValue(FmiBuilder.ExpressionValue value) {
        this.setValue(this.dynamicScope, value);
    }

    private void setValue(FmiBuilder.DynamicActiveScope<PStm> dynamicScope, FmiBuilder.ExpressionValue value) {
        this.dynamicScope.addAll(BuilderUtil.createTypeConvertingAssignment(this.designator, value.getExp(), value.getType(), this.getType()));
    }
}

