/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.util.List;
import java.util.Vector;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AFloatNumericPrimitiveType;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableUtil;
import org.intocps.maestro.typechecker.TypeComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuilderUtil {
    static final Logger logger = LoggerFactory.getLogger(BuilderUtil.class);

    public static List<PStm> createTypeConvertingAssignment(PStateDesignator designator, PExp value, PType valueType, PType targetType) {
        Vector<PStm> statements = new Vector<PStm>();
        TypeComparator typeComparator = new TypeComparator();
        if (typeComparator.compatible(targetType, valueType)) {
            statements.add((PStm)MableAstFactory.newAAssignmentStm((PStateDesignator)designator, (PExp)value));
        } else if (typeComparator.compatible((PType)MableAstFactory.newRealType(), valueType) && typeComparator.compatible((PType)new AFloatNumericPrimitiveType(), targetType)) {
            statements.add((PStm)MableAstFactory.newAAssignmentStm((PStateDesignator)designator, (PExp)value));
        } else if (typeComparator.compatible((PType)MableAstFactory.newBoleanType(), valueType) && typeComparator.compatible((PType)MableAstFactory.newRealType(), targetType) || typeComparator.compatible((PType)MableAstFactory.newRealType(), targetType) || typeComparator.compatible((PType)MableAstFactory.newRealType(), targetType)) {
            AIntLiteralExp trueToken = MableAstFactory.newAIntLiteralExp((Integer)1);
            AIntLiteralExp falseToken = MableAstFactory.newAIntLiteralExp((Integer)0);
            if (typeComparator.compatible((PType)MableAstFactory.newRealType(), targetType)) {
                trueToken = MableAstFactory.newARealLiteralExp((Double)1.0);
                falseToken = MableAstFactory.newARealLiteralExp((Double)0.0);
            }
            statements.add((PStm)MableAstFactory.newIf((PExp)value, (PStm)MableAstFactory.newAAssignmentStm((PStateDesignator)designator.clone(), (PExp)trueToken), (PStm)MableAstFactory.newAAssignmentStm((PStateDesignator)designator.clone(), (PExp)falseToken)));
        } else if (typeComparator.compatible((PType)MableAstFactory.newBoleanType(), targetType) && typeComparator.compatible((PType)MableAstFactory.newRealType(), valueType) || typeComparator.compatible((PType)MableAstFactory.newRealType(), valueType) || typeComparator.compatible((PType)MableAstFactory.newRealType(), valueType)) {
            statements.add((PStm)MableAstFactory.newAAssignmentStm((PStateDesignator)designator.clone(), (PExp)MableAstFactory.newEqual((PExp)value, (PExp)MableAstFactory.newAIntLiteralExp((Integer)1))));
        } else if ((typeComparator.compatible((PType)MableAstFactory.newIntType(), valueType) || typeComparator.compatible((PType)MableAstFactory.newUIntType(), valueType)) && (typeComparator.compatible((PType)MableAstFactory.newIntType(), targetType) || typeComparator.compatible((PType)MableAstFactory.newUIntType(), targetType))) {
            statements.add((PStm)MableAstFactory.newAAssignmentStm((PStateDesignator)designator, (PExp)value));
        } else {
            logger.error("No implementation for type conversion");
            statements.add((PStm)MableAstFactory.newAAssignmentStm((PStateDesignator)designator, (PExp)value));
        }
        return statements;
    }

    public static List<PStm> createTypeConvertingAssignment(MablApiBuilder builder, FmiBuilder.Scope<PStm> scope, PStateDesignator designator, PExp value, PType valueType, PType targetType) {
        return BuilderUtil.createTypeConvertingAssignment(designator, value, valueType, targetType);
    }

    public static List<PExp> toExp(Object ... args) {
        if (args == null || args.length == 0) {
            return new Vector<PExp>();
        }
        Vector<PExp> expressions = new Vector<PExp>();
        for (Object obj : args) {
            Object[] arr;
            if (obj instanceof Double) {
                expressions.add((PExp)MableAstFactory.newARealLiteralExp((Double)((Double)obj)));
                continue;
            }
            if (obj instanceof Integer) {
                expressions.add((PExp)MableAstFactory.newAIntLiteralExp((Integer)((Integer)obj)));
                continue;
            }
            if (obj instanceof Long) {
                expressions.add((PExp)MableAstFactory.newAUIntLiteralExp((Long)((Long)obj)));
                continue;
            }
            if (obj instanceof Boolean) {
                expressions.add((PExp)MableAstFactory.newABoolLiteralExp((Boolean)((Boolean)obj)));
                continue;
            }
            if (obj instanceof String) {
                expressions.add((PExp)MableAstFactory.newAStringLiteralExp((String)((String)obj)));
                continue;
            }
            if (obj instanceof FmuVariableFmi2Api) {
                expressions.add(VariableUtil.getAsExp((VariableFmi2Api)obj));
                continue;
            }
            if (obj instanceof ComponentVariableFmi2Api) {
                expressions.add(VariableUtil.getAsExp((VariableFmi2Api)obj));
                continue;
            }
            if (obj instanceof VariableFmi2Api) {
                expressions.add(VariableUtil.getAsExp((VariableFmi2Api)obj));
                continue;
            }
            if (!(obj instanceof Object[])) continue;
            for (Object o : arr = (Object[])obj) {
                expressions.addAll(BuilderUtil.toExp(o));
            }
        }
        return expressions;
    }
}

