/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AExpressionStm;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;

public class DataWriter {
    private final DynamicActiveBuilderScope dynamicScope;
    private final MablApiBuilder mablApiBuilder;
    private final String FUNCTION_CLOSE = "close";
    private String moduleIdentifier;
    private FmiBuilder.RuntimeModule<PStm> runtimeModule;
    private boolean runtimeModuleMode = false;

    public DataWriter(DynamicActiveBuilderScope dynamicScope, MablApiBuilder mablApiBuilder) {
        this.dynamicScope = dynamicScope;
        this.mablApiBuilder = mablApiBuilder;
        this.moduleIdentifier = "dataWriter";
    }

    public DataWriter(MablApiBuilder mablApiBuilder, FmiBuilder.RuntimeModule<PStm> runtimeModule) {
        this(mablApiBuilder.getDynamicScope(), mablApiBuilder);
        this.runtimeModuleMode = true;
        this.runtimeModule = runtimeModule;
        this.moduleIdentifier = runtimeModule.getName();
    }

    public DataWriterInstance createDataWriterInstance() {
        if (!this.runtimeModuleMode) {
            return new DataWriterInstance(this.dynamicScope, this.mablApiBuilder, this);
        }
        return new DataWriterInstance(this.dynamicScope, this.mablApiBuilder, this, this.runtimeModule);
    }

    public String getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public void unload() {
        this.mablApiBuilder.getDynamicScope().add(new PStm[]{MableAstFactory.newExpressionStm((PExp)MableAstFactory.newUnloadExp(Collections.singletonList(this.getReferenceExp().clone())))});
    }

    private PExp getReferenceExp() {
        return MableAstFactory.newAIdentifierExp((String)this.moduleIdentifier);
    }

    public static class DataWriterInstance {
        private final String FUNCTION_WRITEHEADER = "writeHeader";
        private final String FUNCTION_WRITEDATAPOINT = "writeDataPoint";
        private final String TYPE_DATAWRITERCONFIG = "DataWriterConfig";
        private final DynamicActiveBuilderScope dynamicScope;
        private final MablApiBuilder mablApiBuilder;
        private final DataWriter dataWriter;
        private boolean runtimeModuleMode;
        private List<LogEntry> portsToLog;
        private ALocalVariableStm logHeadersStm;
        private String logHeadersVariableName;
        private ALocalVariableStm writeHeadersStm;
        private boolean initialized;
        private String dataWriterInstanceConfigurationVariableName;
        private FmiBuilder.RuntimeModule<PStm> runtimeModule;

        public DataWriterInstance(DynamicActiveBuilderScope dynamicScope, MablApiBuilder mablApiBuilder, DataWriter dataWriter) {
            this.dynamicScope = dynamicScope;
            this.mablApiBuilder = mablApiBuilder;
            this.dataWriter = dataWriter;
        }

        public DataWriterInstance(DynamicActiveBuilderScope dynamicScope, MablApiBuilder mablApiBuilder, DataWriter dataWriter, FmiBuilder.RuntimeModule<PStm> runtimeModule) {
            this(dynamicScope, mablApiBuilder, dataWriter);
            this.runtimeModuleMode = true;
            this.runtimeModule = runtimeModule;
        }

        public void initialize(LogEntry ... portsToLog) {
            this.initialize(Arrays.asList(portsToLog));
        }

        public void initialize(List<LogEntry> portsToLog) {
            this.portsToLog = portsToLog;
            this.logHeadersVariableName = this.mablApiBuilder.getNameGenerator().getName("datawriter_headers");
            this.dataWriterInstanceConfigurationVariableName = this.mablApiBuilder.getNameGenerator().getName("datawriter_configuration");
            List variablesNamesToLog = this.portsToLog.stream().map(x -> MableAstFactory.newAStringLiteralExp((String)x.name)).collect(Collectors.toList());
            AVariableDeclaration datawriter_configuration = MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)this.logHeadersVariableName), (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newAStringPrimitiveType()), (int)variablesNamesToLog.size(), (PInitializer)MableAstFactory.newAArrayInitializer(variablesNamesToLog));
            this.logHeadersStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)datawriter_configuration);
            this.writeHeadersStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)this.dataWriterInstanceConfigurationVariableName), (PType)MableAstFactory.newANameType((String)"DataWriterConfig"), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.dataWriter.getModuleIdentifier()), (LexIdentifier)MableAstFactory.newAIdentifier((String)"writeHeader"), List.of(MableAstFactory.newAIdentifierExp((String)this.logHeadersVariableName))))));
            this.mablApiBuilder.getDynamicScope().add(new PStm[]{this.logHeadersStm, this.writeHeadersStm});
            this.initialized = true;
        }

        public void log(DoubleVariableFmi2Api time) {
            if (!this.initialized) {
                throw new RuntimeException("DataWriter has not been initialized!");
            }
            AExpressionStm stm = MableAstFactory.newExpressionStm((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.dataWriter.moduleIdentifier), (LexIdentifier)MableAstFactory.newAIdentifier((String)this.FUNCTION_WRITEDATAPOINT), Stream.concat(Arrays.asList(MableAstFactory.newAIdentifierExp((String)this.dataWriterInstanceConfigurationVariableName), time.getReferenceExp().clone()).stream(), this.portsToLog.stream().map(x -> x.exp.get().clone())).collect(Collectors.toList())));
            this.dynamicScope.add(new PStm[]{stm});
        }

        public void close() {
            AExpressionStm stm = MableAstFactory.newExpressionStm((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.dataWriter.moduleIdentifier), (LexIdentifier)MableAstFactory.newAIdentifier((String)this.dataWriter.FUNCTION_CLOSE), List.of()));
            this.dynamicScope.add(new PStm[]{stm});
        }

        public static class LogEntry {
            final String name;
            final Supplier<PExp> exp;

            public LogEntry(String name, Supplier<PExp> exp) {
                this.name = name;
                this.exp = exp;
            }
        }
    }
}

