/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.maestro.ast.ABasicBlockStm;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.SBlockStm;
import org.intocps.maestro.framework.core.FrameworkUnitInfo;
import org.intocps.maestro.framework.core.IRelation;
import org.intocps.maestro.framework.core.ISimulationEnvironment;
import org.intocps.maestro.framework.fmi2.ComponentInfo;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.InstanceInfo;
import org.intocps.maestro.framework.fmi2.RelationVariable;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.ModelDescriptionContext;
import org.intocps.maestro.framework.fmi2.api.mabl.ModelDescriptionContext3;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi3Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi3Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.InstanceVariableFmi3Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FromMaBLToMaBLAPI {
    static final Logger logger = LoggerFactory.getLogger(FromMaBLToMaBLAPI.class);

    public static Map.Entry<String, ComponentVariableFmi2Api> getComponentVariableFrom(MablApiBuilder builder, PExp exp, Fmi2SimulationEnvironment env) throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        if (exp instanceof AIdentifierExp) {
            return FromMaBLToMaBLAPI.getComponentVariableFrom(builder, exp, env, ((AIdentifierExp)exp).getName().getText());
        }
        throw new RuntimeException("exp is not of type AIdentifierExp, but of type: " + String.valueOf(exp.getClass()));
    }

    public static Map.Entry<String, InstanceVariableFmi3Api> getInstanceVariableFrom(MablApiBuilder builder, PExp exp, Fmi2SimulationEnvironment env) throws XPathExpressionException, InvocationTargetException, IllegalAccessException {
        if (exp instanceof AIdentifierExp) {
            return FromMaBLToMaBLAPI.getInstanceVariableFrom(builder, exp, env, ((AIdentifierExp)exp).getName().getText());
        }
        throw new RuntimeException("exp is not of type AIdentifierExp, but of type: " + String.valueOf(exp.getClass()));
    }

    public static Map.Entry<String, ComponentVariableFmi2Api> getComponentVariableFrom(MablApiBuilder builder, PExp exp, Fmi2SimulationEnvironment env, String environmentComponentName) throws IllegalAccessException, XPathExpressionException, InvocationTargetException {
        if (exp instanceof AIdentifierExp) {
            String componentName = ((AIdentifierExp)exp).getName().getText();
            FrameworkUnitInfo inst = env.getInstanceByLexName(environmentComponentName);
            if (inst instanceof ComponentInfo) {
                ComponentInfo instance = (ComponentInfo)inst;
                ModelDescriptionContext modelDescriptionContext = new ModelDescriptionContext(instance.modelDescription);
                ABasicBlockStm dummyStm = MableAstFactory.newABlockStm((PStm[])new PStm[0]);
                builder.getDynamicScope().add(new PStm[]{dummyStm});
                FmuVariableFmi2Api fmu = new FmuVariableFmi2Api(instance.fmuIdentifier, builder, modelDescriptionContext, (PStm)dummyStm, (PType)MableAstFactory.newANameType((String)"FMI2"), builder.getDynamicScope().getActiveScope(), builder.getDynamicScope(), null, (PExp)new AIdentifierExp(new LexIdentifier(instance.fmuIdentifier.replace("{", "").replace("}", ""), null)));
                ComponentVariableFmi2Api a = environmentComponentName == null ? new ComponentVariableFmi2Api((PStm)dummyStm, fmu, componentName, modelDescriptionContext, builder, builder.getDynamicScope().getActiveScope(), null, (PExp)MableAstFactory.newAIdentifierExp((String)componentName)) : new ComponentVariableFmi2Api((PStm)dummyStm, fmu, componentName, modelDescriptionContext, builder, builder.getDynamicScope().getActiveScope(), null, (PExp)MableAstFactory.newAIdentifierExp((String)componentName), environmentComponentName);
                List variablesToLog = null;
                variablesToLog = environmentComponentName == null ? env.getVariablesToLog(componentName) : env.getVariablesToLog(environmentComponentName);
                a.setVariablesToLog(variablesToLog.stream().filter(RelationVariable.class::isInstance).map(RelationVariable.class::cast).collect(Collectors.toList()));
                return Map.entry(componentName, a);
            }
            throw new RuntimeException("instance is not an fmi2 component: " + componentName);
        }
        throw new RuntimeException("exp is not of type AIdentifierExp, but of type: " + String.valueOf(exp.getClass()));
    }

    public static Map.Entry<String, InstanceVariableFmi3Api> getInstanceVariableFrom(MablApiBuilder builder, PExp exp, Fmi2SimulationEnvironment env, String environmentComponentName) throws IllegalAccessException, XPathExpressionException, InvocationTargetException {
        if (exp instanceof AIdentifierExp) {
            String componentName = ((AIdentifierExp)exp).getName().getText();
            FrameworkUnitInfo inst = env.getInstanceByLexName(environmentComponentName);
            if (inst instanceof InstanceInfo) {
                InstanceInfo instance = (InstanceInfo)inst;
                ModelDescriptionContext3 modelDescriptionContext = new ModelDescriptionContext3(instance.getModelDescription());
                ABasicBlockStm dummyStm = MableAstFactory.newABlockStm((PStm[])new PStm[0]);
                builder.getDynamicScope().add(new PStm[]{dummyStm});
                FmuVariableFmi3Api fmu = new FmuVariableFmi3Api(instance.fmuIdentifier, builder, modelDescriptionContext, (PStm)dummyStm, (PType)MableAstFactory.newANameType((String)"FMI3"), builder.getDynamicScope().getActiveScope(), builder.getDynamicScope(), null, (PExp)new AIdentifierExp(new LexIdentifier(instance.fmuIdentifier.replace("{", "").replace("}", ""), null)));
                InstanceVariableFmi3Api a = environmentComponentName == null ? new InstanceVariableFmi3Api((PStm)dummyStm, fmu, componentName, modelDescriptionContext, builder, builder.getDynamicScope().getActiveScope(), null, (PExp)MableAstFactory.newAIdentifierExp((String)componentName)) : new InstanceVariableFmi3Api((PStm)dummyStm, fmu, componentName, modelDescriptionContext, builder, builder.getDynamicScope().getActiveScope(), null, (PExp)MableAstFactory.newAIdentifierExp((String)componentName), environmentComponentName);
                List variablesToLog = null;
                variablesToLog = environmentComponentName == null ? env.getVariablesToLog(componentName) : env.getVariablesToLog(environmentComponentName);
                a.setVariablesToLog(variablesToLog.stream().filter(RelationVariable.class::isInstance).map(RelationVariable.class::cast).collect(Collectors.toList()));
                return Map.entry(componentName, a);
            }
            throw new RuntimeException("instance is not an fmi2 component: " + componentName);
        }
        throw new RuntimeException("exp is not of type AIdentifierExp, but of type: " + String.valueOf(exp.getClass()));
    }

    public static void createBindings(Map<String, ComponentVariableFmi2Api> instances, ISimulationEnvironment env) throws FmiBuilder.Port.PortLinkException {
        for (Map.Entry<String, ComponentVariableFmi2Api> entry : instances.entrySet()) {
            Set<? extends IRelation> relations = FromMaBLToMaBLAPI.getRelations(entry, env);
            for (IRelation relation : relations.stream().filter(x -> x.getDirection() == IRelation.Direction.OutputToInput && x.getOrigin() == IRelation.InternalOrExternal.External).collect(Collectors.toList())) {
                for (org.intocps.maestro.framework.core.RelationVariable targetVar : relation.getTargets().values()) {
                    String targetName = targetVar.getInstance().getText();
                    if (instances.containsKey(targetName) || instances.values().stream().anyMatch(x -> x.getEnvironmentName().equalsIgnoreCase(targetName))) {
                        Optional<ComponentVariableFmi2Api> instanceOpt;
                        ComponentVariableFmi2Api instance = instances.get(targetName);
                        if (instance == null && (instanceOpt = instances.values().stream().filter(x -> x.getEnvironmentName().equalsIgnoreCase(targetName)).findFirst()).isPresent()) {
                            instance = instanceOpt.get();
                        }
                        PortFmi2Api targetPort = instance.getPort(targetVar.getName());
                        String sourcePortName = relation.getSource().getName();
                        if (targetPort != null) {
                            entry.getValue().getPort(sourcePortName).linkTo(targetPort);
                            continue;
                        }
                        logger.warn("Failed to find port '{}' on instance '{}' required by relational '{}' ", new Object[]{sourcePortName, targetName, relation});
                        continue;
                    }
                    logger.warn("Failed to find instance required by relational information from simulation env. Missing '{}' in relation {}", (Object)targetName, (Object)relation);
                }
            }
        }
    }

    public static void createBindings3(Map<String, InstanceVariableFmi3Api> instances, ISimulationEnvironment env) throws FmiBuilder.Port.PortLinkException {
        for (Map.Entry<String, InstanceVariableFmi3Api> entry : instances.entrySet()) {
            Set<? extends IRelation> relations = FromMaBLToMaBLAPI.getRelations3(entry, env);
            for (IRelation relation : relations.stream().filter(x -> x.getDirection() == IRelation.Direction.OutputToInput && x.getOrigin() == IRelation.InternalOrExternal.External).collect(Collectors.toList())) {
                for (org.intocps.maestro.framework.core.RelationVariable targetVar : relation.getTargets().values()) {
                    String targetName = targetVar.getInstance().getText();
                    if (instances.containsKey(targetName) || instances.values().stream().anyMatch(x -> x.getEnvironmentName().equalsIgnoreCase(targetName))) {
                        Optional<InstanceVariableFmi3Api> instanceOpt;
                        InstanceVariableFmi3Api instance = instances.get(targetName);
                        if (instance == null && (instanceOpt = instances.values().stream().filter(x -> x.getEnvironmentName().equalsIgnoreCase(targetName)).findFirst()).isPresent()) {
                            instance = instanceOpt.get();
                        }
                        PortFmi3Api targetPort = instance.getPort(targetVar.getName());
                        String sourcePortName = relation.getSource().getName();
                        if (targetPort != null) {
                            entry.getValue().getPort(sourcePortName).linkTo(targetPort);
                            continue;
                        }
                        logger.warn("Failed to find port '{}' on instance '{}' required by relational '{}' ", new Object[]{sourcePortName, targetName, relation});
                        continue;
                    }
                    logger.warn("Failed to find instance required by relational information from simulation env. Missing '{}' in relation {}", (Object)targetName, (Object)relation);
                }
            }
        }
    }

    private static Set<? extends IRelation> getRelations(Map.Entry<String, ComponentVariableFmi2Api> entry, ISimulationEnvironment env) {
        if (entry.getValue().getEnvironmentName() != entry.getKey()) {
            return env.getRelations(new String[]{entry.getValue().getEnvironmentName()});
        }
        return env.getRelations(new String[]{entry.getKey()});
    }

    private static Set<? extends IRelation> getRelations3(Map.Entry<String, InstanceVariableFmi3Api> entry, ISimulationEnvironment env) {
        if (entry.getValue().getEnvironmentName() != entry.getKey()) {
            return env.getRelations(new String[]{entry.getValue().getEnvironmentName()});
        }
        return env.getRelations(new String[]{entry.getKey()});
    }

    public static Map<String, ComponentVariableFmi2Api> getComponentVariablesFrom(MablApiBuilder builder, PExp exp, Fmi2SimulationEnvironment env) throws IllegalAccessException, XPathExpressionException, InvocationTargetException {
        LexIdentifier componentsArrayName = ((AIdentifierExp)exp).getName();
        SBlockStm containingBlock = (SBlockStm)exp.getAncestor(SBlockStm.class);
        Optional<AVariableDeclaration> componentDeclaration = containingBlock.getBody().stream().filter(ALocalVariableStm.class::isInstance).map(ALocalVariableStm.class::cast).map(ALocalVariableStm::getDeclaration).filter(decl -> decl.getName().equals((Object)componentsArrayName) && !decl.getSize().isEmpty() && decl.getInitializer() != null).findFirst();
        if (!componentDeclaration.isPresent()) {
            throw new RuntimeException("Could not find names for components");
        }
        AArrayInitializer initializer = (AArrayInitializer)componentDeclaration.get().getInitializer();
        List componentIdentifiers = initializer.getExp().stream().filter(AIdentifierExp.class::isInstance).map(AIdentifierExp.class::cast).collect(Collectors.toList());
        HashMap<String, ComponentVariableFmi2Api> fmuInstances = new HashMap<String, ComponentVariableFmi2Api>();
        for (PExp componentName : componentIdentifiers) {
            Map.Entry<String, ComponentVariableFmi2Api> component = FromMaBLToMaBLAPI.getComponentVariableFrom(builder, componentName, env);
            fmuInstances.put(component.getKey(), component.getValue());
        }
        return fmuInstances;
    }

    public static Map<String, InstanceVariableFmi3Api> getInstanceVariablesFrom(MablApiBuilder builder, PExp exp, Fmi2SimulationEnvironment env) throws IllegalAccessException, XPathExpressionException, InvocationTargetException {
        LexIdentifier componentsArrayName = ((AIdentifierExp)exp).getName();
        SBlockStm containingBlock = (SBlockStm)exp.getAncestor(SBlockStm.class);
        Optional<AVariableDeclaration> componentDeclaration = containingBlock.getBody().stream().filter(ALocalVariableStm.class::isInstance).map(ALocalVariableStm.class::cast).map(ALocalVariableStm::getDeclaration).filter(decl -> decl.getName().equals((Object)componentsArrayName) && !decl.getSize().isEmpty() && decl.getInitializer() != null).findFirst();
        if (!componentDeclaration.isPresent()) {
            throw new RuntimeException("Could not find names for components");
        }
        AArrayInitializer initializer = (AArrayInitializer)componentDeclaration.get().getInitializer();
        List componentIdentifiers = initializer.getExp().stream().filter(AIdentifierExp.class::isInstance).map(AIdentifierExp.class::cast).collect(Collectors.toList());
        HashMap<String, InstanceVariableFmi3Api> fmuInstances = new HashMap<String, InstanceVariableFmi3Api>();
        for (PExp componentName : componentIdentifiers) {
            Map.Entry<String, InstanceVariableFmi3Api> component = FromMaBLToMaBLAPI.getInstanceVariableFrom(builder, componentName, env);
            fmuInstances.put(component.getKey(), component.getValue());
        }
        return fmuInstances;
    }
}

