/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.SBlockStm;
import org.intocps.maestro.framework.fmi2.api.mabl.BooleanBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.DataWriter;
import org.intocps.maestro.framework.fmi2.api.mabl.LoggerFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.MathBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.VariableStep;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.RuntimeModuleVariable;

public class MablToMablAPI {
    private final MablApiBuilder mablApiBuilder;
    private BooleanBuilderFmi2Api booleanBuilderApi;
    private DataWriter dataWriter;
    private VariableStep variableStep;
    private MathBuilderFmi2Api mathBuilderFmi2Api;
    private LoggerFmi2Api runtimeLogger;

    public MablToMablAPI(MablApiBuilder mablApiBuilder) {
        this.mablApiBuilder = mablApiBuilder;
    }

    public static Stream<INode> getAncestors(INode node, Predicate<INode> filter) {
        INode parent = node.parent();
        if (parent == null) {
            return Stream.empty();
        }
        if (parent instanceof SBlockStm) {
            INode indexedNode;
            SBlockStm block = (SBlockStm)parent;
            for (indexedNode = node; indexedNode != null && !(indexedNode instanceof PStm); indexedNode = indexedNode.parent()) {
            }
            int pos = block.getBody().indexOf(indexedNode);
            if (pos < 0) {
                return MablToMablAPI.getAncestors(parent, filter);
            }
            return Stream.concat(block.getBody().stream().limit(pos).filter(filter), MablToMablAPI.getAncestors(parent, filter));
        }
        if (filter.test(parent)) {
            return Stream.concat(Stream.of(parent), MablToMablAPI.getAncestors(parent, filter));
        }
        return MablToMablAPI.getAncestors(parent, filter);
    }

    public static AVariableDeclaration findDeclaration(INode node, PStm currentStm, boolean caseSensitive, String name) {
        PStm tmp;
        if (currentStm == null) {
            currentStm = (PStm)node.getAncestor(PStm.class);
        }
        Object object = tmp = currentStm instanceof SBlockStm ? currentStm.parent() : currentStm;
        if (tmp == null) {
            return null;
        }
        SBlockStm block = (SBlockStm)tmp.getAncestor(SBlockStm.class);
        if (block == null) {
            return null;
        }
        while (currentStm.parent() != null && currentStm.parent() instanceof PStm && currentStm.parent() != block) {
            currentStm = (PStm)currentStm.parent();
        }
        if (currentStm.parent() == block) {
            for (int i = block.getBody().indexOf(currentStm) - 1; i >= 0 && i < block.getBody().size(); --i) {
                PStm s = (PStm)block.getBody().get(i);
                if (!(s instanceof ALocalVariableStm)) continue;
                String declName = ((ALocalVariableStm)s).getDeclaration().getName().getText();
                if ((!caseSensitive || !declName.equals(name)) && (caseSensitive || !declName.equalsIgnoreCase(name))) continue;
                return ((ALocalVariableStm)s).getDeclaration();
            }
            return MablToMablAPI.findDeclaration(node, (PStm)block, caseSensitive, name);
        }
        if (currentStm.parent() != null && currentStm.parent() instanceof PStm) {
            return MablToMablAPI.findDeclaration(node, (PStm)currentStm.parent(), caseSensitive, name);
        }
        return null;
    }

    public static Set<String> getPreviouslyUsedNamed(INode node) {
        return MablToMablAPI.getPreviouslyUsedNamed(node, null);
    }

    private static Set<String> getPreviouslyUsedNamed(INode node, PStm currentStm) {
        PStm tmp;
        HashSet<String> names = new HashSet<String>();
        if (currentStm == null) {
            currentStm = (PStm)node.getAncestor(PStm.class);
        }
        Object object = tmp = currentStm instanceof SBlockStm ? currentStm.parent() : currentStm;
        if (tmp == null) {
            return names;
        }
        SBlockStm block = (SBlockStm)tmp.getAncestor(SBlockStm.class);
        if (block == null) {
            return names;
        }
        while (currentStm.parent() != null && currentStm.parent() instanceof PStm && currentStm.parent() != block) {
            currentStm = (PStm)currentStm.parent();
        }
        if (currentStm.parent() == block) {
            for (int i = block.getBody().indexOf(currentStm) - 1; i >= 0 && i < block.getBody().size(); --i) {
                PStm s = (PStm)block.getBody().get(i);
                if (!(s instanceof ALocalVariableStm)) continue;
                String declName = ((ALocalVariableStm)s).getDeclaration().getName().getText();
                names.add(declName);
            }
            names.addAll(MablToMablAPI.getPreviouslyUsedNamed(node, (PStm)block));
        } else if (currentStm.parent() != null && currentStm.parent() instanceof PStm) {
            names.addAll(MablToMablAPI.getPreviouslyUsedNamed(node, (PStm)currentStm.parent()));
        }
        return names;
    }

    public void createExternalRuntimeLogger() {
        String name = "logger";
        RuntimeModuleVariable runtimeModule = new RuntimeModuleVariable(null, (PType)MableAstFactory.newANameType((String)"Logger"), null, this.mablApiBuilder.getDynamicScope(), this.mablApiBuilder, null, (PExp)MableAstFactory.newAIdentifierExp((String)name), true);
        if (this.runtimeLogger == null) {
            this.runtimeLogger = new LoggerFmi2Api(this.mablApiBuilder, runtimeModule);
        }
        this.mablApiBuilder.setRuntimeLogger(this.runtimeLogger);
        this.mablApiBuilder.addExternalLoadedModuleIdentifier(name);
    }

    public VariableStep getVariableStep() {
        if (this.variableStep == null) {
            this.variableStep = new VariableStep(this.mablApiBuilder.dynamicScope, this.mablApiBuilder);
        }
        return this.variableStep;
    }

    public DataWriter getDataWriter() {
        if (this.dataWriter == null) {
            this.dataWriter = new DataWriter(this.mablApiBuilder.dynamicScope, this.mablApiBuilder);
        }
        return this.dataWriter;
    }

    public BooleanBuilderFmi2Api getBooleanBuilder() {
        if (this.booleanBuilderApi == null) {
            this.booleanBuilderApi = new BooleanBuilderFmi2Api(this.mablApiBuilder.dynamicScope, this.mablApiBuilder);
        }
        return this.booleanBuilderApi;
    }

    public MathBuilderFmi2Api getMathBuilder() {
        if (this.mathBuilderFmi2Api == null) {
            this.mathBuilderFmi2Api = new MathBuilderFmi2Api(this.mablApiBuilder.dynamicScope, this.mablApiBuilder, (PExp)new AIdentifierExp(new LexIdentifier("math", null)));
        }
        return this.mathBuilderFmi2Api;
    }
}

