/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl;

import java.util.ArrayList;
import java.util.List;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AByteNumericPrimitiveType;
import org.intocps.maestro.ast.node.AFloatNumericPrimitiveType;
import org.intocps.maestro.ast.node.ALongNumericPrimitiveType;
import org.intocps.maestro.ast.node.ANameType;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.AShortNumericPrimitiveType;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.fmi.fmi3.Fmi3Causality;
import org.intocps.maestro.fmi.fmi3.Fmi3ModelDescription;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.InstanceVariableFmi3Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;

public class PortFmi3Api
implements FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> {
    public final InstanceVariableFmi3Api aMablFmi3InstanceAPI;
    public final Fmi3ModelDescription.Fmi3ScalarVariable scalarVariable;
    private final List<PortFmi3Api> targetPorts = new ArrayList<PortFmi3Api>();
    private VariableFmi2Api sharedAsVariable;
    private PortFmi3Api sourcePort;

    public PortFmi3Api(InstanceVariableFmi3Api aMablFmi3InstanceAPI, Fmi3ModelDescription.Fmi3ScalarVariable scalarVariable) {
        this.aMablFmi3InstanceAPI = aMablFmi3InstanceAPI;
        this.scalarVariable = scalarVariable;
    }

    public String toString() {
        return "Port( '" + this.aMablFmi3InstanceAPI.getName() + "." + this.scalarVariable.getVariable().getName() + "' , '" + this.scalarVariable.getVariable().getTypeIdentifier().name() + "')";
    }

    public VariableFmi2Api getSharedAsVariable() {
        return this.sharedAsVariable;
    }

    public void setSharedAsVariable(VariableFmi2Api sharedAsVariable) {
        this.sharedAsVariable = sharedAsVariable;
    }

    public PType getType() {
        switch (this.scalarVariable.getVariable().getTypeIdentifier()) {
            case Float64Type: {
                return new ARealNumericPrimitiveType();
            }
            case Float32Type: 
            case ClockType: {
                return new AFloatNumericPrimitiveType();
            }
            case Int8Type: 
            case UInt8Type: {
                return new AByteNumericPrimitiveType();
            }
            case Int16Type: 
            case UInt16Type: {
                return new AShortNumericPrimitiveType();
            }
            case Int32Type: 
            case UInt32Type: {
                return MableAstFactory.newIntType();
            }
            case Int64Type: 
            case UInt64Type: 
            case EnumerationType: {
                return new ALongNumericPrimitiveType();
            }
            case BooleanType: {
                return MableAstFactory.newBoleanType();
            }
            case StringType: {
                return MableAstFactory.newStringType();
            }
            case BinaryType: {
                return new ANameType(new LexIdentifier("ByteArrayArray", null));
            }
        }
        throw new RuntimeException("Unknown port type mapping. Port type: " + String.valueOf(this.scalarVariable.getVariable().getTypeIdentifier()));
    }

    public String getQualifiedName() {
        return this.aMablFmi3InstanceAPI.getOwner().getFmuIdentifier() + "." + this.aMablFmi3InstanceAPI.getEnvironmentName() + "." + this.getName();
    }

    public FmiBuilder.FmiSimulationInstance<PStm, Fmi3ModelDescription.Fmi3ScalarVariable> getOwner() {
        return this.aMablFmi3InstanceAPI;
    }

    public Fmi3ModelDescription.Fmi3ScalarVariable getSourceObject() {
        return this.scalarVariable;
    }

    public String getName() {
        return this.scalarVariable.getVariable().getName();
    }

    public Long getPortReferenceValue() {
        return this.scalarVariable.getVariable().getValueReferenceAsLong();
    }

    public void linkTo(FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> ... receivers) throws FmiBuilder.Port.PortLinkException {
        if (receivers == null || receivers.length == 0) {
            return;
        }
        if (this.scalarVariable.getVariable().getCausality() != Fmi3Causality.Output) {
            throw new FmiBuilder.Port.PortLinkException("Can only link output ports. This port is: " + String.valueOf(this.scalarVariable.getVariable().getCausality()), (FmiBuilder.Port)this);
        }
        for (FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> receiver : receivers) {
            PortFmi3Api receiverPort = (PortFmi3Api)receiver;
            if (receiverPort.scalarVariable.getVariable().getCausality() != Fmi3Causality.Input) {
                throw new FmiBuilder.Port.PortLinkException("Receivers must be input ports. This receiver is: " + String.valueOf(receiverPort.scalarVariable.getVariable().getCausality()), (FmiBuilder.Port)receiverPort);
            }
            if (receiverPort.getSourcePort() != null) {
                throw new FmiBuilder.Port.PortLinkException("Cannot port already linked please break link first", receiver);
            }
            receiverPort.sourcePort = this;
            if (this.targetPorts.contains(receiverPort)) continue;
            this.targetPorts.add(receiverPort);
        }
    }

    public PortFmi3Api getSourcePort() {
        return this.sourcePort;
    }

    public void breakLink() {
        if (this.sourcePort != null) {
            this.sourcePort.targetPorts.remove(this);
        }
        this.sourcePort = null;
    }

    public boolean isLinked() {
        return this.isLinkedAsInputConsumer() || this.isLinkedAsOutputProvider();
    }

    public boolean isLinkedAsOutputProvider() {
        return !this.targetPorts.isEmpty();
    }

    public boolean isLinkedAsInputConsumer() {
        return this.sourcePort != null;
    }

    public String toLexName() {
        return this.aMablFmi3InstanceAPI.getOwner().getName() + "_" + this.aMablFmi3InstanceAPI.getName() + "_" + this.getName();
    }

    public String getMultiModelScalarVariableName() {
        return this.aMablFmi3InstanceAPI.getOwner().getFmuIdentifier() + "." + this.aMablFmi3InstanceAPI.getEnvironmentName() + "." + this.getName();
    }

    public String getMultiModelScalarVariableNameWithoutFmu() {
        return this.aMablFmi3InstanceAPI.getEnvironmentName() + "." + this.getName();
    }

    public List<PortFmi3Api> getTargetPorts() {
        return this.targetPorts;
    }
}

