/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl.values;

import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AFloatNumericPrimitiveType;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.NumericExpressionValueFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;

public class FloatExpressionValue
extends NumericExpressionValueFmi2Api
implements FmiBuilder.FloatExpressionValue {
    final PType type = new AFloatNumericPrimitiveType();
    final PExp exp;

    public FloatExpressionValue(float value) {
        this.exp = MableAstFactory.newAFloatLiteralExp((Float)Float.valueOf(value));
    }

    public FloatExpressionValue(PExp exp) {
        this.exp = exp;
    }

    public static FloatExpressionValue of(float value) {
        return new FloatExpressionValue(value);
    }

    public PExp getExp() {
        return this.exp.clone();
    }

    public PType getType() {
        return this.type;
    }

    @Override
    public FloatExpressionValue subtraction(int v) {
        return new FloatExpressionValue((PExp)MableAstFactory.newMinusExp((PExp)this.getExp(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)v)));
    }

    @Override
    public FloatExpressionValue addition(int v) {
        return new FloatExpressionValue((PExp)MableAstFactory.newPlusExp((PExp)this.getExp(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)v)));
    }

    @Override
    public FloatExpressionValue divide(int v) {
        return new FloatExpressionValue((PExp)MableAstFactory.newDivideExp((PExp)this.getExp(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)v)));
    }

    @Override
    public FloatExpressionValue multiply(int v) {
        return new FloatExpressionValue((PExp)MableAstFactory.newMultiplyExp((PExp)this.getExp(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)v)));
    }

    @Override
    public FloatExpressionValue subtraction(double v) {
        return new FloatExpressionValue((PExp)MableAstFactory.newMinusExp((PExp)this.getExp(), (PExp)MableAstFactory.newARealLiteralExp((Double)v)));
    }

    @Override
    public FloatExpressionValue addition(double v) {
        return new FloatExpressionValue((PExp)MableAstFactory.newPlusExp((PExp)this.getExp(), (PExp)MableAstFactory.newARealLiteralExp((Double)v)));
    }

    @Override
    public FloatExpressionValue divide(double v) {
        return new FloatExpressionValue((PExp)MableAstFactory.newDivideExp((PExp)this.getExp(), (PExp)MableAstFactory.newARealLiteralExp((Double)v)));
    }

    @Override
    public FloatExpressionValue multiply(double v) {
        return new FloatExpressionValue((PExp)MableAstFactory.newMultiplyExp((PExp)this.getExp(), (PExp)MableAstFactory.newARealLiteralExp((Double)v)));
    }

    @Override
    public FloatExpressionValue addition(FmiBuilder.NumericTypedReferenceExp v) {
        return new FloatExpressionValue((PExp)MableAstFactory.newPlusExp((PExp)this.getExp(), (PExp)v.getExp()));
    }

    @Override
    public FloatExpressionValue divide(FmiBuilder.NumericTypedReferenceExp v) {
        return new FloatExpressionValue((PExp)MableAstFactory.newDivideExp((PExp)this.getExp(), (PExp)v.getExp()));
    }

    @Override
    public FloatExpressionValue subtraction(FmiBuilder.NumericTypedReferenceExp v) {
        return new FloatExpressionValue((PExp)MableAstFactory.newMinusExp((PExp)this.getExp(), (PExp)v.getExp()));
    }

    @Override
    public FloatExpressionValue multiply(FmiBuilder.NumericTypedReferenceExp v) {
        return new FloatExpressionValue((PExp)MableAstFactory.newMultiplyExp((PExp)this.getExp(), (PExp)v.getExp()));
    }

    @Override
    public PredicateFmi2Api lessThan(FmiBuilder.NumericTypedReferenceExp endTimeVar) {
        return new PredicateFmi2Api((PExp)MableAstFactory.newALessBinaryExp((PExp)this.getExp(), (PExp)endTimeVar.getExp()));
    }
}

