/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.framework.fmi2.api.mabl.variables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.MableBuilder;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.DepthFirstAnalysisAdaptor;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.ABoolLiteralExp;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.AErrorStm;
import org.intocps.maestro.ast.node.AExpInitializer;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.ARealLiteralExp;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.ARefExp;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PExpBase;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStateDesignatorBase;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.SBlockStm;
import org.intocps.maestro.fmi.fmi3.Fmi3Causality;
import org.intocps.maestro.fmi.fmi3.Fmi3ModelDescription;
import org.intocps.maestro.fmi.fmi3.Fmi3TypeEnum;
import org.intocps.maestro.framework.core.RelationVariable;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.BuilderUtil;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.ModelDescriptionContext3;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi3Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.ScopeFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.values.PortValueExpresssionMapImpl;
import org.intocps.maestro.framework.fmi2.api.mabl.values.PortValueMapImpl;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ArrayVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.Buffers;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.FmuVariableFmi3Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.PortVariableMapImpl;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.StateMablVariableFmi3Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.UIntVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VarWrap;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceVariableFmi3Api
extends VariableFmi2Api<FmiBuilder.NamedVariable<PStm>>
implements FmiBuilder.Fmi3InstanceVariable<PStm, Fmi3ModelDescription.Fmi3ScalarVariable> {
    static final Logger logger = LoggerFactory.getLogger(InstanceVariableFmi3Api.class);
    private static final int FMI_STATUS_LAST_SUCCESSFUL = 2;
    private static final String LOGLEVELS_POSTFIX = "_log_levels";
    private static final String CATEGORY_STATUS = "category_status";
    final List<PortFmi3Api> outputPorts;
    final List<PortFmi3Api> inputPorts;
    final List<PortFmi3Api> ports;
    private final FmuVariableFmi3Api owner;
    private final String name;
    private final MablApiBuilder builder;
    private final String environmentName;
    private final Buffers<Fmi3TypeEnum> buffers;
    Predicate<FmiBuilder.Port> isLinked = p -> ((PortFmi3Api)p).getSourcePort() != null;
    ModelDescriptionContext3 modelDescriptionContext;
    private ArrayVariableFmi2Api<Object> derSharedBuffer;
    private DoubleVariableFmi2Api currentTimeVar = null;
    private BooleanVariableFmi2Api currentTimeStepFullStepVar = null;
    private ArrayVariableFmi2Api<Object> valueRefBuffer;
    private Map<PortFmi3Api, List<VariableFmi2Api<Object>>> derivativePortsToShare;
    private List<String> variablesToLog;
    Predicate<FmiBuilder.Port> obtainAsShared = p -> p.isLinked() || this.variablesToLog != null && this.variablesToLog.contains(p.getName());
    StepResult stepResult;

    public InstanceVariableFmi3Api(PStm declaration, FmuVariableFmi3Api parent, String name, ModelDescriptionContext3 modelDescriptionContext, MablApiBuilder builder, IMablScope declaringScope, PStateDesignator designator, PExp referenceExp) {
        this(declaration, parent, name, modelDescriptionContext, builder, declaringScope, designator, referenceExp, name);
    }

    public InstanceVariableFmi3Api(PStm declaration, FmuVariableFmi3Api parent, String name, ModelDescriptionContext3 modelDescriptionContext, MablApiBuilder builder, IMablScope declaringScope, PStateDesignator designator, PExp referenceExp, String environmentName) {
        super(declaration, (PType)MableAstFactory.newANameType((String)"FMI3Instance"), declaringScope, builder.getDynamicScope(), designator, referenceExp);
        this.owner = parent;
        this.name = name;
        this.modelDescriptionContext = modelDescriptionContext;
        this.builder = builder;
        this.ports = modelDescriptionContext.nameToSv.values().stream().map(sv -> new PortFmi3Api(this, (Fmi3ModelDescription.Fmi3ScalarVariable)sv)).sorted(Comparator.comparing(PortFmi3Api::getPortReferenceValue)).collect(Collectors.toUnmodifiableList());
        this.outputPorts = this.ports.stream().filter(p -> p.scalarVariable.getVariable().getCausality() == Fmi3Causality.Output).sorted(Comparator.comparing(PortFmi3Api::getPortReferenceValue)).collect(Collectors.toUnmodifiableList());
        this.inputPorts = this.ports.stream().filter(p -> p.scalarVariable.getVariable().getCausality() == Fmi3Causality.Input).sorted(Comparator.comparing(PortFmi3Api::getPortReferenceValue)).collect(Collectors.toUnmodifiableList());
        this.environmentName = environmentName;
        Map<Fmi3TypeEnum, Integer> svTypeMaxCount = modelDescriptionContext.valRefToSv.values().stream().collect(Collectors.groupingBy(i -> i.getVariable().getTypeIdentifier())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, l -> ((List)l.getValue()).size()));
        this.buffers = new Buffers<Fmi3TypeEnum>(builder, name, this.getDeclaringStm(), (ScopeFmi2Api)this.getDeclaredScope(), svTypeMaxCount);
    }

    public Fmi3ModelDescription getModelDescription() {
        return this.modelDescriptionContext.getModelDescription();
    }

    public List<PortFmi3Api> getVariablesToLog() {
        return this.getPorts(this.variablesToLog.toArray(new String[0]));
    }

    public void setVariablesToLog(List<? extends RelationVariable> variablesToLog) {
        this.variablesToLog = variablesToLog.stream().map(RelationVariable::getName).collect(Collectors.toList());
    }

    public <V> void share(FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> port, FmiBuilder.Variable<PStm, V> value) {
        HashMap<FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm>, FmiBuilder.Variable<PStm, V>> map = new HashMap<FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm>, FmiBuilder.Variable<PStm, V>>();
        map.put(port, value);
        this.share(map);
    }

    private DoubleVariableFmi2Api getCurrentTimeVar() {
        if (this.currentTimeVar == null) {
            String name = this.builder.getNameGenerator().getName(this.name, "current", "time");
            PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newRealType(), (PExp)MableAstFactory.newARealLiteralExp((Double)0.0));
            this.getDeclaredScope().addAfter(this.getDeclaringStm(), var);
            this.currentTimeVar = new DoubleVariableFmi2Api(var, this.getDeclaredScope(), (FmiBuilder.DynamicActiveScope<PStm>)this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        }
        return this.currentTimeVar;
    }

    private BooleanVariableFmi2Api getCurrentTimeFullStepVar() {
        if (this.currentTimeStepFullStepVar == null) {
            String name = this.builder.getNameGenerator().getName(this.name, "current", "time", "full", "step");
            PStm var = MableBuilder.newVariable((String)name, (PType)MableAstFactory.newBoleanType(), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)true));
            this.getDeclaredScope().addAfter(this.getDeclaringStm(), var);
            this.currentTimeStepFullStepVar = new BooleanVariableFmi2Api(var, this.getDeclaredScope(), (FmiBuilder.DynamicActiveScope<PStm>)this.dynamicScope, (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)name), (PExp)MableAstFactory.newAIdentifierExp((String)name));
        }
        return this.currentTimeStepFullStepVar;
    }

    private ArrayVariableFmi2Api<Object> getValueReferenceBuffer() {
        if (this.valueRefBuffer == null) {
            this.valueRefBuffer = this.createBuffer((PType)MableAstFactory.newUIntType(), "VRef", this.modelDescriptionContext.valRefToSv.size(), this.getDeclaredScope());
        }
        return this.valueRefBuffer;
    }

    private ArrayVariableFmi2Api<Object> getSharedDerBuffer() {
        if (this.derSharedBuffer == null) {
            try {
                this.derSharedBuffer = this.createDerValBuffer("DerShare", List.of(Integer.valueOf(1), Integer.valueOf(this.getModelDescription().getMaxOutputDerivativeOrder())));
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException("Exception occurred when accessing modeldescription: " + String.valueOf(e));
            }
        }
        return this.derSharedBuffer;
    }

    private ArrayVariableFmi2Api createMDArrayRecursively(List<Integer> arraySizes, PStm declaringStm, PStateDesignatorBase stateDesignator, PExpBase indexExp) {
        if (arraySizes.size() > 1) {
            ArrayList arrays = new ArrayList();
            for (int i = 0; i < arraySizes.get(0); ++i) {
                arrays.add(this.createMDArrayRecursively(arraySizes.subList(1, arraySizes.size()), declaringStm, (PStateDesignatorBase)MableAstFactory.newAArayStateDesignator((PStateDesignator)stateDesignator, (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExpBase)MableAstFactory.newAArrayIndexExp((PExp)indexExp, List.of(MableAstFactory.newAIntLiteralExp((Integer)i)))));
            }
            return new ArrayVariableFmi2Api(declaringStm, ((VariableFmi2Api)arrays.get(0)).getType(), this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)stateDesignator, indexExp.clone(), arrays);
        }
        ArrayList variables = new ArrayList();
        for (int i = 0; i < arraySizes.get(0); ++i) {
            variables.add(new VariableFmi2Api(declaringStm, this.type, this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)stateDesignator.clone(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)indexExp.clone(), List.of(MableAstFactory.newAIntLiteralExp((Integer)i)))));
        }
        return new ArrayVariableFmi2Api(declaringStm, ((VariableFmi2Api)variables.get(0)).getType(), this.getDeclaredScope(), this.builder.getDynamicScope(), ((AArrayStateDesignator)((VariableFmi2Api)variables.get(0)).getDesignatorClone()).getTarget(), indexExp.clone(), variables);
    }

    private ArrayVariableFmi2Api createDerValBuffer(String identifyingName, List<Integer> lengths) {
        String bufferName = this.builder.getNameGenerator().getName(this.name, identifyingName);
        ALocalVariableStm arrayVariableStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclarationMultiDimensionalArray((LexIdentifier)MableAstFactory.newAIdentifier((String)bufferName), (PType)MableAstFactory.newARealNumericPrimitiveType(), lengths));
        this.getDeclaredScope().addAfter(this.getDeclaringStm(), new PStm[]{arrayVariableStm});
        return this.createMDArrayRecursively(lengths, (PStm)arrayVariableStm, (PStateDesignatorBase)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)bufferName)), (PExpBase)MableAstFactory.newAIdentifierExp((String)bufferName));
    }

    private ArrayVariableFmi2Api<Object> createBuffer(PType type, String prefix, int length, IMablScope scope) {
        String ioBufName = this.builder.getNameGenerator().getName(this.name, String.valueOf(type), prefix);
        ALocalVariableStm var = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName), (PType)type, (int)length, null));
        this.getDeclaredScope().addAfter(this.getDeclaringStm(), new PStm[]{var});
        List items = IntStream.range(0, length).mapToObj(arg_0 -> this.lambda$createBuffer$7((PStm)var, type, scope, ioBufName, arg_0)).collect(Collectors.toList());
        return new ArrayVariableFmi2Api<Object>((PStm)var, type, scope, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIdentifierExp((String)ioBufName), items);
    }

    BooleanVariableFmi2Api createReusableBooleanVariable(boolean initial, IMablScope scope, String ... name) {
        String ioBufName = this.builder.getNameGenerator().getName(name);
        ABooleanPrimitiveType type = new ABooleanPrimitiveType();
        ALocalVariableStm var = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName), (PType)type, (PInitializer)new AExpInitializer((PExp)new ABoolLiteralExp(Boolean.valueOf(initial)))));
        this.getDeclaredScope().addAfter(this.getDeclaringStm(), new PStm[]{var});
        return new BooleanVariableFmi2Api((PStm)var, scope, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIdentifierExp((String)ioBufName));
    }

    DoubleVariableFmi2Api createReusableDoubleVariable(double initial, IMablScope scope, String ... name) {
        String ioBufName = this.builder.getNameGenerator().getName(name);
        ARealNumericPrimitiveType type = new ARealNumericPrimitiveType();
        ALocalVariableStm var = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName), (PType)type, (PInitializer)new AExpInitializer((PExp)new ARealLiteralExp(Double.valueOf(initial)))));
        this.getDeclaredScope().addAfter(this.getDeclaringStm(), new PStm[]{var});
        return new DoubleVariableFmi2Api((PStm)var, scope, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIdentifierExp((String)ioBufName));
    }

    public void setDebugLogging(List<String> categories, boolean enableLogging) {
        String method = "setDebugLogging";
        AArrayInitializer loglevelsArrayInitializer = null;
        String arrayName = this.name + LOGLEVELS_POSTFIX;
        IMablScope scope = this.builder.getDynamicScope().getActiveScope();
        if (!categories.isEmpty()) {
            loglevelsArrayInitializer = MableAstFactory.newAArrayInitializer(categories.stream().map(MableAstFactory::newAStringLiteralExp).collect(Collectors.toList()));
        }
        ALocalVariableStm arrayContent = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)arrayName), (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newAStringPrimitiveType()), (int)categories.size(), loglevelsArrayInitializer));
        LexIdentifier statusIdentifier = MableAstFactory.newAIdentifier((String)(this.getEnvironmentName() + "_category_status"));
        ALocalVariableStm callStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)statusIdentifier, (PType)MableAstFactory.newAIntNumericPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.name), (LexIdentifier)MableAstFactory.newAIdentifier((String)"setDebugLogging"), Arrays.asList(MableAstFactory.newABoolLiteralExp((Boolean)enableLogging), MableAstFactory.newAIdentifierExp((String)arrayName))))));
        scope.add(new PStm[]{arrayContent, callStm});
        this.handleError(scope, "setDebugLogging");
    }

    public void setupExperiment(FmiBuilder.DoubleVariable<PStm> startTime, FmiBuilder.DoubleVariable<PStm> endTime, FmiBuilder.BoolVariable<PStm> endTimeDefined, Double tolerance) {
        this.setupExperiment(((DoubleVariableFmi2Api)startTime).getReferenceExp().clone(), ((DoubleVariableFmi2Api)endTime).getReferenceExp().clone(), ((BooleanVariableFmi2Api)endTimeDefined).getReferenceExp().clone(), tolerance);
    }

    public void setupExperiment(double startTime, Double endTime, Double tolerance) {
        this.setupExperiment((PExp)MableAstFactory.newARealLiteralExp((Double)startTime), (PExp)MableAstFactory.newARealLiteralExp((Double)endTime), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)true), tolerance);
    }

    private void setupExperiment(PExp startTime, PExp endTime, PExp endTimeDefined, Double tolerance) {
        IMablScope scope = this.builder.getDynamicScope().getActiveScope();
        this.setupExperiment((FmiBuilder.Scope<PStm>)scope, startTime, endTime, endTimeDefined, tolerance);
    }

    private void setupExperiment(FmiBuilder.Scope<PStm> scope, PExp startTime, PExp endTime, PExp endTimeDefined, Double tolerance) {
        String method = "setupExperiment";
        AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)((IMablScope)scope).getFmiStatusVariable().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)"setupExperiment", new ArrayList<PExp>(Arrays.asList(MableAstFactory.newABoolLiteralExp((Boolean)(tolerance != null ? 1 : 0)), MableAstFactory.newARealLiteralExp((Double)(tolerance != null ? tolerance : 0.0)), startTime.clone(), endTimeDefined, endTime != null ? endTime.clone() : MableAstFactory.newARealLiteralExp((Double)0.0)))));
        scope.add((Object[])new PStm[]{stm});
        this.handleError(scope, "setupExperiment");
    }

    public void enterInitializationMode(boolean toleranceDefined, double tolerance, double startTime, boolean stopTimeDefined, double stopTime) {
        this.enterInitializationMode((FmiBuilder.Scope<PStm>)this.builder.getDynamicScope(), toleranceDefined, tolerance, startTime, stopTimeDefined, stopTime);
    }

    public void enterInitializationMode(FmiBuilder.Scope<PStm> scope, boolean toleranceDefined, double tolerance, double startTime, boolean stopTimeDefined, double stopTime) {
        this.enterInitializationMode((FmiBuilder.Scope<PStm>)this.builder.getDynamicScope(), VarWrap.wrap(toleranceDefined), VarWrap.wrap(tolerance), VarWrap.wrap(startTime), VarWrap.wrap(stopTimeDefined), VarWrap.wrap(stopTime));
    }

    public void enterInitializationMode(FmiBuilder.BoolVariable<PStm> toleranceDefined, FmiBuilder.DoubleVariable<PStm> tolerance, FmiBuilder.DoubleVariable<PStm> startTime, FmiBuilder.BoolVariable<PStm> stopTimeDefined, FmiBuilder.DoubleVariable<PStm> stopTime) {
        this.enterInitializationMode((FmiBuilder.Scope<PStm>)this.builder.getDynamicScope(), toleranceDefined, tolerance, startTime, stopTimeDefined, stopTime);
    }

    public void enterInitializationMode(FmiBuilder.Scope<PStm> scope, FmiBuilder.BoolVariable<PStm> toleranceDefined, FmiBuilder.DoubleVariable<PStm> tolerance, FmiBuilder.DoubleVariable<PStm> startTime, FmiBuilder.BoolVariable<PStm> stopTimeDefined, FmiBuilder.DoubleVariable<PStm> stopTime) {
        String method = "enterInitializationMode";
        AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)((IMablScope)scope).getFmiStatusVariable().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)"enterInitializationMode", (PExp[])new PExp[]{toleranceDefined.getExp().clone(), tolerance.getExp().clone(), startTime.getExp().clone(), stopTimeDefined.getExp().clone(), stopTime.getExp().clone()}));
        scope.add((Object[])new PStm[]{stm});
        this.handleError(scope, "enterInitializationMode");
    }

    public void enterEventMode() {
        this.enterEventMode((FmiBuilder.Scope<PStm>)this.dynamicScope);
    }

    public void enterEventMode(FmiBuilder.Scope<PStm> scope) {
        this.fmiCall(scope, "enterEventMode", new PExp[0]);
    }

    public void enterStepMode() {
        this.enterStepMode((FmiBuilder.Scope<PStm>)this.dynamicScope);
    }

    public void enterStepMode(FmiBuilder.Scope<PStm> scope) {
        this.fmiCall(scope, "enterStepMode", new PExp[0]);
    }

    public void getEventIndicators(FmiBuilder.Scope<PStm> scope, FmiBuilder.ArrayVariable<PStm, ? extends FmiBuilder.UIntVariable<PStm>> eventIndicators, FmiBuilder.UIntVariable<PStm> nEventIndicators) {
        this.fmiCall(scope, "getEventIndicators", new PExp[]{new ARefExp(eventIndicators.getExp().clone()), nEventIndicators.getExp().clone()});
    }

    public void getNumberOfEventIndicators(FmiBuilder.Scope<PStm> scope, FmiBuilder.UIntVariable<PStm> nEventIndicators) {
        this.fmiCall(scope, "getNumberOfEventIndicators", new PExp[]{new ARefExp(nEventIndicators.getExp().clone())});
    }

    private void handleError(FmiBuilder.Scope<PStm> scope, String method) {
        this.handleError(scope, method, MablApiBuilder.Fmi3Status.FMI_ERROR, MablApiBuilder.Fmi3Status.FMI_FATAL);
    }

    private void handleError(FmiBuilder.Scope<PStm> scope, String method, MablApiBuilder.Fmi3Status ... statusesToFail) {
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, method, this, (IMablScope)scope, statusesToFail);
        }
    }

    public void exitInitializationMode() {
        this.exitInitializationMode(this.builder.getDynamicScope());
    }

    public void setupExperiment(FmiBuilder.Scope<PStm> scope, FmiBuilder.DoubleVariable<PStm> startTime, FmiBuilder.DoubleVariable<PStm> endTime, FmiBuilder.BoolVariable<PStm> endTimeDefined, Double tolerance) {
        this.setupExperiment(scope, ((DoubleVariableFmi2Api)startTime).getReferenceExp().clone(), ((DoubleVariableFmi2Api)endTime).getReferenceExp().clone(), endTimeDefined.getExp().clone(), tolerance);
    }

    public void setupExperiment(FmiBuilder.Scope<PStm> scope, double startTime, Double endTime, Double tolerance) {
        this.setupExperiment(scope, (PExp)MableAstFactory.newARealLiteralExp((Double)startTime), (PExp)MableAstFactory.newARealLiteralExp((Double)endTime), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)true), tolerance);
    }

    public void exitInitializationMode(FmiBuilder.Scope<PStm> scope) {
        this.fmiCall(scope, "exitInitializationMode", new PExp[0]);
    }

    public void getClock(ArrayVariableFmi2Api<UIntVariableFmi2Api> vrs, FmiBuilder.IntVariable<PStm> nvr, ArrayVariableFmi2Api<BooleanVariableFmi2Api> triggeredClocks) {
        this.getClock(this.builder.getDynamicScope(), vrs, nvr, triggeredClocks);
    }

    public void getClock(FmiBuilder.Scope<PStm> scope, ArrayVariableFmi2Api<UIntVariableFmi2Api> vrs, FmiBuilder.IntVariable<PStm> nvr, ArrayVariableFmi2Api<BooleanVariableFmi2Api> triggeredClocks) {
        this.fmiCall(scope, "getClock", new PExp[]{vrs.getReferenceExp().clone(), nvr.getExp().clone(), new ARefExp(triggeredClocks.getExp().clone())});
    }

    public void setClock(ArrayVariableFmi2Api<UIntVariableFmi2Api> vrs, FmiBuilder.IntVariable<PStm> nvr, ArrayVariableFmi2Api<BooleanVariableFmi2Api> triggeredClocks) {
        this.setClock(this.builder.getDynamicScope(), vrs, nvr, triggeredClocks);
    }

    public void setClock(FmiBuilder.Scope<PStm> scope, ArrayVariableFmi2Api<UIntVariableFmi2Api> vrs, FmiBuilder.IntVariable<PStm> nvr, ArrayVariableFmi2Api<BooleanVariableFmi2Api> triggeredClocks) {
        this.fmiCall(scope, "setClock", vrs.getReferenceExp().clone(), nvr.getExp().clone(), triggeredClocks.getExp().clone());
    }

    public void updateDiscreteStates(FmiBuilder.Scope<PStm> scope, BooleanVariableFmi2Api discreteStatesNeedUpdate, BooleanVariableFmi2Api terminateSimulation, BooleanVariableFmi2Api nominalsOfContinuousStatesChanged, BooleanVariableFmi2Api valuesOfContinuousStatesChanged, BooleanVariableFmi2Api nextEventTimeDefined, DoubleVariableFmi2Api nextEventTime) {
        this.fmiCall(scope, "updateDiscreteStates", new PExp[]{new ARefExp(discreteStatesNeedUpdate.getReferenceExp().clone()), new ARefExp(terminateSimulation.getReferenceExp().clone()), new ARefExp(nominalsOfContinuousStatesChanged.getReferenceExp().clone()), new ARefExp(valuesOfContinuousStatesChanged.getReferenceExp().clone()), new ARefExp(nextEventTimeDefined.getReferenceExp().clone()), new ARefExp(nextEventTime.getReferenceExp().clone())});
    }

    public Map.Entry<FmiBuilder.BoolVariable<PStm>, StepResult> step(FmiBuilder.Scope<PStm> scope, FmiBuilder.DoubleVariable<PStm> currentCommunicationPoint, FmiBuilder.DoubleVariable<PStm> communicationStepSize, PExp noSetFMUStatePriorToCurrentPoint) {
        if (this.stepResult == null) {
            this.stepResult = new StepResult(this.createReusableBooleanVariable(false, this.getDeclaredScope(), this.name + "EventHandlingNeeded"), this.createReusableBooleanVariable(false, this.getDeclaredScope(), this.name + "TerminateSimulation"), this.createReusableBooleanVariable(false, this.getDeclaredScope(), this.name + "EarlyReturn"), this.createReusableDoubleVariable(0.0, this.getDeclaredScope(), this.name + "LastSuccessfulTime"));
        }
        scope.add((Object[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)((IMablScope)scope).getFmiStatusVariable().getDesignator().clone(), (PExp)MableAstFactory.newACallExp((PExp)this.getReferenceExp().clone(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"doStep"), Arrays.asList(((VariableFmi2Api)currentCommunicationPoint).getReferenceExp().clone(), ((VariableFmi2Api)communicationStepSize).getReferenceExp().clone(), noSetFMUStatePriorToCurrentPoint.clone(), new ARefExp(this.stepResult.eventHandlingNeeded.getReferenceExp()).clone(), new ARefExp(this.stepResult.terminateSimulation.getReferenceExp()).clone(), new ARefExp(this.stepResult.earlyReturn.getReferenceExp()).clone(), new ARefExp(this.stepResult.lastSuccessfulTime.getReferenceExp()).clone())))});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, "doStep", this, (IMablScope)scope, MablApiBuilder.Fmi3Status.FMI_ERROR, MablApiBuilder.Fmi3Status.FMI_FATAL);
        }
        return Map.entry(this.getCurrentTimeFullStepVar(), this.stepResult);
    }

    public List<PortFmi3Api> getPorts() {
        return this.ports;
    }

    public List<PortFmi3Api> getPorts(String ... names) {
        List<String> accept = Arrays.asList(names);
        return this.ports.stream().filter(p -> accept.contains(p.getName())).collect(Collectors.toList());
    }

    public List<PortFmi3Api> getPorts(int ... valueReferences) {
        List accept = Arrays.stream(valueReferences).boxed().collect(Collectors.toList());
        return this.ports.stream().filter(p -> accept.contains(p.getPortReferenceValue().intValue())).collect(Collectors.toList());
    }

    public PortFmi3Api getPort(String name) {
        return this.getPorts(name).get(0);
    }

    public PortFmi3Api getPort(int valueReference) {
        return this.getPorts(valueReference).get(0);
    }

    public <V> Map<PortFmi3Api, VariableFmi2Api<V>> get(FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> ... ports) {
        return this.get(this.builder.getDynamicScope().getActiveScope(), ports);
    }

    public <V> Map<PortFmi3Api, VariableFmi2Api<V>> get(FmiBuilder.Scope<PStm> scope, FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> ... ports) {
        if (ports == null || ports.length == 0) {
            return Map.of();
        }
        List selectedPorts = Arrays.stream(ports).map(PortFmi3Api.class::cast).collect(Collectors.toList());
        HashMap<PortFmi3Api, VariableFmi2Api<VariableFmi2Api<Object>>> results = new HashMap<PortFmi3Api, VariableFmi2Api<VariableFmi2Api<Object>>>();
        HashMap typeToSortedPorts = new HashMap();
        ArrayVariableFmi2Api<Object> vrefBuf = this.getValueReferenceBuffer();
        selectedPorts.stream().map(p -> p.scalarVariable.getVariable().getTypeIdentifier()).distinct().map(t -> selectedPorts.stream().filter(p -> p.scalarVariable.getVariable().getTypeIdentifier().equals(t)).sorted(Comparator.comparing(FmiBuilder.Port::getPortReferenceValue)).collect(Collectors.toList())).forEach(l -> typeToSortedPorts.put(((PortFmi3Api)l.get((int)0)).scalarVariable.getVariable().getTypeIdentifier(), l));
        for (Map.Entry e : typeToSortedPorts.entrySet()) {
            for (int i = 0; i < ((List)e.getValue()).size(); ++i) {
                PortFmi3Api p2 = (PortFmi3Api)((List)e.getValue()).get(i);
                PStateDesignator designator = vrefBuf.items().get(i).getDesignator().clone();
                scope.add((Object[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)designator, (PExp)MableAstFactory.newAIntLiteralExp((Integer)p2.getPortReferenceValue().intValue()))});
            }
            PortFmi3Api firstTargetPort = (PortFmi3Api)((List)e.getValue()).get(0);
            PType type = firstTargetPort.getType();
            ArrayVariableFmi2Api<Object> valBuf = this.buffers.getBuffer(Buffers.BufferTypes.IO, type, firstTargetPort.getSourceObject().getVariable().getTypeIdentifier());
            AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)((IMablScope)scope).getFmiStatusVariable().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)this.createFunctionName(FmiFunctionType.GET, firstTargetPort), (PExp[])new PExp[]{vrefBuf.getReferenceExp().clone(), MableAstFactory.newAUIntLiteralExp((Long)Long.valueOf(((List)e.getValue()).size())), MableAstFactory.newARefExp((PExp)valBuf.getReferenceExp().clone()), MableAstFactory.newAUIntLiteralExp((Long)Long.valueOf(((List)e.getValue()).size()))}));
            scope.add((Object[])new PStm[]{stm});
            this.handleError(scope, this.createFunctionName(FmiFunctionType.GET, firstTargetPort));
            if (this.builder.getSettings().setGetDerivatives && type.equals((Object)new ARealNumericPrimitiveType())) {
                this.derivativePortsToShare = this.getDerivatives((List)e.getValue(), scope);
            }
            for (int i = 0; i < ((List)e.getValue()).size(); ++i) {
                results.put((PortFmi3Api)((List)e.getValue()).get(i), valBuf.items().get(i));
            }
        }
        return results;
    }

    public Map<PortFmi3Api, List<VariableFmi2Api<Object>>> getDerivatives(List<PortFmi3Api> ports, FmiBuilder.Scope<PStm> scope) {
        HashMap<PortFmi3Api, List<VariableFmi2Api<Object>>> derivativePortsToReturn = new HashMap<PortFmi3Api, List<VariableFmi2Api<Object>>>();
        return derivativePortsToReturn;
    }

    public <V> Map<PortFmi3Api, VariableFmi2Api<V>> get() {
        return this.get(this.builder.getDynamicScope(), (FmiBuilder.Port[])this.outputPorts.toArray(FmiBuilder.Port[]::new));
    }

    public <V> Map<PortFmi3Api, VariableFmi2Api<V>> get(int ... valueReferences) {
        List accept = Arrays.stream(valueReferences).boxed().collect(Collectors.toList());
        return this.get(this.builder.getDynamicScope(), (FmiBuilder.Port[])this.outputPorts.stream().filter(p -> accept.contains(p.getPortReferenceValue().intValue())).toArray(FmiBuilder.Port[]::new));
    }

    public <V> Map<PortFmi3Api, VariableFmi2Api<V>> get(String ... names) {
        List<String> accept = Arrays.asList(names);
        FmiBuilder.Port[] ports = (FmiBuilder.Port[])this.ports.stream().filter(p -> accept.contains(p.getName())).toArray(FmiBuilder.Port[]::new);
        return this.get(this.builder.getDynamicScope(), ports);
    }

    public <V> Map<PortFmi3Api, VariableFmi2Api<V>> getAndShare(String ... names) {
        Map<PortFmi3Api, VariableFmi2Api<V>> values = this.get(names);
        this.share(values);
        return values;
    }

    public <V> Map<? extends FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm>, ? extends FmiBuilder.Variable<PStm, V>> getAndShare(FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> ... ports) {
        Map<PortFmi3Api, VariableFmi2Api<V>> values = this.get(ports);
        this.share(values);
        return values;
    }

    public <V> Map<? extends FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm>, ? extends FmiBuilder.Variable<PStm, V>> getAndShare() {
        Map<PortFmi3Api, VariableFmi2Api<V>> values = this.get((FmiBuilder.Port[])this.getPorts().stream().filter(this.obtainAsShared).toArray(FmiBuilder.Port[]::new));
        this.share(values);
        return values;
    }

    public VariableFmi2Api getShared(String name) {
        return this.getPort(name).getSharedAsVariable();
    }

    public VariableFmi2Api getShared(FmiBuilder.Port port) {
        return ((PortFmi3Api)port).getSharedAsVariable();
    }

    public <V> VariableFmi2Api<V> getSingle(FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> port) {
        return this.get(port).entrySet().iterator().next().getValue();
    }

    private String createFunctionName(FmiFunctionType fun, PortFmi3Api p) {
        return this.createFunctionName(fun, p.scalarVariable.getVariable().getTypeIdentifier());
    }

    private String createFunctionName(FmiFunctionType f, Fmi3TypeEnum type) {
        Object functionName = "";
        switch (f.ordinal()) {
            case 0: {
                functionName = (String)functionName + "get";
                break;
            }
            case 1: {
                functionName = (String)functionName + "set";
                break;
            }
            default: {
                throw new RuntimeException("Attempting to call non type-dependant function with type: " + String.valueOf(type));
            }
        }
        functionName = (String)functionName + type.name().substring(0, type.name().length() - "Type".length());
        if (((String)functionName).endsWith("Enumeration")) {
            functionName = ((String)functionName).replace("Enumeration", "Int64");
        }
        return functionName;
    }

    public VariableFmi2Api getSingle(String name) {
        return this.get(name).entrySet().iterator().next().getValue();
    }

    public void set(FmiBuilder.Port p, FmiBuilder.ExpressionValue v) {
        this.set(new PortValueExpresssionMapImpl(Map.of(p, v)));
    }

    public void set(FmiBuilder.Scope<PStm> scope, FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> p, FmiBuilder.ExpressionValue v) {
        this.set(scope, new PortValueMapImpl(Map.of(p, v)));
    }

    public void set(FmiBuilder.FmiSimulationInstance.PortExpressionValueMap value) {
        this.set((FmiBuilder.Scope<PStm>)this.builder.getDynamicScope().getActiveScope(), (FmiBuilder.FmiSimulationInstance.PortExpressionValueMap<Fmi3ModelDescription.Fmi3ScalarVariable, PStm>)value);
    }

    public void set(FmiBuilder.Scope<PStm> scope, FmiBuilder.FmiSimulationInstance.PortExpressionValueMap<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        List<PortFmi3Api> selectedPorts = value.keySet().stream().map(PortFmi3Api.class::cast).collect(Collectors.toList());
        this.set(scope, selectedPorts, (PortFmi3Api port) -> {
            FmiBuilder.ExpressionValue value_ = (FmiBuilder.ExpressionValue)value.get(port);
            return Map.entry(value_.getExp(), value_.getType());
        });
    }

    public <V> void set(FmiBuilder.Scope<PStm> scope, FmiBuilder.FmiSimulationInstance.PortValueMap<V, Fmi3ModelDescription.Fmi3ScalarVariable, PStm> value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        List<PortFmi3Api> selectedPorts = value.keySet().stream().map(PortFmi3Api.class::cast).collect(Collectors.toList());
        this.set(scope, selectedPorts, (PortFmi3Api port) -> {
            Object val = ((FmiBuilder.Value)value.get(port)).get();
            if (val instanceof Double) {
                return Map.entry(MableAstFactory.newARealLiteralExp((Double)((Double)val)), MableAstFactory.newRealType());
            }
            if (val instanceof Long) {
                return Map.entry(MableAstFactory.newAUIntLiteralExp((Long)((Long)val)), MableAstFactory.newUIntType());
            }
            if (val instanceof Integer) {
                return Map.entry(MableAstFactory.newAIntLiteralExp((Integer)((Integer)val)), MableAstFactory.newIntType());
            }
            if (val instanceof Boolean) {
                return Map.entry(MableAstFactory.newABoolLiteralExp((Boolean)((Boolean)val)), MableAstFactory.newBoleanType());
            }
            if (val instanceof String) {
                return Map.entry(MableAstFactory.newAStringLiteralExp((String)((String)val)), MableAstFactory.newStringType());
            }
            return null;
        });
    }

    public <V> void set(FmiBuilder.Scope<PStm> scope, FmiBuilder.FmiSimulationInstance.PortVariableMap<V, Fmi3ModelDescription.Fmi3ScalarVariable, PStm> value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        List<PortFmi3Api> selectedPorts = value.keySet().stream().map(PortFmi3Api.class::cast).collect(Collectors.toList());
        FmiBuilder.FmiSimulationInstance.PortVariableMap valueFinal = value;
        this.set(scope, selectedPorts, (PortFmi3Api port) -> Map.entry(((VariableFmi2Api)valueFinal.get(port)).getReferenceExp().clone(), ((VariableFmi2Api)valueFinal.get((Object)port)).type));
    }

    public void set(FmiBuilder.Scope<PStm> scope, List<PortFmi3Api> selectedPorts, Function<PortFmi3Api, Map.Entry<PExp, PType>> portToValue) {
        Set selectedPortsAsStrings = selectedPorts.stream().map(p -> p.getName() + "-" + p.aMablFmi3InstanceAPI.getName() + "-" + p.aMablFmi3InstanceAPI.getOwner().getName()).collect(Collectors.toSet());
        selectedPortsAsStrings.removeAll(this.ports.stream().map(p -> p.getName() + "-" + p.aMablFmi3InstanceAPI.getName() + "-" + p.aMablFmi3InstanceAPI.getOwner().getName()).collect(Collectors.toSet()));
        if (!selectedPortsAsStrings.isEmpty()) {
            throw new RuntimeException("Unable to set port(s) that is not declared in the FMU: " + selectedPortsAsStrings.stream().map(name -> name.split("-")[0]).collect(Collectors.joining(", ")));
        }
        List sortedPorts = selectedPorts.stream().sorted(Comparator.comparing(FmiBuilder.Port::getPortReferenceValue)).collect(Collectors.toList());
        sortedPorts.stream().collect(Collectors.groupingBy(i -> i.getSourceObject().getVariable().getTypeIdentifier().toString())).forEach((key, value) -> {
            ArrayVariableFmi2Api<Object> vrefBuf = this.getValueReferenceBuffer();
            PortFmi3Api firstTargetPort = (PortFmi3Api)value.get(0);
            PType type = firstTargetPort.getType();
            for (int i = 0; i < value.size(); ++i) {
                FmiBuilder.Port p = (FmiBuilder.Port)value.get(i);
                PStateDesignator designator = vrefBuf.items().get(i).getDesignator().clone();
                scope.add((Object[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)designator, (PExp)MableAstFactory.newAIntLiteralExp((Integer)p.getPortReferenceValue().intValue()))});
            }
            ArrayVariableFmi2Api<Object> valBuf = this.buffers.getBuffer(Buffers.BufferTypes.IO, type, firstTargetPort.getSourceObject().getVariable().getTypeIdentifier());
            for (int i = 0; i < value.size(); ++i) {
                PortFmi3Api p = (PortFmi3Api)value.get(i);
                PStateDesignator designator = valBuf.items().get(i).getDesignator();
                scope.addAll(BuilderUtil.createTypeConvertingAssignment(this.builder, scope, designator.clone(), ((PExp)((Map.Entry)portToValue.apply(p)).getKey()).clone(), (PType)((Map.Entry)portToValue.apply(p)).getValue(), valBuf.type));
            }
            AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)((IMablScope)scope).getFmiStatusVariable().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)this.createFunctionName(FmiFunctionType.SET, firstTargetPort), (PExp[])new PExp[]{vrefBuf.getReferenceExp().clone(), MableAstFactory.newAIntLiteralExp((Integer)value.size()), valBuf.getReferenceExp().clone(), MableAstFactory.newAIntLiteralExp((Integer)value.size())}));
            scope.add((Object[])new PStm[]{stm});
            this.handleError(scope, this.createFunctionName(FmiFunctionType.SET, firstTargetPort));
        });
    }

    public void setDerivatives(ArrayVariableFmi2Api derValInBuf, ArrayVariableFmi2Api derOrderInBuf, ArrayVariableFmi2Api derRefInBuf, FmiBuilder.Scope<PStm> scope) {
        String method = "setRealInputDerivatives";
        int arraySize = derValInBuf.size();
        AAssigmentStm ifStm = MableAstFactory.newAAssignmentStm((PStateDesignator)this.builder.getGlobalFmiStatus().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)"setRealInputDerivatives", (PExp[])new PExp[]{derRefInBuf.getReferenceExp().clone(), MableAstFactory.newAUIntLiteralExp((Long)Long.valueOf(arraySize)), derOrderInBuf.getReferenceExp().clone(), derValInBuf.getReferenceExp().clone()}));
        scope.add((Object[])new PStm[]{ifStm});
        this.handleError(scope, "setRealInputDerivatives");
    }

    public <V> void set(FmiBuilder.FmiSimulationInstance.PortValueMap<V, Fmi3ModelDescription.Fmi3ScalarVariable, PStm> value) {
        this.set((FmiBuilder.Scope<PStm>)this.builder.getDynamicScope(), value);
    }

    public <V> void set(FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> port, FmiBuilder.Variable<PStm, V> value) {
        this.set(new PortVariableMapImpl<V, Fmi3ModelDescription.Fmi3ScalarVariable>(Map.of(port, value)));
    }

    public <V> void set(FmiBuilder.Scope<PStm> scope, FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> port, FmiBuilder.Variable<PStm, V> value) {
        this.set(scope, new PortVariableMapImpl<V, Fmi3ModelDescription.Fmi3ScalarVariable>(Map.of(port, value)));
    }

    public <V> void set(FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> port, FmiBuilder.Value<V> value) {
        PortValueMapImpl map = new PortValueMapImpl();
        map.put(port, value);
        this.set(map);
    }

    public <V> void set(FmiBuilder.FmiSimulationInstance.PortVariableMap<V, Fmi3ModelDescription.Fmi3ScalarVariable, PStm> value) {
        this.set((FmiBuilder.Scope<PStm>)this.builder.getDynamicScope(), value);
    }

    public void setLinked(FmiBuilder.Scope<PStm> scope, FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> ... filterPorts) {
        List<PortFmi3Api> selectedPorts = this.ports.stream().filter(this.isLinked).collect(Collectors.toList());
        if (filterPorts != null && filterPorts.length != 0) {
            List<FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm>> filterList = Arrays.asList(filterPorts);
            for (FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm> p : filterList) {
                if (this.isLinked.test(p)) continue;
                logger.warn("Filter for setLinked contains unlined port. Its ignored. {}", p);
            }
            selectedPorts = selectedPorts.stream().filter(filterList::contains).collect(Collectors.toList());
        }
        if (selectedPorts.isEmpty()) {
            logger.warn("No linked input variables for FMU instance: " + this.getName());
            return;
        }
        for (PortFmi3Api port : selectedPorts) {
            if (port.getSourcePort() == null) {
                throw new RuntimeException("Attempting to obtain shared value from a port that is not linked. This port is missing a required link: " + String.valueOf(port));
            }
            if (port.getSourcePort().getSharedAsVariable() != null) continue;
            throw new RuntimeException("Attempting to obtain shared values from a port that is linked but has no value shared. Share a value first. " + String.valueOf(port));
        }
        this.set(scope, selectedPorts, (PortFmi3Api k) -> Map.entry(k.getSourcePort().getSharedAsVariable().getReferenceExp().clone(), k.getSourcePort().getSharedAsVariable().type));
    }

    public void setLinked() {
        this.setLinked((FmiBuilder.Scope<PStm>)this.dynamicScope, (FmiBuilder.Port[])null);
    }

    public void setLinked(FmiBuilder.Port ... filterPorts) {
        this.setLinked((FmiBuilder.Scope<PStm>)this.dynamicScope, filterPorts);
    }

    public void setLinked(String ... filterNames) {
        List<String> accept = Arrays.asList(filterNames);
        this.setLinked((FmiBuilder.Scope<PStm>)this.dynamicScope, (FmiBuilder.Port[])this.getPorts().stream().filter(p -> accept.contains(p.getName())).toArray(FmiBuilder.Port[]::new));
    }

    public void setLinked(long ... filterValueReferences) {
        List accept = Arrays.stream(filterValueReferences).boxed().collect(Collectors.toList());
        this.setLinked((FmiBuilder.Scope<PStm>)this.dynamicScope, (FmiBuilder.Port[])this.getPorts().stream().filter(p -> accept.contains(p.getPortReferenceValue())).toArray(FmiBuilder.Port[]::new));
    }

    public void setInt(Map<? extends Integer, ? extends FmiBuilder.Value<Integer>> values) {
    }

    public void setString(Map<? extends String, ? extends FmiBuilder.Value<String>> value) {
    }

    public void terminate() {
        this.terminate(this.builder.getDynamicScope());
    }

    public void terminate(FmiBuilder.Scope<PStm> scope) {
        this.fmiCall(scope, "terminate", new PExp[0]);
    }

    public void reset() {
        this.reset(this.builder.getDynamicScope());
    }

    public void reset(FmiBuilder.Scope<PStm> scope) {
        this.fmiCall(scope, "reset", new PExp[0]);
    }

    private void fmiCall(FmiBuilder.Scope<PStm> scope, String methodName, PExp ... args) {
        AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)((IMablScope)scope).getFmiStatusVariable().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)methodName, (PExp[])args));
        scope.add((Object[])new PStm[]{stm});
        this.handleError(scope, methodName);
    }

    public void freeInstance() {
        this.freeInstance(this.builder.getDynamicScope());
    }

    public void freeInstance(FmiBuilder.Scope<PStm> scope) {
        scope.add((Object[])new PStm[]{MableAstFactory.newExpressionStm((PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)"freeInstance", (PExp[])new PExp[0]))});
    }

    public <V> void share(Map<? extends FmiBuilder.Port<Fmi3ModelDescription.Fmi3ScalarVariable, PStm>, ? extends FmiBuilder.Variable<PStm, V>> values) {
        values.entrySet().stream().collect(Collectors.groupingBy(map -> ((PortFmi3Api)map.getKey()).getType().toString())).entrySet().stream().forEach(map -> {
            PType type = ((PortFmi3Api)((Map.Entry)((List)map.getValue()).get(0)).getKey()).getType();
            Map<FmiBuilder.Port, FmiBuilder.Variable> data = ((List)map.getValue()).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            data.keySet().stream().map(PortFmi3Api.class::cast).sorted(Comparator.comparing(PortFmi3Api::getPortReferenceValue)).forEach(port -> {
                Fmi3TypeEnum fmiType = port.getSourceObject().getVariable().getTypeIdentifier();
                ArrayVariableFmi2Api<Object> buffer = this.buffers.getBuffer(Buffers.BufferTypes.Share, type, fmiType);
                if (port.getSharedAsVariable() == null) {
                    ArrayVariableFmi2Api<Object> newBuf = this.buffers.growBuffer(Buffers.BufferTypes.Share, buffer, 1, fmiType);
                    VariableFmi2Api<Object> newShared = newBuf.items().get(newBuf.items().size() - 1);
                    port.setSharedAsVariable(newShared);
                }
                PStateDesignator designator = port.getSharedAsVariable().getDesignator();
                this.builder.getDynamicScope().addAll(BuilderUtil.createTypeConvertingAssignment(this.builder, (FmiBuilder.Scope<PStm>)this.dynamicScope, designator.clone(), ((VariableFmi2Api)data.get(port)).getReferenceExp().clone(), port.getType(), ((VariableFmi2Api)data.get((Object)port)).type));
                if (type.equals((Object)new ARealNumericPrimitiveType()) && this.derivativePortsToShare != null) {
                    this.derivativePortsToShare.keySet().stream().filter(derivativePort -> this.modelDescriptionContext.getModelDescription().getDerivatives().stream().map(v -> v.getVariable().getValueReferenceAsLong()).anyMatch(vref -> vref.equals(port.getPortReferenceValue()) && vref.equals(derivativePort.getPortReferenceValue()))).findFirst().ifPresent(derivativePort -> {
                        if (derivativePort.getSharedAsVariable() == null) {
                            ArrayVariableFmi2Api<Object> sharedDerBuf = this.growSharedDerBuf(1);
                            ArrayVariableFmi2Api newSharedArray = (ArrayVariableFmi2Api)sharedDerBuf.items().get(sharedDerBuf.items().size() - 1);
                            derivativePort.setSharedAsVariable(newSharedArray);
                        }
                        List derivatives = ((ArrayVariableFmi2Api)derivativePort.getSharedAsVariable()).items();
                        for (int i = 0; i < derivatives.size(); ++i) {
                            PExp val = this.derivativePortsToShare.get(derivativePort).get(i).getReferenceExp().clone();
                            this.builder.getDynamicScope().add(new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)derivatives.get(i).getDesignator().clone(), (PExp)val)});
                        }
                    });
                }
            });
        });
    }

    private ArrayVariableFmi2Api<Object> growSharedDerBuf(int increaseByCount) {
        int innerArraySize;
        if (this.derSharedBuffer == null && increaseByCount == 1) {
            return this.getSharedDerBuffer();
        }
        ArrayVariableFmi2Api<Object> sharedBuffer = this.getSharedDerBuffer();
        try {
            innerArraySize = this.modelDescriptionContext.getModelDescription().getMaxOutputDerivativeOrder();
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Exception occurred when accessing model description: ", e);
        }
        String bufferName = ((AIdentifierExp)sharedBuffer.getReferenceExp()).getName().getText();
        int outerArraySize = sharedBuffer.size() + increaseByCount;
        ALocalVariableStm outerArrayVariableStm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclarationMultiDimensionalArray((LexIdentifier)MableAstFactory.newAIdentifier((String)bufferName), (PType)MableAstFactory.newARealNumericPrimitiveType(), Arrays.asList(outerArraySize, innerArraySize)));
        sharedBuffer.getDeclaringStm().parent().replaceChild((INode)sharedBuffer.getDeclaringStm(), (INode)outerArrayVariableStm);
        ArrayList items = new ArrayList();
        for (int i = 0; i < increaseByCount; ++i) {
            int outerIndex = sharedBuffer.size() + i;
            ArrayList variables = new ArrayList();
            for (int l = 0; l < innerArraySize; ++l) {
                AArrayStateDesignator designator = MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)bufferName)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)outerIndex)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)l));
                AArrayIndexExp indexExp = MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((String)bufferName), Arrays.asList(MableAstFactory.newAIntLiteralExp((Integer)outerIndex), MableAstFactory.newAIntLiteralExp((Integer)l)));
                variables.add(new VariableFmi2Api((PStm)outerArrayVariableStm, this.type, this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)designator, (PExp)indexExp));
            }
            ArrayVariableFmi2Api innerArrayVariable = new ArrayVariableFmi2Api((PStm)outerArrayVariableStm, (PType)MableAstFactory.newARealNumericPrimitiveType(), this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)bufferName)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)outerIndex)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((String)bufferName), Collections.singletonList(MableAstFactory.newAIntLiteralExp((Integer)outerIndex))), variables);
            items.add(innerArrayVariable);
        }
        items.addAll(0, sharedBuffer.items());
        return new ArrayVariableFmi2Api<Object>((PStm)outerArrayVariableStm, (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newARealNumericPrimitiveType()), this.getDeclaredScope(), this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)bufferName)), (PExp)MableAstFactory.newAIdentifierExp((String)bufferName), items);
    }

    public FmiBuilder.StateVariable<PStm> getState() throws XPathExpressionException {
        return this.getState(this.builder.getDynamicScope());
    }

    public FmiBuilder.StateVariable<PStm> getState(FmiBuilder.Scope<PStm> scope) throws XPathExpressionException {
        if (!this.modelDescriptionContext.getModelDescription().getCanGetAndSetFmustate()) {
            throw new RuntimeException("Unable to get state on fmu: " + String.valueOf(this.getOwner()) + " with instance name: " + this.getName());
        }
        String stateName = this.builder.getNameGenerator().getName(this.name, "state");
        PStm stateVar = MableBuilder.newVariable((String)stateName, (PType)MableAstFactory.newANameType((String)"FmiComponentState"), (int[])new int[0]);
        scope.add((Object[])new PStm[]{stateVar});
        StateMablVariableFmi3Api state = new StateMablVariableFmi3Api(stateVar, (PType)MableAstFactory.newANameType((String)"FmiComponentState"), (IMablScope)scope, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((String)stateName), (PExp)MableAstFactory.newAIdentifierExp((String)stateName), this.builder, this);
        AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)((IMablScope)scope).getFmiStatusVariable().getDesignator().clone(), (PExp)MableBuilder.call((PExp)this.getReferenceExp().clone(), (String)"getState", Collections.singletonList(MableAstFactory.newARefExp((PExp)state.getReferenceExp().clone()))));
        scope.add((Object[])new PStm[]{stm});
        if (this.builder.getSettings().fmiErrorHandlingEnabled) {
            FmiStatusErrorHandlingBuilder.generate(this.builder, "getState", this, (IMablScope)scope, MablApiBuilder.Fmi3Status.FMI_ERROR, MablApiBuilder.Fmi3Status.FMI_FATAL);
        }
        return state;
    }

    public FmuVariableFmi3Api getOwner() {
        return this.owner;
    }

    public List<PortFmi3Api> getAllConnectedOutputs() {
        return this.ports.stream().filter(x -> x.scalarVariable.getVariable().getCausality() == Fmi3Causality.Output && x.getTargetPorts().size() > 0).collect(Collectors.toList());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    private /* synthetic */ VariableFmi2Api lambda$createBuffer$7(PStm var, PType type, IMablScope scope, String ioBufName, int i) {
        return new VariableFmi2Api(var, type, scope, this.builder.getDynamicScope(), (PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)ioBufName)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExp)MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((String)ioBufName), Collections.singletonList(MableAstFactory.newAIntLiteralExp((Integer)i))));
    }

    static class FmiStatusErrorHandlingBuilder {
        FmiStatusErrorHandlingBuilder() {
        }

        static void generate(MablApiBuilder builder, String method, InstanceVariableFmi3Api instance, IMablScope scope, MablApiBuilder.Fmi3Status ... statusesToFail) {
            if (statusesToFail == null || statusesToFail.length == 0) {
                return;
            }
            Function<MablApiBuilder.Fmi3Status, PExp> checkStatusEq = s -> MableAstFactory.newEqual((PExp)scope.getFmiStatusVariable().getReferenceExp().clone(), (PExp)builder.getFmiStatusConstant((MablApiBuilder.Fmi3Status)s).getReferenceExp().clone());
            PExp exp = checkStatusEq.apply(statusesToFail[0]);
            for (int i = 1; i < statusesToFail.length; ++i) {
                exp = MableAstFactory.newOr((PExp)exp, (PExp)checkStatusEq.apply(statusesToFail[i]));
            }
            ScopeFmi2Api thenScope = scope.enterIf(new PredicateFmi2Api(exp)).enterThen();
            for (MablApiBuilder.Fmi3Status status : statusesToFail) {
                ScopeFmi2Api s2 = thenScope.enterIf(new PredicateFmi2Api(checkStatusEq.apply(status))).enterThen();
                builder.getLogger().error(s2, method.substring(0, 1).toUpperCase() + method.substring(1) + " failed on '%s' with status: " + String.valueOf(status), instance);
            }
            thenScope.add(new PStm[]{new AErrorStm((PExp)MableAstFactory.newAStringLiteralExp((String)("Failed to '" + method + "' on '" + instance.getName() + "'")))});
            thenScope.leave();
        }

        static Set<String> collectedPreviousLoadedModules(INode node) {
            if (node == null) {
                return new HashSet<String>();
            }
            Function<PStm, String> getLoadedIdentifier = s -> {
                final AtomicReference id = new AtomicReference();
                try {
                    s.apply((IAnalysis)new DepthFirstAnalysisAdaptor(){

                        public void caseALoadExp(ALoadExp node) {
                            AVariableDeclaration decl = (AVariableDeclaration)node.getAncestor(AVariableDeclaration.class);
                            if (decl != null) {
                                id.set(decl.getName().getText());
                            }
                            ALocalVariableStm ldecl = (ALocalVariableStm)node.getAncestor(ALocalVariableStm.class);
                            if (decl != null) {
                                id.set(ldecl.getDeclaration().getName().getText());
                            }
                        }
                    });
                }
                catch (AnalysisException e) {
                    e.addSuppressed((Throwable)e);
                }
                return (String)id.get();
            };
            HashSet<String> identifiers = new HashSet<String>();
            if (node instanceof SBlockStm) {
                for (PStm n : ((SBlockStm)node).getBody()) {
                    String id = getLoadedIdentifier.apply(n);
                    if (id == null) continue;
                    identifiers.add(id);
                }
            }
            if (node.parent() != null) {
                identifiers.addAll(FmiStatusErrorHandlingBuilder.collectedPreviousLoadedModules(node.parent()));
            }
            return identifiers;
        }
    }

    public static class StepResult {
        final BooleanVariableFmi2Api eventHandlingNeeded;
        final BooleanVariableFmi2Api terminateSimulation;
        final BooleanVariableFmi2Api earlyReturn;
        final DoubleVariableFmi2Api lastSuccessfulTime;

        public StepResult(BooleanVariableFmi2Api eventHandlingNeeded, BooleanVariableFmi2Api terminateSimulation, BooleanVariableFmi2Api earlyReturn, DoubleVariableFmi2Api lastSuccessfulTime) {
            this.eventHandlingNeeded = eventHandlingNeeded;
            this.terminateSimulation = terminateSimulation;
            this.earlyReturn = earlyReturn;
            this.lastSuccessfulTime = lastSuccessfulTime;
        }

        public BooleanVariableFmi2Api getEventHandlingNeeded() {
            return this.eventHandlingNeeded;
        }

        public BooleanVariableFmi2Api getTerminateSimulation() {
            return this.terminateSimulation;
        }

        public BooleanVariableFmi2Api getEarlyReturn() {
            return this.earlyReturn;
        }

        public DoubleVariableFmi2Api getLastSuccessfulTime() {
            return this.lastSuccessfulTime;
        }
    }

    public static enum FmiFunctionType {
        GET,
        SET;

    }
}

