/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter;

import java.util.HashMap;
import java.util.Map;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.interpreter.values.Value;

class Context {
    final Context outer;
    Map<LexIdentifier, Value> values = new HashMap<LexIdentifier, Value>();

    Context(Context outer) {
        this.outer = outer;
    }

    public void put(AIdentifierExp identifier, Value apply) {
        this.values.put(identifier.getName(), apply);
    }

    public void put(LexIdentifier identifier, Value apply) {
        this.values.put(identifier, apply);
    }

    public Value lookup(LexIdentifier identifier) {
        Value val = this.values.get(identifier);
        if (val != null) {
            return val;
        }
        if (this.outer != null) {
            return this.outer.lookup(identifier);
        }
        return null;
    }

    public Value lookup(String name) {
        Value val = this.lookup(new LexIdentifier(name, null));
        if (val != null) {
            return val;
        }
        if (this.outer != null) {
            return this.outer.lookup(name);
        }
        return null;
    }
}

