/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.spencerwi.either.Either;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.interpreter.FmiInterpreter;
import org.intocps.maestro.interpreter.IExternalValueFactory;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.LoggerValue;
import org.intocps.maestro.interpreter.values.MathValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.intocps.maestro.interpreter.values.csv.CSVValue;
import org.intocps.maestro.interpreter.values.csv.CsvDataWriter;
import org.intocps.maestro.interpreter.values.datawriter.DataWriterValue;
import org.intocps.maestro.interpreter.values.fmi.FmuValue;

public class DefaultExternalValueFactory
implements IExternalValueFactory {
    static final String DEFAULT_CSV_FILENAME = "outputs.csv";
    protected final String DATA_WRITER_TYPE_NAME = "DataWriter";
    protected final String MATH_TYPE_NAME = "Math";
    protected HashMap<String, Function<List<Value>, Either<Exception, Value>>> instantiators;

    public DefaultExternalValueFactory() throws IOException {
        this(null, null);
    }

    public DefaultExternalValueFactory(final File workingDirectory, InputStream config) throws IOException {
        JsonNode configTree;
        String dataWriterFileName = DEFAULT_CSV_FILENAME;
        List dataWriterFilter = null;
        if (config != null && (configTree = new ObjectMapper().readTree(config)).has("DataWriter")) {
            JsonNode dwConfig = configTree.get("DataWriter");
            for (JsonNode val : dwConfig) {
                if (!val.has("type") || !val.get("type").equals((Object)"CSV")) continue;
                dataWriterFileName = val.get("filename").asText();
                dataWriterFilter = StreamSupport.stream(Spliterators.spliteratorUnknownSize(val.get("filter").iterator(), 16), false).map(v -> v.asText()).collect(Collectors.toList());
            }
        }
        final String dataWriterFileNameFinal = dataWriterFileName;
        final List dataWriterFilterFinal = dataWriterFilter;
        this.instantiators = new HashMap<String, Function<List<Value>, Either<Exception, Value>>>(){
            {
                this.put("FMI2", args -> {
                    String guid = ((StringValue)args.get(0)).getValue();
                    String path = ((StringValue)args.get(1)).getValue();
                    try {
                        path = new URI(path).getRawPath();
                    }
                    catch (URISyntaxException e) {
                        return Either.left((Object)new AnalysisException("The path passed to load is not a URI", (Throwable)e));
                    }
                    return Either.right((Object)new FmiInterpreter(workingDirectory).createFmiValue(path, guid));
                });
                this.put("CSV", args -> Either.right((Object)new CSVValue()));
                this.put("Logger", args -> Either.right((Object)new LoggerValue()));
                this.put("DataWriter", args -> Either.right((Object)new DataWriterValue(Collections.singletonList(new CsvDataWriter(workingDirectory == null ? new File(dataWriterFileNameFinal) : new File(workingDirectory, dataWriterFileNameFinal), dataWriterFilterFinal)))));
                this.put("Math", args -> Either.right((Object)new MathValue()));
            }
        };
    }

    @Override
    public boolean supports(String type) {
        return this.instantiators.containsKey(type);
    }

    @Override
    public Either<Exception, Value> create(String type, List<Value> args) {
        return this.instantiators.get(type).apply(args);
    }

    @Override
    public Value destroy(Value value) {
        if (value instanceof FmuValue) {
            FmuValue fmuVal = (FmuValue)value;
            FunctionValue unloadFunction = (FunctionValue)fmuVal.lookup("unload");
            return unloadFunction.evaluate(Collections.emptyList());
        }
        if (value instanceof CSVValue) {
            return new VoidValue();
        }
        if (value instanceof LoggerValue) {
            return new VoidValue();
        }
        if (value instanceof DataWriterValue) {
            return new VoidValue();
        }
        if (value instanceof MathValue) {
            return new VoidValue();
        }
        throw new InterpreterException("UnLoad of unknown type: " + value);
    }
}

