/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.intocps.fmi.Fmi2Status;
import org.intocps.fmi.Fmi2StatusKind;
import org.intocps.fmi.FmiInvalidNativeStateException;
import org.intocps.fmi.FmuInvocationException;
import org.intocps.fmi.FmuMissingLibraryException;
import org.intocps.fmi.FmuResult;
import org.intocps.fmi.IFmiComponent;
import org.intocps.fmi.IFmiComponentState;
import org.intocps.fmi.IFmu;
import org.intocps.fmi.IFmuCallback;
import org.intocps.fmi.InvalidParameterException;
import org.intocps.fmi.jnifmuapi.Factory;
import org.intocps.maestro.interpreter.Interpreter;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.ArrayValue;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.NullValue;
import org.intocps.maestro.interpreter.values.NumericValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.UpdatableValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.intocps.maestro.interpreter.values.fmi.FmuComponentStateValue;
import org.intocps.maestro.interpreter.values.fmi.FmuComponentValue;
import org.intocps.maestro.interpreter.values.fmi.FmuValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FmiInterpreter {
    static final Logger logger = LoggerFactory.getLogger(Interpreter.class);
    private final File workingDirectory;

    public FmiInterpreter(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    static boolean getBool(Value value) {
        if ((value = value.deref()) instanceof BooleanValue) {
            return ((BooleanValue)value).getValue();
        }
        throw new InterpreterException("Value is not boolean");
    }

    static double getDouble(Value value) {
        if ((value = value.deref()) instanceof RealValue) {
            return ((RealValue)value).getValue();
        }
        throw new InterpreterException("Value is not double");
    }

    static String getString(Value value) {
        if ((value = value.deref()) instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        throw new InterpreterException("Value is not string");
    }

    static void checkArgLength(List<Value> values, int size) {
        if (values == null) {
            throw new InterpreterException("No values passed");
        }
        if (values.stream().anyMatch(Objects::isNull)) {
            throw new InterpreterException("Argument list contains null values");
        }
        if (values.size() != size) {
            if (values.size() < size) {
                throw new InterpreterException("Too few arguments");
            }
            throw new InterpreterException("Too many arguments");
        }
    }

    static <T extends Value> List<T> getArrayValue(Value value, Class<T> clz) {
        if ((value = value.deref()) instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            if (((ArrayValue)value).getValues().isEmpty()) {
                return Collections.emptyList();
            }
            if (!clz.isAssignableFrom(((Value)array.getValues().get(0)).deref().getClass())) {
                throw new InterpreterException("Array not containing the right type. Expected: " + clz.getSimpleName() + " Actual: " + ((Value)array.getValues().get(0)).getClass().getSimpleName());
            }
            return array.getValues().stream().map(Value::deref).map(clz::cast).collect(Collectors.toList());
        }
        throw new InterpreterException("Value is not an array");
    }

    public Value createFmiValue(String path, String guid) throws InterpreterException {
        try {
            long startExecTime = System.nanoTime();
            IFmu fmu = Factory.create((File)new File(path));
            fmu.load();
            HashMap<String, Value> functions = new HashMap<String, Value>();
            functions.put("instantiate", new FunctionValue.ExternalFunctionValue(fargs -> {
                FmiInterpreter.checkArgLength(fargs, 3);
                String name = FmiInterpreter.getString((Value)fargs.get(0));
                boolean visible = FmiInterpreter.getBool((Value)fargs.get(1));
                boolean logginOn = FmiInterpreter.getBool((Value)fargs.get(2));
                try {
                    long startInstantiateTime = System.nanoTime();
                    logger.debug(String.format("Loading native FMU. GUID: %s, NAME: %s", guid, name));
                    final BufferedOutputStream fmuLogOutputStream = new BufferedOutputStream(new FileOutputStream(new File(this.workingDirectory, name + ".log")));
                    final String formatter = "{} {} {} {}";
                    String pattern = "%d{ISO8601} %-5p - %m%n";
                    PatternLayout layout = PatternLayout.newBuilder().withPattern(pattern).withCharset(StandardCharsets.UTF_8).build();
                    IFmiComponent component = fmu.instantiate(guid, name, visible, logginOn, new IFmuCallback((Layout)layout){
                        final /* synthetic */ Layout val$layout;
                        {
                            this.val$layout = layout;
                        }

                        public void log(String instanceName, Fmi2Status status, String category, String message) {
                            logger.info("NATIVE: instance: '{}', status: '{}', category: '{}', message: {}", new Object[]{instanceName, status, category, message});
                            Log4jLogEvent.Builder builder = Log4jLogEvent.newBuilder().setMessage((Message)new ParameterizedMessage(formatter, new Object[]{category, status, instanceName, message}));
                            switch (status) {
                                case OK: 
                                case Discard: 
                                case Pending: {
                                    builder.setLevel(Level.INFO);
                                    break;
                                }
                                case Error: 
                                case Fatal: {
                                    builder.setLevel(Level.ERROR);
                                }
                                case Warning: {
                                    builder.setLevel(Level.WARN);
                                    break;
                                }
                                default: {
                                    builder.setLevel(Level.TRACE);
                                }
                            }
                            try {
                                Log4jLogEvent event = builder.build();
                                fmuLogOutputStream.write(this.val$layout.toByteArray((LogEvent)event));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }

                        public void stepFinished(Fmi2Status status) {
                        }
                    });
                    if (component == null) {
                        logger.debug("Component instantiate failed");
                        return new NullValue();
                    }
                    HashMap<String, Value> componentMembers = new HashMap<String, Value>();
                    componentMembers.put("fmi2SetDebugLogging", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 3);
                        boolean debugLogginOn = FmiInterpreter.getBool((Value)fcargs.get(0));
                        List<StringValue> categories = FmiInterpreter.getArrayValue((Value)fcargs.get(2), StringValue.class);
                        try {
                            Fmi2Status res = component.setDebugLogging(debugLogginOn, (String[])categories.stream().map(StringValue::getValue).toArray(String[]::new));
                            return new IntegerValue(res.value);
                        }
                        catch (FmuInvocationException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("setupExperiment", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 5);
                        boolean toleranceDefined = FmiInterpreter.getBool((Value)fcargs.get(0));
                        double tolerance = FmiInterpreter.getDouble((Value)fcargs.get(1));
                        double startTime = FmiInterpreter.getDouble((Value)fcargs.get(2));
                        boolean stopTimeDefined = FmiInterpreter.getBool((Value)fcargs.get(3));
                        double stopTime = FmiInterpreter.getDouble((Value)fcargs.get(4));
                        try {
                            Fmi2Status res = component.setupExperiment(toleranceDefined, tolerance, startTime, stopTimeDefined, stopTime);
                            return new IntegerValue(res.value);
                        }
                        catch (FmuInvocationException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("enterInitializationMode", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 0);
                        try {
                            Fmi2Status res = component.enterInitializationMode();
                            return new IntegerValue(res.value);
                        }
                        catch (FmuInvocationException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("exitInitializationMode", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 0);
                        try {
                            Fmi2Status res = component.exitInitializationMode();
                            return new IntegerValue(res.value);
                        }
                        catch (FmuInvocationException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("setReal", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 3);
                        long[] scalarValueIndices = FmiInterpreter.getArrayValue((Value)fcargs.get(0), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
                        double[] values = FmiInterpreter.getArrayValue((Value)fcargs.get(2), RealValue.class).stream().mapToDouble(RealValue::getValue).toArray();
                        try {
                            Fmi2Status res = component.setReals(scalarValueIndices, values);
                            return new IntegerValue(res.value);
                        }
                        catch (FmiInvalidNativeStateException | InvalidParameterException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("getReal", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 3);
                        if (!(fcargs.get(2) instanceof UpdatableValue)) {
                            throw new InterpreterException("value not a reference value");
                        }
                        long[] scalarValueIndices = FmiInterpreter.getArrayValue((Value)fcargs.get(0), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
                        try {
                            FmuResult res = component.getReal(scalarValueIndices);
                            if (res.status == Fmi2Status.OK) {
                                UpdatableValue ref = (UpdatableValue)fcargs.get(2);
                                List values = Arrays.stream(ArrayUtils.toObject((double[])((double[])res.result))).map(d -> new RealValue((double)d)).collect(Collectors.toList());
                                ref.setValue(new ArrayValue(values));
                            }
                            return new IntegerValue(res.status.value);
                        }
                        catch (FmuInvocationException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("setInteger", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 3);
                        long[] scalarValueIndices = FmiInterpreter.getArrayValue((Value)fcargs.get(0), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
                        int[] values = FmiInterpreter.getArrayValue((Value)fcargs.get(2), IntegerValue.class).stream().mapToInt(IntegerValue::getValue).toArray();
                        try {
                            Fmi2Status res = component.setIntegers(scalarValueIndices, values);
                            return new IntegerValue(res.value);
                        }
                        catch (FmiInvalidNativeStateException | InvalidParameterException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("getInteger", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 3);
                        if (!(fcargs.get(2) instanceof UpdatableValue)) {
                            throw new InterpreterException("value not a reference value");
                        }
                        long[] scalarValueIndices = FmiInterpreter.getArrayValue((Value)fcargs.get(0), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
                        try {
                            FmuResult res = component.getInteger(scalarValueIndices);
                            if (res.status == Fmi2Status.OK) {
                                UpdatableValue ref = (UpdatableValue)fcargs.get(2);
                                List values = Arrays.stream(ArrayUtils.toObject((int[])((int[])res.result))).map(i -> new IntegerValue((int)i)).collect(Collectors.toList());
                                ref.setValue(new ArrayValue(values));
                            }
                            return new IntegerValue(res.status.value);
                        }
                        catch (FmuInvocationException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("setBoolean", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 3);
                        long[] scalarValueIndices = FmiInterpreter.getArrayValue((Value)fcargs.get(0), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
                        boolean[] values = ArrayUtils.toPrimitive((Boolean[])FmiInterpreter.getArrayValue((Value)fcargs.get(2), BooleanValue.class).stream().map(BooleanValue::getValue).collect(Collectors.toList()).toArray(new Boolean[0]));
                        try {
                            Fmi2Status res = component.setBooleans(scalarValueIndices, values);
                            return new IntegerValue(res.value);
                        }
                        catch (FmiInvalidNativeStateException | InvalidParameterException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("getBoolean", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 3);
                        if (!(fcargs.get(2) instanceof UpdatableValue)) {
                            throw new InterpreterException("value not a reference value");
                        }
                        long[] scalarValueIndices = FmiInterpreter.getArrayValue((Value)fcargs.get(0), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
                        try {
                            FmuResult res = component.getBooleans(scalarValueIndices);
                            if (res.status == Fmi2Status.OK) {
                                UpdatableValue ref = (UpdatableValue)fcargs.get(2);
                                List values = Arrays.stream(ArrayUtils.toObject((boolean[])((boolean[])res.result))).map(BooleanValue::new).collect(Collectors.toList());
                                ref.setValue(new ArrayValue(values));
                            }
                            return new IntegerValue(res.status.value);
                        }
                        catch (FmuInvocationException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("setString", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 3);
                        long[] scalarValueIndices = FmiInterpreter.getArrayValue((Value)fcargs.get(0), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
                        String[] values = FmiInterpreter.getArrayValue((Value)fcargs.get(2), StringValue.class).stream().map(StringValue::getValue).collect(Collectors.toList()).toArray(new String[0]);
                        try {
                            Fmi2Status res = component.setStrings(scalarValueIndices, values);
                            return new IntegerValue(res.value);
                        }
                        catch (FmiInvalidNativeStateException | InvalidParameterException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("getString", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 3);
                        if (!(fcargs.get(2) instanceof UpdatableValue)) {
                            throw new InterpreterException("value not a reference value");
                        }
                        long[] scalarValueIndices = FmiInterpreter.getArrayValue((Value)fcargs.get(0), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
                        try {
                            FmuResult res = component.getStrings(scalarValueIndices);
                            if (res.status == Fmi2Status.OK) {
                                UpdatableValue ref = (UpdatableValue)fcargs.get(2);
                                List values = Arrays.stream((String[])res.result).map(StringValue::new).collect(Collectors.toList());
                                ref.setValue(new ArrayValue(values));
                            }
                            return new IntegerValue(res.status.value);
                        }
                        catch (FmuInvocationException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("doStep", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 3);
                        double currentCommunicationPoint = FmiInterpreter.getDouble((Value)fcargs.get(0));
                        double communicationStepSize = FmiInterpreter.getDouble((Value)fcargs.get(1));
                        boolean noSetFMUStatePriorToCurrentPoint = FmiInterpreter.getBool((Value)fcargs.get(2));
                        try {
                            Fmi2Status res = component.doStep(currentCommunicationPoint, communicationStepSize, noSetFMUStatePriorToCurrentPoint);
                            return new IntegerValue(res.value);
                        }
                        catch (FmuInvocationException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("terminate", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 0);
                        try {
                            Fmi2Status res = component.terminate();
                            return new IntegerValue(res.value);
                        }
                        catch (FmuInvocationException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("setState", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 1);
                        Value v = ((Value)fcargs.get(0)).deref();
                        if (v instanceof FmuComponentStateValue) {
                            try {
                                FmuComponentStateValue stateValue = (FmuComponentStateValue)v;
                                Fmi2Status res = component.setState((IFmiComponentState)stateValue.getModule());
                                return new IntegerValue(res.value);
                            }
                            catch (FmuInvocationException e) {
                                throw new InterpreterException(e);
                            }
                        }
                        throw new InterpreterException("Invalid value");
                    }));
                    componentMembers.put("getState", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 1);
                        if (!(fcargs.get(0) instanceof UpdatableValue)) {
                            throw new InterpreterException("value not a reference value");
                        }
                        try {
                            FmuResult res = component.getState();
                            if (res.status == Fmi2Status.OK) {
                                UpdatableValue ref = (UpdatableValue)fcargs.get(0);
                                ref.setValue(new FmuComponentStateValue((IFmiComponentState)res.result));
                            }
                            return new IntegerValue(res.status.value);
                        }
                        catch (FmuInvocationException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("freeState", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 1);
                        Value v = ((Value)fcargs.get(0)).deref();
                        if (v instanceof FmuComponentStateValue) {
                            try {
                                FmuComponentStateValue stateValue = (FmuComponentStateValue)v;
                                Fmi2Status res = component.freeState((IFmiComponentState)stateValue.getModule());
                                return new IntegerValue(res.value);
                            }
                            catch (FmuInvocationException e) {
                                throw new InterpreterException(e);
                            }
                        }
                        throw new InterpreterException("Invalid value");
                    }));
                    componentMembers.put("getRealStatus", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 2);
                        if (!(fcargs.get(1) instanceof UpdatableValue)) {
                            throw new InterpreterException("value not a reference value");
                        }
                        Value kindValue = ((Value)fcargs.get(0)).deref();
                        if (!(kindValue instanceof IntegerValue)) {
                            throw new InterpreterException("Invalid kind value: " + kindValue);
                        }
                        int kind = ((IntegerValue)kindValue).getValue();
                        Fmi2StatusKind kindEnum = Arrays.stream(Fmi2StatusKind.values()).filter(v -> v.value == kind).findFirst().orElse(null);
                        try {
                            FmuResult res = component.getRealStatus(kindEnum);
                            if (res.status == Fmi2Status.OK) {
                                UpdatableValue ref = (UpdatableValue)fcargs.get(1);
                                ref.setValue(new RealValue((Double)res.result));
                            }
                            return new IntegerValue(res.status.value);
                        }
                        catch (FmuInvocationException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("getRealOutputDerivatives", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 4);
                        if (!(fcargs.get(3) instanceof UpdatableValue)) {
                            throw new InterpreterException("value not a reference value");
                        }
                        long[] scalarValueIndices = FmiInterpreter.getArrayValue((Value)fcargs.get(0), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
                        int[] orders = FmiInterpreter.getArrayValue((Value)fcargs.get(2), NumericValue.class).stream().mapToInt(NumericValue::intValue).toArray();
                        try {
                            FmuResult res = component.getRealOutputDerivatives(scalarValueIndices, orders);
                            if (res.status == Fmi2Status.OK) {
                                UpdatableValue ref = (UpdatableValue)fcargs.get(3);
                                List values = Arrays.stream(ArrayUtils.toObject((double[])((double[])res.result))).map(d -> new RealValue((double)d)).collect(Collectors.toList());
                                ref.setValue(new ArrayValue(values));
                            }
                            return new IntegerValue(res.status.value);
                        }
                        catch (FmuInvocationException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    componentMembers.put("setRealInputDerivatives", new FunctionValue.ExternalFunctionValue(fcargs -> {
                        FmiInterpreter.checkArgLength(fcargs, 4);
                        long[] scalarValueIndices = FmiInterpreter.getArrayValue((Value)fcargs.get(0), NumericValue.class).stream().mapToLong(NumericValue::longValue).toArray();
                        int[] orders = FmiInterpreter.getArrayValue((Value)fcargs.get(2), NumericValue.class).stream().mapToInt(NumericValue::intValue).toArray();
                        double[] values = FmiInterpreter.getArrayValue((Value)fcargs.get(3), RealValue.class).stream().mapToDouble(RealValue::getValue).toArray();
                        try {
                            Fmi2Status res = component.setRealInputDerivatives(scalarValueIndices, orders, values);
                            return new IntegerValue(res.value);
                        }
                        catch (FmuInvocationException e) {
                            throw new InterpreterException(e);
                        }
                    }));
                    long stopInstantiateTime = System.nanoTime();
                    System.out.println("Interpretation instantiate took: " + (stopInstantiateTime - startInstantiateTime));
                    return new FmuComponentValue(componentMembers, component, fmuLogOutputStream);
                }
                catch (IOException | XPathExpressionException | FmiInvalidNativeStateException e) {
                    e.printStackTrace();
                    return null;
                }
            }));
            functions.put("freeInstance", new FunctionValue.ExternalFunctionValue(fargs -> {
                fargs = fargs.stream().map(Value::deref).collect(Collectors.toList());
                logger.debug("freeInstance");
                if (fargs.size() != 1) {
                    throw new InterpreterException("Too few arguments");
                }
                if (!(fargs.get(0) instanceof FmuComponentValue)) {
                    throw new InterpreterException("Argument must be an external module reference");
                }
                FmuComponentValue component = (FmuComponentValue)fargs.get(0);
                try {
                    component.getFmuLoggerOutputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return new VoidValue();
            }));
            functions.put("unload", new FunctionValue.ExternalFunctionValue(fargs -> {
                fargs = fargs.stream().map(Value::deref).collect(Collectors.toList());
                logger.debug("unload");
                if (fargs.size() != 0) {
                    throw new InterpreterException("Too many arguments");
                }
                try {
                    fmu.unLoad();
                }
                catch (FmuInvocationException e) {
                    e.printStackTrace();
                }
                return new VoidValue();
            }));
            long stopTime = System.nanoTime();
            System.out.println("Interpretation load took: " + (stopTime - startExecTime));
            return new FmuValue((Map<String, Value>)functions, fmu);
        }
        catch (IOException | FmuInvocationException | FmuMissingLibraryException e) {
            e.printStackTrace();
            return new NullValue();
        }
    }
}

