/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter;

import java.util.Collections;
import java.util.List;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.ArrayValue;
import org.intocps.maestro.interpreter.values.Value;

public class ValueExtractionUtilities {
    public static <T extends Value> T getValue(Value value, Class<T> clz) {
        Value dereffed = value.deref();
        if (clz.isAssignableFrom(dereffed.getClass())) {
            return (T)((Value)clz.cast(dereffed));
        }
        throw new InterpreterException("Value is not the right type");
    }

    public static <T extends Value> List<T> getArrayValue(Value value, Class<T> clz) {
        if ((value = value.deref()) instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            if (((ArrayValue)value).getValues().isEmpty()) {
                return Collections.emptyList();
            }
            if (!clz.isAssignableFrom(array.getValues().get(0).getClass())) {
                throw new InterpreterException("Array not containing the right type");
            }
            return array.getValues();
        }
        throw new InterpreterException("Value is not an array");
    }
}

