/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.ExternalModuleValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerValue
extends ExternalModuleValue<Object> {
    static final Logger logger = LoggerFactory.getLogger(LoggerValue.class);

    public LoggerValue() {
        super(LoggerValue.createMembers(), null);
    }

    static Object[] getValues(List<Value> values) {
        return values.stream().map(Value::deref).map(v -> {
            if (v instanceof IntegerValue) {
                return Integer.valueOf(((IntegerValue)v).intValue());
            }
            if (v instanceof BooleanValue) {
                return ((BooleanValue)v).getValue();
            }
            if (v instanceof RealValue) {
                return Double.valueOf(((RealValue)v).getValue());
            }
            if (v instanceof StringValue) {
                return ((StringValue)v).getValue();
            }
            return v.toString();
        }).collect(Collectors.toList()).toArray();
    }

    static Map<String, Value> createMembers() {
        HashMap<String, Value> componentMembers = new HashMap<String, Value>();
        componentMembers.put("log", new FunctionValue.ExternalFunctionValue(fcargs -> {
            if (fcargs == null) {
                throw new InterpreterException("No values passed");
            }
            if (fcargs.stream().anyMatch(Objects::isNull)) {
                throw new InterpreterException("Argument list contains null values");
            }
            if (fcargs.size() < 2) {
                throw new InterpreterException("Too few arguments");
            }
            IntegerValue level = (IntegerValue)((Value)fcargs.get(0)).deref();
            StringValue msg = (StringValue)((Value)fcargs.get(1)).deref();
            String logMsg = String.format(msg.getValue(), LoggerValue.getValues(fcargs.stream().skip(2L).collect(Collectors.toList())));
            if (level.getValue() == 0) {
                logger.trace(logMsg);
            } else if (level.getValue() == 1) {
                logger.debug(logMsg);
            } else if (level.intValue() == 2) {
                logger.info(logMsg);
            } else if (level.intValue() == 3) {
                logger.warn(logMsg);
            } else if (level.getValue() == 4) {
                logger.error(logMsg);
            }
            return new VoidValue();
        }));
        return componentMembers;
    }
}

