/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.derivativeestimator;

import org.intocps.maestro.interpreter.values.derivativeestimator.DerivativeEstimationAlgorithm;
import org.intocps.maestro.interpreter.values.derivativeestimator.FirstOrderDerivativeEstimationAlgorithm;
import org.intocps.maestro.interpreter.values.derivativeestimator.SecondOrderDerivativeEstimationAlgorithm;

public class ScalarDerivativeEstimator {
    private final DerivativeEstimationAlgorithm algorithm;
    private final Integer order;
    private Double[] x = null;
    private Double[] xPrev = null;
    private Double[] xPrevPrev = null;
    private Double[] xPrevPrevPrev = null;
    private Double dt = null;
    private Double dtPrev = null;
    private Double dtPrevPrev = null;

    public ScalarDerivativeEstimator(Integer order) {
        if (order == null) {
            this.algorithm = new SecondOrderDerivativeEstimationAlgorithm();
            this.order = 2;
            return;
        }
        this.algorithm = order.equals(1) ? new FirstOrderDerivativeEstimationAlgorithm() : new SecondOrderDerivativeEstimationAlgorithm();
        this.order = order;
    }

    public void advance(Double[] xNew, Double dtNew) {
        this.shiftBackward();
        this.x = this.algorithm.update(xNew, this.xPrev, this.xPrevPrev, dtNew, this.dtPrev);
        this.dt = dtNew;
    }

    public void rollback() {
        this.shiftForward();
    }

    public Double getDerivative(Integer order) {
        if (this.x != null && this.x[order] != null) {
            return this.x[order];
        }
        return null;
    }

    public Double getFirstDerivative() {
        return this.x[1];
    }

    public Double getSecondDerivative() {
        return this.x[2];
    }

    public Integer getOrder() {
        return this.order;
    }

    private void shiftBackward() {
        this.xPrevPrevPrev = this.xPrevPrev;
        this.xPrevPrev = this.xPrev;
        this.xPrev = this.x;
        this.dtPrevPrev = this.dtPrev;
        this.dtPrev = this.dt;
    }

    private void shiftForward() {
        this.x = this.xPrev;
        this.xPrev = this.xPrevPrev;
        this.xPrevPrev = this.xPrevPrevPrev;
        this.xPrevPrevPrev = null;
        this.dt = this.dtPrev;
        this.dtPrev = this.dtPrevPrev;
        this.dtPrevPrev = null;
    }
}

