/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter;

import com.spencerwi.either.Either;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.intocps.maestro.ast.AAndBinaryExp;
import org.intocps.maestro.ast.AEqualBinaryExp;
import org.intocps.maestro.ast.AGreaterBinaryExp;
import org.intocps.maestro.ast.AGreaterEqualBinaryExp;
import org.intocps.maestro.ast.ALessBinaryExp;
import org.intocps.maestro.ast.ALessEqualBinaryExp;
import org.intocps.maestro.ast.AMinusBinaryExp;
import org.intocps.maestro.ast.AMinusUnaryExp;
import org.intocps.maestro.ast.ANotEqualBinaryExp;
import org.intocps.maestro.ast.ANotUnaryExp;
import org.intocps.maestro.ast.AOrBinaryExp;
import org.intocps.maestro.ast.APlusBinaryExp;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.QuestionAnswerAdaptor;
import org.intocps.maestro.ast.analysis.intf.IQuestionAnswer;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.node.AArrayType;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.ABlockStm;
import org.intocps.maestro.ast.node.ABoolLiteralExp;
import org.intocps.maestro.ast.node.ABreakStm;
import org.intocps.maestro.ast.node.ACallExp;
import org.intocps.maestro.ast.node.AExpInitializer;
import org.intocps.maestro.ast.node.AExpressionStm;
import org.intocps.maestro.ast.node.AFieldExp;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.AIdentifierStateDesignator;
import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.AInstanceMappingStm;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.ANullExp;
import org.intocps.maestro.ast.node.AParExp;
import org.intocps.maestro.ast.node.ARealLiteralExp;
import org.intocps.maestro.ast.node.ARefExp;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.AStringLiteralExp;
import org.intocps.maestro.ast.node.AUIntLiteralExp;
import org.intocps.maestro.ast.node.AUnloadExp;
import org.intocps.maestro.ast.node.AWhileStm;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.interpreter.BreakException;
import org.intocps.maestro.interpreter.Context;
import org.intocps.maestro.interpreter.IExternalValueFactory;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.ModuleContext;
import org.intocps.maestro.interpreter.values.ArrayValue;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.ModuleValue;
import org.intocps.maestro.interpreter.values.NullValue;
import org.intocps.maestro.interpreter.values.NumericValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.UndefinedValue;
import org.intocps.maestro.interpreter.values.UnsignedIntegerValue;
import org.intocps.maestro.interpreter.values.UpdatableValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Interpreter
extends QuestionAnswerAdaptor<Context, Value> {
    static final Logger logger = LoggerFactory.getLogger(Interpreter.class);
    private final IExternalValueFactory loadFactory;

    public Interpreter(IExternalValueFactory loadFactory) {
        this.loadFactory = loadFactory;
    }

    List<Value> evaluate(List<? extends PExp> list, Context ctxt) throws AnalysisException {
        Vector<Value> values = new Vector<Value>();
        for (PExp pExp : list) {
            values.add((Value)pExp.apply((IQuestionAnswer)this, (Object)ctxt));
        }
        return values;
    }

    public Value caseARootDocument(ARootDocument node, Context question) throws AnalysisException {
        AnalysisException[] exception = new AnalysisException[]{null};
        Value result = node.getContent().stream().filter(f -> f instanceof ASimulationSpecificationCompilationUnit).findFirst().map(spec -> {
            try {
                return (Value)spec.apply((IQuestionAnswer)this, (Object)question);
            }
            catch (AnalysisException e) {
                exception[0] = e;
                return null;
            }
        }).orElse(null);
        if (result == null) {
            throw exception[0];
        }
        return result;
    }

    public Value caseASimulationSpecificationCompilationUnit(ASimulationSpecificationCompilationUnit node, Context question) throws AnalysisException {
        return (Value)node.getBody().apply((IQuestionAnswer)this, (Object)question);
    }

    public Value caseABlockStm(ABlockStm node, Context question) throws AnalysisException {
        Context ctxt = new Context(question);
        for (PStm stm : node.getBody()) {
            stm.apply((IQuestionAnswer)this, (Object)ctxt);
        }
        return new VoidValue();
    }

    public Value caseAInstanceMappingStm(AInstanceMappingStm node, Context question) {
        return new VoidValue();
    }

    public Value caseALocalVariableStm(ALocalVariableStm node, Context question) throws AnalysisException {
        return (Value)node.getDeclaration().apply((IQuestionAnswer)this, (Object)question);
    }

    public Value caseALoadExp(ALoadExp node, Context question) throws AnalysisException {
        if (node.getArgs().size() < 1) {
            throw new AnalysisException("load contains too few arguments. At least a type is required");
        }
        List<Value> args = this.evaluate(node.getArgs(), question);
        String type = ((StringValue)args.get(0)).getValue();
        if (this.loadFactory.supports(type)) {
            Either<Exception, Value> valueE = this.loadFactory.create(type, args.subList(1, args.size()));
            if (valueE.isLeft()) {
                throw new AnalysisException((Throwable)valueE.getLeft());
            }
            return (Value)valueE.getRight();
        }
        throw new AnalysisException("Load of unknown type");
    }

    public Value caseAUnloadExp(AUnloadExp node, Context question) throws AnalysisException {
        List args = this.evaluate(node.getArgs(), question).stream().map(Value::deref).collect(Collectors.toList());
        Value nameVal = (Value)args.get(0);
        return this.loadFactory.destroy(nameVal);
    }

    public Value caseAIdentifierStateDesignator(AIdentifierStateDesignator node, Context question) throws AnalysisException {
        return question.lookup(node.getName());
    }

    public Value caseAArrayStateDesignator(AArrayStateDesignator node, Context question) throws AnalysisException {
        Value arrayValue = (Value)node.getTarget().apply((IQuestionAnswer)this, (Object)question);
        if (!(arrayValue.deref() instanceof ArrayValue)) {
            throw new InterpreterException("Array designator is not an array: " + arrayValue);
        }
        return arrayValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Value caseAAssigmentStm(AAssigmentStm node, Context question) throws AnalysisException {
        Value newValue = (Value)node.getExp().apply((IQuestionAnswer)this, (Object)question);
        Value currentValue = (Value)node.getTarget().apply((IQuestionAnswer)this, (Object)question);
        if (!(currentValue instanceof UpdatableValue)) {
            throw new InterpreterException("Cannot assign to a constant value");
        }
        UpdatableValue currentUpdatableValue = (UpdatableValue)currentValue;
        if (currentUpdatableValue.deref() instanceof ArrayValue) {
            if (!(node.getTarget() instanceof AArrayStateDesignator)) throw new InterpreterException("Bad array designator: " + node.getTarget().toString());
            AArrayStateDesignator arrayStateDesignator = (AArrayStateDesignator)node.getTarget();
            if (arrayStateDesignator.getExp() == null) {
                currentUpdatableValue.setValue(newValue.deref());
                return new VoidValue();
            } else {
                Value indexValue = ((Value)arrayStateDesignator.getExp().apply((IQuestionAnswer)this, (Object)question)).deref();
                if (!(indexValue instanceof NumericValue)) {
                    throw new InterpreterException("Array index is not an integer: " + indexValue.toString());
                }
                int index = ((NumericValue)indexValue).intValue();
                ArrayValue arrayValue = (ArrayValue)currentUpdatableValue.deref();
                if (index < 0 || index >= arrayValue.getValues().size()) throw new InterpreterException("Array index out of bounds: " + indexValue.toString());
                arrayValue.getValues().set(index, newValue);
            }
            return new VoidValue();
        } else {
            currentUpdatableValue.setValue(newValue.deref());
        }
        return new VoidValue();
    }

    public Value caseANotEqualBinaryExp(ANotEqualBinaryExp node, Context question) throws AnalysisException {
        NumericValue left = (NumericValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        NumericValue right = (NumericValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref();
        return new BooleanValue(left.deref().compareTo(right.deref()) != 0);
    }

    public Value caseAVariableDeclaration(AVariableDeclaration node, Context question) throws AnalysisException {
        if (node.getType() instanceof AArrayType) {
            ArrayValue val;
            if (node.getInitializer() != null) {
                val = (ArrayValue)node.getInitializer().apply((IQuestionAnswer)this, (Object)question);
            } else {
                if (node.getSize() == null || node.getSize().isEmpty()) {
                    throw new InterpreterException("Array size cannot be unspecified when no initializer is specified: " + node.getName());
                }
                NumericValue size = (NumericValue)((PExp)node.getSize().get(0)).apply((IQuestionAnswer)this, (Object)question);
                val = new ArrayValue(IntStream.range(0, size.intValue()).mapToObj(i -> new UpdatableValue(new UndefinedValue())).collect(Collectors.toList()));
            }
            question.put(node.getName(), (Value)new UpdatableValue(val));
        } else {
            question.put(node.getName(), (Value)new UpdatableValue(node.getInitializer() == null ? new UndefinedValue() : (Value)node.getInitializer().apply((IQuestionAnswer)this, (Object)question)));
        }
        return new VoidValue();
    }

    public Value caseAExpInitializer(AExpInitializer node, Context question) throws AnalysisException {
        return (Value)node.getExp().apply((IQuestionAnswer)this, (Object)question);
    }

    public Value caseAArrayInitializer(AArrayInitializer node, Context question) throws AnalysisException {
        ArrayValue array = new ArrayValue(this.evaluate(node.getExp(), question).stream().map(Value::deref).collect(Collectors.toList()));
        return array;
    }

    public Value caseAFieldExp(AFieldExp node, Context question) throws AnalysisException {
        Value root = (Value)node.getRoot().apply((IQuestionAnswer)this, (Object)question);
        if (root instanceof ModuleValue) {
            ModuleContext moduleContext = new ModuleContext((ModuleValue)root, question);
            return moduleContext.lookup(node.getField());
        }
        throw new InterpreterException("Unhandled node: " + node);
    }

    public Value caseAExpressionStm(AExpressionStm node, Context question) throws AnalysisException {
        return (Value)node.getExp().apply((IQuestionAnswer)this, (Object)question);
    }

    public Value caseAIdentifierExp(AIdentifierExp node, Context question) throws AnalysisException {
        Value val = question.lookup(node.getName());
        if (val == null) {
            throw new InterpreterException("Variable undefined: '" + node.getName() + "':" + node.getName().getSymbol().getLine());
        }
        return val;
    }

    public Value caseAPlusBinaryExp(APlusBinaryExp node, Context question) throws AnalysisException {
        NumericValue left = (NumericValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        NumericValue right = (NumericValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref();
        if (left instanceof IntegerValue && right instanceof IntegerValue) {
            return new IntegerValue(left.intValue() + right.intValue());
        }
        return new RealValue(left.realValue() + right.realValue());
    }

    public Value caseAMinusBinaryExp(AMinusBinaryExp node, Context question) throws AnalysisException {
        NumericValue left = (NumericValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        NumericValue right = (NumericValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref();
        if (left instanceof IntegerValue && right instanceof IntegerValue) {
            return new IntegerValue(left.intValue() + right.intValue());
        }
        return new RealValue(left.realValue() - right.realValue());
    }

    public Value caseACallExp(ACallExp node, Context question) throws AnalysisException {
        Value function;
        Context callContext = question;
        if (node.getObject() != null) {
            ModuleValue objectModule = (ModuleValue)((Value)node.getObject().apply((IQuestionAnswer)this, (Object)question)).deref();
            callContext = new ModuleContext(objectModule, question);
        }
        if ((function = callContext.lookup(node.getMethodName())) instanceof FunctionValue) {
            return ((FunctionValue)function).evaluate(this.evaluate(node.getArgs(), callContext));
        }
        throw new InterpreterException("Unhandled node: " + node);
    }

    public Value caseAWhileStm(AWhileStm node, Context question) throws AnalysisException {
        try {
            while (((BooleanValue)((Value)node.getTest().apply((IQuestionAnswer)this, (Object)question)).deref()).getValue().booleanValue()) {
                node.getBody().apply((IQuestionAnswer)this, (Object)question);
            }
        }
        catch (BreakException e) {
            logger.trace("Loop stopped:" + node);
        }
        return new VoidValue();
    }

    public Value caseAIfStm(AIfStm node, Context question) throws AnalysisException {
        if (((BooleanValue)((Value)node.getTest().apply((IQuestionAnswer)this, (Object)question)).deref()).getValue().booleanValue()) {
            node.getThen().apply((IQuestionAnswer)this, (Object)question);
        } else if (node.getElse() != null) {
            node.getElse().apply((IQuestionAnswer)this, (Object)question);
        }
        return new VoidValue();
    }

    public Value caseALessBinaryExp(ALessBinaryExp node, Context question) throws AnalysisException {
        NumericValue left = (NumericValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        NumericValue right = (NumericValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref();
        return new BooleanValue(left.deref().compareTo(right.deref()) < 0);
    }

    public Value caseALessEqualBinaryExp(ALessEqualBinaryExp node, Context question) throws AnalysisException {
        NumericValue left = (NumericValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        NumericValue right = (NumericValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref();
        return new BooleanValue(left.deref().compareTo(right.deref()) <= 0);
    }

    public Value caseAGreaterBinaryExp(AGreaterBinaryExp node, Context question) throws AnalysisException {
        NumericValue left = (NumericValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        NumericValue right = (NumericValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref();
        return new BooleanValue(left.deref().compareTo(right.deref()) > 0);
    }

    public Value caseAEqualBinaryExp(AEqualBinaryExp node, Context question) throws AnalysisException {
        Value rv;
        Value lv = ((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        if (lv.equals(rv = ((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref())) {
            new BooleanValue(true);
        } else {
            if (lv instanceof NumericValue && rv instanceof NumericValue) {
                NumericValue left = (NumericValue)lv;
                NumericValue right = (NumericValue)rv;
                return new BooleanValue(left.deref().compareTo(right.deref()) == 0);
            }
            if (lv instanceof BooleanValue && rv instanceof BooleanValue) {
                BooleanValue left = (BooleanValue)lv;
                BooleanValue right = (BooleanValue)rv;
                return new BooleanValue(left.getValue().compareTo(right.getValue()) == 0);
            }
            if (lv instanceof NullValue && rv instanceof NullValue) {
                return new BooleanValue(true);
            }
        }
        return new BooleanValue(false);
    }

    public Value caseAOrBinaryExp(AOrBinaryExp node, Context question) throws AnalysisException {
        return new BooleanValue(((BooleanValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref()).getValue() != false || ((BooleanValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref()).getValue() != false);
    }

    public Value caseAParExp(AParExp node, Context question) throws AnalysisException {
        return (Value)node.getExp().apply((IQuestionAnswer)this, (Object)question);
    }

    public Value caseAAndBinaryExp(AAndBinaryExp node, Context question) throws AnalysisException {
        return new BooleanValue(((BooleanValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref()).getValue() != false && ((BooleanValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref()).getValue() != false);
    }

    public Value caseAGreaterEqualBinaryExp(AGreaterEqualBinaryExp node, Context question) throws AnalysisException {
        NumericValue left = (NumericValue)((Value)node.getLeft().apply((IQuestionAnswer)this, (Object)question)).deref();
        NumericValue right = (NumericValue)((Value)node.getRight().apply((IQuestionAnswer)this, (Object)question)).deref();
        return new BooleanValue(left.deref().compareTo(right.deref()) >= 0);
    }

    public Value caseARealLiteralExp(ARealLiteralExp node, Context question) throws AnalysisException {
        return new RealValue(node.getValue());
    }

    public Value caseABoolLiteralExp(ABoolLiteralExp node, Context question) throws AnalysisException {
        return new BooleanValue(node.getValue());
    }

    public Value caseAStringLiteralExp(AStringLiteralExp node, Context question) throws AnalysisException {
        return new StringValue(node.getValue());
    }

    public Value caseAIntLiteralExp(AIntLiteralExp node, Context question) throws AnalysisException {
        return new IntegerValue(node.getValue());
    }

    public Value caseAUIntLiteralExp(AUIntLiteralExp node, Context question) throws AnalysisException {
        return new UnsignedIntegerValue(node.getValue());
    }

    public Value caseAArrayIndexExp(AArrayIndexExp node, Context question) throws AnalysisException {
        Value value = ((Value)node.getArray().apply((IQuestionAnswer)this, (Object)question)).deref();
        if (value instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            List indies = this.evaluate(node.getIndices(), question).stream().map(Value::deref).map(NumericValue.class::cast).collect(Collectors.toList());
            return (Value)array.getValues().get(((NumericValue)indies.get(0)).intValue());
        }
        throw new AnalysisException("No array or index for: " + node);
    }

    public Value caseANotUnaryExp(ANotUnaryExp node, Context question) throws AnalysisException {
        Value value = (Value)node.getExp().apply((IQuestionAnswer)this, (Object)question);
        if (!(value.deref() instanceof BooleanValue)) {
            throw new InterpreterException("Invalid type in not expression");
        }
        return new BooleanValue(((BooleanValue)value.deref()).getValue() == false);
    }

    public Value caseABreakStm(ABreakStm node, Context question) throws AnalysisException {
        throw new BreakException();
    }

    public Value caseANullExp(ANullExp node, Context question) throws AnalysisException {
        return new NullValue();
    }

    public Value createNewReturnValue(INode node, Context question) throws AnalysisException {
        logger.debug("Unhandled interpreter node: {}", (Object)node.getClass().getSimpleName());
        throw new InterpreterException("Unhandled node: " + node);
    }

    public Value caseARefExp(ARefExp node, Context question) throws AnalysisException {
        return (Value)node.getExp().apply((IQuestionAnswer)this, (Object)question);
    }

    public Value createNewReturnValue(Object node, Context question) throws AnalysisException {
        logger.debug("Unhandled interpreter object: {}", (Object)node.getClass().getSimpleName());
        throw new InterpreterException("Unhandled object: " + node);
    }

    public Value caseAMinusUnaryExp(AMinusUnaryExp node, Context question) throws AnalysisException {
        NumericValue exp = (NumericValue)((Value)node.getExp().apply((IQuestionAnswer)this, (Object)question)).deref();
        if (exp instanceof IntegerValue) {
            return new IntegerValue(exp.intValue() * -1);
        }
        return new RealValue(exp.realValue() * -1.0);
    }
}

