/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.csv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.ExternalModuleValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.intocps.maestro.interpreter.values.csv.CsvFileValue;

public class CSVValue
extends ExternalModuleValue {
    public CSVValue() {
        super(CSVValue.createCsvMembers(), null);
    }

    static String getString(Value value) {
        if ((value = value.deref()) instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        throw new InterpreterException("Value is not string");
    }

    private static Map<String, Value> createCsvMembers() {
        HashMap<String, Value> componentMembers = new HashMap<String, Value>();
        componentMembers.put("open", new FunctionValue.ExternalFunctionValue(fcargs -> {
            fcargs = fcargs.stream().map(Value::deref).collect(Collectors.toList());
            CSVValue.checkArgLength(fcargs, 1);
            String path = CSVValue.getString(fcargs.get(0));
            try {
                return new CsvFileValue(new PrintWriter(new FileOutputStream(new File(path))));
            }
            catch (FileNotFoundException e) {
                throw new InterpreterException(e);
            }
        }));
        componentMembers.put("close", new FunctionValue.ExternalFunctionValue(fcargs -> {
            fcargs = fcargs.stream().map(Value::deref).collect(Collectors.toList());
            CSVValue.checkArgLength(fcargs, 1);
            if (fcargs.get(0) instanceof CsvFileValue) {
                ((PrintWriter)((CsvFileValue)fcargs.get(0)).getModule()).close();
            }
            return new VoidValue();
        }));
        return componentMembers;
    }
}

